/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public final class BitmapFont {
    private int m_iFontID = ++s_iLastID;
    private int m_iFontHeight;
    private int m_iFontColor;
    private int m_iBorderColor;
    public int m_iSpaceCharWidth;
    private boolean m_hasBorder;
    private int m_curAlpha = -16777216;
    private int m_iTotalChars;
    private char[] m_aEnumChars;
    private String m_sEnumChars;
    private int[] m_aiFontImageData;
    private byte[] m_bFontWidth;
    private byte[] m_abFontPackData;
    private int[] m_aiFontPackDataOffset;
    private int m_iBitPerPixel;
    private int m_iBitToShift;
    private int m_iBitAND;
    private int m_iBitToCheckBorder;
    private int m_iScale;
    private boolean m_isLoadDataBitmapFont = false;
    private int m_iCurrentPal;
    private static int s_iMaxCachePool = 0;
    private static int s_iLastID = 0;
    public static int s_iCurFrameCachedCount = 0;

    public BitmapFont() {
    }

    public BitmapFont(String string) {
        this.LoadFont(string);
    }

    private boolean LoadFont(String string) {
        this.m_iFontColor = -16777216;
        this.m_iBorderColor = -16777216;
        this.m_hasBorder = true;
        this.m_iBitPerPixel = 1;
        this.m_iSpaceCharWidth = 6;
        if (string.charAt(0) != '/') {
            string = "/" + string;
        }
        try {
            InputStream inputStream = GLLib.GetResourceAsStream(string);
            if (inputStream == null) {
                new StringBuffer().append("!!!Error!!! Can't load bitmap font data: ").append(string);
                return false;
            }
            this.m_iTotalChars = inputStream.read();
            if (this.m_iTotalChars == -1) {
                return false;
            }
            int n = inputStream.read();
            if (n == -1) {
                return false;
            }
            this.m_iTotalChars |= n << 8;
            this.m_aEnumChars = new char[this.m_iTotalChars];
            this.m_bFontWidth = new byte[this.m_iTotalChars];
            this.m_iFontHeight = inputStream.read();
            if (this.m_iFontHeight == -1) {
                return false;
            }
            this.m_aiFontImageData = new int[this.m_iFontHeight * this.m_iFontHeight << 1];
            this.m_iBitPerPixel = inputStream.read();
            this.m_iBitToShift = 4 - this.m_iBitPerPixel;
            if (this.m_iBitPerPixel == 1) {
                this.m_iBitAND = 7;
                this.m_iBitToCheckBorder = 1;
                this.m_iScale = 0;
            } else {
                this.m_iBitAND = 3;
                this.m_iBitToCheckBorder = 3;
                this.m_iScale = 1;
            }
            this.m_aiFontPackDataOffset = new int[this.m_iTotalChars + 1];
            this.m_aiFontPackDataOffset[0] = 0;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[2];
            byte[] byArray2 = new byte[1000];
            for (int i = 0; i < this.m_iTotalChars; ++i) {
                n = inputStream.read(byArray, 0, 2);
                if (n == -1) {
                    return false;
                }
                this.m_aEnumChars[i] = (char)(byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8);
                n = inputStream.read();
                if (n == -1) {
                    return false;
                }
                this.m_bFontWidth[i] = (byte)n;
                int n2 = 1 + (this.m_bFontWidth[i] * this.m_iFontHeight >> this.m_iBitToShift);
                n = inputStream.read(byArray2, 0, n2);
                this.m_aiFontPackDataOffset[i + 1] = this.m_aiFontPackDataOffset[i] + n2;
                byteArrayOutputStream.write(byArray2, 0, n2);
                if (n != -1) continue;
                return false;
            }
            inputStream.close();
            this.m_abFontPackData = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            this.m_sEnumChars = new String(this.m_aEnumChars);
            this.m_isLoadDataBitmapFont = true;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public final void SetColor(int n) {
        this.m_iFontColor = n | 0xFF000000;
    }

    public final void SetBorderColor(int n) {
        if (n == -1) {
            v0.m_hasBorder = false;
            return;
        }
        this.m_hasBorder = true;
        this.m_iBorderColor = n | 0xFF000000;
    }

    public final int DrawChar(Graphics object, char c, int n, int n2) {
        if (c == ' ') {
            return bitmapFont.m_iSpaceCharWidth;
        }
        if (c == '|') {
            return 0;
        }
        if (!bitmapFont.m_isLoadDataBitmapFont) {
            return 0;
        }
        int n3 = bitmapFont.MapChar(c);
        c = (char)n3;
        if (n3 == -1) {
            return 0;
        }
        bitmapFont.DecodeFont(c, bitmapFont.m_aiFontImageData);
        c = bitmapFont.m_bFontWidth[c];
        Graphics graphics = object;
        int n4 = bitmapFont.m_iFontHeight;
        char c2 = c;
        object = bitmapFont.m_aiFontImageData;
        BitmapFont bitmapFont = graphics;
        GLLib.DrawRGB(graphics, (int[])object, 0, c, n, n2, c2, n4, true, true, 0);
        return c;
    }

    public final void SetCurrentPalette(int n) {
        this.m_iCurrentPal = n;
    }

    public final int GetFontHeight() {
        return this.m_iFontHeight;
    }

    public final int GetCharWidth(char c) {
        if (c == ' ') {
            return this.m_iSpaceCharWidth;
        }
        if (c == '|') {
            return 0;
        }
        int n = this.MapChar(c);
        c = (char)n;
        if (n == -1) {
            return 0;
        }
        return this.m_bFontWidth[c];
    }

    private int MapChar(char c) {
        return this.m_sEnumChars.indexOf(c);
    }

    public final void setAlpha(int n) {
        this.m_curAlpha = n << 24;
    }

    public final void setDefaultAlpha() {
        this.m_curAlpha = -16777216;
    }

    private void DecodeFont(int n, int[] nArray) {
        int n2 = this.m_iFontHeight * this.m_bFontWidth[n];
        if (nArray == null) {
            nArray = new int[n2];
        }
        int n3 = n2;
        while (--n3 >= 0) {
            n2 = n3 >> this.m_iBitToShift;
            int n4 = (n3 & this.m_iBitAND) << this.m_iScale;
            n2 = this.m_abFontPackData[this.m_aiFontPackDataOffset[n] + n2] >> n4 & this.m_iBitToCheckBorder;
            nArray[n3] = --n2 == 0 ? this.m_iFontColor | 0xF000000 : (this.m_hasBorder && n2 > 0 ? this.m_iBorderColor | 0xF000000 : 0);
            if (nArray[n3] == 0 || (this.m_curAlpha & 0xFF000000) == -16777216) continue;
            int n5 = n3;
            nArray[n5] = nArray[n5] & 0xFFFFFF;
            int n6 = n3;
            nArray[n6] = nArray[n6] | this.m_curAlpha;
        }
    }
}

