/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public abstract class GLLib
extends Canvas
implements Runnable {
    public static Graphics g = null;
    private static Graphics s_lastPaintGraphics = null;
    public static Graphics s_screenGraphics = null;
    static boolean s_game_isPaused;
    static int s_game_state;
    private static long s_game_timeWhenFrameStart;
    static boolean s_game_interruptNotify;
    static int s_screenWidth;
    static int s_screenHeight;
    private static Display s_display;
    private static boolean s_game_isInPaint;
    private static MIDlet s_application;
    private static int m_FPSLimiter;
    private long m_frameCoheranceTimer;
    private static int m_customSleepTime;
    private static Image m_imgBackBuffer;
    private static Graphics m_gBackBuffer;
    private static boolean m_bBackBufferEnabled;
    static int s_game_frameDT;
    private static long s_game_frameDTTimer;
    static int s_game_totalExecutionTime;
    private static int s_game_currentFrameNB;
    static GLLib s_gllib_instance;
    private static int m_keys_pressed;
    private static int m_keys_state;
    private static int m_current_keys_state;
    private static int m_current_keys_pressed;
    private static int m_current_keys_released;
    private static int m_last_key_pressed;
    static int s_keysDisabledTimer;
    private static Hashtable standardKeyTable;
    private static Hashtable gameActionKeyTable;
    private static int s_math_F_1;
    private static Random s_math_random;
    private static int[] s_math_cosTable;
    private static int[] s_math_aTanTable;
    static final int Math_AngleMUL;
    private static int Math_Angle90;
    private static int Math_Angle180;
    private static int Math_Angle270;
    private static int Math_Angle360;
    private static int Math_FixedPoint_PI;
    private static String s_pack_filename;
    private static InputStream s_pack_is;
    private static int s_pack_curOffset;
    private static short s_pack_nbData;
    private static int[] s_pack_offset;
    private static short s_pack_subPack_nbOf;
    private static short[] s_pack_subPack_fat;
    private static int s_pack_subPack_curSubPack;
    static int s_pack_lastDataReadMimeType;
    private static boolean s_pack_lastDataIsCompress;
    private static byte[] s_Pack_SkipBuffer;
    private static byte[][] MIME_type;
    private static byte[] m_Buffer;
    private static int m_inSize;
    private static long m_Range;
    private static long m_Code;
    private static byte[] m_outStream;
    private static int inputIndex;
    private static short[] m_lzmaInternalData;
    private static int Stream_readOffset;
    private static int text_nbString;
    static String text_encoding;
    private static byte[] text_array;
    private static int[] text_arrayOffset;
    private static String[] text_stringCacheArray;
    private static RecordStore s_rs;
    private static boolean s_profiler_emulator;
    private static int s_alphaRectCurrentARGB;
    private static int[] s_alphaRectARGBData;
    private static boolean pfx_usingScreenBuffer;
    static final boolean pfx_useSpriteEffects;
    private static boolean s_PFX_initializd;
    static int s_PFX_type;
    static int[][] s_PFX_params;
    static boolean s_PFX_hasAlpha;
    static int s_PFX_sizeX;
    static int s_PFX_sizeY;
    private static Image s_PFX_screenBuffer;
    private static Graphics s_PFX_screenBufferG;
    private static int s_PFX_enableScreenBuffer;
    private static int s_PFX_enableScreenBufferThisFrame;

    void Game_update() throws Exception {
    }

    public void Game_Run() throws Exception {
    }

    public GLLib(Object object, Object object2) {
        s_gllib_instance = this;
        s_game_state = -1;
        s_game_isInPaint = true;
        s_application = (MIDlet)object;
        s_display = (Display)object2;
        this.SetupDisplay();
        gameActionKeyTable = new Hashtable();
        standardKeyTable = new Hashtable<Integer, Integer>();
        standardKeyTable.put(new Integer(48), new Integer(6));
        standardKeyTable.put(new Integer(49), new Integer(7));
        standardKeyTable.put(new Integer(50), new Integer(8));
        standardKeyTable.put(new Integer(51), new Integer(9));
        standardKeyTable.put(new Integer(52), new Integer(10));
        standardKeyTable.put(new Integer(53), new Integer(11));
        standardKeyTable.put(new Integer(54), new Integer(12));
        standardKeyTable.put(new Integer(55), new Integer(13));
        standardKeyTable.put(new Integer(56), new Integer(14));
        standardKeyTable.put(new Integer(57), new Integer(15));
        standardKeyTable.put(new Integer(35), new Integer(17));
        standardKeyTable.put(new Integer(42), new Integer(16));
        standardKeyTable.put(new Integer(-6), new Integer(18));
        standardKeyTable.put(new Integer(-7), new Integer(19));
        gameActionKeyTable.put(new Integer(-5), new Integer(5));
        gameActionKeyTable.put(new Integer(-1), new Integer(1));
        gameActionKeyTable.put(new Integer(-2), new Integer(2));
        gameActionKeyTable.put(new Integer(-3), new Integer(3));
        gameActionKeyTable.put(new Integer(-4), new Integer(4));
        this.m_frameCoheranceTimer = s_game_frameDTTimer = System.currentTimeMillis();
        this.Init();
    }

    protected final void Init() {
        if (s_game_state >= 0) {
            return;
        }
        s_screenWidth = 320;
        s_screenHeight = 240;
        GLLib.Math_RandSetSeed(System.currentTimeMillis());
        s_game_state = 0;
        new Thread(this).start();
    }

    protected void Pause() {
        if (!s_game_isPaused) {
            s_game_isPaused = true;
        }
    }

    protected void Resume() {
        if (s_game_isPaused) {
            long l;
            s_game_timeWhenFrameStart = l = System.currentTimeMillis();
            s_game_frameDTTimer = l;
            this.m_frameCoheranceTimer = l;
            s_game_isPaused = false;
            this.SetupDisplay();
            s_game_interruptNotify = true;
            if (!s_game_isInPaint) {
                this.repaint();
            }
            GLLib.ResetKey();
        }
    }

    public void hideNotify() {
        this.Pause();
    }

    public void showNotify() {
        this.Resume();
    }

    public void sizeChanged(int n, int n2) {
    }

    private void SetupDisplay() {
        if (s_display != null && s_display.getCurrent() != this) {
            s_display.setCurrent((Displayable)this);
        }
        this.setFullScreenMode(true);
    }

    public void run() {
        try {
            this.SetupDisplay();
            s_game_isInPaint = false;
            while (s_game_state >= 0) {
                if (!s_game_isPaused) {
                    this.repaint();
                    this.serviceRepaints();
                    this.Game_Run();
                    s_game_interruptNotify = false;
                    long l = System.currentTimeMillis();
                    this.m_frameCoheranceTimer = Math.min(this.m_frameCoheranceTimer, l);
                    Thread.sleep(Math.max(1L, (long)m_FPSLimiter - (l - this.m_frameCoheranceTimer)));
                    this.m_frameCoheranceTimer = System.currentTimeMillis();
                    continue;
                }
                this.m_frameCoheranceTimer = Math.min(this.m_frameCoheranceTimer, System.currentTimeMillis());
                Thread.sleep(1L);
            }
        }
        catch (Exception exception) {
            new StringBuffer().append("!!FATAL ERROR!! in cGame.run().").append(exception);
            exception.printStackTrace();
            s_game_state = -1;
        }
        MIME_type = null;
        System.gc();
        s_application.notifyDestroyed();
    }

    public void paint(Graphics graphics) {
        s_screenGraphics = graphics;
        if (s_game_isPaused || s_game_isInPaint) {
            return;
        }
        s_game_isInPaint = true;
        m_keys_pressed = m_current_keys_pressed;
        m_keys_state = m_current_keys_state;
        m_current_keys_pressed = 0;
        m_current_keys_released = 0;
        if (s_keysDisabledTimer > 0) {
            if (s_keysDisabledTimer != Integer.MAX_VALUE) {
                s_keysDisabledTimer -= s_game_frameDT;
            }
            GLLib.ResetKey();
        }
        if ((s_game_frameDT = (int)((s_game_timeWhenFrameStart = System.currentTimeMillis()) - s_game_frameDTTimer)) < 0) {
            s_game_frameDT = 0;
        }
        if (s_game_frameDT > 1000) {
            s_game_frameDT = 1000;
        }
        s_game_frameDTTimer = s_game_timeWhenFrameStart;
        s_game_totalExecutionTime += s_game_frameDT;
        ++s_game_currentFrameNB;
        try {
            g = s_lastPaintGraphics = graphics;
            this.Game_update();
        }
        catch (Exception exception) {
            new StringBuffer().append("!!FATAL ERROR!! in Game_paint().").append(exception);
            exception.printStackTrace();
            s_game_state = -1;
        }
        s_game_isInPaint = false;
        s_screenGraphics = null;
    }

    protected void keyPressed(int n) {
        int n2 = 1 << GLLib.Game_TranslateKeyCode(n);
        m_current_keys_pressed |= n2;
        m_current_keys_state |= n2;
    }

    protected void pointerReleased(int n, int n2) {
        if (n < 30 && n2 > 220) {
            this.keyPressed(-6);
            return;
        }
        if (n > 290 && n2 > 220) {
            this.keyPressed(-7);
        }
    }

    protected void keyReleased(int n) {
        int n2 = 1 << GLLib.Game_TranslateKeyCode(n);
        m_current_keys_released |= n2;
        m_current_keys_state &= ~n2;
    }

    public static void Game_KeySetKeyCode(boolean bl, int n, int n2) {
        Hashtable hashtable = standardKeyTable;
        Integer n3 = new Integer(n);
        Integer n4 = (Integer)hashtable.get(n3);
        if (n4 != null) {
            hashtable.remove(n3);
        }
        hashtable.put(n3, new Integer(n2));
    }

    private static byte Game_TranslateKeyCode(int n) {
        Integer n2 = new Integer(n);
        if (standardKeyTable == null) {
            return 0;
        }
        Integer n3 = (Integer)standardKeyTable.get(n2);
        if (n3 != null) {
            return n3.byteValue();
        }
        n3 = (Integer)gameActionKeyTable.get(n2);
        if (n3 != null) {
            return n3.byteValue();
        }
        return 0;
    }

    public static void ResetKey() {
        m_keys_pressed = 0;
        m_keys_state = 0;
        m_current_keys_state = 0;
        m_current_keys_pressed = 0;
        m_current_keys_released = 0;
    }

    public static boolean IsKeyDown(int n) {
        return (m_keys_state & 1 << n) != 0;
    }

    public static int WasAnyKeyPressed() {
        if (m_keys_pressed == 0) {
            return -1;
        }
        int n = 24;
        while (--n >= 0) {
            if ((m_keys_pressed & 1 << n) == 0) continue;
            return n;
        }
        return -1;
    }

    public static boolean WasKeyPressed(int n) {
        return (m_keys_pressed & 1 << n) != 0;
    }

    static void Math_Init(String string, int n, int n2) throws Exception {
        GLLib.Pack_Open(string);
        s_math_cosTable = (int[])GLLib.Pack_ReadArray(0);
        GLLib.Pack_ReadArray(1);
        GLLib.Pack_Close();
    }

    static final int Math_FixedPointToInt(int n) {
        return n + (s_math_F_1 >> 1) >> 8;
    }

    static final int Math_Log2(int n) {
        int n2 = 0;
        while (n >> n2 > 1) {
            ++n2;
        }
        return n2;
    }

    static final void Math_RandSetSeed(long l) {
        if (s_math_random == null) {
            s_math_random = new Random(l);
            return;
        }
        s_math_random.setSeed(l);
    }

    static int Math_Rand(int n, int n2) {
        if (n2 != n) {
            int n3 = s_math_random.nextInt();
            if (n3 < 0) {
                n3 = -n3;
            }
            return n + n3 % (n2 - n);
        }
        return n2;
    }

    static final int Math_Rand() {
        return s_math_random.nextInt();
    }

    static final int Math_Sin(int n) {
        return GLLib.Math_Cos(Math_Angle90 - n);
    }

    static int Math_Cos(int n) {
        if (n < 0) {
            n = -n;
        }
        if ((n &= Math_Angle360 - 1) <= Math_Angle90) {
            return s_math_cosTable[n];
        }
        if (n < Math_Angle180) {
            n = Math_Angle180 - n;
            return -s_math_cosTable[n];
        }
        if (n <= Math_Angle270) {
            return -s_math_cosTable[n -= Math_Angle180];
        }
        n = Math_Angle360 - n;
        return s_math_cosTable[n];
    }

    private static int Math_Tan(int n) {
        int n2 = GLLib.Math_Cos(n);
        if (n2 == 0) {
            return Integer.MAX_VALUE;
        }
        n = GLLib.Math_Sin(n);
        return (n << 8) / n2;
    }

    private static int Math_AtanSlow(int n, int n2, int n3) {
        for (int i = n; i < n2; ++i) {
            if (GLLib.Math_Tan(i) > n3 || n3 >= GLLib.Math_Tan(i + 1)) continue;
            return i;
        }
        if (n == Math_Angle90 || n2 == Math_Angle90) {
            return Math_Angle90;
        }
        if (n == Math_Angle270 || n2 == Math_Angle270) {
            return Math_Angle270;
        }
        return 0;
    }

    static int Math_Atan(int n, int n2) {
        int n3;
        if (s_math_aTanTable == null) {
            s_math_aTanTable = new int[s_math_F_1 + 1];
            for (n3 = 0; n3 < s_math_F_1 + 1; ++n3) {
                int n4 = n3;
                int n5 = s_math_F_1;
                GLLib.s_math_aTanTable[n3] = n5 > 0 ? (n4 > 0 ? GLLib.Math_AtanSlow(0, Math_Angle90, n4 * s_math_F_1 / n5) : (n4 == 0 ? 0 : GLLib.Math_AtanSlow(Math_Angle270, Math_Angle360, n4 * s_math_F_1 / n5))) : (n5 == 0 ? (n4 > 0 ? Math_Angle90 : (n4 == 0 ? 0 : Math_Angle270)) : (n4 > 0 ? GLLib.Math_AtanSlow(Math_Angle90, Math_Angle180, n4 * s_math_F_1 / n5) : (n4 == 0 ? Math_Angle180 : GLLib.Math_AtanSlow(Math_Angle180, Math_Angle270, n4 * s_math_F_1 / n5))));
            }
        }
        if (n == 0) {
            if (n2 > 0) {
                return Math_Angle90;
            }
            if (n2 == 0) {
                return 0;
            }
            return Math_Angle270;
        }
        if (n > 0) {
            if (n2 >= 0) {
                if (n >= n2) {
                    n3 = n2 * s_math_F_1 / n;
                    return s_math_aTanTable[n3];
                }
                n3 = n * s_math_F_1 / n2;
                return Math_Angle90 - s_math_aTanTable[n3];
            }
            if (n >= (n2 = -n2)) {
                n3 = n2 * s_math_F_1 / n;
                return Math_Angle360 - s_math_aTanTable[n3];
            }
            n3 = n * s_math_F_1 / n2;
            return Math_Angle270 + s_math_aTanTable[n3];
        }
        n = -n;
        if (n2 >= 0) {
            if (n >= n2) {
                n3 = n2 * s_math_F_1 / n;
                return Math_Angle180 - s_math_aTanTable[n3];
            }
            n3 = n * s_math_F_1 / n2;
            return Math_Angle90 + s_math_aTanTable[n3];
        }
        if (n >= (n2 = -n2)) {
            n3 = n2 * s_math_F_1 / n;
            return Math_Angle180 + s_math_aTanTable[n3];
        }
        n3 = n * s_math_F_1 / n2;
        return Math_Angle270 - s_math_aTanTable[n3];
    }

    static int Math_Sqrt(long l) {
        long l2 = 0L;
        long l3 = 32768L;
        long l4 = 15L;
        do {
            long l5;
            if (l < (l5 = (l2 << 1) + l3 << (int)l4--)) continue;
            l2 += l3;
            l -= l5;
        } while ((l3 >>= 1) > 0L);
        return (int)l2;
    }

    static boolean Math_RectIntersect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n3 < n5) {
            return false;
        }
        if (n > n7) {
            return false;
        }
        if (n4 < n6) {
            return false;
        }
        return n2 <= n8;
    }

    public static InputStream GetResourceAsStream(String object) {
        object = "".getClass().getResourceAsStream((String)object);
        return object;
    }

    static void Pack_Open(String object) {
        if (s_pack_filename != null && ((String)object).compareTo(s_pack_filename) == 0) {
            return;
        }
        GLLib.Pack_Close();
        s_pack_filename = object;
        object = s_pack_filename;
        object = GLLib.GetResourceAsStream(s_pack_filename);
        s_pack_is = object;
        s_pack_nbData = (short)GLLib.Pack_Read16();
        s_pack_subPack_nbOf = (short)GLLib.Pack_Read16();
        s_pack_subPack_fat = new short[s_pack_subPack_nbOf];
        for (int i = 0; i < s_pack_subPack_nbOf; ++i) {
            GLLib.s_pack_subPack_fat[i] = (short)GLLib.Pack_Read16();
        }
        s_pack_subPack_curSubPack = 0;
        GLLib.Pack_GetDataOffset();
    }

    private static void Pack_GetDataOffset() {
        int n = s_pack_subPack_curSubPack == s_pack_subPack_nbOf - 1 ? s_pack_nbData - s_pack_subPack_fat[s_pack_subPack_curSubPack] : s_pack_subPack_fat[s_pack_subPack_curSubPack + 1] - s_pack_subPack_fat[s_pack_subPack_curSubPack];
        s_pack_offset = new int[n + 1];
        for (int i = 0; i < n + 1; ++i) {
            GLLib.s_pack_offset[i] = GLLib.Pack_Read() & 0xFF | (GLLib.Pack_Read() & 0xFF) << 8 | ((GLLib.Pack_Read() & 0xFF) << 16 | (GLLib.Pack_Read() & 0xFF) << 24);
        }
    }

    static void Pack_Close() {
        if (s_pack_is != null) {
            try {
                s_pack_is.close();
            }
            catch (Exception exception) {}
            s_pack_is = null;
        }
        s_pack_curOffset = 0;
        System.gc();
    }

    private static int Pack_PositionAtData(int n) {
        Object object;
        int n2;
        for (n2 = s_pack_subPack_nbOf - 1; n2 >= 0 && s_pack_subPack_fat[n2] > n; --n2) {
        }
        if (s_pack_subPack_curSubPack != n2) {
            s_pack_subPack_curSubPack = n2;
            GLLib.Pack_Close();
            if (s_pack_subPack_curSubPack == 0) {
                String string = s_pack_filename;
                s_pack_filename = null;
                GLLib.Pack_Open(string);
            } else {
                String string = s_pack_filename;
                if (s_pack_filename.endsWith(".png")) {
                    string = s_pack_filename.substring(0, s_pack_filename.length() - ".png".length());
                }
                object = string + "_" + s_pack_subPack_curSubPack + ".png";
                object = GLLib.GetResourceAsStream((String)object);
                s_pack_is = object;
                GLLib.Pack_GetDataOffset();
            }
        } else if (s_pack_is == null) {
            if (s_pack_subPack_curSubPack == 0) {
                String string = s_pack_filename;
                s_pack_filename = null;
                GLLib.Pack_Open(string);
            } else {
                String string = s_pack_filename;
                if (s_pack_filename.endsWith(".png")) {
                    string = s_pack_filename.substring(0, s_pack_filename.length() - ".png".length());
                }
                object = string + "_" + s_pack_subPack_curSubPack + ".png";
                object = GLLib.GetResourceAsStream((String)object);
                s_pack_is = object;
            }
        }
        int n3 = s_pack_offset[n -= s_pack_subPack_fat[s_pack_subPack_curSubPack]];
        n = s_pack_offset[n + 1] - s_pack_offset[n];
        if (s_pack_curOffset != n3) {
            if (s_pack_curOffset > n3) {
                GLLib.Pack_Close();
                if (s_pack_subPack_curSubPack == 0) {
                    object = s_pack_filename;
                    object = GLLib.GetResourceAsStream((String)object);
                    s_pack_is = object;
                } else {
                    object = s_pack_filename;
                    if (s_pack_filename.endsWith(".png")) {
                        object = s_pack_filename.substring(0, s_pack_filename.length() - ".png".length());
                    }
                    object = (String)object + "_" + s_pack_subPack_curSubPack + ".png";
                    object = GLLib.GetResourceAsStream((String)object);
                    s_pack_is = object;
                }
                if (s_pack_is == null) {
                    // empty if block
                }
            } else {
                n3 -= s_pack_curOffset;
            }
            GLLib.Pack_Skip(n3);
        }
        s_pack_lastDataIsCompress = false;
        if (n > 0) {
            s_pack_lastDataReadMimeType = GLLib.Pack_Read() & 0xFF;
            if (s_pack_lastDataReadMimeType >= 127) {
                s_pack_lastDataReadMimeType -= 127;
                s_pack_lastDataIsCompress = true;
            }
            --n;
        }
        return n;
    }

    static byte[] Pack_ReadData(int n) {
        n = GLLib.Pack_PositionAtData(n);
        byte[] byArray = null;
        if (s_pack_lastDataIsCompress) {
            try {
                Object object;
                int n2 = n;
                Object object2 = s_pack_is;
                byte[] byArray2 = new byte[13];
                byte[] byArray3 = new byte[n2 - 13];
                GLLib.Stream_ReadFully((InputStream)object2, byArray2, 0, 13);
                GLLib.Stream_ReadFully((InputStream)object2, byArray3, 0, n2 - 13);
                object2 = new int[5];
                for (n2 = 0; n2 < 5; ++n2) {
                    object2[n2] = byArray2[n2] & 0xFF;
                }
                n2 = 0;
                for (object = 0; object < 4; ++object) {
                    n2 += (byArray2[object + 5] & 0xFF) << (object << 3);
                }
                Object object3 = object2[0];
                object = object3;
                Object object4 = object3 / 45;
                int n3 = (object %= 45) / 9;
                int n4 = object % 9;
                object = 1846 + (768 << n4 + n3);
                m_outStream = new byte[n2];
                m_lzmaInternalData = new short[object];
                reference v1 = object4;
                object4 = n2;
                byte[] byArray4 = byArray3;
                Object object5 = v1;
                n2 = n4;
                n4 = object << 1;
                int n5 = byArray4.length;
                int n6 = 1846 + (768 << n2 + n3);
                short[] sArray = m_lzmaInternalData;
                int n7 = 0;
                boolean bl = false;
                int n8 = 0;
                int n9 = 1;
                int n10 = 1;
                int n11 = 1;
                int n12 = 1;
                int n13 = 0;
                object5 = (1 << object5) - 1;
                n3 = (1 << n3) - 1;
                if (n4 >= n6 << 1) {
                    int n14;
                    for (n4 = 0; n4 < n6; ++n4) {
                        sArray[n4] = 1024;
                    }
                    int n15 = n5;
                    m_Buffer = byArray4;
                    m_inSize = n15;
                    inputIndex = 0;
                    m_Code = 0L;
                    m_Range = 0xFFFFFFFFL;
                    for (n14 = 0; n14 < 5; ++n14) {
                        m_Code = m_Code << 8 | (long)GLLib.LZMA_RangeDecoderReadByte();
                    }
                    while (n13 < object4) {
                        n4 = n13 & object5;
                        if (GLLib.LZMA_RangeDecoderBitDecode(0 + (n7 << 4) + n4) == 0) {
                            int n16 = 1846 + 768 * (((n13 & n3) << n2) + ((n8 & 0xFF) >> 8 - n2));
                            n7 = n7 < 4 ? 0 : (n7 < 10 ? (n7 -= 3) : (n7 -= 6));
                            if (bl) {
                                n15 = n5 = m_outStream[n13 - n9];
                                n14 = 1;
                                do {
                                    int n17 = n15 >> 7 & 1;
                                    n15 = (byte)(n15 << 1);
                                    int n18 = GLLib.LZMA_RangeDecoderBitDecode(n16 + (n17 + 1 << 8) + n14);
                                    n14 = n14 << 1 | n18;
                                    if (n17 == n18) continue;
                                    while (n14 < 256) {
                                        n14 = n14 << 1 | GLLib.LZMA_RangeDecoderBitDecode(n16 + n14);
                                    }
                                    break;
                                } while (n14 < 256);
                                n8 = n14 & 0xFF;
                                bl = false;
                            } else {
                                n15 = 1;
                                while ((n15 = n15 << 1 | GLLib.LZMA_RangeDecoderBitDecode(n16 + n15)) < 256) {
                                }
                                n8 = n15 & 0xFF;
                            }
                            GLLib.m_outStream[n13++] = (byte)n8;
                            continue;
                        }
                        bl = true;
                        if (GLLib.LZMA_RangeDecoderBitDecode(n7 + 192) == 1) {
                            if (GLLib.LZMA_RangeDecoderBitDecode(n7 + 204) == 0) {
                                if (GLLib.LZMA_RangeDecoderBitDecode(240 + (n7 << 4) + n4) == 0) {
                                    n7 = n7 < 7 ? 9 : 11;
                                    n8 = m_outStream[n13 - n9] & 0xFF;
                                    GLLib.m_outStream[n13++] = (byte)n8;
                                    continue;
                                }
                            } else {
                                int n19;
                                if (GLLib.LZMA_RangeDecoderBitDecode(n7 + 216) == 0) {
                                    n19 = n10;
                                } else {
                                    if (GLLib.LZMA_RangeDecoderBitDecode(n7 + 228) == 0) {
                                        n19 = n11;
                                    } else {
                                        n19 = n12;
                                        n12 = n11;
                                    }
                                    n11 = n10;
                                }
                                n10 = n9;
                                n9 = n19;
                            }
                            n4 = GLLib.LZMA_LenDecode(1332, n4);
                            n7 = n7 < 7 ? 8 : 11;
                        } else {
                            n12 = n11;
                            n11 = n10;
                            n10 = n9;
                            n7 = n7 < 7 ? 7 : 10;
                            int n20 = GLLib.LZMA_RangeDecoderBitTreeDecode(432 + (((n4 = GLLib.LZMA_LenDecode(818, n4)) < 4 ? n4 : 3) << 6), 6);
                            if (n20 >= 4) {
                                n5 = (n20 >> 1) - 1;
                                n9 = (2 | n20 & 1) << n5;
                                if (n20 < 14) {
                                    n9 += GLLib.LZMA_RangeDecoderReverseBitTreeDecode(n9 + 688 - n20 - 1, n5);
                                } else {
                                    n20 = n5 - 4;
                                    long l = m_Range;
                                    long l2 = m_Code;
                                    n5 = 0;
                                    while (n20 > 0) {
                                        n5 <<= 1;
                                        if (l2 >= (l >>= 1)) {
                                            l2 -= l;
                                            n5 |= 1;
                                        }
                                        if (l < 0x1000000L) {
                                            l <<= 8;
                                            l2 = l2 << 8 | (long)GLLib.LZMA_RangeDecoderReadByte();
                                        }
                                        --n20;
                                    }
                                    m_Range = l;
                                    m_Code = l2;
                                    n9 += n5 << 4;
                                    n9 += GLLib.LZMA_RangeDecoderReverseBitTreeDecode(802, 4);
                                }
                            } else {
                                n9 = n20;
                            }
                            ++n9;
                        }
                        n4 += 2;
                        do {
                            n8 = m_outStream[n13 - n9] & 0xFF;
                            GLLib.m_outStream[n13++] = (byte)n8;
                        } while (--n4 > 0 && n13 < object4);
                    }
                }
                m_lzmaInternalData = null;
                m_Buffer = null;
                System.gc();
                s_pack_curOffset += n;
                byArray = m_outStream;
                m_outStream = null;
            }
            catch (Exception exception) {
                new StringBuffer().append("LZMA decompression failed : ").append(exception.toString());
            }
        } else {
            byArray = new byte[n];
            GLLib.Pack_ReadFully(byArray, 0, byArray.length);
        }
        return byArray;
    }

    private static void Pack_Skip(int n) {
        if (n == 0) {
            return;
        }
        if (s_Pack_SkipBuffer == null) {
            s_Pack_SkipBuffer = new byte[256];
        }
        while (n > 256) {
            GLLib.Pack_ReadFully(s_Pack_SkipBuffer, 0, 256);
            n -= 256;
        }
        if (n > 0) {
            GLLib.Pack_ReadFully(s_Pack_SkipBuffer, 0, n);
        }
    }

    private static int Pack_Read() {
        int n = 0;
        try {
            n = s_pack_is.read();
        }
        catch (Exception exception) {}
        ++s_pack_curOffset;
        return n;
    }

    private static int Pack_Read16() {
        return GLLib.Pack_Read() & 0xFF | (GLLib.Pack_Read() & 0xFF) << 8;
    }

    private static int Pack_ReadFully(byte[] byArray, int n, int n2) {
        n = 0;
        int n3 = n2;
        try {
            while (n3 > 0) {
                int n4 = s_pack_is.read(byArray, n, n3);
                n3 -= n4;
                n += n4;
            }
        }
        catch (Exception exception) {}
        s_pack_curOffset += n2;
        return n2;
    }

    private static Object Pack_ReadArray(int n) {
        Object object;
        GLLib.Pack_PositionAtData(n);
        Stream_readOffset = 0;
        if (s_pack_lastDataIsCompress) {
            object = GLLib.Pack_ReadData(n);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            object = byteArrayInputStream;
            object = GLLib.Mem_ReadArray(byteArrayInputStream);
        } else {
            object = GLLib.Mem_ReadArray(s_pack_is);
            s_pack_curOffset += Stream_readOffset;
        }
        return object;
    }

    static void Pack_LoadMIME(String object) {
        if (MIME_type == null) {
            InputStream inputStream = s_pack_is;
            object = GLLib.GetResourceAsStream((String)object);
            s_pack_is = object;
            int n = GLLib.Pack_Read();
            MIME_type = new byte[n][];
            for (int i = 0; i < n; ++i) {
                int n2 = GLLib.Pack_Read();
                GLLib.MIME_type[i] = new byte[n2];
                GLLib.Pack_ReadFully(MIME_type[i], 0, n2);
            }
            try {
                s_pack_is.close();
            }
            catch (Exception exception) {}
            s_pack_is = inputStream;
        }
    }

    private static int LZMA_RangeDecoderReadByte() {
        if (inputIndex == m_inSize) {
            return 255;
        }
        return m_Buffer[inputIndex++] & 0xFF;
    }

    private static int LZMA_RangeDecoderBitDecode(int n) {
        long l = (m_Range >> 11) * (long)m_lzmaInternalData[n];
        if (m_Code < l) {
            m_Range = l;
            int n2 = n;
            m_lzmaInternalData[n2] = (short)(m_lzmaInternalData[n2] + (2048 - m_lzmaInternalData[n] >> 5));
            if (m_Range < 0x1000000L) {
                m_Code = m_Code << 8 | (long)GLLib.LZMA_RangeDecoderReadByte();
                m_Range <<= 8;
            }
            return 0;
        }
        m_Code -= l;
        int n3 = n;
        m_lzmaInternalData[n3] = (short)(m_lzmaInternalData[n3] - (m_lzmaInternalData[n] >> 5));
        if ((m_Range -= l) < 0x1000000L) {
            m_Code = m_Code << 8 | (long)GLLib.LZMA_RangeDecoderReadByte();
            m_Range <<= 8;
        }
        return 1;
    }

    private static int LZMA_RangeDecoderBitTreeDecode(int n, int n2) {
        int n3 = 1;
        for (int i = n2; i > 0; --i) {
            n3 = (n3 << 1) + GLLib.LZMA_RangeDecoderBitDecode(n + n3);
        }
        return n3 - (1 << n2);
    }

    private static int LZMA_LenDecode(int n, int n2) {
        if (GLLib.LZMA_RangeDecoderBitDecode(n) == 0) {
            return GLLib.LZMA_RangeDecoderBitTreeDecode(n + 2 + (n2 << 3), 3);
        }
        if (GLLib.LZMA_RangeDecoderBitDecode(n + 1) == 0) {
            return 8 + GLLib.LZMA_RangeDecoderBitTreeDecode(n + 130 + (n2 << 3), 3);
        }
        return 16 + GLLib.LZMA_RangeDecoderBitTreeDecode(n + 258, 8);
    }

    private static int LZMA_RangeDecoderReverseBitTreeDecode(int n, int n2) {
        int n3 = 1;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = GLLib.LZMA_RangeDecoderBitDecode(n + n3);
            n3 = (n3 << 1) + n5;
            n4 |= n5 << i;
        }
        return n4;
    }

    static final int GetClipX(Graphics graphics) {
        return graphics.getClipX();
    }

    static final int GetClipY(Graphics graphics) {
        return graphics.getClipY();
    }

    static final int GetClipWidth(Graphics graphics) {
        return graphics.getClipWidth();
    }

    static final int GetClipHeight(Graphics graphics) {
        return graphics.getClipHeight();
    }

    static final void ClipRect(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.clipRect(n, n2, n3, n4);
    }

    static final void SetClip(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setClip(n, n2, n3, n4);
    }

    static final boolean IsClipValid(Graphics graphics) {
        return graphics != null;
    }

    static final void FillRect(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.fillRect(n, n2, n3, n4);
    }

    static final void DrawRect(int n, int n2, int n3, int n4) {
        g.drawRect(n, n2, n3, n4);
    }

    static final Image CreateRGBImage(int[] object, int n, int n2, boolean bl) {
        Image image = Image.createRGBImage((int[])object, (int)n, (int)n2, (boolean)bl);
        object = image;
        return image;
    }

    static final void DrawRGB(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean n7, boolean bl, int n8) {
        int n9;
        int n10;
        int n11;
        if (n11 != 0) {
            if ((n11 & 4) != 0) {
                n2 = n5;
                n5 = n6;
                n6 = n2;
                n2 = n5;
            }
            nArray = ASprite.TransformRGB(nArray, n5, n6, n11);
        }
        int n12 = n2;
        int n13 = n6;
        n6 = n5;
        n5 = n / n2;
        n2 = n % n2;
        n = n12;
        boolean bl2 = n7;
        n11 = n13;
        int n14 = n6;
        n7 = n4;
        n6 = n3;
        n4 = n2;
        n3 = n;
        int[] nArray2 = nArray;
        n = s_screenHeight;
        int n102 = s_screenWidth;
        n4 += n5 * n3;
        if (n6 >= n102 || n6 + n14 <= 0 || n7 >= n || n7 + n11 <= 0) {
            return;
        }
        if (g == null) {
            Graphics graphics2 = graphics;
            g = graphics2 == null ? s_lastPaintGraphics : graphics2;
        }
        Graphics graphics2 = g;
        int n112 = graphics2.getClipX();
        graphics2 = g;
        int n15 = graphics2.getClipY();
        graphics2 = g;
        int n16 = graphics2.getClipWidth();
        graphics2 = g;
        int n17 = graphics2.getClipHeight();
        if (n112 >= n102 || n112 + n16 <= 0 || n15 >= n || n15 + n17 <= 0) {
            return;
        }
        if (n6 <= 0) {
            n4 -= n6;
            n10 = n14 + n6;
            n6 = 0;
        }
        if (n6 + n10 >= n102) {
            n9 = n102 - n6;
        }
        if (n7 + n11 >= n) {
            n11 = n - n7;
        }
        if (n7 <= 0) {
            n4 -= n7 * n3;
            n11 += n7;
            n7 = 0;
        }
        if (n4 > 0) {
            n112 = nArray2.length;
            n15 = 0;
            for (n16 = n4; n16 < n112; ++n16) {
                nArray2[n15++] = nArray2[n16];
            }
            n4 = 0;
        }
        graphics.drawRGB(nArray2, n4, n3, n6, n7, n9, n11, bl2);
    }

    public static final void GetRGB(Image image, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        image.getRGB(nArray, n, n2, n3, n4, n5, n6);
    }

    static short Mem_GetShort(byte[] byArray, int n) {
        return (short)(byArray[n++] & 0xFF | (byArray[n] & 0xFF) << 8);
    }

    private static Object Mem_ReadArray(InputStream inputStream) {
        Object[] objectArray = null;
        try {
            int n = GLLib.Stream_Read(inputStream);
            int n2 = n >> 4;
            int n3 = n & 7;
            n = (n & 8) != 0 ? GLLib.Stream_Read16(inputStream) : GLLib.Stream_Read(inputStream);
            switch (n3) {
                case 0: {
                    byte[] byArray = new byte[n];
                    for (n2 = 0; n2 < n; ++n2) {
                        byArray[n2] = (byte)GLLib.Stream_Read(inputStream);
                    }
                    objectArray = byArray;
                    break;
                }
                case 1: {
                    short[] sArray = new short[n];
                    if (n2 == 0) {
                        for (n2 = 0; n2 < n; ++n2) {
                            sArray[n2] = (byte)GLLib.Stream_Read(inputStream);
                        }
                    } else {
                        for (n2 = 0; n2 < n; ++n2) {
                            sArray[n2] = (short)GLLib.Stream_Read16(inputStream);
                        }
                    }
                    objectArray = sArray;
                    break;
                }
                case 2: {
                    int[] nArray = new int[n];
                    if (n2 == 0) {
                        for (n2 = 0; n2 < n; ++n2) {
                            nArray[n2] = (byte)GLLib.Stream_Read(inputStream);
                        }
                    } else if (n2 == 1) {
                        for (n2 = 0; n2 < n; ++n2) {
                            nArray[n2] = (short)GLLib.Stream_Read16(inputStream);
                        }
                    } else {
                        for (n2 = 0; n2 < n; ++n2) {
                            nArray[n2] = GLLib.Stream_Read32(inputStream);
                        }
                    }
                    objectArray = nArray;
                    break;
                }
                default: {
                    Object[] objectArray2;
                    switch (n3 &= 3) {
                        case 0: {
                            Object object;
                            if (n2 == 2) {
                                object = new byte[n][];
                                objectArray2 = (Object[])object;
                                break;
                            }
                            byte[][][] byArrayArray = new byte[n][][];
                            object = byArrayArray;
                            objectArray2 = (Object[])byArrayArray;
                            break;
                        }
                        case 1: {
                            Object object;
                            if (n2 == 2) {
                                short[][] sArrayArray = new short[n][];
                                object = sArrayArray;
                                objectArray2 = (Object[])sArrayArray;
                                break;
                            }
                            short[][][] sArrayArray = new short[n][][];
                            object = sArrayArray;
                            objectArray2 = (Object[])sArrayArray;
                            break;
                        }
                        default: {
                            Object object;
                            if (n2 == 2) {
                                int[][] nArrayArray = new int[n][];
                                object = nArrayArray;
                                objectArray2 = (Object[])nArrayArray;
                                break;
                            }
                            int[][][] nArrayArray = new int[n][][];
                            object = nArrayArray;
                            objectArray2 = (Object[])nArrayArray;
                        }
                    }
                    for (int i = 0; i < n; ++i) {
                        objectArray2[i] = GLLib.Mem_ReadArray(inputStream);
                    }
                    objectArray = objectArray2;
                    break;
                }
            }
        }
        catch (Exception exception) {}
        return objectArray;
    }

    private static int Stream_Read(InputStream inputStream) throws Exception {
        int n = inputStream.read();
        if (n >= 0) {
            ++Stream_readOffset;
        }
        return n;
    }

    private static int Stream_Read16(InputStream inputStream) throws Exception {
        return GLLib.Stream_Read(inputStream) & 0xFF | (GLLib.Stream_Read(inputStream) & 0xFF) << 8;
    }

    private static int Stream_Read32(InputStream inputStream) throws Exception {
        return GLLib.Stream_Read(inputStream) & 0xFF | (GLLib.Stream_Read(inputStream) & 0xFF) << 8 | ((GLLib.Stream_Read(inputStream) & 0xFF) << 16 | (GLLib.Stream_Read(inputStream) & 0xFF) << 24);
    }

    private static int Stream_ReadFully(InputStream inputStream, byte[] byArray, int n, int n2) {
        n = 0;
        int n3 = n2;
        try {
            while (n3 > 0) {
                int n4 = inputStream.read(byArray, n, n3);
                n3 -= n4;
                n += n4;
            }
        }
        catch (Exception exception) {}
        Stream_readOffset += n2;
        return n2;
    }

    private static int Text_LoadTextFromStream(InputStream inputStream) {
        try {
            text_nbString = GLLib.Stream_Read32(inputStream);
            text_arrayOffset = new int[text_nbString + 1];
            for (int i = 1; i < text_nbString + 1; ++i) {
                GLLib.text_arrayOffset[i] = GLLib.Stream_Read32(inputStream);
            }
            text_array = new byte[text_arrayOffset[text_nbString]];
            GLLib.Stream_ReadFully(inputStream, text_array, 0, text_array.length);
        }
        catch (Exception exception) {}
        return text_array.length + (text_nbString + 1 << 2);
    }

    static void Text_LoadTextFromPack(String object, int n) {
        GLLib.Text_FreeAll();
        GLLib.Pack_Open((String)object);
        GLLib.Pack_PositionAtData(0);
        if (s_pack_lastDataIsCompress) {
            object = GLLib.Pack_ReadData(0);
            object = new ByteArrayInputStream((byte[])object);
            GLLib.Text_LoadTextFromStream((InputStream)object);
        } else {
            GLLib.Text_LoadTextFromStream(s_pack_is);
        }
        GLLib.Pack_Close();
        GLLib.Text_BuildStringCache();
    }

    static void Text_LoadTextFromPack(String object, int n, int n2) {
        GLLib.Text_FreeAll();
        GLLib.Pack_Open((String)object);
        GLLib.Pack_PositionAtData(0);
        if (s_pack_lastDataIsCompress) {
            object = new ByteArrayInputStream(GLLib.Pack_ReadData(0));
            GLLib.Text_LoadTextFromStream((InputStream)object);
        } else {
            s_pack_curOffset += GLLib.Text_LoadTextFromStream(s_pack_is);
        }
        int n3 = text_nbString;
        int[] nArray = text_arrayOffset;
        byte[] byArray = text_array;
        GLLib.Text_FreeAll();
        GLLib.Pack_PositionAtData(n2);
        if (s_pack_lastDataIsCompress) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(GLLib.Pack_ReadData(n2));
            GLLib.Text_LoadTextFromStream(byteArrayInputStream);
        } else {
            s_pack_curOffset += GLLib.Text_LoadTextFromStream(s_pack_is);
        }
        int n4 = text_nbString;
        int[] nArray2 = text_arrayOffset;
        byte[] byArray2 = text_array;
        int n5 = 1;
        while (n5 < n4 + 1) {
            int n6 = n5++;
            nArray2[n6] = nArray2[n6] + nArray[n3];
        }
        GLLib.Text_FreeAll();
        GLLib.Pack_Close();
        text_nbString = n3 + n4;
        text_arrayOffset = new int[text_nbString + 1];
        System.arraycopy(nArray, 0, text_arrayOffset, 0, nArray.length);
        System.arraycopy(nArray2, 1, text_arrayOffset, nArray.length, nArray2.length - 1);
        text_array = new byte[text_arrayOffset[text_nbString]];
        System.arraycopy(byArray, 0, text_array, 0, byArray.length);
        System.arraycopy(byArray2, 0, text_array, byArray.length, byArray2.length);
        GLLib.Text_BuildStringCache();
    }

    private static String Text_FromUTF8(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = n;
        n += n2;
        while (n4 < n) {
            if ((byArray[n4] & 0x80) == 0) {
                cArray[n3++] = (char)byArray[n4++];
                continue;
            }
            if ((byArray[n4] & 0xE0) == 224 && n4 + 2 < n && (byArray[n4 + 1] & 0xC0) == 128 && (byArray[n4 + 2] & 0xC0) == 128) {
                cArray[n3++] = (char)((byArray[n4] & 0xF) << 12 | (byArray[n4 + 1] & 0x3F) << 6 | byArray[n4 + 2] & 0x3F);
                n4 += 3;
                continue;
            }
            if ((byArray[n4] & 0xC0) == 192 && n4 + 1 < n && (byArray[n4 + 1] & 0xC0) == 128) {
                cArray[n3++] = (char)((byArray[n4] & 0x1F) << 6 | byArray[n4 + 1] & 0x3F);
                n4 += 2;
                continue;
            }
            return "";
        }
        return new String(cArray, 0, n3);
    }

    static String Text_GetString(int n) {
        if (text_stringCacheArray != null) {
            return text_stringCacheArray[n];
        }
        try {
            int n2 = text_arrayOffset[n + 1] - text_arrayOffset[n];
            if (n2 == 0) {
                return null;
            }
            if (!text_encoding.equals("UTF-8")) {
                return new String(text_array, text_arrayOffset[n], n2, text_encoding);
            }
            return GLLib.Text_FromUTF8(text_array, text_arrayOffset[n], n2);
        }
        catch (Exception exception) {
            new StringBuffer().append("Text_GetString.unable to create string, might try another encoding.").append(exception);
            return null;
        }
    }

    private static void Text_BuildStringCache() {
        int n = 0;
        String[] stringArray = new String[text_nbString];
        for (int i = 0; i < text_nbString; ++i) {
            stringArray[i] = GLLib.Text_GetString(i);
            if (stringArray[i] == null) continue;
            n += stringArray[i].length();
        }
        text_stringCacheArray = stringArray;
        text_arrayOffset = null;
        text_array = null;
        System.gc();
        if ((n <<= 1) > 15360) {
            new StringBuffer().append("you are caching ").append(text_nbString).append(" string, this comsume ").append(n).append(" byte of memory, you may consider dividing your text in smaller text package");
        }
    }

    private static void Text_FreeAll() {
        if (text_stringCacheArray != null) {
            for (int i = 0; i < text_nbString; ++i) {
                GLLib.text_stringCacheArray[i] = null;
            }
            text_stringCacheArray = null;
        }
        text_arrayOffset = null;
        text_array = null;
        text_nbString = 0;
    }

    public static final String StringFormat(String string, String stringArray) {
        stringArray = new String[]{stringArray};
        String string2 = "";
        int n = string.indexOf(37);
        if (n < 0) {
            return string;
        }
        int n2 = 0;
        n = 0;
        do {
            if ((n = string.indexOf(37, n)) < 0 || n == string.length() - 1) {
                string2 = string2 + string.substring(n2);
                n = -1;
                continue;
            }
            if (string.charAt(n + 1) == 's') {
                int n3 = -1;
                if (n + 2 < string.length()) {
                    n3 = string.charAt(n + 2) - 48;
                }
                if (n3 >= 0 && n3 <= 9) {
                    string2 = string2 + string.substring(n2, n);
                    string2 = string2 + stringArray[n3];
                    n = n2 = n + 3;
                    continue;
                }
                new StringBuffer().append("Invalid string format pattern '").append(string).append("'");
            }
            ++n;
        } while (n >= 0);
        return string2;
    }

    private static void Rms_Close() {
        if (s_rs == null) {
            return;
        }
        try {
            s_rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            new StringBuffer().append("ERROR! Failed closing RMS: ").append((Object)recordStoreException);
        }
        s_rs = null;
    }

    private static void Rms_Open(String string) throws RecordStoreException {
        new StringBuffer().append(" Open recordstore : ").append(string);
        s_rs = RecordStore.openRecordStore((String)string, (boolean)true);
    }

    static byte[] Rms_Read(String string) {
        return GLLib.Rms_Read_Single(string);
    }

    private static byte[] Rms_Read_Single(String string) {
        byte[] byArray = null;
        try {
            GLLib.Rms_Open(string);
            if (s_rs.getNumRecords() > 0) {
                byArray = s_rs.getRecord(1);
            }
        }
        catch (RecordStoreException recordStoreException) {
            new StringBuffer().append("ERROR! Failed reading from RMS: ").append((Object)recordStoreException);
            byArray = null;
        }
        GLLib.Rms_Close();
        return byArray;
    }

    static void Rms_Write(String string, byte[] byArray) {
        int n = byArray.length;
        boolean bl = false;
        String string2 = string;
        try {
            GLLib.Rms_Open(string2);
            if (s_rs.getNumRecords() > 0) {
                s_rs.setRecord(1, byArray, 0, n);
            } else {
                s_rs.addRecord(byArray, 0, n);
            }
        }
        catch (RecordStoreException recordStoreException) {
            new StringBuffer().append("ERROR! Failed writing into RMS: ").append((Object)recordStoreException);
        }
        GLLib.Rms_Close();
    }

    static void Profiler_BeginNamedEvent(String string) {
        if (s_profiler_emulator) {
            new StringBuffer().append("EMU://BeginNamedEvent:").append(string);
        }
    }

    static void Profiler_EndNamedEvent() {
    }

    public static void AlphaRect_SetColor(int n) {
        if (n != s_alphaRectCurrentARGB || s_alphaRectARGBData == null) {
            s_alphaRectCurrentARGB = n;
            if (s_alphaRectARGBData == null) {
                s_alphaRectARGBData = new int[1024];
            }
            int n2 = 1024;
            while (n2 > 0) {
                GLLib.s_alphaRectARGBData[--n2] = n;
            }
        }
    }

    public static void AlphaRect_Draw(Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics graphics2 = graphics;
        int n5 = graphics2.getClipX();
        graphics2 = graphics;
        int n6 = graphics2.getClipY();
        graphics2 = graphics;
        int n7 = graphics2.getClipWidth();
        graphics2 = graphics;
        int n8 = graphics2.getClipHeight();
        int n9 = n > n5 ? n : n5;
        int n10 = n2 > n6 ? n2 : n6;
        n3 = (n + n3 < n5 + n7 ? n + n3 : n5 + n7) - n9;
        n4 = (n2 + n4 < n6 + n8 ? n2 + n4 : n6 + n8) - n10;
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        GLLib.SetClip(graphics, n9, n10, n3, n4);
        if (n3 * n4 < 1024) {
            int n11 = n9;
            int n12 = n10;
            int n13 = n4;
            n10 = n3;
            n9 = n12;
            n4 = n11;
            int[] nArray = s_alphaRectARGBData;
            Graphics graphics3 = graphics;
            GLLib.DrawRGB(graphics3, nArray, 0, n3, n4, n9, n10, n13, true, true, 0);
        } else {
            n3 += n9;
            n4 += n10;
            for (n = n9; n < n3; n += 32) {
                for (n2 = n10; n2 < n4; n2 += 32) {
                    int n14 = n2;
                    int n15 = n;
                    int[] nArray = s_alphaRectARGBData;
                    Graphics graphics4 = graphics;
                    GLLib.DrawRGB(graphics4, nArray, 0, 32, n15, n14, 32, 32, true, true, 0);
                }
            }
        }
        GLLib.SetClip(graphics, n5, n6, n7, n8);
    }

    static void DrawAlphaRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = n5 >>> 24;
        GLLib.DrawAAAlphaLine(graphics, n + 1, n2, n + n3, n2, n5 &= 0xFFFFFF, n6, n6);
        GLLib.DrawAAAlphaLine(graphics, n, n2, n, n2 + n4, n5, n6, n6);
        GLLib.DrawAAAlphaLine(graphics, n + n3, n2 + n4, n + n3, n2, n5, n6, n6);
        GLLib.DrawAAAlphaLine(graphics, n + n3 + 1, n2 + n4, n, n2 + n4, n5, n6, n6);
    }

    private static final void PFX_ProcessAdditive(int[] nArray, int n, int n2, int n3, int[] nArray2, int n4, int n5, int n6, int n7, int n8) {
        int n9 = 0;
        for (int i = n4; i != n6; i += n5) {
            int n10 = n + n2;
            for (int j = n7; j >= 0; --j) {
                n4 = nArray[n10];
                int n11 = nArray2[n9];
                int n12 = n4 & 0xFF0000;
                int n13 = n4 & 0xFF00;
                n4 &= 0xFF;
                int n14 = n11 & 0xFF0000;
                int n15 = n11 & 0xFF00;
                n11 &= 0xFF;
                if ((n12 += n14) > 0xFF0000) {
                    n12 = 0xFF0000;
                }
                if ((n13 += n15) > 65280) {
                    n13 = 65280;
                }
                if ((n4 += n11) > 255) {
                    n4 = 255;
                }
                nArray2[n9] = 0xFF000000 | n12 | n13 | n4;
                n10 += n8;
                ++n9;
            }
            n += n3;
        }
    }

    private static final void PFX_ProcessMultiplicative(int[] nArray, int n, int n2, int n3, int[] nArray2, int n4, int n5, int n6, int n7, int n8) {
        int n9 = 0;
        for (int i = n4; i != n6; i += n5) {
            int n10 = n + n2;
            for (int j = n7; j >= 0; --j) {
                n4 = nArray[n10];
                int n11 = nArray2[n9];
                int n12 = n4 >> 16 & 0xFF;
                int n13 = n4 >> 8 & 0xFF;
                n4 &= 0xFF;
                int n14 = n11 >> 16 & 0xFF;
                int n15 = n11 >> 8 & 0xFF;
                n11 &= 0xFF;
                if ((n12 = (n12 * n14 >> 6) + n14) > 255) {
                    n12 = 255;
                }
                if ((n13 = (n13 * n15 >> 6) + n15) > 255) {
                    n13 = 255;
                }
                if ((n4 = (n4 * n11 >> 6) + n11) > 255) {
                    n4 = 255;
                }
                nArray2[n9] = 0xFF000000 | n12 << 16 | n13 << 8 | n4;
                n10 += n8;
                ++n9;
            }
            n += n3;
        }
    }

    static final int PFX_GetGrayscaleColor(int n) {
        int n2 = n >> 16 & 0xFF & 0xFF;
        return n & 0xFFFF0000 | n2 << 8 | n2;
    }

    private static final void PFX_WritePixelData(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        GLLib.DrawRGB(graphics, nArray, 0, n2, n3, n4, n5, n6, bl, true, 0);
    }

    static final void PFX_EnableEffect(int n, boolean bl) {
        s_PFX_type |= 1 << n;
        if ((1 << n & 0x27F) != 0) {
            s_PFX_type &= 0xFFFFFD80;
        }
        if ((1 << n & 0x1F) != 0) {
            s_PFX_enableScreenBuffer |= 1 << n;
        }
    }

    static final boolean PFX_IsEffectEnabled(int n) {
        return (s_PFX_type & 1 << n) != 0;
    }

    private static final boolean PFX_UpdateMultiAlpha(boolean bl, int n) {
        if (n == 1) {
            return false;
        }
        if (n == 2) {
            return true;
        }
        return bl;
    }

    static final int[] PFX_ProcessSpriteEffects(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        int[] nArray = ASprite.GetPixelBuffer_int(null);
        GLLib.GetRGB(image, nArray, 0, n3, 0, 0, n3, n4);
        return GLLib.PFX_ProcessSpriteEffects(graphics, nArray, n, n2, n3, n4, n5, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    static final int[] PFX_ProcessSpriteEffects(Graphics object, int[] object2, int n, int n2, int n3, int n4, int object3, boolean n5, boolean n6) {
        s_PFX_hasAlpha = n5;
        s_PFX_sizeX = n3;
        s_PFX_sizeY = n4;
        if ((s_PFX_type & 0xD80) != 0) {
            if ((object3 & 4) != 0) {
                s_PFX_sizeX = n4;
                s_PFX_sizeY = n3;
                n3 = s_PFX_sizeX;
                n4 = s_PFX_sizeY;
            }
            object2 = ASprite.TransformRGB(object2, n3, n4, object3);
        }
        int[] nArray = ASprite.GetPixelBuffer_int(object2, n3, n4);
        if ((s_PFX_type & 0x800) != 0) {
            int n7;
            n6 = GLLib.PFX_UpdateMultiAlpha((boolean)n6, (int)null[0]);
            if (null[1] == 100 && null[2] == -1) {
                return object2;
            }
            int n8 = n6;
            boolean bl = n5;
            n6 = null[2];
            n5 = null[1];
            object3 = n4;
            n4 = n3;
            n3 = n2;
            n2 = n;
            int[] nArray2 = nArray;
            int n9 = ((int[])object2).length;
            int n10 = 0;
            int n11 = n4 * n5 / 100 + 1;
            n5 = object3 * n5 / 100 + 1;
            int n12 = n7 = nArray2.length / n11;
            int n13 = n3;
            if (n6 < 0) {
                for (n8 = 0; n8 < n5; ++n8) {
                    n3 = n8;
                    int n35 = n3 * object3 / n5 * n4;
                    for (int i = 0; i < n11; ++i) {
                        n3 = i;
                        nArray2[n10++] = (n3 = n35 + n3 * n4 / n11) < n9 ? object2[n3] : 0;
                    }
                    if (--n12 != 0) continue;
                    GLLib.PFX_WritePixelData(object, nArray2, 0, n11, n2, n13, n11, n7, bl);
                    n13 += n7;
                    n12 = n7;
                    n10 = 0;
                }
            } else if (n8 == 0 && !bl) {
                boolean n23 = true;
                n6 <<= 24;
                for (n8 = 0; n8 < n5; ++n8) {
                    n3 = n8;
                    int n14 = n3 * object3 / n5 * n4;
                    for (int i = 0; i < n11; ++i) {
                        n3 = i;
                        nArray2[n10++] = (n3 = n14 + n3 * n4 / n11) < n9 ? n6 | object2[n3] & 0xFFFFFF : 0;
                    }
                    if (--n12 != 0) continue;
                    GLLib.PFX_WritePixelData(object, nArray2, 0, n11, n2, n13, n11, n7, true);
                    n13 += n7;
                    n12 = n7;
                    n10 = 0;
                }
            } else if (n8 == 0 && bl) {
                boolean n24 = true;
                n6 <<= 24;
                for (n8 = 0; n8 < n5; ++n8) {
                    n3 = n8;
                    int n15 = n3 * object3 / n5 * n4;
                    for (int i = 0; i < n11; ++i) {
                        n3 = i;
                        if ((n3 = n15 + n3 * n4 / n11) < n9) {
                            int n16 = object2[n3] & 0xFFFFFF;
                            if (n16 != 0xFF00FF) {
                                nArray2[n10++] = n6 | n16;
                                continue;
                            }
                            nArray2[n10++] = 0;
                            continue;
                        }
                        nArray2[n10++] = 0;
                    }
                    if (--n12 != 0) continue;
                    GLLib.PFX_WritePixelData(object, nArray2, 0, n11, n2, n13, n11, n7, true);
                    n13 += n7;
                    n12 = n7;
                    n10 = 0;
                }
            } else {
                boolean n30 = true;
                for (n8 = 0; n8 < n5; ++n8) {
                    n3 = n8;
                    int n17 = n3 * object3 / n5 * n4;
                    for (int i = 0; i < n11; ++i) {
                        n3 = i;
                        if ((n3 = n17 + n3 * n4 / n11) < n9) {
                            int n18 = object2[n3] >>> 24;
                            n18 = n18 * n6 >> 8;
                            n18 = (n18 & 0xFF) << 24;
                            nArray2[n10++] = n18 | object2[n3] & 0xFFFFFF;
                            continue;
                        }
                        nArray2[n10++] = 0;
                    }
                    if (--n12 != 0) continue;
                    GLLib.PFX_WritePixelData(object, nArray2, 0, n11, n2, n13, n11, n7, true);
                    n13 += n7;
                    n12 = n7;
                    n10 = 0;
                }
            }
            if (n12 != n7) {
                void n31;
                GLLib.PFX_WritePixelData(object, nArray2, 0, n11, n2, n13, n11, n7 - n12, (boolean)n31);
            }
            return null;
        }
        if ((s_PFX_type & 0x400) != 0) {
            n6 = GLLib.PFX_UpdateMultiAlpha((boolean)n6, (int)null[0]);
            Object object4 = object2;
            int n19 = n3 * n4;
            n4 = n6;
            n3 = n5;
            n2 = null[1];
            n = n19;
            object2 = nArray;
            object = object4;
            n2 = n2 < 0 ? 0 : (n2 > 255 ? 255 : n2);
            n2 = n2 & 0xFF;
            if (n4 != 0) {
                while (n > 0) {
                    reference v2 = object[--n] >>> 24;
                    object3 = v2;
                    reference v3 = v2 * n2 >> 8;
                    object3 = v3;
                    object3 = (v3 & 0xFF) << 24;
                    object2[n] = object[n] & 0xFFFFFF | object3;
                }
            } else if (n3 != 0) {
                n2 <<= 24;
                while (n > 0) {
                    if ((object[--n] & 0xFFFFFF) != 0xFF00FF) {
                        object2[n] = object[n] & 0xFFFFFF | n2;
                        continue;
                    }
                    object2[n] = 0;
                }
            } else {
                n2 <<= 24;
                while (n > 0) {
                    object2[--n] = object[n] & 0xFFFFFF | n2;
                }
            }
            s_PFX_hasAlpha = true;
            return object2;
        }
        if ((s_PFX_type & 0x80) != 0) {
            n6 = GLLib.PFX_UpdateMultiAlpha((boolean)n6, (int)null[0]);
            Object object5 = object2;
            int n20 = n3 * n4;
            object3 = n6;
            n4 = n5;
            n3 = null[1];
            n2 = null[2];
            n = n20;
            object2 = nArray;
            object = object5;
            n5 = n;
            if (n3 < 0) {
                if (n2 <= 0) {
                    while (n5 != 0) {
                        Graphics graphics = object[--n5];
                        n6 = graphics;
                        int n32 = graphics >> 16 & 0xFF & 0xFF;
                        object2[n5] = n6 & 0xFFFF0000 | n32 << 8 | n32;
                    }
                } else if (n2 < 255) {
                    while (n5 != 0) {
                        Graphics graphics = object[--n5];
                        n6 = graphics;
                        int n21 = graphics >> 16 & 0xFF & 0xFF;
                        object2[n5] = n6 & 0xFFFF0000;
                        int n22 = n6 >> 8 & 0xFF & 0xFF;
                        int n23 = n21 + ((n22 - n21) * n2 >> 8);
                        int n24 = n5;
                        object2[n24] = object2[n24] | (n23 & 0xFF) << 8;
                        n22 = n6 & 0xFF;
                        int n25 = n21 + ((n22 - n21) * n2 >> 8);
                        int n26 = n5;
                        object2[n26] = object2[n26] | n25 & 0xFF;
                    }
                } else {
                    object2 = object;
                }
            } else {
                s_PFX_hasAlpha = true;
                if (object3 != 0) {
                    while (n5 != 0) {
                        Graphics graphics = object[--n5];
                        n6 = graphics;
                        int n27 = graphics >> 16 & 0xFF & 0xFF;
                        Object object6 = object[n5] >>> 24;
                        object6 = object6 * n3 >> 8;
                        object6 = (object6 & 0xFF) << 24;
                        object2[n5] = object6 | n27 << 16 | n27 << 8 | n27;
                    }
                } else if (n4 != 0) {
                    n3 <<= 24;
                    while (n5 != 0) {
                        Graphics graphics = object[--n5];
                        n6 = graphics;
                        if ((graphics & 0xFF00FF) != 0xFF00FF) {
                            int n28 = n6 >> 16 & 0xFF & 0xFF;
                            object2[n5] = n3 | n28 << 16 | n28 << 8 | n28;
                            continue;
                        }
                        object2[n5] = 0;
                    }
                } else {
                    n3 <<= 24;
                    while (n5 != 0) {
                        Graphics graphics = object[--n5];
                        n6 = graphics;
                        int n29 = graphics >> 16 & 0xFF & 0xFF;
                        object2[n5] = n3 | n29 << 16 | n29 << 8 | n29;
                    }
                }
            }
            return object2;
        }
        if ((s_PFX_type & 0x100) != 0) {
            n5 = n6 = (Object)GLLib.PFX_UpdateMultiAlpha((boolean)n6, (int)null[0]);
            object3 = n4;
            n4 = n3;
            n3 = n2;
            n2 = n;
            int[] nArray5 = nArray;
            n6 = null[1];
            void var9_22 = null[2];
            int n30 = null[3] & 0xFFFFFF;
            void var11_29 = null[5];
            int n31 = (1 << var11_29) - 1;
            int n32 = 0;
            if (null[4] != false) {
                n6 -= n2;
                n6 -= var9_22 >> 1;
            }
            GLLib.PFX_WritePixelData(object, object2, 0, n4, n2, n3, n4, object3, true);
            if (n5 == 0) {
                for (Object object7 = 0; object7 < object3; ++object7) {
                    for (n5 = 0; n5 < n4; ++n5) {
                        n3 = 0;
                        if (n5 > n6 && n5 < n6 + var9_22 && (object2[n32] & 0xFF000000) != 0) {
                            n3 = n31 - (((n5 - (n6 + (var9_22 >> 1)) < 0 ? -(n5 - (n6 + (var9_22 >> 1))) : n5 - (n6 + (var9_22 >> 1))) << var11_29) - 1) / (var9_22 >> 1);
                        }
                        nArray5[n32] = (n3 & 0xFF) << 24 | n30;
                        ++n32;
                    }
                }
            } else {
                for (Object object8 = 0; object8 < object3; ++object8) {
                    for (n5 = 0; n5 < n4; ++n5) {
                        n3 = 0;
                        if (n5 > n6 && n5 < n6 + var9_22 && (object2[n32] & 0xFF000000) != 0) {
                            n3 = n31 - ((n5 - (n6 + (var9_22 >> 1)) < 0 ? -(n5 - (n6 + (var9_22 >> 1))) : n5 - (n6 + (var9_22 >> 1))) << var11_29) / (var9_22 >> 1);
                        }
                        int n33 = object2[n32] >>> 24;
                        n33 = n33 * n3 >> 8;
                        nArray5[n32] = (n33 & 0xFF) << 24 | n30;
                        ++n32;
                    }
                }
            }
            s_PFX_hasAlpha = true;
            return nArray5;
        }
        if ((s_PFX_type & 0x20) != 0) {
            return GLLib.PFX_ProcessPixelEffect(object, object2, nArray, n, n2, n3, n4, object3, (s_PFX_type & 0x20) != 0, (s_PFX_type & 0x40) != 0, true);
        }
        if ((s_PFX_type & 0x40) != 0) {
            return GLLib.PFX_ProcessPixelEffect(object, object2, nArray, n, n2, n3, n4, object3, (s_PFX_type & 0x20) != 0, (s_PFX_type & 0x40) != 0, true);
        }
        return null;
    }

    static final int[] PFX_ProcessPixelEffect(Graphics graphics, int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3) {
        int n6 = 0;
        int n7 = 0;
        int n8 = n3;
        Graphics graphics2 = graphics;
        int n9 = graphics2.getClipX();
        graphics2 = graphics;
        int n10 = graphics2.getClipY();
        graphics2 = graphics;
        int n11 = graphics2.getClipWidth();
        graphics2 = graphics;
        int n12 = graphics2.getClipHeight();
        if ((n5 & 4) != 0) {
            n8 = n4;
            n4 = n3;
        }
        int n13 = n8;
        int n14 = n4;
        if (n2 + n14 > n12 + n10) {
            n14 = n12 + n10 - n2;
        }
        if (n + n13 > n11 + n9) {
            n13 = n11 + n9 - n;
        }
        if (n < n9) {
            n6 = n9 - n;
            n13 = n8 - n6;
            n = 0;
        }
        if (n2 < n10) {
            n7 = n10 - n2;
            n14 = n4 - n7;
            n2 = 0;
        }
        if (n8 <= 0 || n13 <= 0) {
            return nArray;
        }
        if (n4 <= 0 || n14 <= 0) {
            return nArray;
        }
        if (bl3) {
            int n15 = n;
            n = n14;
            n = n13;
            n = n2;
            n = n15;
            n = n13;
            n = 0;
            int[] nArray3 = nArray2;
        }
        if (n13 != n8 || n14 != n4) {
            for (int i = n14 - 1; i >= 0; --i) {
                System.arraycopy(nArray2, i * n13, nArray2, n6 + (i + n7) * n8, n13);
            }
        }
        if ((n5 & 4) != 0) {
            int n16;
            boolean bl4 = false;
            n3 = n4;
            n6 = 1;
            if ((n5 & 1) != 0) {
                n16 = n4 - 1;
                n3 = -1;
                n6 = -1;
            }
            n7 = n8 - 1;
            n14 = -n4;
            int n162 = (n8 - 1) * n4;
            if ((n5 & 2) != 0) {
                n14 = n4;
                n162 = 0;
            }
            n2 = n6;
            n13 = n16;
            if (bl) {
                GLLib.PFX_ProcessAdditive(nArray, n13, n162, n2, nArray2, n16, n6, n3, n7, n14);
            }
            if (bl2) {
                GLLib.PFX_ProcessMultiplicative(nArray, n13, n162, n2, nArray2, n16, n6, n3, n7, n14);
            }
        } else {
            n7 = 0;
            n9 = n4;
            n14 = 1;
            if ((n5 & 2) != 0) {
                n7 = n4 - 1;
                n9 = -1;
                n14 = -1;
            }
            int n17 = n8 - 1;
            n6 = 1;
            int n172 = 0;
            if ((n5 & 1) != 0) {
                n6 = -1;
                n172 = n8 - 1;
            }
            n2 = n14 * n3;
            n13 = n7 * n3;
            if (bl) {
                GLLib.PFX_ProcessAdditive(nArray, n13, n172, n2, nArray2, n7, n14, n9, n17, n6);
            }
            if (bl2) {
                GLLib.PFX_ProcessMultiplicative(nArray, n13, n172, n2, nArray2, n7, n14, n9, n17, n6);
            }
        }
        s_PFX_sizeX = n8;
        s_PFX_sizeY = n4;
        s_PFX_hasAlpha = false;
        return nArray2;
    }

    private static void DrawAAAlphaLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9 = n3 - n;
        if ((n9 < 0 ? -n9 : n9) > ((n8 = n4 - n2) < 0 ? -n8 : n8)) {
            if (n3 < n) {
                n9 = n;
                n = n3;
                n3 = n9;
                n9 = n2;
                n2 = n4;
                n4 = n9;
                n9 = n6;
                n6 = n7;
                n7 = n9;
            }
            n9 = n3 - n;
            n8 = n4 - n2;
            int n10 = 0;
            if (n9 != 0) {
                n10 = (n8 << 16) / n9;
            }
            int n11 = n;
            n = (n2 << 16) + 0;
            n2 = n11;
            n += n10;
            n3 = n11 = n3;
            n4 = 0;
            if (n9 != 0) {
                n4 = (n7 - n6 << 16) / n9;
            }
            int[] nArray = ASprite.GetPixelBuffer_int(null);
            n6 <<= 16;
            while (n2 < n3) {
                n9 = n >> 16;
                n8 = n & 0xFFFF;
                n11 = 65535 - n8;
                n11 = (n11 >> 8) * n6 & 0xFF000000;
                nArray[0] = n11 | n5;
                n11 = (n8 >> 8) * n6 & 0xFF000000;
                nArray[1] = n11 | n5;
                int n12 = n9;
                n11 = n2++;
                int[] nArray2 = nArray;
                Graphics graphics2 = graphics;
                GLLib.DrawRGB(graphics2, nArray2, 0, 1, n11, n12, 1, 2, true, true, 0);
                n += n10;
                n6 += n4;
            }
        } else {
            if (n4 < n2) {
                n9 = n;
                n = n3;
                n3 = n9;
                n9 = n2;
                n2 = n4;
                n4 = n9;
                n9 = n6;
                n6 = n7;
                n7 = n9;
            }
            n9 = n3 - n;
            n8 = n4 - n2;
            int n13 = 0;
            if (n8 != 0) {
                n13 = (n9 << 16) / n8;
            }
            int n14 = n2;
            n = (n << 16) + 0;
            n2 = n14;
            n += n13;
            n3 = n14 = n4;
            n4 = 0;
            if (n8 != 0) {
                n4 = (n7 - n6 << 16) / n8;
            }
            n6 <<= 16;
            int[] nArray = ASprite.temp_int;
            while (n2 < n3) {
                n9 = n >> 16;
                n8 = n & 0xFFFF;
                n14 = 65535 - n8;
                n14 = (n14 >> 8) * n6 & 0xFF000000;
                nArray[0] = n14 | n5;
                n14 = (n8 >> 8) * n6 & 0xFF000000;
                nArray[1] = n14 | n5;
                int n15 = n2++;
                n14 = n9;
                int[] nArray3 = nArray;
                Graphics graphics3 = graphics;
                GLLib.DrawRGB(graphics3, nArray3, 0, 2, n14, n15, 2, 1, true, true, 0);
                n += n13;
                n6 += n4;
            }
        }
    }

    static {
        s_screenWidth = 320;
        s_screenHeight = 240;
        m_FPSLimiter = 62;
        m_customSleepTime = -1;
        m_imgBackBuffer = null;
        m_gBackBuffer = null;
        m_bBackBufferEnabled = true;
        m_last_key_pressed = -9999;
        s_math_F_1 = 256;
        Math_AngleMUL = 256;
        Math_Angle90 = 90 * Math_AngleMUL / 360;
        Math_Angle180 = 180 * Math_AngleMUL / 360;
        Math_Angle270 = 270 * Math_AngleMUL / 360;
        Math_Angle360 = 360 * Math_AngleMUL / 360;
        Math_FixedPoint_PI = 804;
        Stream_readOffset = 0;
        text_encoding = "UTF-8";
        s_profiler_emulator = System.getProperty("EMU://EndNamedEvent") != null;
        pfx_usingScreenBuffer = false;
        pfx_useSpriteEffects = true;
        s_PFX_initializd = false;
        s_PFX_type = 0;
        s_PFX_params = null;
        s_PFX_screenBuffer = null;
        s_PFX_screenBufferG = null;
        s_PFX_enableScreenBuffer = 0;
        s_PFX_enableScreenBufferThisFrame = 0;
    }
}

