/*
 * Decompiled with CFR 0.152.
 */
package com.ea.engine.game._2d2;

import com.ea.engine.core.InteractionListener;
import com.ea.engine.game.Astar;
import com.ea.engine.game.CarmackBuffer;
import com.ea.engine.game._2d2.DCharacter;
import com.ea.engine.game._2d2.DData;
import com.ea.engine.game._2d2.DElement;
import com.ea.engine.game._2d2.DMap;
import com.ea.engine.model.AModel;
import com.ea.engine.model.AnimationModel;
import com.ea.engine.model.M;
import com.ea.engine.worker.Worker;
import com.ea.engine.worker.WorkerTask;
import com.ea.util.BooleanUtil;
import com.ea.util.CallbackListener;
import com.ea.util.Log;
import com.ea.util.MathUtil;
import com.ea.util.graphics.GraphicsUtil;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class DBoard
extends AModel
implements InteractionListener,
WorkerTask,
CallbackListener {
    public static final String BOARD_SUFFIX = ".bord";
    public static final int HEADER = 1112494660;
    public static final int END = 1111838276;
    public static final byte MODE_WITH_IMAGE = 1;
    public static final int FILTER_BUILDINGS = 1;
    public static final int FILTER_NPCS = 2;
    public static final int FILTER_DATAS = 4;
    private String a;
    public short col;
    public short row;
    public int width;
    public int height;
    public short tileWidth;
    public short tileHeight;
    public short tileHalfWidth;
    public short tileHalfHeight;
    protected DMap map;
    private Vector b;
    private Vector c;
    private DElement[][] d;
    private Vector e;
    private DData[][] f;
    private DCharacter[][] g;
    protected int screenX = -1;
    protected int screenY = -1;
    protected int screenWidth;
    protected int screenHeight;
    private Vector h;
    private DCharacter i;
    private boolean j;
    private boolean k = true;
    private Astar l;
    private boolean m;
    private CarmackBuffer n;
    private int o;
    protected int backgroundColor = -1;
    private static int p;

    private DBoard() {
    }

    public DBoard(byte[] byArray) throws Exception {
        super(byArray);
    }

    public DBoard(InputStream inputStream, boolean bl) throws Exception {
        super(inputStream, bl);
    }

    public DBoard(InputStream inputStream) throws Exception {
        super(inputStream);
    }

    public DBoard(String string) throws Exception {
        super(string);
    }

    public static DBoard createBlankModel(String string) {
        DBoard dBoard = new DBoard();
        new DBoard().id = string;
        return dBoard;
    }

    public int getHeader() {
        return 1112494660;
    }

    public int getEnd() {
        return 1111838276;
    }

    protected void init(InputStream inputStream, boolean bl) throws Exception {
        super.init(inputStream, bl);
    }

    protected void inflate(DataInputStream dataInputStream) throws Exception {
        int n;
        int n2;
        int n3;
        this.b = new Vector();
        this.c = new Vector();
        this.e = new Vector();
        this.a = dataInputStream.readUTF();
        dataInputStream.readByte();
        this.tileWidth = dataInputStream.readByte();
        this.tileHeight = dataInputStream.readByte();
        this.tileHalfWidth = (short)(this.tileWidth >> 1);
        this.tileHalfHeight = (short)(this.tileHeight >> 1);
        this.col = dataInputStream.readShort();
        this.row = dataInputStream.readShort();
        this.width = this.col * this.tileWidth;
        this.height = this.row * this.tileHeight;
        int n4 = dataInputStream.readShort();
        Object object = new AModel[n4];
        Object object2 = new byte[n4][2];
        Object object3 = new String[n4];
        Vector<AModel> vector = new Vector<AModel>();
        p = 0;
        for (int k = 0; k < n4; ++k) {
            if ((this.mode & 1) != 0) {
                int n5 = dataInputStream.readInt();
                byte[] byArray = new byte[n5];
                dataInputStream.read(byArray);
                object[k] = M.instance.getResource(byArray);
            } else {
                String string = dataInputStream.readUTF();
                object3[k] = string + ".cpng";
                object[k] = M.instance.getClientResource(object3[k]);
                if (object[k] == null) {
                    object[k] = M.instance.getBlankModel(object3[k]);
                    object[k].setCallbackListener(this);
                    ++p;
                    vector.addElement(object[k]);
                }
            }
            object2[k][0] = dataInputStream.readByte();
            object2[k][1] = dataInputStream.readByte();
        }
        if (vector.size() > 0) {
            M.instance.syncRmsResource(false);
            Object[] objectArray = new AModel[vector.size()];
            vector.copyInto(objectArray);
            M.instance.getResourceFromServer((AModel[])objectArray);
        }
        this.map = new DMap(this);
        this.map.images = object;
        this.map.imagesData = object2;
        this.map.init(dataInputStream);
        short[][] sArray = DElement.readImageClips(dataInputStream);
        DElement[] dElementArray = new DElement[dataInputStream.readUnsignedByte()];
        n4 = dElementArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            object2 = new DElement(this);
            new DElement(this).images = object;
            ((DElement)object2).imageClips = sArray;
            ((DElement)object2).initClip(dataInputStream);
            dElementArray[n3] = object2;
        }
        n3 = dataInputStream.readUnsignedByte();
        while (--n3 >= 0) {
            n4 = dataInputStream.readByte();
            int n6 = dataInputStream.readUnsignedByte();
            object = null;
            if (n4 == 0) {
                object = dElementArray[n6].clone(null);
            } else if (n4 == 1) {
                object = new DElement(this);
                object.setType(1);
                object.setAnimationModel((AnimationModel)M.instance.getResource(dataInputStream.readUTF() + ".anmt").clone(null));
            } else if (n4 == 2) {
                object = dElementArray[n6].clone(null);
            }
            object.init(dataInputStream);
            this.addBuilding((DElement)object);
        }
        AnimationModel[] animationModelArray = new AnimationModel[dataInputStream.readUnsignedByte()];
        int n7 = animationModelArray.length;
        for (n2 = 0; n2 < n7; ++n2) {
            animationModelArray[n2] = new AnimationModel(dataInputStream);
        }
        n2 = dataInputStream.readUnsignedByte();
        while (--n2 >= 0) {
            n7 = dataInputStream.readUnsignedByte();
            object3 = new DCharacter(this);
            ((DElement)object3).setAnimationModel(animationModelArray[n7]);
            ((DElement)object3).init(dataInputStream);
            this.addCharacter((DCharacter)object3);
        }
        DData[] dDataArray = new DData[dataInputStream.readUnsignedByte()];
        int n8 = dDataArray.length;
        for (n = 0; n < n8; ++n) {
            dDataArray[n] = new DData(this);
            dDataArray[n].init(dataInputStream);
        }
        n = dataInputStream.readUnsignedByte();
        if (n > 0) {
            this.f = new DData[this.row][this.col];
        }
        while (--n >= 0) {
            DData dData = dDataArray[dataInputStream.readUnsignedByte()].clone(null);
            dData.initialize(dataInputStream);
            this.f[dData.row][dData.col] = dData;
        }
        if (p > 0) {
            DBoard dBoard = this;
            synchronized (dBoard) {
                try {
                    this.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    Log.innerDebug("DBord wait Images", interruptedException);
                }
            }
            M.instance.syncRmsResource(true);
        }
    }

    public String getName() {
        return this.a;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setBackgroundColor(int n) {
        this.backgroundColor = n;
    }

    public static int getLoadImagesCount() {
        return p;
    }

    public void addBuilding(DElement dElement) {
        int n;
        dElement.onAdded(this);
        if (dElement.isDynamic()) {
            this.c.addElement(dElement);
            return;
        }
        this.b.addElement(dElement);
        if (this.d == null) {
            this.d = new DElement[this.row][this.col];
        }
        int[] nArray = dElement.getTileBoundsWithPosition();
        int n2 = nArray[3] + n;
        for (n = nArray[1]; n < n2; ++n) {
            int n3;
            int n4 = nArray[2] + n3;
            for (n3 = nArray[0]; n3 < n4; ++n3) {
                this.d[n][n3] = dElement;
            }
        }
    }

    public void addCharacter(DCharacter dCharacter) {
        if (this.e == null) {
            this.e = new Vector();
        }
        if (this.containCharacter(dCharacter)) {
            return;
        }
        dCharacter.onAdded(this);
        if (!dCharacter.isThroughAble()) {
            if (this.g == null) {
                this.g = new DCharacter[this.row][this.col];
            }
            this.g[dCharacter.row][dCharacter.col] = dCharacter;
        }
        this.e.addElement(dCharacter);
    }

    public void removeCharacter(DCharacter dCharacter) {
        if (this.e == null) {
            return;
        }
        if (!dCharacter.isThroughAble() && this.g[dCharacter.row][dCharacter.col] == dCharacter) {
            this.g[dCharacter.row][dCharacter.col] = null;
        }
        this.e.removeElement(dCharacter);
        dCharacter.onRemoved();
    }

    public boolean containCharacter(DCharacter dCharacter) {
        if (this.e == null) {
            return false;
        }
        return this.e.contains(dCharacter);
    }

    public Vector getCharacters() {
        return this.e;
    }

    public DData[][] getDatas() {
        return this.f;
    }

    public Vector getBuildsStatic() {
        return this.b;
    }

    public Vector getBuildsDynamic() {
        return this.c;
    }

    public void setScreenSize(int n, int n2) {
        this.screenWidth = n / this.tileWidth * this.tileWidth + (n % this.tileWidth == 0 ? (short)0 : this.tileWidth);
        this.screenHeight = n2 / this.tileHeight * this.tileHeight + (n2 % this.tileHeight == 0 ? (short)0 : this.tileHeight);
    }

    public int getScreenX() {
        return this.screenX;
    }

    public int getScreenY() {
        return this.screenY;
    }

    public boolean setScreenCenterPosition(int n, int n2) {
        return this.setScreenPosition(n - (this.screenWidth >> 1), n2 - (this.screenHeight >> 1));
    }

    public boolean setScreenPosition(int n, int n2) {
        if (this.screenX == n && this.screenY == n2) {
            return false;
        }
        if (this.getWidth() > this.screenWidth) {
            if (n < 0) {
                n = 0;
            } else if (n > this.getWidth() - this.screenWidth) {
                n = this.getWidth() - this.screenWidth;
            }
        } else {
            n = this.getWidth() - this.screenWidth >> 1;
        }
        if (this.getHeight() > this.screenHeight) {
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > this.getHeight() - this.screenHeight) {
                n2 = this.getHeight() - this.screenHeight;
            }
        } else {
            n2 = this.getHeight() - this.screenHeight >> 1;
        }
        if (this.screenX != n || this.screenY != n2) {
            if (this.carmackBufferEnable() && this.n != null) {
                this.n.scrollTo(n, n2);
            }
            this.screenX = n;
            this.screenY = n2;
        }
        return true;
    }

    public int[] getScreenTileBounds() {
        int[] nArray = new int[4];
        int[] nArray2 = nArray;
        nArray[0] = this.screenX / this.tileWidth;
        nArray2[1] = this.screenY / this.tileHeight;
        nArray2[0] = nArray2[0] < 0 ? 0 : nArray2[0];
        nArray2[1] = nArray2[1] < 0 ? 0 : nArray2[1];
        nArray2[2] = this.screenWidth / this.tileWidth + (this.screenX % this.tileWidth == 0 ? 0 : 1) + (this.screenWidth - (this.tileWidth - this.screenX % this.tileWidth) % this.tileWidth == 0 ? 0 : 1);
        nArray2[3] = this.screenHeight / this.tileHeight + (this.screenY % this.tileHeight == 0 ? 0 : 1) + (this.screenHeight - (this.tileHeight - this.screenY % this.tileHeight) % this.tileHeight == 0 ? 0 : 1);
        nArray2[2] = nArray2[0] + nArray2[2] > this.col ? this.col - nArray2[0] : nArray2[2];
        nArray2[3] = nArray2[1] + nArray2[3] > this.row ? this.row - nArray2[1] : nArray2[3];
        return nArray2;
    }

    protected int[] getTileBoundsWithPosition(int n, int n2, int n3, int n4) {
        n3 = Math.min(n + n3, 0 + this.getWidth());
        n4 = Math.min(n2 + n4, 0 + this.getHeight());
        n = Math.max(n, 0);
        n2 = Math.max(n2, 0);
        n3 -= n;
        n4 -= n2;
        int[] nArray = new int[4];
        int[] nArray2 = nArray;
        nArray[0] = n / this.tileWidth;
        nArray2[1] = n2 / this.tileHeight;
        nArray2[2] = n3 / this.tileWidth + (n % this.tileWidth == 0 ? 0 : 1) + (n3 - (this.tileWidth - n % this.tileWidth) % this.tileWidth == 0 ? 0 : 1);
        nArray2[3] = n4 / this.tileHeight + (n2 % this.tileHeight == 0 ? 0 : 1) + (n4 - (this.tileHeight - n2 % this.tileHeight) % this.tileHeight == 0 ? 0 : 1);
        nArray2[2] = nArray2[0] + nArray2[2] > this.col ? this.col - nArray2[0] : nArray2[2];
        nArray2[3] = nArray2[1] + nArray2[3] > this.row ? this.row - nArray2[1] : nArray2[3];
        nArray2[0] = nArray2[0] < 0 ? 0 : nArray2[0];
        nArray2[1] = nArray2[1] < 0 ? 0 : nArray2[1];
        return nArray2;
    }

    public int[] convertScreenPosition2Tile(int n, int n2) {
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = (this.screenX + n) / this.tileWidth;
        nArray2[1] = (this.screenY + n2) / this.tileHeight;
        return nArray2;
    }

    public int[] convertTile2ScreenPosition(int n, int n2) {
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = n * this.tileWidth + this.tileHalfWidth - this.screenX;
        nArray2[1] = n2 * this.tileHeight + this.tileHalfHeight - this.screenY;
        return nArray2;
    }

    public void setPlayer(DCharacter dCharacter) {
        this.i = dCharacter;
    }

    public DCharacter getPlayer() {
        return this.i;
    }

    public int[][] AstarMove(int n, int n2, int n3, int n4) {
        if (this.l == null) {
            this.l = new Astar();
            this.l.setPointCanMove(this);
        }
        return this.l.AstarMove(n, n2, n3, n4);
    }

    public boolean canMove(int n, int n2) {
        int n3 = n / this.tileWidth;
        int n4 = n2 / this.tileHeight;
        DData dData = this.getTileObjectExceptBuild(n3, n4, 6);
        if (dData != null && !dData.isThroughAble()) {
            return false;
        }
        return this.map.canTileMove(n3, n4) || this.map.canMove(n, n2);
    }

    public boolean canTileMove(int n, int n2) {
        return this.canTileMove(n, n2, 6);
    }

    public boolean canTileMove(int n, int n2, int n3) {
        try {
            if (n < 0 || n >= this.col || n2 < 0 || n2 >= this.row) {
                return false;
            }
            DData dData = this.getTileObjectExceptBuild(n, n2, n3);
            if (dData != null && !dData.isThroughAble()) {
                return false;
            }
            return this.map.canTileMove(n, n2);
        }
        catch (Exception exception) {
            Log.warn("DBoard.canTileMove", exception);
            return false;
        }
    }

    public DData getTileObjectExceptBuild(int n, int n2, int n3) {
        if (n < 0 || n >= this.col || n2 < 0 || n2 >= this.row) {
            return null;
        }
        if ((n3 & 2) != 0 && this.g != null && this.g[n2][n] != null) {
            return this.g[n2][n];
        }
        if ((n3 & 4) != 0 && this.f != null && this.f[n2][n] != null) {
            return this.f[n2][n];
        }
        return null;
    }

    public DData getObjectExceptBuild(int n, int n2) {
        return this.getTileObjectExceptBuild(n /= this.tileWidth, n2 /= this.tileHeight, 6);
    }

    public DElement getScreenBuild(int n, int n2) {
        int[] nArray;
        DElement dElement;
        n = this.screenX + n;
        n2 = this.screenY + n2;
        int n3 = this.b.size();
        while (--n3 >= 0) {
            dElement = (DElement)this.b.elementAt(n3);
            nArray = dElement.getBounds();
            if (!MathUtil.pointInRect(n, n2, nArray[0], nArray[1], nArray[2], nArray[3])) continue;
            return dElement;
        }
        n3 = this.c.size();
        while (--n3 >= 0) {
            dElement = (DElement)this.c.elementAt(n3);
            nArray = dElement.getBounds();
            if (!MathUtil.pointInRect(n, n2, nArray[0], nArray[1], nArray[2], nArray[3])) continue;
            return dElement;
        }
        return null;
    }

    public DCharacter getScreenCharacter(int n, int n2) {
        if (this.h == null) {
            return null;
        }
        n = this.screenX + n;
        n2 = this.screenY + n2;
        int n3 = this.h.size();
        while (--n3 >= 0) {
            Object object = this.h.elementAt(n3);
            if (!(object instanceof DCharacter)) continue;
            object = (DCharacter)object;
            int[] nArray = ((DElement)object).getBounds();
            if (((DData)object).isThroughAble() || !MathUtil.pointInRect(n, n2, nArray[0], nArray[1], nArray[2], nArray[3])) continue;
            return object;
        }
        return null;
    }

    public void setCharactersVisible(boolean bl) {
        this.k = bl;
    }

    public void setTransparenceMaskEnable(int n) {
        this.o = n;
        if (!this.carmackBufferEnable() || this.n == null) {
            return;
        }
        if (n != 0) {
            Graphics graphics = this.n.getGraphics();
            GraphicsUtil.drawTransRect(graphics, n, 0, 0, this.n.getBufWidth(), this.n.getBufHeight());
            return;
        }
        if (this.n != null) {
            this.n.forcePaintBuffer();
        }
    }

    public void resetPaintBuffer() {
        if (this.n != null) {
            this.processPlayer();
            this.n.resetPaintBuffer();
            this.n.scrollTo(this.screenX, this.screenY);
        }
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.screenX, this.screenY, this.screenWidth, this.screenHeight, 0, 0);
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.j) {
            this.j = true;
            Worker.mainWorker.pushTask(this, 0);
        }
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        int n9 = graphics.getClipX();
        int n10 = graphics.getClipY();
        graphics.translate(-n + n5, -n2 + n6);
        if (n3 > 0 && n4 > 0) {
            graphics.clipRect(n, n2, n3, n4);
        }
        if (this.backgroundColor != -1) {
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(n, n2, n3, n4);
        }
        graphics.clipRect(0, 0, this.getWidth(), this.getHeight());
        if (this.carmackBufferEnable() && this.n != null) {
            if (this.n.isInited()) {
                this.n.paint(graphics, n < 0 ? 0 : n, n2 < 0 ? 0 : n2);
                this.a(graphics);
            }
        } else {
            this.map.paint(graphics, n, n2, n3, n4);
            this.a(graphics, n, n2, n3, n4);
            this.a(graphics);
            if (this.o != 0) {
                GraphicsUtil.drawTransRect(graphics, this.o, n, n2, n3, n4);
            }
        }
        graphics.translate(n - n5, n2 - n6);
        graphics.setClip(n9, n10, n7, n8);
    }

    private void a(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.b == null) {
            return;
        }
        int n5 = this.b.size();
        for (int k = 0; k < n5; ++k) {
            DElement dElement = (DElement)this.b.elementAt(k);
            if (!MathUtil.rectCollided(dElement.getBounds(), new int[]{n, n2, n3, n4})) continue;
            dElement.paint(graphics);
        }
    }

    protected void paintDirtyBuilding(Graphics graphics, DElement dElement) {
        Object object;
        int n;
        if (this.d == null) {
            return;
        }
        Vector<DElement> vector = new Vector<DElement>();
        int[] nArray = dElement.getBounds();
        int[] nArray2 = dElement.getTileBoundsWithPosition();
        for (int k = nArray2[1]; k < nArray2[1] + nArray2[3]; ++k) {
            for (n = nArray2[0]; n < nArray2[0] + nArray2[2]; ++n) {
                DElement dElement2 = this.d[k][n];
                if (dElement2 == null || dElement2.y <= dElement.y || vector.contains(dElement2)) continue;
                int[] nArray3 = dElement2.getBounds();
                object = nArray3;
                object = MathUtil.intersectionRect(nArray3, nArray);
                dElement2.addPaintClip((int[])object);
                vector.addElement(dElement2);
                if (!GraphicsUtil.transparenceEnable) continue;
                dElement.addPaintClip((int[])object);
            }
        }
        Vector<DElement> vector2 = new Vector<DElement>(vector.size());
        int n2 = this.b.size();
        for (n = 0; n < n2; ++n) {
            object = (DElement)this.b.elementAt(n);
            if (vector.contains(this.b.elementAt(n))) {
                vector2.addElement((DElement)object);
            }
            if (vector2.size() == n2) break;
        }
        for (n = 0; n < vector2.size(); ++n) {
            DElement dElement3 = (DElement)vector2.elementAt(n);
            dElement3.paintClips(graphics);
            dElement3.clearPaintClip();
        }
    }

    private void a(Graphics graphics) {
        DElement dElement;
        int n;
        if (this.e == null || !this.k) {
            return;
        }
        this.h = new Vector();
        Vector<DElement> vector = new Vector<DElement>();
        int n2 = this.e.size();
        for (n = 0; n < n2; ++n) {
            dElement = (DCharacter)this.e.elementAt(n);
            if (MathUtil.pointInRect(dElement.x, dElement.y, this.screenX, this.screenY, this.screenWidth, this.screenHeight)) {
                if (((DCharacter)dElement).isFly()) {
                    vector.addElement(dElement);
                    continue;
                }
                this.h.addElement(dElement);
                continue;
            }
            ((DCharacter)dElement).cleanTransparenceModel();
        }
        n2 = this.c.size();
        for (n = 0; n < n2; ++n) {
            dElement = (DElement)this.c.elementAt(n);
            if (!MathUtil.pointInRect(dElement.x, dElement.y, this.screenX, this.screenY, this.screenWidth, this.screenHeight)) continue;
            this.h.addElement(dElement);
        }
        DBoard.a(this.h);
        n2 = this.h.size();
        for (n = 0; n < n2; ++n) {
            dElement = (DElement)this.h.elementAt(n);
            dElement.paint(graphics);
        }
        DBoard.a(vector);
        n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            dElement = (DElement)vector.elementAt(n);
            dElement.paint(graphics);
        }
    }

    public boolean run(int n) {
        if (!this.j) {
            return true;
        }
        try {
            int n2;
            if (this.k) {
                n2 = this.e.size();
                for (n = 0; n < n2; ++n) {
                    DCharacter dCharacter = (DCharacter)this.e.elementAt(n);
                    dCharacter.run();
                }
            }
            n2 = this.c.size();
            for (n = 0; n < n2; ++n) {
                ((DElement)this.c.elementAt(n)).run();
            }
            this.processPlayer();
        }
        catch (Exception exception) {
            Log.warn("DBoard.run", exception);
        }
        return false;
    }

    public void processPlayer() {
        if (this.i != null) {
            int n = 0;
            int n2 = this.screenX;
            int n3 = this.screenY;
            if (this.setScreenCenterPosition(this.i.x, this.i.y)) {
                if (this.screenX != n2) {
                    n = this.screenX < n2 ? 4 : 8;
                } else if (this.screenY != n3) {
                    n = this.screenY < n3 ? 1 : 2;
                }
                this.map.scrollAlittle((byte)n);
            }
        }
    }

    private static void a(Vector vector) {
        int n = vector.size() - 1;
        for (int k = 0; k < n; ++k) {
            boolean bl = false;
            for (int i2 = 0; i2 < n - k; ++i2) {
                DElement dElement = (DElement)vector.elementAt(i2);
                DElement dElement2 = (DElement)vector.elementAt(i2 + 1);
                if (dElement2.y >= dElement.y) continue;
                bl = true;
                vector.removeElementAt(i2);
                vector.removeElementAt(i2);
                vector.insertElementAt(dElement, i2);
                vector.insertElementAt(dElement2, i2);
            }
            if (bl) continue;
            return;
        }
    }

    public void onRemove(int n) {
    }

    public String getTaskName() {
        return "DBoradTask " + this.a;
    }

    public Object callback(int n, Object object, Object object2) {
        switch (n) {
            case 0: {
                if (this.canTileMove(((int[])object)[0], ((int[])object)[1], 2)) {
                    return BooleanUtil.TRUE_VALUE;
                }
                return BooleanUtil.FALSE_VALUE;
            }
            case 1: {
                if (--p <= 0) {
                    DBoard dBoard = this;
                    synchronized (dBoard) {
                        this.notify();
                    }
                }
                return null;
            }
            case -1: {
                if ("\u78b0\u649e".equals(object.toString())) {
                    DMap.collisionEnable = !DMap.collisionEnable;
                    return BooleanUtil.TRUE_VALUE;
                }
                return BooleanUtil.FALSE_VALUE;
            }
        }
        return null;
    }

    public void setCarmackBufferEnable(boolean bl) {
        this.m = bl;
        if (bl) {
            if (!this.map.scrollLayerEnable()) {
                DBoard dBoard = this;
                int n = dBoard.getWidth() < dBoard.screenWidth ? dBoard.getWidth() : dBoard.screenWidth;
                int n2 = dBoard.getHeight() < dBoard.screenHeight ? dBoard.getHeight() : dBoard.screenHeight;
                dBoard.n = new CarmackBuffer(dBoard, dBoard.getWidth(), dBoard.getHeight(), n, n2, dBoard.tileWidth, dBoard.tileHeight);
                return;
            }
            this.map.createCarmackScroll();
            return;
        }
        this.n = null;
    }

    public boolean carmackBufferEnable() {
        return this.m;
    }

    public void paint(int n, Graphics graphics, int n2, int n3) {
        n = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        graphics.translate(n2, n3);
        this.map.paintByCarmack(graphics, n5 - n2, n6 - n3, n, n4);
        this.a(graphics, n5 - n2, n6 - n3, n, n4);
        graphics.translate(-n2, -n3);
    }

    public boolean onKeyEvent(int n, byte by, int n2) {
        return false;
    }

    public boolean onPointerEvent(int n, byte by, int n2, int n3) {
        return false;
    }

    public void free() {
        this.j = false;
        this.b = null;
        this.c = null;
        this.d = null;
        this.e = null;
        this.h = null;
        this.f = null;
        this.g = null;
        this.i = null;
        if (this.n != null) {
            this.n.free();
        }
        this.n = null;
        this.l = null;
        if (this.map != null) {
            this.map.free();
        }
        this.map = null;
    }

    public void freeMapImages() {
        if (this.map != null) {
            int n = this.map.images.length;
            while (--n >= 0) {
                M.instance.removeResource(this.map.images[n].id);
            }
        }
    }
}

