/*
 * Decompiled with CFR 0.152.
 */
package com.ea.engine.game._2d2;

import com.ea.engine.game._2d2.CharacterListener;
import com.ea.engine.game._2d2.DBoard;
import com.ea.engine.game._2d2.DData;
import com.ea.engine.game._2d2.DElement;
import com.ea.engine.model.AnimationModel;
import com.ea.util.CallbackListener;
import com.ea.util.Log;
import com.ea.util.MathUtil;
import com.ea.util.structure.LinkedListItem;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class DCharacter
extends DElement
implements CallbackListener,
LinkedListItem {
    public static final String STEP_NPC = "stepnpc";
    public static final String SUFFER_ENEMY = "sfenemy";
    protected byte ACTION_STAND = 0;
    protected byte ACTION_WALK = 1;
    protected byte ACTION_FLY = (byte)6;
    private Vector a;
    private Vector b;
    protected int moveSpeedX = 6;
    protected int moveSpeedY = 6;
    private int c;
    private int d;
    private byte e = (byte)4;
    private byte f = (byte)4;
    private byte g;
    private DCharacter h = this;
    private DCharacter i = this;
    private DCharacter j;
    private DCharacter k;
    private Vector l;
    private CharacterListener m;
    private int n;
    private boolean o;
    private boolean p;
    private boolean q = true;
    private int[] r;
    private int[] s;
    private boolean t;
    private boolean u;
    private byte v;
    private boolean w = false;

    public DCharacter() {
        this(null);
    }

    public DCharacter(DBoard dBoard) {
        super(dBoard);
        this.type = 1;
        this.setThroughAble(true);
    }

    public void reset() {
        this.h = this;
        this.i = this;
        this.setPrevious(null);
        this.setNext(null);
    }

    public LinkedListItem getNext() {
        return this.k;
    }

    public void setNext(LinkedListItem linkedListItem) {
        this.k = (DCharacter)linkedListItem;
        if (linkedListItem == null) {
            this.l = null;
            return;
        }
        this.l = new Vector(2);
    }

    public LinkedListItem getPrevious() {
        return this.j;
    }

    public void setPrevious(LinkedListItem linkedListItem) {
        this.j = (DCharacter)linkedListItem;
    }

    public DCharacter getFirst() {
        return this.h;
    }

    public DCharacter getLast() {
        return this.i;
    }

    public int getLength() {
        int n = 0;
        DCharacter dCharacter = this.h;
        while (dCharacter != null) {
            ++n;
            dCharacter = dCharacter.k;
        }
        return n;
    }

    public int compareTo(LinkedListItem linkedListItem, int n) {
        return 0;
    }

    public void addFollower(DCharacter dCharacter) {
        this.board.addCharacter(dCharacter);
        if (this.contain(dCharacter)) {
            return;
        }
        if (this.k == dCharacter) {
            return;
        }
        if (dCharacter.col == -1 || dCharacter.row == -1) {
            dCharacter.setTilePosition(this.col, this.row);
        }
        DCharacter dCharacter2 = this.h;
        while (dCharacter2 != null) {
            dCharacter2.i = dCharacter;
            dCharacter2 = dCharacter2.k;
        }
        this.setNext(dCharacter);
        dCharacter.h = this.h;
        dCharacter.setPrevious(this);
    }

    public void removeSelf() {
        DCharacter dCharacter;
        if (this == this.h) {
            dCharacter = this.h;
            while (dCharacter != null) {
                dCharacter.h = this.h.k;
                dCharacter = dCharacter.k;
            }
        }
        if (this == this.i) {
            dCharacter = this.i;
            while (dCharacter != null) {
                dCharacter.i = this.i.j;
                dCharacter = dCharacter.j;
            }
        }
        if (this.j != null) {
            this.j.setNext(this.k);
        }
        if (this.k != null) {
            this.k.setPrevious(this.j);
        }
        this.h = this;
        this.i = this;
        this.setPrevious(null);
        this.setNext(null);
        this.board.removeCharacter(this);
        this.onRemoved();
    }

    public boolean contain(DCharacter dCharacter) {
        DCharacter dCharacter2 = this.h;
        while (dCharacter2 != null) {
            if (dCharacter2 == dCharacter) {
                return true;
            }
            dCharacter2 = dCharacter2.k;
        }
        return false;
    }

    public void resetAll() {
        DCharacter dCharacter = this.h;
        while (dCharacter != null) {
            DCharacter dCharacter2 = dCharacter.k;
            dCharacter.reset();
            dCharacter = dCharacter2;
        }
    }

    public boolean isLeader() {
        return this.h == this;
    }

    public boolean isSingle() {
        return this.h == this && this.i == this;
    }

    public void setCharacterListener(CharacterListener characterListener) {
        this.m = characterListener;
    }

    public CharacterListener getCharacterListener() {
        return this.m;
    }

    public void setDefaultDire(byte by) {
        this.e = by;
    }

    public void setEnemyRate(int n) {
        this.n = n;
    }

    public void setCurDire(byte by) {
        if (this.f != by) {
            this.f = by;
            this.addHistoryPaths(this.col, this.row);
        }
        if (this.o) {
            return;
        }
        if (by == 4 || by == 8) {
            if (by != this.e) {
                this.setTransform(2);
                return;
            }
            if (by == this.e) {
                this.setTransform(0);
            }
        }
    }

    public boolean isFly() {
        return this.getAction() == this.ACTION_FLY || this.p;
    }

    public void setFly(boolean bl) {
        this.p = bl;
    }

    public int getLeft() {
        if (this.animationModel != null) {
            if (this.animationModel.getTransform() == 2) {
                return -super.getRight();
            }
            return super.getLeft();
        }
        return super.getLeft();
    }

    public int getRight() {
        if (this.animationModel != null) {
            if (this.animationModel.getTransform() == 2) {
                return -super.getLeft();
            }
            return super.getRight();
        }
        return super.getRight();
    }

    public void moveForever(byte by) {
        this.g = by;
        this.setCurDire(by);
    }

    public boolean moveAlittle(byte by) {
        int n = 0;
        int n2 = 0;
        if ((by & 1) == 1) {
            n2 = -1;
        } else if ((by & 2) == 2) {
            n2 = 1;
        }
        if ((by & 4) == 4) {
            n = -1;
        } else if ((by & 8) == 8) {
            n = 1;
        }
        return this.moveLinearTo(this.x + n * this.moveSpeedX, this.y + n2 * this.moveSpeedY);
    }

    public boolean moveTile(byte by) {
        int n = 0;
        int n2 = 0;
        switch (by) {
            case 1: {
                n2 = -1;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 4: {
                n = -1;
                break;
            }
            case 8: {
                n = 1;
            }
        }
        return this.moveTileLinearTo(this.col + n, this.row + n2);
    }

    public boolean moveTileLinearTo(int n, int n2) {
        return this.moveLinearTo(n * this.board.tileWidth + this.board.tileHalfWidth, n2 * this.board.tileHeight + this.board.tileHalfHeight);
    }

    public boolean moveLinearTo(int n, int n2) {
        this.o = false;
        return this.a(n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean a(int n, int n2) {
        this.q = false;
        int n3 = 0;
        if (this.board != null) {
            boolean bl;
            int n4 = this.x == n ? n : (n3 = this.x > n ? n - this.board.tileHalfWidth + 1 : n + this.board.tileHalfWidth - 1);
            if (this.isFly()) {
                bl = this.a(n3, n2, false);
            } else {
                int n5 = n2;
                int n6 = n3;
                DCharacter dCharacter = this;
                if (dCharacter.board != null && dCharacter == dCharacter.board.getPlayer() && dCharacter.isLeader()) {
                    if (!dCharacter.board.canMove(n6, n5)) {
                        DData dData = dCharacter.board.getObjectExceptBuild(n6, n5);
                        if (dData == null) return false;
                        if (dData instanceof DCharacter) {
                            dData = (DCharacter)dData;
                            ((DCharacter)dData).setCurDire(dCharacter.f == 4 ? (byte)8 : 4);
                            ((DCharacter)dData).getCharacterListener().onMessage(STEP_NPC, null);
                            dCharacter.stop();
                            return false;
                        } else {
                            if (!(dData instanceof DData)) return false;
                            dData.executeScript();
                            dCharacter.stop();
                        }
                        return false;
                    }
                    if (MathUtil.nextInt(100) < dCharacter.n && dCharacter.getCharacterListener().onMessage(SUFFER_ENEMY, null)) {
                        return false;
                    }
                }
                bl = false;
            }
            n3 = bl ? 1 : 0;
        }
        if (n3 == 0) {
            this.setMoveTarget(n, n2);
        }
        if (n3 != 0) return false;
        return true;
    }

    private boolean a(int n, int n2, boolean bl) {
        if (this.board != null && this == this.board.getPlayer() && this.isLeader()) {
            DData dData;
            if (!this.board.map.canBoundsMove(n / this.board.tileWidth, n2 / this.board.tileHeight)) {
                return true;
            }
            if (bl && (dData = this.board.getObjectExceptBuild(n, n2)) != null && !(dData instanceof DCharacter) && dData instanceof DData) {
                dData.executeScript();
                this.stop();
                return true;
            }
        }
        return false;
    }

    public int[][] moveAstarTo(int n, int n2) {
        DData dData = null;
        if (this.board.getPlayer() == this && (dData = this.board.getTileObjectExceptBuild(n, n2, 6)) != null) {
            dData.setThroughAble(true);
        }
        int[][] nArray = this.board.AstarMove(this.col, this.row, n, n2);
        if (dData != null) {
            dData.setThroughAble(false);
        }
        if (nArray != null && nArray.length > 0) {
            this.clearMovePath();
            n2 = nArray.length;
            while (--n2 >= 0) {
                this.addMovePath(nArray[n2][0], nArray[n2][1]);
            }
            return nArray;
        }
        return null;
    }

    public boolean patrolMoveTo(int n, int n2) {
        if (this.moveAstarTo(n, n2) != null) {
            this.r = new int[]{this.col, this.row};
            this.s = new int[]{n, n2};
            this.u = true;
            return true;
        }
        return false;
    }

    public void pausePatrolMove() {
        int[] nArray = this.r;
        int[] nArray2 = this.s;
        this.stop();
        this.r = nArray;
        this.s = nArray2;
        this.t = true;
    }

    public boolean continuePatrolMove() {
        if (this.r != null && this.s != null) {
            if (this.r[0] == this.col && this.r[1] == this.row) {
                this.moveAstarTo(this.s[0], this.s[1]);
                this.u = false;
                return true;
            }
            if (this.s[0] == this.col && this.s[1] == this.row) {
                this.moveAstarTo(this.r[0], this.r[1]);
                this.u = true;
                return true;
            }
            if (this.t) {
                this.moveAstarTo(this.u ? this.s[0] : this.r[0], this.u ? this.s[1] : this.r[1]);
                this.t = false;
                return true;
            }
        }
        return false;
    }

    public void cleanPatrolMove() {
        this.t = false;
        this.r = null;
        this.s = null;
    }

    public boolean ignoreDireMoveLinearTo(int n, int n2) {
        this.o = true;
        return this.a(n, n2);
    }

    public void flyTileLinearTo(int n, int n2) {
        this.clearMovePath();
        this.addMovePath(n, n2);
    }

    public void flyForever(byte by) {
        this.g = by;
        this.setCurDire(by);
    }

    public boolean movePathEmpty() {
        return this.b == null || this.b.isEmpty();
    }

    public void addMovePath(int n, int n2) {
        if (!this.isLeader()) {
            return;
        }
        if (this.col == -1 || this.row == -1) {
            this.setTilePosition(n, n2);
            return;
        }
        if (this.b == null) {
            this.b = new Vector();
        }
        if (this.b.isEmpty()) {
            if (this.col == n && this.row == n2) {
                return;
            }
            this.moveTileLinearTo(n, n2);
        } else {
            int[] nArray = (int[])this.b.elementAt(this.b.size() - 1);
            if (nArray[0] == n && nArray[1] == n2) {
                return;
            }
        }
        this.b.addElement(new int[]{n, n2});
    }

    public void subMovePath() {
        if (!this.isLeader()) {
            return;
        }
        if (this.b != null && this.b.size() > 0) {
            this.b.removeElementAt(0);
            if (this.b.size() > 0) {
                int[] nArray = (int[])this.b.elementAt(0);
                this.moveTileLinearTo(nArray[0], nArray[1]);
                return;
            }
            if (!this.continuePatrolMove()) {
                this.stop();
            }
        }
    }

    public void clearMovePath() {
        if (this.b != null) {
            this.b.removeAllElements();
        }
    }

    public void addHistoryPaths(int n, int n2) {
        if (!this.isLeader() || this.board == null || this.board.getPlayer() != this) {
            return;
        }
        if (this.a == null) {
            this.a = new Vector();
        } else {
            int[] nArray;
            if (this.a.size() >= 127) {
                Log.warn("\u5386\u53f2\u4fdd\u5b58\u8def\u5f84\u8fc7\u5927 " + this.a.size());
                return;
            }
            if (!this.a.isEmpty() && (nArray = (int[])this.a.elementAt(this.a.size() - 1))[0] == n && nArray[1] == n2) {
                return;
            }
        }
        this.a.addElement(new int[]{n, n2});
    }

    public Vector getMovePaths() {
        return this.b;
    }

    public Vector getHistoryPaths() {
        return this.a;
    }

    public void cleanHistoryPaths() {
        this.a = null;
    }

    public void setTilePosition(int n, int n2) {
        super.setTilePosition(n, n2);
        this.setMoveTarget(this.x, this.y);
        if (this.k != null) {
            this.k.setTilePosition(n, n2);
        }
    }

    public void setPosition(int n, int n2) {
        super.setPosition(n, n2);
        this.setMoveTarget(n, n2);
    }

    public void setMoveSpeed(int n, int n2) {
        this.moveSpeedX = n;
        this.moveSpeedY = n2;
    }

    public void stop() {
        this.v = 0;
        this.g = 0;
        if (this.getAction() == this.ACTION_WALK) {
            this.setAction(this.ACTION_STAND);
        }
        this.clearMovePath();
        DCharacter dCharacter = this;
        this.q = true;
        dCharacter.setMoveTarget(dCharacter.x, dCharacter.y);
        dCharacter.o = false;
    }

    public boolean isStoped() {
        return this.q;
    }

    public void setMoveTarget(int n, int n2) {
        this.c = n;
        this.d = n2;
    }

    public boolean setCurPosition(int n, int n2) {
        boolean bl = super.setCurPosition(n, n2);
        if (this.k != null && bl) {
            this.l.addElement(new int[]{n, n2});
            if (this.l.size() >= 2) {
                int[] nArray = (int[])this.l.elementAt(0);
                this.k.moveLinearTo(nArray[0], nArray[1]);
                this.l.removeElementAt(0);
            }
        }
        return bl;
    }

    public void run() {
        if (!this.visible) {
            return;
        }
        try {
            int n;
            int n2;
            super.run();
            if (this.g != 0) {
                n2 = this.g;
                DCharacter dCharacter = this;
                boolean bl = dCharacter.moveAlittle((byte)n2);
                n = bl ? 1 : 0;
                if (!bl) {
                    n = 0;
                    switch (n2) {
                        case 1: {
                            n = dCharacter.v == 8 ? 4 : 8;
                            break;
                        }
                        case 2: {
                            n = dCharacter.v == 4 ? 8 : 4;
                            break;
                        }
                        case 4: {
                            n = dCharacter.v == 1 ? 2 : 1;
                            break;
                        }
                        case 8: {
                            int n3 = n = dCharacter.v == 2 ? 1 : 2;
                        }
                    }
                    if (!dCharacter.moveAlittle((byte)n)) {
                        dCharacter.v = (byte)n;
                    }
                } else {
                    byte cfr_ignored_0 = dCharacter.v;
                }
            }
            boolean bl = false;
            n2 = this.x;
            n = this.y;
            int n4 = this.f;
            if (this.d != n) {
                if (this.d > n) {
                    n4 = 2;
                    n = (n += this.moveSpeedY) > this.d ? this.d : n;
                } else {
                    n4 = 1;
                    n = (n -= this.moveSpeedY) < this.d ? this.d : n;
                }
                bl = true;
            }
            if (this.c != n2) {
                if (this.c > n2) {
                    n4 = 8;
                    n2 = (n2 += this.moveSpeedX) > this.c ? this.c : n2;
                } else {
                    n4 = 4;
                    n2 = (n2 -= this.moveSpeedX) < this.c ? this.c : n2;
                }
                bl = true;
            }
            if (bl) {
                this.setCurDire((byte)n4);
                this.setCurPosition(n2, n);
                if (this.isFly()) {
                    this.a(n2, n, true);
                }
            }
            if (!this.isFly()) {
                if (bl && this.getAction() == this.ACTION_STAND) {
                    this.setAction(this.ACTION_WALK);
                } else if (!bl && this.getAction() == this.ACTION_WALK && this.g == 0) {
                    this.setAction(this.ACTION_STAND);
                } else if (!bl && this.getAction() == this.ACTION_STAND && this.g != 0) {
                    this.setAction(this.ACTION_WALK);
                }
            }
            if (n2 == this.c && n == this.d && !this.movePathEmpty()) {
                this.subMovePath();
            }
            return;
        }
        catch (Exception exception) {
            Log.warn("DCharacter.run", exception);
            return;
        }
    }

    public void cleanTransparenceModel() {
        this.transparenceModel = null;
    }

    public void paintClips(Graphics graphics) {
        if (!this.visible || this.paintClips == null || this.animationModel == null) {
            return;
        }
        if (this.transparenceModel == null) {
            this.transparenceModel = (AnimationModel)this.animationModel.clone(null, true);
            this.transparenceModel.setTransparence(120, true);
            this.setAction(this.getAction());
        }
        int n = graphics.getClipWidth();
        int n2 = graphics.getClipHeight();
        int n3 = graphics.getClipX();
        int n4 = graphics.getClipY();
        graphics.clipRect(this.paintClips[0], this.paintClips[1], this.paintClips[2], this.paintClips[3]);
        graphics.translate(this.x, this.y);
        if (this.transparenceModel != null) {
            this.transparenceModel.draw(graphics, 0, 0);
        }
        graphics.translate(-this.x, -this.y);
        graphics.setClip(n3, n4, n, n2);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.isFly() && !this.w && this.board != null) {
            this.board.paintDirtyBuilding(graphics, this);
        }
    }

    public void paintSelf(Graphics graphics) {
        this.w = false;
        if (this.m != null) {
            this.w = this.m.paintSelf(graphics);
        }
        if (!this.w) {
            super.paintSelf(graphics);
        }
    }

    protected void onAdded(DBoard dBoard) {
        super.onAdded(dBoard);
        if (this.l != null) {
            this.l.removeAllElements();
        }
        this.cleanHistoryPaths();
        this.clearMovePath();
    }

    public Object callback(int n, Object object, Object object2) {
        switch (n) {
            case 1: {
                this.cleanTransparenceModel();
                return null;
            }
        }
        return null;
    }

    public DElement clone(DElement dElement) {
        if ((dElement = (DCharacter)dElement) == null) {
            dElement = new DCharacter(this.board);
        }
        super.clone(dElement);
        ((DCharacter)dElement).e = this.e;
        ((DCharacter)dElement).f = this.f;
        return dElement;
    }
}

