/*
 * Decompiled with CFR 0.152.
 */
package com.ea.engine.game._2d2;

import com.ea.engine.game._2d2.DBoard;
import com.ea.engine.game._2d2.DData;
import com.ea.engine.model.AModel;
import com.ea.engine.model.AnimationModel;
import com.ea.util.Log;
import com.ea.util.MathUtil;
import com.ea.util.graphics.GraphicsUtil;
import java.io.DataInputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class DElement
extends DData {
    public static final Font DEFAULT_FONT = Font.getFont((int)0, (int)0, (int)8);
    public static final byte TYPE_DEFAULT = 0;
    public static final byte TYPE_ANIMATION = 1;
    public static final byte TYPE_LABEL = 2;
    public static final byte DIRE_NONE = 0;
    public static final byte DIRE_UP = 1;
    public static final byte DIRE_LEFT = 4;
    public static final byte DIRE_RIGHT = 8;
    public static final byte DIRE_DOWN = 2;
    public static final byte DIRE_LEFT_UP = 5;
    public static final byte DIRE_RIGHT_UP = 9;
    public static final byte DIRE_LEFT_DOWN = 6;
    public static final byte DIRE_RIGHT_DOWN = 10;
    protected AnimationModel animationModel;
    protected AModel[] images;
    protected short[][] imageClips;
    private short[][] a;
    private int b;
    private int c;
    private int d;
    private int e;
    protected boolean visible = true;
    private byte f;
    protected int[] paintClips;
    protected AnimationModel transparenceModel;
    private String g;
    private int h;
    private int i;
    private byte j;

    public DElement(DBoard dBoard) {
        super(dBoard);
    }

    public static short[][] readImageClips(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readUnsignedByte();
        short[][] sArray = new short[n][6];
        for (int k = 0; k < n; ++k) {
            sArray[k][0] = (short)dataInputStream.readUnsignedByte();
            sArray[k][1] = dataInputStream.readShort();
            sArray[k][2] = dataInputStream.readShort();
            sArray[k][3] = dataInputStream.readShort();
            sArray[k][4] = dataInputStream.readShort();
            sArray[k][5] = dataInputStream.readByte();
        }
        return sArray;
    }

    public void init(DataInputStream dataInputStream) throws Exception {
        this.x = dataInputStream.readShort();
        this.y = dataInputStream.readShort();
        if (this.type == 1 && this.animationModel != null) {
            this.f = dataInputStream.readByte();
            this.setTransform(this.f);
        }
    }

    public void initClip(DataInputStream dataInputStream) throws Exception {
        this.type = dataInputStream.readByte();
        this.name = dataInputStream.readUTF();
        if (this.type == 0) {
            this.f = dataInputStream.readByte();
            this.b = dataInputStream.readShort();
            this.c = dataInputStream.readShort();
            this.d = dataInputStream.readShort();
            this.e = dataInputStream.readShort();
            int n = dataInputStream.readUnsignedByte();
            this.a = new short[n][3];
            for (int k = 0; k < n; ++k) {
                this.a[k][0] = (short)dataInputStream.readUnsignedByte();
                this.a[k][1] = dataInputStream.readShort();
                this.a[k][2] = dataInputStream.readShort();
            }
            return;
        }
        if (this.type == 2) {
            this.g = dataInputStream.readUTF();
            this.j = dataInputStream.readByte();
            this.i = dataInputStream.readInt();
            this.h = dataInputStream.readInt();
        }
    }

    public void setAnimationModel(AnimationModel animationModel) {
        this.animationModel = animationModel;
        this.cleanTransparenceModel();
    }

    public AnimationModel getAnimationModel() {
        return this.animationModel;
    }

    public void cleanTransparenceModel() {
        this.transparenceModel = null;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setAction(int n) {
        if (this.type == 1 && this.animationModel != null) {
            this.animationModel.setAction(n);
            if (this.transparenceModel != null) {
                this.transparenceModel.setAction(n);
            }
        }
    }

    public void setTransform(int n) {
        if (this.type == 1 && this.animationModel != null) {
            this.animationModel.setTransform(n);
            if (this.transparenceModel != null) {
                this.transparenceModel.setTransform(n);
            }
        }
    }

    public int getAction() {
        if (this.type == 1 && this.animationModel != null) {
            return this.animationModel.getAction();
        }
        return 0;
    }

    protected boolean isDynamic() {
        return this.type == 1;
    }

    public String getName() {
        if (this.name != null && !"".equals(this.name)) {
            return this.name;
        }
        if (this.type == 1 && this.animationModel != null) {
            return this.animationModel.data.name;
        }
        if (this.type == 2) {
            return this.g;
        }
        return super.getName();
    }

    public int getType() {
        if (this.type == 1 && this.animationModel != null) {
            return this.animationModel.data.type;
        }
        return super.getType();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getCol() {
        return this.col;
    }

    public int getRow() {
        return this.row;
    }

    public int getLeft() {
        if (this.type == 1 && this.animationModel != null) {
            return this.animationModel.data.left;
        }
        return this.e;
    }

    public int getRight() {
        if (this.type == 1 && this.animationModel != null) {
            return this.animationModel.data.right;
        }
        return this.c;
    }

    public int getTop() {
        if (this.type == 1 && this.animationModel != null) {
            return this.animationModel.data.top;
        }
        return this.b;
    }

    public int getBottom() {
        if (this.type == 1 && this.animationModel != null) {
            return this.animationModel.data.bottom;
        }
        return this.d;
    }

    public int getWidth() {
        if (this.type == 1 && this.animationModel != null) {
            return this.animationModel.getWidth();
        }
        if (this.type == 2) {
            return Font.getDefaultFont().stringWidth(this.g);
        }
        return this.c - this.e;
    }

    public int getHeight() {
        if (this.type == 1 && this.animationModel != null) {
            return this.animationModel.getHeight();
        }
        if (this.type == 2) {
            return Font.getDefaultFont().getHeight();
        }
        return this.d - this.b;
    }

    public int[] getBounds() {
        int n = this.x + this.getLeft();
        int n2 = this.y + this.getTop();
        return new int[]{n, n2, this.getWidth(), this.getHeight()};
    }

    public void setTransparence(int n) {
        this.setTransparence(n, false);
    }

    public void setTransparence(int n, boolean bl) {
        if (!GraphicsUtil.transparenceEnable) {
            return;
        }
        if (this.type == 1 && this.animationModel != null) {
            if (bl) {
                this.animationModel.clone(this.animationModel, true);
            }
            this.animationModel.setTransparence(n, bl);
        }
    }

    public void recover() {
        if (!GraphicsUtil.transparenceEnable) {
            return;
        }
        if (this.type == 1 && this.animationModel != null) {
            this.animationModel.recover();
        }
    }

    public boolean inTileCenter() {
        return this.x % this.board.tileWidth == this.board.tileHalfWidth && this.y % this.board.tileHeight == this.board.tileHalfHeight;
    }

    protected int[] getTileBoundsWithPosition() {
        return this.board.getTileBoundsWithPosition(this.x + this.getLeft(), this.y + this.getTop(), this.getWidth(), this.getHeight());
    }

    public void addPaintClip(int[] nArray) {
        if (this.paintClips == null) {
            this.paintClips = nArray;
        }
        this.paintClips = MathUtil.minRectAdded(this.paintClips, nArray);
    }

    public void clearPaintClip() {
        this.paintClips = null;
    }

    public void run() {
        if (!this.visible) {
            return;
        }
        try {
            if (this.type == 1 && this.animationModel != null) {
                this.animationModel.run();
                if (this.transparenceModel != null) {
                    this.transparenceModel.run();
                }
            }
            return;
        }
        catch (Exception exception) {
            Log.warn("DElement.run", exception);
            return;
        }
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.x, this.y);
    }

    public void paint(Graphics graphics, int n, int n2) {
        if (!this.visible) {
            return;
        }
        graphics.translate(n, n2);
        this.paintSelf(graphics);
        graphics.translate(-n, -n2);
    }

    public void paintClips(Graphics graphics) {
        if (!this.visible || this.paintClips == null) {
            return;
        }
        int n = graphics.getClipWidth();
        int n2 = graphics.getClipHeight();
        int n3 = graphics.getClipX();
        int n4 = graphics.getClipY();
        graphics.clipRect(this.paintClips[0], this.paintClips[1], this.paintClips[2], this.paintClips[3]);
        graphics.translate(this.x, this.y);
        this.paintSelf(graphics);
        graphics.translate(-this.x, -this.y);
        graphics.setClip(n3, n4, n, n2);
    }

    public void paintSelf(Graphics graphics) {
        block6: {
            try {
                if (this.type == 1 && this.animationModel != null) {
                    this.animationModel.draw(graphics);
                    break block6;
                }
                if (this.type == 0) {
                    int n = this.a.length;
                    for (int k = 0; k < n; ++k) {
                        short[] sArray = this.imageClips[this.a[k][0]];
                        short s = (short)GraphicsUtil.TRANSFORM_TABLE[sArray[5]][this.f];
                        GraphicsUtil.drawRegion(graphics, this.images[sArray[0]].getImage(), sArray[1], sArray[2], sArray[3], sArray[4], s, this.a[k][1], this.a[k][2], 0);
                    }
                    break block6;
                }
                if (this.type == 2) {
                    graphics.setFont(DEFAULT_FONT);
                    GraphicsUtil.drawRimString(graphics, this.g, 0, 0, 0, this.h, this.i, this.j);
                }
                return;
            }
            catch (Exception exception) {
                Log.warn("DElement.painSelf", exception);
            }
        }
    }

    public DElement clone(DElement dElement) {
        if (dElement == null) {
            dElement = new DElement(this.board);
        }
        super.clone(dElement);
        dElement.animationModel = this.animationModel;
        dElement.images = this.images;
        dElement.imageClips = this.imageClips;
        dElement.a = this.a;
        dElement.b = this.b;
        dElement.c = this.c;
        dElement.d = this.d;
        dElement.e = this.e;
        dElement.f = this.f;
        dElement.i = this.i;
        dElement.g = this.g;
        dElement.h = this.h;
        dElement.j = this.j;
        return dElement;
    }
}

