/*
 * Decompiled with CFR 0.152.
 */
package com.ea.engine.model;

import com.ea.engine.model.M;
import com.ea.io.net.Protocol;
import com.ea.io.net.ProtocolListener;
import com.ea.util.CallbackListener;
import com.ea.util.Encoder;
import com.ea.util.GZIP;
import com.ea.util.Log;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.microedition.lcdui.Image;

public abstract class AModel
implements ProtocolListener {
    public int fileLength;
    public String id;
    public int version;
    public static final byte MODE_WITH_GZIP = 64;
    public static final byte MODE_WITH_ENCRY = 32;
    public static final byte MODE_CACHE_LEVEL0 = 0;
    public static final byte MODE_CACHE_LEVEL1 = 1;
    public static final byte MODE_CACHE_LEVEL2 = 2;
    public static final byte MODE_CACHE_LEVEL3 = 3;
    public static final byte MODE_CACHE_LEVELMARK = 3;
    public byte mode0;
    public byte mode;
    protected int byteSize;
    public long lastGetTime;
    protected boolean removeMark = false;
    public byte cacheLevel = (byte)2;
    private boolean a = false;
    public static final int LISTENER_INITOVER = 1;
    private CallbackListener b;

    public AModel() {
        this.a = true;
    }

    public AModel(String string) throws Exception {
        InputStream inputStream = null;
        try {
            inputStream = M.getInputStreamFromRmsOrJar(string);
            this.init(inputStream, true);
        }
        catch (Throwable throwable) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public AModel(byte[] byArray) throws Exception {
        this(AModel.createStream(byArray));
    }

    public static ByteArrayInputStream createStream(byte[] object) {
        object = new ByteArrayInputStream((byte[])object);
        try {
            ((ByteArrayInputStream)object).close();
        }
        catch (Exception exception) {}
        return object;
    }

    public AModel(InputStream inputStream) throws Exception {
        this(inputStream, true);
    }

    public AModel(InputStream inputStream, boolean bl) throws Exception {
        this.init(inputStream, bl);
    }

    protected void init(InputStream inputStream, boolean bl) throws Exception {
        int n;
        this.lastGetTime = System.currentTimeMillis();
        InputStream inputStream2 = inputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        if (bl && (n = ((DataInputStream)inputStream).readInt()) != this.getHeader()) {
            throw new Exception("\u975e\u6cd5\u5f00\u59cb\u6807\u8bb0 " + n);
        }
        this.inflate(this.getDataStream((DataInputStream)inputStream));
        if (bl && (n = ((DataInputStream)inputStream).readInt()) != this.getEnd()) {
            throw new Exception("\u975e\u6cd5\u7ed3\u675f\u6807\u8bb0 " + n);
        }
        this.a = false;
        this.onInited();
    }

    public int getDataLength() throws UnsupportedEncodingException {
        return this.fileLength - 8 - 4 - 2 - this.id.getBytes("UTF-8").length - 1 - 1 - 1;
    }

    public AModel(AModel aModel) {
    }

    public abstract int getHeader();

    public abstract int getEnd();

    protected abstract void inflate(DataInputStream var1) throws Exception;

    public void removeMark() {
        this.removeMark = true;
    }

    public void reuse() {
        this.removeMark = false;
        this.lastGetTime = System.currentTimeMillis();
    }

    public void setCallbackListener(CallbackListener callbackListener) {
        this.b = callbackListener;
    }

    public boolean procSucc(Protocol protocol) {
        try {
            if (M.saveServerResource2Rms && this.id != null && !"".equals(this.id)) {
                DataInputStream dataInputStream = protocol.getInputStream();
                byte[] byArray = new byte[protocol.content.getRecvSize()];
                dataInputStream.readFully(byArray);
                dataInputStream.reset();
                M.instance.saveResourceToRms(this.id, byArray);
            }
            this.init(protocol.getInputStream(), true);
            M.instance.cacheResource(null, this);
        }
        catch (Throwable throwable) {
            Log.error("\u4ece\u670d\u52a1\u5668\u83b7\u5f97Model " + this.id + "\u89e3\u6790\u5f02\u5e38", throwable);
        }
        return true;
    }

    public boolean procError(Protocol protocol) {
        Log.warn("\u4ece\u670d\u52a1\u5668\u672a\u83b7\u5f97Model " + this.id);
        return true;
    }

    public void onInited() {
        if (this.b != null) {
            this.b.callback(1, null, this);
            this.b = null;
        }
    }

    public Image getImage() {
        throw new RuntimeException(this.getClass().getName() + " \u672a\u5b9e\u73b0getImage\u65b9\u6cd5\uff0c\u53ef\u80fd\u4e0d\u662f\u4e0e\u56fe\u7247\u76f8\u5173\u7684\u8d44\u6e90");
    }

    public void setImage() {
    }

    protected final DataInputStream getDataStream(DataInputStream object) throws Exception {
        this.fileLength = ((DataInputStream)object).readInt();
        this.id = ((DataInputStream)object).readUTF();
        this.version = ((DataInputStream)object).readUnsignedByte();
        this.mode0 = ((DataInputStream)object).readByte();
        this.cacheLevel = (byte)(this.mode0 & 3);
        this.mode = ((DataInputStream)object).readByte();
        byte[] byArray = new byte[this.getDataLength()];
        ((DataInputStream)object).readFully(byArray);
        if ((this.mode0 & 0x40) == 64) {
            byArray = GZIP.inflate(byArray);
            this.fileLength += byArray.length - this.getDataLength();
        }
        if ((this.mode0 & 0x20) == 32) {
            object = this.id.getBytes("UTF-8");
            byArray = Encoder.encry(byArray, (byte[])object, 0);
        }
        return new DataInputStream(AModel.createStream(byArray));
    }

    public boolean isNull() {
        return this.a;
    }

    public final AModel clone(AModel aModel) {
        return this.clone(aModel, false);
    }

    public AModel clone(AModel aModel, boolean bl) {
        if (aModel == null) {
            return null;
        }
        aModel.fileLength = this.fileLength;
        aModel.id = this.id;
        aModel.version = this.version;
        aModel.a = this.a;
        return aModel;
    }

    public String toString() {
        return super.toString() + "^id=" + this.id + "^cache=" + this.cacheLevel;
    }
}

