/*
 * Decompiled with CFR 0.152.
 */
package com.ea.engine.model;

import com.ea.engine.model.AModel;
import com.ea.util.graphics.GraphicsUtil;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public abstract class ImageModel
extends AModel {
    protected Image image;
    protected Image processedImage;
    private boolean a = true;
    private byte[] b;
    private int c = 255;
    private int[] d;
    private boolean e;

    public ImageModel() {
    }

    public ImageModel(String string) throws Exception {
        super(string);
    }

    public ImageModel(byte[] byArray) throws Exception {
        super(byArray);
    }

    public ImageModel(InputStream inputStream) throws Exception {
        super(inputStream);
    }

    public ImageModel(InputStream inputStream, boolean bl) throws Exception {
        super(inputStream, bl);
    }

    public Image getImage() {
        if (this.processedImage != null) {
            return this.processedImage;
        }
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public int[] getPixels() {
        if (this.d != null) {
            return this.d;
        }
        Image image = this.getImage();
        if (image != null) {
            int n = image.getWidth();
            int n2 = image.getHeight();
            this.d = new int[n * n2];
            image.getRGB(this.d, 0, n, 0, 0, n, n2);
            return this.d;
        }
        return null;
    }

    public void scale(int n, int n2) {
        int[] nArray = GraphicsUtil.scale(n, n2, this.getWidth(), this.getWidth(), this.getHeight(), this.getPixels());
        if (this.processedImage != null) {
            this.processedImage = Image.createRGBImage((int[])nArray, (int)n, (int)n2, (boolean)true);
            return;
        }
        this.image = Image.createRGBImage((int[])nArray, (int)n, (int)n2, (boolean)true);
    }

    public int getWidth() {
        if (this.processedImage != null) {
            return this.processedImage.getWidth();
        }
        return this.image.getWidth();
    }

    public int getHeight() {
        if (this.processedImage != null) {
            return this.processedImage.getHeight();
        }
        return this.image.getHeight();
    }

    public void useOriginal(boolean bl) {
        this.a = bl;
    }

    public void recover() {
        this.processedImage = null;
        if (this.b != null) {
            this.setTransparence(255);
        }
        this.b = null;
    }

    public void setTransparence(int n) {
        if (!GraphicsUtil.transparenceEnable) {
            return;
        }
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("\u900f\u660e\u5ea6\u8d85\u51fa\u8303\u56f4" + n);
        }
        if (this.c == n) {
            return;
        }
        this.c = n;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int[] nArray = new int[n2 * n3];
        boolean bl = this.b == null;
        if (bl) {
            this.b = new byte[nArray.length];
        }
        this.image.getRGB(nArray, 0, n2, 0, 0, n2, n3);
        for (int k = 0; k < nArray.length; ++k) {
            if (nArray[k] >>> 24 == 0) continue;
            if (bl) {
                this.b[k] = (byte)((nArray[k] >>> 24) - 128);
            }
            nArray[k] = n * (this.b[k] + 128) >>> 8 << 24 | nArray[k] & 0xFFFFFF;
        }
        this.image = Image.createRGBImage((int[])nArray, (int)n2, (int)n3, (boolean)true);
    }

    public void setGray() {
        if (this.isNull()) {
            this.e = true;
            return;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        int[] nArray = new int[n * n2];
        this.image.getRGB(nArray, 0, n, 0, 0, n, n2);
        for (int k = 0; k < nArray.length; ++k) {
            int n3 = nArray[k];
            int n4 = n3 >> 16 & 0xFF;
            int n5 = n3 >> 8 & 0xFF;
            n3 &= 0xFF;
            n3 = n4 * 76 + n5 * 150 + n3 * 29 >> 8;
            nArray[k] = nArray[k] & 0xFF000000 | n3 << 16 | n3 << 8 | n3;
        }
        if (this.a) {
            this.image = Image.createRGBImage((int[])nArray, (int)n, (int)n2, (boolean)true);
            return;
        }
        this.processedImage = Image.createRGBImage((int[])nArray, (int)n, (int)n2, (boolean)true);
    }

    public void setGrayScale(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("\u7070\u5ea6\u503c\u8d85\u51fa\u8303\u56f4");
        }
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int[] nArray = new int[n2 * n3];
        this.image.getRGB(nArray, 0, n2, 0, 0, n2, n3);
        for (int k = 0; k < nArray.length; ++k) {
            nArray[k] = nArray[k] & 0xFF000000 | n << 16 | n << 8 | n;
        }
        if (this.a) {
            this.image = Image.createRGBImage((int[])nArray, (int)n2, (int)n3, (boolean)true);
            return;
        }
        this.processedImage = Image.createRGBImage((int[])nArray, (int)n2, (int)n3, (boolean)true);
    }

    public void setRGBValue(int n, int n2, int n3) {
        if (n < -1 || n > 255 || n2 < -1 || n2 > 255 || n3 < -1 || n3 > 255) {
            throw new IllegalArgumentException("\u6570\u503c\u8d85\u51fa\u8303\u56f4");
        }
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        int[] nArray = new int[n4 * n5];
        this.image.getRGB(nArray, 0, n4, 0, 0, n4, n5);
        for (int k = 0; k < nArray.length; ++k) {
            if (n != -1) {
                nArray[k] = nArray[k] & 0xFF00FFFF | n << 16;
            }
            if (n2 != -1) {
                nArray[k] = nArray[k] & 0xFFFF00FF | n2 << 8;
            }
            if (n3 == -1) continue;
            nArray[k] = nArray[k] & 0xFFFFFF00 | n3;
        }
        if (this.a) {
            this.image = Image.createRGBImage((int[])nArray, (int)n4, (int)n5, (boolean)true);
            return;
        }
        this.processedImage = Image.createRGBImage((int[])nArray, (int)n4, (int)n5, (boolean)true);
    }

    public void onInited() {
        super.onInited();
        if (this.e) {
            this.setGray();
            this.e = false;
        }
    }

    public AModel clone(AModel aModel, boolean bl) {
        aModel = (ImageModel)aModel;
        super.clone(aModel, bl);
        ((ImageModel)aModel).image = bl ? Image.createImage((Image)this.image) : this.image;
        ((ImageModel)aModel).processedImage = this.processedImage;
        ((ImageModel)aModel).a = this.a;
        ((ImageModel)aModel).b = this.b;
        ((ImageModel)aModel).c = this.c;
        ((ImageModel)aModel).d = this.d;
        return aModel;
    }
}

