/*
 * Decompiled with CFR 0.152.
 */
package com.ea.engine.model;

import com.ea.engine.model.AModel;
import com.ea.engine.model.ImageModel;
import com.ea.engine.model.M;
import com.ea.io.net.Protocol;
import com.ea.util.Log;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class StandardPngModel
extends ImageModel {
    public static final int HEADER = -1991225785;
    public static final int END = 1229278788;
    public static final byte MODE_WITH_LENGTH = 1;
    public static final byte MODE_WITHOUT_LENGTH = 2;

    private StandardPngModel() {
    }

    public StandardPngModel(String string) {
        this(M.getInputStreamFromRmsOrJar(string));
    }

    public StandardPngModel(byte[] byArray) {
        this(AModel.createStream(byArray));
    }

    public StandardPngModel(InputStream inputStream) {
        this(inputStream, 2);
    }

    public StandardPngModel(InputStream inputStream, byte by) {
        try {
            this.mode = by;
            this.init(inputStream, false);
            return;
        }
        catch (Exception exception) {
            Log.error("\u6784\u5efa" + this.id + "\u5931\u8d25", exception);
            return;
        }
    }

    public static StandardPngModel createBlankModel(String string) {
        StandardPngModel standardPngModel = new StandardPngModel();
        new StandardPngModel().id = string;
        return standardPngModel;
    }

    protected void init(InputStream inputStream, boolean bl) throws Exception {
        this.lastGetTime = System.currentTimeMillis();
        inputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        this.inflate((DataInputStream)inputStream);
    }

    protected void inflate(DataInputStream dataInputStream) throws Exception {
        switch (this.mode) {
            case 1: {
                int n = dataInputStream.readInt();
                byte[] byArray = new byte[n];
                dataInputStream.readFully(byArray);
                this.image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                return;
            }
            case 2: {
                this.image = Image.createImage((InputStream)dataInputStream);
            }
        }
    }

    public int getHeader() {
        return -1991225785;
    }

    public int getEnd() {
        return 1229278788;
    }

    public int byteSize() {
        return 0;
    }

    public boolean procSucc(Protocol object) {
        try {
            object = ((Protocol)object).getInputStream();
            this.mode = 1;
            this.inflate((DataInputStream)object);
        }
        catch (Exception exception) {
            Log.error("\u4ece\u670d\u52a1\u5668\u83b7\u5f97Model " + this.id + "\u89e3\u6790\u5f02\u5e38", exception);
        }
        return true;
    }

    public AModel clone(AModel aModel, boolean bl) {
        if ((aModel = (StandardPngModel)aModel) == null) {
            aModel = new StandardPngModel();
        }
        super.clone(aModel, bl);
        return aModel;
    }
}

