/*
 * Decompiled with CFR 0.152.
 */
package com.ea.engine.ui.widget;

import com.ea.engine.core.InteractionListener;
import com.ea.engine.ui.FocusManager;
import com.ea.engine.ui.UI;
import com.ea.engine.ui.widget.Label;
import com.ea.engine.ui.widget.ScrollPane;
import com.ea.engine.ui.widget.Widget;
import com.ea.engine.ui.widget.WidgetConstants;
import com.ea.util.BooleanUtil;
import com.ea.util.Log;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;

public class ActionWidget
extends Widget {
    protected short responseFocusId = (short)-1;
    protected short responseSelectId = (short)-1;
    protected short responseFocusSelectId = (short)-1;
    protected short responseDisenabledId = (short)-1;
    protected boolean focusable = true;
    protected boolean focused = false;
    private String a;
    private String b;
    protected boolean enabled = true;
    private boolean c = false;
    private String d;
    private int e;
    private InteractionListener f;
    protected ActionWidget displayedWidget;
    protected String text;
    protected Label label;
    protected boolean home = true;
    private boolean g = false;
    protected String onSelect;
    protected String onUnselect;
    protected boolean checkBox;

    public ActionWidget() {
        super(12);
    }

    public ActionWidget(int n) {
        super(n);
    }

    public ActionWidget(String string) {
        super(string);
    }

    public Object getAttribute(String string) {
        if (WidgetConstants.WIDGET_ATTRIBUTES[7].equals(string)) {
            return BooleanUtil.toString(this.isFocused());
        }
        if (WidgetConstants.WIDGET_ATTRIBUTES[4].equals(string)) {
            return BooleanUtil.toString(this.isSelected());
        }
        if (WidgetConstants.WIDGET_ATTRIBUTES[12].equals(string)) {
            if (this.d == null) {
                return null;
            }
            string = this.d;
            if (string.startsWith("~") || string.startsWith("^")) {
                string = string.substring(1);
            }
            return UI.parseMethod(string, this);
        }
        if (WidgetConstants.WIDGET_ATTRIBUTES[6].equals(string)) {
            return this.getText();
        }
        return super.getAttribute(string);
    }

    public boolean setAttribute(String string, Object object) {
        if (object == null) {
            this.setText(null);
            return true;
        }
        if (object instanceof String) {
            this.setText((String)object);
            return true;
        }
        if (object instanceof Integer) {
            this.setText(((Integer)object).toString());
            return true;
        }
        if (object instanceof Long) {
            this.setText(((Long)object).toString());
            return true;
        }
        return super.setAttribute(string, object);
    }

    public void setFocusAndEnabled(boolean bl) {
        this.setFocusable(bl);
        this.setEnabled(bl);
    }

    public void setFocusable(boolean bl) {
        this.focusable = bl;
        if (!bl) {
            this.giveFocusToNearestWidget();
        }
    }

    public boolean isFocusable() {
        return this.focusable;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.a();
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            this.giveFocusToNearestWidget();
        }
        super.setVisible(bl);
    }

    public String getOnFocus() {
        return this.a;
    }

    public void setOnFocus(String string) {
        this.a = string;
        this.onSelect = string;
    }

    public String getOnLostFocus() {
        return this.b;
    }

    public void setOnLostFocus(String string) {
        this.b = string;
        this.onUnselect = string;
    }

    public String getOnAction() {
        return this.d;
    }

    public void setOnAction(String string) {
        this.d = string;
    }

    public void setText(String string) {
        this.text = string;
        Label label = this.getLabel();
        if (label != null) {
            label.setText(string);
        }
        this.invalidate();
        if (this.displayedWidget != null) {
            this.displayedWidget.setText(string);
        }
    }

    public String getText() {
        return this.text;
    }

    public Label getLabel() {
        if (this.label == null) {
            Widget widget = this.getChild();
            while (widget != null) {
                if (widget != null && widget instanceof Label) {
                    Label label = (Label)widget;
                    if ("".equals(label.defaultText)) {
                        this.label = label;
                        break;
                    }
                }
                widget = widget.next;
            }
        }
        return this.label;
    }

    private void a(Widget widget) {
        widget = widget.getChild();
        while (widget != null) {
            Widget widget2;
            if (widget.hasBindInstruction() && (widget2 = this.getWidget(widget.name)) != null) {
                if (widget2 instanceof ActionWidget) {
                    ((ActionWidget)widget2).a(widget);
                } else {
                    widget2.setRawData(widget.getRawData(null));
                }
            }
            widget = widget.next;
        }
    }

    public boolean isShortcutsAccessible() {
        return super.isShortcutsAccessible() && this.isEnabled();
    }

    public void giveFocusToNearestWidget() {
        FocusManager focusManager;
        if (this.isFocused() && (focusManager = this.getFocusManager()) != null) {
            focusManager.requestOtherFocus(true, null);
            if (focusManager.getFocusedWidget() == this) {
                focusManager.requestOtherFocus(false, null);
                if (focusManager.getFocusedWidget() == this) {
                    focusManager.requestFocus(null);
                }
            }
        }
    }

    public void remove() {
        this.giveFocusToNearestWidget();
        super.remove();
    }

    public void requestFocus() {
        if (this.isFocusable()) {
            FocusManager focusManager = this.getFocusManager();
            if (focusManager != null) {
                focusManager.requestFocus(this);
                return;
            }
            this.c = true;
        }
    }

    public boolean isSelected() {
        return this.g;
    }

    public void setSelected(boolean bl) {
        if (this.g != bl) {
            this.g = bl;
            this.a();
            this.invalidate();
        }
    }

    private void a() {
        int n;
        String string = null;
        if (!this.isEnabled()) {
            n = this.responseDisenabledId;
            string = "displayDisenabled";
        } else if (this.isFocused() && this.isSelected()) {
            n = this.responseFocusSelectId;
            string = "displayFocusSelect";
        } else if (this.isFocused()) {
            n = this.responseFocusId;
            string = "displayFocus";
        } else if (this.isSelected()) {
            n = this.responseSelectId;
            string = "displaySelect";
        } else {
            n = -1;
        }
        if (this.displayedWidget != null) {
            this.displayedWidget.parent = null;
        }
        if (n == -1) {
            this.displayedWidget = null;
            return;
        }
        this.displayedWidget = (ActionWidget)UI.getControl(n).clone(null);
        this.displayedWidget.name = string;
        this.displayedWidget.setText(this.text);
        this.displayedWidget.a(this);
        this.displayedWidget.parent = this.parent;
    }

    protected void onFocus(Widget widget) {
        this.focused = true;
        this.a();
        if (this.displayedWidget != null) {
            this.displayedWidget.onFocus(widget);
        }
    }

    protected void onLostFocus(Widget widget) {
        this.focused = false;
        this.a();
    }

    public boolean processFocusEvent(byte by) {
        switch (by) {
            case 30: {
                this.focused = true;
                if (this.a != null) {
                    this.processActionString(this.a, false);
                }
                this.propagateFocusEvent(this, false);
                return true;
            }
            case 31: {
                this.focused = false;
                if (this.b != null) {
                    this.processActionString(this.b, false);
                }
                this.propagateFocusEvent(this, true);
                return true;
            }
        }
        return super.processFocusEvent(by);
    }

    protected boolean processFocusablePointerEvent(byte by, int n, int n2) {
        if (this.isFocusable() && by == 20) {
            ScrollPane scrollPane = UI.findFirstScrollPaneParent(this);
            if (scrollPane != null) {
                scrollPane.processPointerEvent(by, n, n2);
            }
            this.requestFocus();
            return true;
        }
        return super.processPointerEvent(by, n, n2);
    }

    public boolean processPointerEvent(byte by, int n, int n2) {
        if (this.isTransitionRunning()) {
            return false;
        }
        if (this.f != null) {
            Widget widget = this;
            while (widget != null) {
                n -= widget.getX();
                n2 -= widget.getY();
                widget = widget.parent;
            }
            return this.f.onPointerEvent(this.e, by, n, n2);
        }
        if (this.isEnabled() && by == 21) {
            boolean bl = this.processActionEvent();
            if (!bl) {
                bl = super.processPointerEvent(by, n, n2);
            }
            return bl;
        }
        return this.processFocusablePointerEvent(by, n, n2);
    }

    public boolean processKeyEvent(byte by, int n) {
        if (this.isTransitionRunning()) {
            return false;
        }
        if (this.f != null) {
            return this.f.onKeyEvent(this.e, by, n);
        }
        if (this.isEnabled() && n == 16 && by == 10) {
            return this.processActionEvent();
        }
        return false;
    }

    public boolean processShortcutKeyEvent(int n) {
        if (this.isTransitionRunning()) {
            return false;
        }
        if (this.isEnabled() && !super.processShortcutKeyEvent(n)) {
            return this.processActionEvent();
        }
        return false;
    }

    public boolean processActionEvent() {
        try {
            if (this.checkBox) {
                this.setSelected(!this.g);
            }
            if (this.isGuideWidget) {
                this.processActionString("guideAction", false);
                this.isGuideWidget = false;
            }
            if (this.d != null) {
                this.processActionString(this.d, true);
                return true;
            }
        }
        catch (Exception exception) {
            Log.error("ActionWidget.processActionEvent " + this.d, exception);
        }
        return false;
    }

    protected String processActionString(String string, boolean bl) {
        Widget widget = null;
        if (bl) {
            if (!string.startsWith("~")) {
                widget = this.getParentInstance(7);
            } else {
                string = string.substring(1);
            }
            if (string.startsWith("^")) {
                widget = this.getParentInstance(30);
                string = string.substring(1);
            }
        }
        UI.callActionMethod(UI.parseMethod(string, this));
        if (widget != null) {
            widget.remove();
        }
        return string;
    }

    protected void paintChildrenImpl(Graphics graphics) {
        if (this.f != null) {
            try {
                this.f.paint(this.e, graphics, 0, 0);
                return;
            }
            catch (Throwable throwable) {
                Log.warn("ActionWidget.interactionListener.paint", throwable);
                return;
            }
        }
        if (this.displayedWidget != null && this.width != 0 && this.height != 0) {
            this.displayedWidget.setBounds(this.x, this.y, this.width, this.height);
            this.displayedWidget.paintChildrenImpl(graphics);
            return;
        }
        super.paintChildrenImpl(graphics);
    }

    protected void onAdded(Widget widget) {
        super.onAdded(widget);
        if (this.c) {
            this.requestFocus();
            this.c = false;
        }
    }

    public void setInteractionListener(int n, InteractionListener interactionListener) {
        this.e = n;
        this.f = interactionListener;
    }

    public InteractionListener getInteractionListener() {
        return this.f;
    }

    public void init(DataInputStream dataInputStream) throws Exception {
        if (this.isHome()) {
            this.focusable = dataInputStream.readBoolean();
        }
        super.init(dataInputStream);
    }

    public void initialize(DataInputStream dataInputStream) throws Exception {
        short s;
        Widget widget;
        if (this.tag == 12 && (widget = UI.getControl(s = dataInputStream.readShort())) != null) {
            widget.clone(this);
        }
        super.initialize(dataInputStream);
    }

    public void initializeControl(DataInputStream dataInputStream) throws Exception {
        short s;
        Widget widget;
        if (this.tag == 12 && (widget = UI.getControl(s = dataInputStream.readShort())) != null) {
            widget.clone(this);
        }
        super.initializeControl(dataInputStream);
    }

    protected boolean isHome() {
        return this.home;
    }

    public boolean processModelUpdateEvent(String string) {
        boolean bl = super.processModelUpdateEvent(string);
        if (this.displayedWidget != null) {
            this.displayedWidget.a(this);
            this.displayedWidget.invalidate();
        }
        return bl;
    }

    public Widget clone(Widget widget) {
        if ((widget = (ActionWidget)widget) == null) {
            widget = new ActionWidget(this.tag);
        }
        super.clone(widget);
        widget.id = this.id;
        ((ActionWidget)widget).responseFocusId = this.responseFocusId;
        ((ActionWidget)widget).responseSelectId = this.responseSelectId;
        ((ActionWidget)widget).responseFocusSelectId = this.responseFocusSelectId;
        ((ActionWidget)widget).responseDisenabledId = this.responseDisenabledId;
        ((ActionWidget)widget).focusable = this.focusable;
        ((ActionWidget)widget).focused = this.focused;
        ((ActionWidget)widget).a = this.a;
        ((ActionWidget)widget).b = this.b;
        ((ActionWidget)widget).onSelect = this.onSelect;
        ((ActionWidget)widget).onUnselect = this.onUnselect;
        ((ActionWidget)widget).enabled = this.enabled;
        ((ActionWidget)widget).c = this.c;
        ((ActionWidget)widget).d = this.d;
        ((ActionWidget)widget).e = this.e;
        ((ActionWidget)widget).f = this.f;
        ((ActionWidget)widget).checkBox = this.checkBox;
        return widget;
    }

    public String toString() {
        return super.toString() + "^txt=" + this.text;
    }
}

