/*
 * Decompiled with CFR 0.152.
 */
package com.ea.engine.ui.widget;

import com.ea.engine.ui.FocusManager;
import com.ea.engine.ui.UI;
import com.ea.engine.ui.widget.Desktop;
import com.ea.engine.ui.widget.List;
import com.ea.engine.ui.widget.MenuItem;
import com.ea.engine.ui.widget.Widget;
import com.ea.engine.ui.widget.Window;
import com.ea.engine.ui.widget.c;
import java.io.DataInputStream;

public class Menu
extends MenuItem {
    protected MenuPopup popup;

    public Menu() {
        this(17);
    }

    public Menu(int n) {
        super(n);
    }

    public Menu(String string) {
        super(string);
    }

    public MenuPopup getPopup() {
        if (this.popup == null) {
            this.popup = new MenuPopup(this);
        }
        return this.popup;
    }

    public void setPopup(MenuPopup menuPopup) {
        if (menuPopup == null) {
            return;
        }
        this.popup = menuPopup;
        menuPopup.setMenu(this);
    }

    public int getDepth() {
        if (this.parent instanceof MenuPopup) {
            return ((MenuPopup)this.parent).getMenu().getDepth() + 1;
        }
        return 0;
    }

    public Widget getWidget(String string) {
        Widget widget = super.getWidget(string);
        if (widget == null && this.popup != null) {
            return this.popup.getWidget(string);
        }
        return widget;
    }

    public void applyShortcutsAssociation(FocusManager focusManager, boolean bl) {
        super.applyShortcutsAssociation(focusManager, bl);
        if (this.popup != null) {
            this.popup.applyShortcutsAssociation(focusManager, bl);
        }
    }

    public void showPopup() {
        this.showPopup(this.getDisplayX() + this.getWidth(), this.getDisplayY() + this.getHeight());
    }

    public void showPopup(int n, int n2) {
        if (this.getDepth() == 0) {
            Menu.hideAllMenuPopups();
        }
        if (this.popup != null) {
            this.popup.show(this.getDesktop(), n, n2);
        }
    }

    public void hidePopup() {
        if (this.popup != null) {
            this.popup.hide();
        }
    }

    public void hideMenuTree() {
        if (this.parent != null && this.parent instanceof MenuPopup) {
            ((MenuPopup)this.parent).getMenu().hideMenuTree();
            return;
        }
        this.hidePopup();
    }

    public static void hideAllMenuPopups() {
        UI.getCanvas().getDesktop().removeAllPopupFromTag(18);
    }

    public void cleanUp() {
        super.cleanUp();
        this.hidePopup();
        if (this.popup != null) {
            this.popup.cleanUp();
        }
    }

    public void removeAll() {
        super.removeAll();
        if (this.popup != null) {
            this.popup.removeAll();
            this.popup = null;
        }
    }

    public boolean processActionEvent() {
        if (this.popup != null && this.popup.parent == null) {
            this.showPopup();
        }
        return super.processActionEvent();
    }

    public void init(DataInputStream dataInputStream) throws Exception {
        super.init(dataInputStream);
    }

    public void initialize(DataInputStream dataInputStream) throws Exception {
        int n;
        short s = dataInputStream.readShort();
        Widget widget = UI.getControl(s);
        if (widget != null) {
            widget.clone(this);
        }
        if ((n = dataInputStream.readBoolean()) != 0) {
            this.setText(dataInputStream.readUTF());
        }
        if ((n = dataInputStream.readBoolean()) != 0) {
            this.setOnAction(dataInputStream.readUTF());
        }
        super.initialize(dataInputStream);
        n = dataInputStream.readUnsignedByte();
        if (n == 1 && (n = dataInputStream.readUnsignedByte()) == 6) {
            this.popup = new MenuPopup(this);
            this.popup.initialize(dataInputStream);
        }
    }

    public void initializeControl(DataInputStream dataInputStream) throws Exception {
        short s = dataInputStream.readShort();
        Widget widget = UI.getControl(s);
        if (widget != null) {
            widget.clone(this);
        }
        super.initializeControl(dataInputStream);
    }

    public Widget clone(Widget widget) {
        if ((widget = (Menu)widget) == null) {
            widget = new Menu(this.tag);
        }
        super.clone(widget);
        return widget;
    }

    public class MenuPopup
    extends List {
        private final FocusManager a;
        private Menu b;

        public void setMenu(Menu menu) {
            this.b = menu;
        }

        public MenuPopup(Menu menu) {
            super(18);
            this.b = menu;
            this.a = new c(this, this, true, menu);
        }

        public Menu getMenu() {
            return this.b;
        }

        public FocusManager getFocusManager() {
            return this.a;
        }

        public boolean isShortcutsAccessible() {
            return this.b.isShortcutsAccessible();
        }

        public void show(Desktop desktop, int n, int n2) {
            if (desktop != null) {
                Window window = (Window)this.b.getParentInstance(30);
                if (window != null) {
                    window.addPopup(this);
                    return;
                }
                desktop.addPopup(this);
            }
        }

        public void hide() {
            if (this.parent == null) {
                return;
            }
            Widget widget = this.getChild();
            while (widget != null) {
                if (widget instanceof Menu) {
                    ((Menu)widget).hidePopup();
                }
                widget = widget.next;
            }
            this.remove();
        }

        protected void onRemoved(Widget widget) {
            this.a.reset();
        }
    }
}

