/*
 * Decompiled with CFR 0.152.
 */
package com.ea.engine.ui.widget;

import com.ea.engine.ui.DataProvider;
import com.ea.engine.ui.FocusManager;
import com.ea.engine.ui.UI;
import com.ea.engine.ui.transition.Transition;
import com.ea.engine.ui.widget.Desktop;
import com.ea.engine.ui.widget.WidgetConstants;
import com.ea.util.Alignment;
import com.ea.util.BooleanUtil;
import com.ea.util.Log;
import com.ea.util.MathUtil;
import com.ea.util.structure.LinkedList;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Widget
implements WidgetConstants {
    public static final byte MARK_VISIBLE = 1;
    protected static final Alignment DEFAULT_ALIGN = Alignment.TOP_LEFT;
    public final int tag;
    public final String tagName;
    public int id = -1;
    public String name;
    public Widget parent;
    public Widget previous;
    public Widget next;
    private Widget a;
    private Widget b;
    public int x;
    public int y;
    public int width;
    public int height;
    private int c;
    private int d;
    protected boolean visible = true;
    private Hashtable e = null;
    private boolean f = true;
    protected DataProvider dataProvider = null;
    private boolean g = true;
    public Alignment align = Alignment.TOP_LEFT;
    protected boolean packed = false;
    private int h = -1;
    private boolean i = false;
    private Hashtable j;
    private Transition k;
    private boolean l;
    private boolean m;
    public boolean isGuideWidget;
    public static final String GUIDE_ACTION = "guideAction";
    public Widget guideWidget;
    protected static final byte PIXEL = 0;
    protected static final byte PERCENT = 1;
    private byte n = 1;
    private byte o = 1;
    private byte p = 0;
    private byte q = 0;
    private byte r = 0;
    private byte s = 0;
    private short t;
    private short u;
    private short v;
    private short w;

    public Widget() {
        this(0);
    }

    public Widget(int n) {
        this.tag = n;
        if (n < WidgetConstants.WIDGET_TAGS.length) {
            this.tagName = WidgetConstants.WIDGET_TAGS[n];
            return;
        }
        this.tagName = null;
    }

    public Widget(String string) {
        this.tagName = string;
        this.tag = -1;
    }

    public Widget(byte[] byArray) {
        this(Widget.createStream(byArray));
    }

    protected static ByteArrayInputStream createStream(byte[] object) {
        object = new ByteArrayInputStream((byte[])object);
        try {
            ((ByteArrayInputStream)object).close();
        }
        catch (Exception exception) {}
        return object;
    }

    public Widget(InputStream inputStream) {
        this(0);
        try {
            this.init(inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream));
            return;
        }
        catch (Exception exception) {
            Log.error("\u6784\u5efa" + this + "\u5931\u8d25", exception);
            return;
        }
    }

    public Object getAttribute(String object) {
        if (WidgetConstants.WIDGET_ATTRIBUTES[0].equals(object)) {
            return new Integer(this.id);
        }
        if (WidgetConstants.WIDGET_ATTRIBUTES[1].equals(object)) {
            return this.name;
        }
        if (WidgetConstants.WIDGET_ATTRIBUTES[9].equals(object)) {
            return this.getDataProvider();
        }
        if (WidgetConstants.WIDGET_ATTRIBUTES[10].equals(object) && (object = this.getFocusManager()) != null) {
            return ((FocusManager)object).getFocusedWidget();
        }
        return null;
    }

    public boolean setAttribute(String string, Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            this.setVisible((Boolean)object);
            return true;
        }
        return false;
    }

    public void setColor(int n) {
        this.h = n;
    }

    public Widget getParentInstance(int n) {
        if (this.tag == n) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.getParentInstance(n);
        }
        return null;
    }

    public Widget getChild() {
        return this.a;
    }

    public Widget getLastChild() {
        return this.b;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getDisplayX() {
        return (this.parent != null ? this.parent.getDisplayX() : 0) + this.x;
    }

    public int getDisplayY() {
        return (this.parent != null ? this.parent.getDisplayY() : 0) + this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Log.innerDebug("setBounds " + this + " " + n + " " + n2 + " " + n3 + " " + n4);
        if (this.g || this.x != n || this.y != n2 || this.width != n3 || this.height != n4) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.c = n3 / 2;
            this.d = n4 / 2;
            this.doLayout();
        }
    }

    public void setSize(int n, int n2) {
        if (this.width != n || this.height != n2) {
            this.width = n;
            this.height = n2;
            this.c = n / 2;
            this.d = n2 / 2;
            this.doLayout();
        }
    }

    public void setPosition(int n, int n2) {
        if (this.x != n || this.y != n2) {
            this.x = n;
            this.y = n2;
        }
    }

    public boolean isVisible() {
        if (this.visible) {
            if (this.parent != null) {
                return this.parent.isVisible();
            }
            return false;
        }
        return this.visible;
    }

    public boolean isIndividuallyVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        this.invalidate();
    }

    public void setIndividuallyVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isInWidgetTree() {
        if (this.parent != null) {
            return this.parent.isInWidgetTree();
        }
        return false;
    }

    public boolean hasBindInstruction() {
        return this.name != null && !"".equals(this.name);
    }

    private void a(boolean bl) {
        Object object;
        if (this.dataProvider != null && this.hasBindInstruction() && ((object = this.dataProvider.getValue(this.name)) != null || bl) && !this.setAttribute(WidgetConstants.WIDGET_ATTRIBUTES[1], object)) {
            Log.warn(this + " processAttributeBindInstruction " + this.name);
        }
    }

    public boolean isShortcutsAccessible() {
        if (this.parent != null) {
            return this.parent.isShortcutsAccessible();
        }
        return this.isInWidgetTree();
    }

    public void applyShortcutsAssociation(FocusManager focusManager, boolean bl) {
        if (bl || this.f) {
            if (this.hasShortcuts() && (this.getFocusManager() == focusManager || this.getFocusManager() == null)) {
                focusManager.addShortcutHandler(this);
            }
            Widget widget = this.a;
            while (widget != null) {
                widget.applyShortcutsAssociation(focusManager, bl);
                widget = widget.next;
            }
            this.f = false;
        }
    }

    public boolean isShortcutsInvalidated() {
        return this.f;
    }

    protected void invalidateShortcuts() {
        this.f = true;
        if (this.parent != null && !this.parent.f) {
            this.parent.invalidateShortcuts();
        }
    }

    public void addShortcutAction(int n, String string) {
        if (this.e == null) {
            this.e = new Hashtable(1);
        }
        this.e.put(new Integer(n), string);
        this.invalidateShortcuts();
    }

    public boolean hasShortcuts() {
        return this.e != null;
    }

    public boolean hasShortcutKeyCodes(byte by) {
        switch (by) {
            case 10: {
                return this.e != null;
            }
        }
        return false;
    }

    public boolean isShortcutKeyCodeCompatible(int n, byte by) {
        switch (by) {
            case 10: {
                return this.e.containsKey(new Integer(n));
            }
        }
        return false;
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public Desktop getDesktop() {
        if (this.parent != null) {
            return this.parent.getDesktop();
        }
        return null;
    }

    public Widget getChildWidget(int n) {
        Widget widget = this.a;
        while (widget != null) {
            if (widget.id == n) {
                return widget;
            }
            widget = widget.next;
        }
        return null;
    }

    public Widget getVisibleChildWidget() {
        Widget widget = this.a;
        while (widget != null) {
            if (widget.isIndividuallyVisible()) {
                return widget;
            }
            widget = widget.next;
        }
        return null;
    }

    public Widget getWidget(int n) {
        if (this.id != -1 && this.id == n) {
            return this;
        }
        Widget widget = this.a;
        while (widget != null) {
            Widget widget2 = widget.getWidget(n);
            if (widget2 != null) {
                return widget2;
            }
            widget = widget.next;
        }
        return null;
    }

    public Widget getWidget(String string) {
        if (this.name != null && this.name.equals(string)) {
            return this;
        }
        Widget widget = this.a;
        while (widget != null) {
            Widget widget2 = widget.getWidget(string);
            if (widget2 != null) {
                return widget2;
            }
            widget = widget.next;
        }
        return null;
    }

    public Widget getVisibleWidget(int n) {
        if (this.id != -1 && this.id == n && this.isVisible()) {
            return this;
        }
        Widget widget = this.a;
        while (widget != null) {
            Widget widget2 = widget.getWidget(n);
            if (widget2 != null) {
                return widget2;
            }
            widget = widget.next;
        }
        return null;
    }

    public Widget getWidgetAt(int n, int n2) {
        return this.getWidgetAt(n, n2, this.x, this.y, this.width, this.height);
    }

    public Widget getWidgetAt(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.visible && !this.i && n >= n3 && n2 >= n4 && n < n3 + n5 && n2 < n4 + n6) {
            Widget widget = this.a(this.a, n - this.x, n2 - this.y);
            if (widget != null) {
                return widget;
            }
            return this;
        }
        return null;
    }

    private Widget a(Widget widget, int n, int n2) {
        if (widget == null) {
            return null;
        }
        Widget widget2 = this.a(widget.next, n, n2);
        if (widget2 != null) {
            return widget2;
        }
        return widget.getWidgetAt(n, n2);
    }

    public boolean isFocusable() {
        return false;
    }

    public boolean isFocused() {
        return false;
    }

    public boolean isFocusWidgetChild() {
        if (!this.isFocused() && this.parent != null) {
            return this.parent.isFocusWidgetChild();
        }
        return this.isFocused();
    }

    public FocusManager getFocusManager() {
        if (this.parent != null) {
            return this.parent.getFocusManager();
        }
        return null;
    }

    public FocusManager getCurrentFocusManager() {
        return null;
    }

    public Widget add(Widget widget) {
        return this.add(widget, this.b, true);
    }

    public Widget add(Widget widget, Widget widget2, boolean bl) {
        if (widget2 != null && widget2.parent != this) {
            return this;
        }
        if (widget.parent != null) {
            widget.remove();
        }
        widget.parent = this;
        if (this.b == null) {
            this.b = this.a = widget;
        } else {
            if (widget2 == null) {
                widget2 = this.b;
                bl = true;
            }
            if (bl) {
                Widget widget3 = widget2.next;
                widget2.next = widget;
                widget.previous = widget2;
                widget.next = widget3;
                if (widget3 != null) {
                    widget3.previous = widget;
                } else {
                    this.b = widget;
                }
            } else {
                Widget widget4 = widget2.previous;
                widget2.previous = widget;
                widget.previous = widget4;
                widget.next = widget2;
                if (widget4 != null) {
                    widget4.next = widget;
                } else {
                    this.a = widget;
                }
            }
        }
        this.invalidate();
        this.onChildAdded(widget);
        widget.onAdded(this);
        return this;
    }

    public void bringToFront(Widget widget) {
        if (widget != null && widget.parent == this && this.a != widget) {
            this.a(widget);
            this.a.previous = widget;
            widget.next = this.a;
            this.a = widget;
            this.invalidate();
        }
    }

    public void bringToFront() {
        if (this.parent != null) {
            this.parent.bringToFront(this);
        }
    }

    public void sendToBack(Widget widget) {
        if (widget != null && widget.parent == this && this.b != widget) {
            this.a(widget);
            this.b.next = widget;
            widget.previous = this.b;
            this.b = widget;
            this.invalidate();
        }
    }

    public void sendToBack() {
        if (this.parent != null) {
            this.parent.sendToBack(this);
        }
    }

    public void bringNear(Widget widget, Widget widget2, boolean bl) {
        if (widget == null || widget2 == null || widget.parent != this || widget2.parent != this || bl && widget2.next == widget || !bl && widget2.previous == widget) {
            return;
        }
        this.a(widget);
        if (bl) {
            Widget widget3 = widget2.next;
            widget2.next = widget;
            widget.previous = widget2;
            widget.next = widget3;
            if (widget3 != null) {
                widget3.previous = widget;
            } else {
                this.b = widget;
            }
        } else {
            Widget widget4 = widget2.previous;
            widget2.previous = widget;
            widget.previous = widget4;
            widget.next = widget2;
            if (widget4 != null) {
                widget4.next = widget;
            } else {
                this.a = widget;
            }
        }
        this.invalidate();
    }

    private void a(Widget widget) {
        if (this.a == widget) {
            this.a = widget.next;
        }
        if (this.b == widget) {
            this.b = widget.previous;
        }
        if (widget.previous != null) {
            widget.previous.next = widget.next;
        }
        if (widget.next != null) {
            widget.next.previous = widget.previous;
            widget.next = null;
        }
        widget.previous = null;
    }

    public void remove() {
        if (this.parent == null) {
            return;
        }
        if (this.parent.a == this) {
            this.parent.a = this.next;
        }
        if (this.parent.b == this) {
            this.parent.b = this.previous;
        }
        if (this.previous != null) {
            this.previous.next = this.next;
        }
        if (this.next != null) {
            this.next.previous = this.previous;
            this.next = null;
        }
        this.previous = null;
        Widget widget = this.parent;
        this.parent = null;
        widget.invalidate();
        widget.onChildRemoved(this);
        this.onRemoved(widget);
        if (this.guideWidget != null) {
            this.guideWidget.remove();
            this.guideWidget = null;
        }
    }

    public void removeAll() {
        if (this.a != null) {
            Widget widget = this.a;
            Widget widget2 = null;
            while (widget != null) {
                widget2 = widget.next;
                widget.parent = null;
                widget.previous = null;
                widget.next = null;
                this.onChildRemoved(widget);
                widget.onRemoved(this);
                widget = widget2;
            }
            this.a = null;
            this.b = null;
            this.invalidate();
        }
    }

    public void cleanUp() {
        if (this.dataProvider != null) {
            this.dataProvider.unbind(this);
        }
        this.cleanUpChildren();
    }

    public void cleanUpChildren() {
        Widget widget = this.a;
        while (widget != null) {
            widget.cleanUp();
            widget = widget.next;
        }
    }

    public boolean isInvalidated() {
        return this.g;
    }

    public void invalidate() {
        this.invalidate(this);
    }

    protected void invalidate(Widget widget) {
        this.g = true;
        if (this.parent != null && !this.parent.g) {
            this.parent.invalidate(widget);
        }
    }

    protected void markAsValidate() {
        this.g = false;
    }

    public void doLayout() {
        this.markAsValidate();
        Widget widget = this.getChild();
        while (widget != null) {
            widget.measure();
            widget = widget.next;
        }
    }

    public void measure() {
        if (!this.packed) {
            this.measure(this.parent);
        }
    }

    public boolean isPacked() {
        return this.packed;
    }

    public void invalidateAppearance() {
        this.invalidateAppearanceRegion(0, 0, this.width, this.height);
    }

    protected void invalidateAppearanceRegion(int n, int n2, int n3, int n4) {
        if (this.parent != null) {
            this.parent.invalidateAppearanceRegion(n + this.x, n2 + this.y, n3, n4);
        }
    }

    public void paint(Graphics graphics) {
        int n = graphics.getClipWidth();
        int n2 = graphics.getClipHeight();
        int n3 = graphics.getClipX();
        int n4 = graphics.getClipY();
        if (this.width > 0 && this.height > 0 && (n3 + n <= this.x || n3 >= this.x + this.width || n4 + n2 <= this.y || n4 >= this.y + this.height)) {
            return;
        }
        graphics.translate(this.x, this.y);
        if (this.h != -1) {
            graphics.setColor(this.h);
            graphics.fillRect(0, 0, this.width, this.height);
        }
        graphics.clipRect(0, 0, this.width, this.height);
        this.paintChildrenImpl(graphics);
        graphics.translate(-this.x, -this.y);
        graphics.setClip(n3, n4, n, n2);
    }

    public void paintImpl(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (!this.m && !this.l) {
            this.paint(graphics);
        }
    }

    public boolean paintTransition(Graphics graphics) {
        if (!this.g && this.m && this.k != null) {
            if (!this.l) {
                this.l = true;
                this.k.init(this);
            }
            if (this.k.process(graphics)) {
                this.m = false;
                this.l = false;
                this.k = null;
                return true;
            }
        }
        return false;
    }

    protected void paintChildrenImpl(Graphics graphics) {
        Widget widget = this.a;
        while (widget != null) {
            widget.paintImpl(graphics);
            widget = widget.next;
        }
    }

    public void requestFocus() {
    }

    public void requestBackwardFocus() {
        FocusManager focusManager = this.getFocusManager();
        if (focusManager != null) {
            focusManager.requestOtherFocus(this, false, null);
        }
    }

    public void requestForwardFocus() {
        FocusManager focusManager = this.getFocusManager();
        if (focusManager != null) {
            focusManager.requestOtherFocus(this, true, null);
        }
    }

    public Widget getOtherFocus(Widget widget, Widget widget2, Widget widget3, boolean bl, Alignment alignment, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5;
        block13: {
            Widget widget4;
            block8: {
                boolean bl6;
                block12: {
                    block9: {
                        int n;
                        int n2;
                        Alignment alignment2;
                        block10: {
                            int n3;
                            int n4;
                            block11: {
                                bl5 = this.isVisible();
                                if (!bl2 || widget == this || this.isFocused() || !this.isFocusable() || !bl5) break block8;
                                if (widget2 == null || alignment == null) {
                                    return this;
                                }
                                alignment2 = alignment;
                                Widget widget5 = widget3;
                                Widget widget6 = widget2;
                                Widget widget7 = this;
                                if (widget6 == null || alignment2 == null) break block9;
                                n4 = widget6.getDisplayX() + widget6.c;
                                n3 = widget6.getDisplayY() + widget6.d;
                                n2 = widget7.getDisplayX() + widget7.c - n4;
                                n = widget7.getDisplayY() + widget7.d - n3;
                                if (widget5 == null) break block10;
                                n4 = widget5.getDisplayX() + widget5.c - n4;
                                n3 = widget5.getDisplayY() + widget5.d - n3;
                                if (!alignment2.isTop() && !alignment2.isBottom()) break block11;
                                if (Math.abs(n) > Math.abs(n3) || n == 0 || (!alignment2.isBottom() || n <= 0) && (!alignment2.isTop() || n >= 0) || Math.abs(n2) > Math.abs(n4)) break block9;
                                bl6 = Math.abs(n2) + Math.abs(n) < Math.abs(n4) + Math.abs(n3);
                                break block12;
                            }
                            if (Math.abs(n2) > Math.abs(n4) || n2 == 0 || (!alignment2.isRight() || n2 <= 0) && (!alignment2.isLeft() || n2 >= 0) || Math.abs(n) > Math.abs(n3)) break block9;
                            bl6 = Math.abs(n2) + Math.abs(n) < Math.abs(n4) + Math.abs(n3);
                            break block12;
                        }
                        bl6 = alignment2.isTop() || alignment2.isBottom() ? n != 0 && (alignment2.isBottom() && n > 0 || alignment2.isTop() && n < 0) : n2 != 0 && (alignment2.isRight() && n2 > 0 || alignment2.isLeft() && n2 < 0);
                        break block12;
                    }
                    bl6 = false;
                }
                if (bl6) {
                    widget3 = this;
                }
                break block13;
            }
            if (bl3 && bl5 && (widget4 = bl ? this.a : this.b) != null) {
                widget3 = widget4.getOtherFocus(widget, widget2, widget3, bl, alignment, true, true, false);
                if ((widget2 == null || alignment == null) && widget3 != null) {
                    return widget3;
                }
            }
        }
        if (widget != this) {
            Widget widget8 = bl ? this.next : this.previous;
            if (widget8 != null && (widget3 = widget8.getOtherFocus(widget, widget2, widget3, bl, alignment, true, true, false)) != null) {
                return widget3;
            }
            if (bl4 && this.parent != null && bl5) {
                widget3 = this.parent.getOtherFocus(widget, widget2, widget3, bl, alignment, true, false, true);
                if ((widget2 == null || alignment == null) && widget3 != null) {
                    return widget3;
                }
            }
        }
        return widget3;
    }

    public boolean processKeyEvent(byte by, int n) {
        return false;
    }

    public boolean processShortcutKeyEvent(int n) {
        String string;
        if (this.e != null && (string = (String)this.e.get(new Integer(n))) != null) {
            UI.callActionMethod(UI.parseMethod(string, this));
        }
        return false;
    }

    public boolean processPointerEvent(byte by, int n, int n2) {
        if (this.parent != null) {
            return this.parent.processPointerEvent(by, n, n2);
        }
        return false;
    }

    public boolean processFocusEvent(byte by) {
        return false;
    }

    public boolean processActionEvent() {
        return false;
    }

    public boolean processDataBindEvent() {
        if (this.dataProvider != null && this.hasBindInstruction()) {
            this.a(false);
            this.invalidate();
            return true;
        }
        return false;
    }

    public boolean processModelUpdateEvent(String string) {
        if (this.dataProvider != null && this.hasBindInstruction() && (string == null || string.equals(this.name))) {
            this.a(true);
            this.invalidate();
            return true;
        }
        return false;
    }

    public boolean processItemsModelUpdateEvent(byte by, String string, DataProvider dataProvider, LinkedList.LinkedListEnumeration linkedListEnumeration) {
        return false;
    }

    protected void propagateFocusEvent(Widget widget, boolean bl) {
        if (bl) {
            this.onLostFocus(widget);
        } else {
            this.onFocus(widget);
        }
        Widget widget2 = this.a;
        while (widget2 != null) {
            widget2.propagateFocusEvent(widget, bl);
            widget2 = widget2.next;
        }
    }

    public boolean inParent(Widget widget) {
        if (this.parent != null) {
            if (this.parent == widget) {
                return true;
            }
            return this.parent.inParent(widget);
        }
        return false;
    }

    protected void onAdded(Widget widget) {
    }

    protected void onRemoved(Widget widget) {
    }

    protected void onChildAdded(Widget widget) {
    }

    protected void onChildRemoved(Widget widget) {
    }

    protected void onFocus(Widget widget) {
    }

    protected void onLostFocus(Widget widget) {
    }

    public Vector getRawData(Vector vector) {
        if (vector == null) {
            vector = new Vector<Boolean>();
        }
        vector.addElement(BooleanUtil.toBoolean(this.visible));
        return vector;
    }

    public void setRawData(Vector vector) {
        Boolean bl = (Boolean)vector.elementAt(0);
        vector.removeElementAt(0);
        this.setVisible(bl);
    }

    public void markAsPack() {
        this.packed = true;
    }

    public int[] pack() {
        this.markAsPack();
        int[] nArray = new int[]{0, 0, 0, 0};
        Widget widget = this.a;
        while (widget != null) {
            MathUtil.minRectAdded(nArray, widget.pack());
            widget = widget.next;
        }
        nArray[0] = this.x;
        nArray[1] = this.y;
        this.setSize(nArray[2], nArray[3]);
        return nArray;
    }

    public void onChildPacked(Widget widget) {
        if (this.parent != null) {
            this.parent.onChildPacked(this);
        }
    }

    public void setTransparence(int n) {
        Widget widget = this.a;
        while (widget != null) {
            widget.setTransparence(n);
            widget = widget.next;
        }
    }

    public void recover() {
        Widget widget = this.a;
        while (widget != null) {
            widget.recover();
            widget = widget.next;
        }
    }

    public boolean isItem() {
        return false;
    }

    public void setPenetrable(boolean bl) {
        this.i = bl;
    }

    public void addTransition(Transition transition) {
        if (this.j == null) {
            this.j = new Hashtable();
        }
        this.j.put(transition.getName(), transition);
    }

    public Transition getTransition(String string) {
        if (this.j != null) {
            return (Transition)this.j.get(string);
        }
        return null;
    }

    public Transition startTransition(String string) {
        if (this.j != null) {
            this.k = (Transition)this.j.get(string);
            if (this.k == null) {
                return null;
            }
            if (string.indexOf("exit") != -1) {
                this.markAsValidate();
            }
            UI.getCanvas().addTransitionWidget(this);
            this.l = false;
            this.m = true;
            return this.k;
        }
        return null;
    }

    public boolean isTransitionRunning() {
        if (!this.l) {
            if (this.parent != null) {
                return this.parent.isTransitionRunning();
            }
            return false;
        }
        return this.l;
    }

    public void init(DataInputStream dataInputStream) throws Exception {
        this.id = dataInputStream.readShort();
        boolean bl = dataInputStream.readBoolean();
        this.name = bl ? dataInputStream.readUTF() : null;
        byte[] byArray = new byte[dataInputStream.readUnsignedByte()];
        dataInputStream.read(byArray);
        int n = dataInputStream.readUnsignedByte();
        for (int k = 0; k < n; ++k) {
            int n2 = dataInputStream.readUnsignedByte();
            Widget widget = UI.convertWidgetTag(n2);
            widget.initializeControl(dataInputStream);
            this.add(widget);
        }
    }

    public void initialize(DataInputStream dataInputStream) throws Exception {
        int n;
        this.id = dataInputStream.readUnsignedByte();
        boolean bl = dataInputStream.readBoolean();
        this.name = bl ? dataInputStream.readUTF() : null;
        byte[] byArray = new byte[dataInputStream.readUnsignedByte()];
        dataInputStream.read(byArray);
        this.align = Alignment.convertAlignment(dataInputStream.readByte());
        this.n = dataInputStream.readByte();
        this.p = dataInputStream.readByte();
        this.t = dataInputStream.readShort();
        this.q = dataInputStream.readByte();
        this.u = dataInputStream.readShort();
        this.o = dataInputStream.readByte();
        this.r = dataInputStream.readByte();
        this.v = dataInputStream.readShort();
        this.s = dataInputStream.readByte();
        this.w = dataInputStream.readShort();
        int n2 = dataInputStream.readByte();
        for (n = 0; n < n2; ++n) {
            this.addShortcutAction(dataInputStream.readInt(), dataInputStream.readUTF());
        }
        n = dataInputStream.readByte();
        this.visible = (n & 1) == 1;
    }

    public void initializeControl(DataInputStream dataInputStream) throws Exception {
        boolean bl = dataInputStream.readBoolean();
        this.name = bl ? dataInputStream.readUTF() : null;
        byte[] byArray = new byte[dataInputStream.readUnsignedByte()];
        dataInputStream.read(byArray);
        this.align = Alignment.convertAlignment(dataInputStream.readByte());
        this.n = dataInputStream.readByte();
        this.p = dataInputStream.readByte();
        this.t = dataInputStream.readShort();
        this.q = dataInputStream.readByte();
        this.u = dataInputStream.readShort();
        this.o = dataInputStream.readByte();
        this.r = dataInputStream.readByte();
        this.v = dataInputStream.readShort();
        this.s = dataInputStream.readByte();
        this.w = dataInputStream.readShort();
    }

    public void measure(Widget object) {
        int[] nArray = this.measureSize((Widget)object);
        object = this.measurePosition((Widget)object, nArray[0], nArray[1]);
        this.setBounds((int)object[0], (int)object[1], nArray[0], nArray[1]);
    }

    public int[] measureSize(Widget widget) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = widget.getWidth();
        if (this.n == 1) {
            n2 = 0;
            n = 0;
            switch (this.p) {
                case 0: {
                    n2 = this.t;
                    break;
                }
                case 1: {
                    n2 = this.t * n5 >> 10;
                }
            }
            switch (this.q) {
                case 0: {
                    n = n5 - this.u;
                    break;
                }
                case 1: {
                    n = n5 - (this.u * n5 >> 10);
                }
            }
            n3 = n - n2;
        } else if (this.n == 0) {
            switch (this.q) {
                case 0: {
                    n3 = this.u;
                    break;
                }
                case 1: {
                    n3 = this.u * n5 >> 10;
                }
            }
        }
        if (this.o == 1) {
            n2 = 0;
            n = 0;
            switch (this.r) {
                case 0: {
                    n2 = this.v;
                    break;
                }
                case 1: {
                    n2 = this.v * widget.getHeight() >> 10;
                }
            }
            switch (this.s) {
                case 0: {
                    n = widget.getHeight() - this.w;
                    break;
                }
                case 1: {
                    n = widget.getHeight() - (this.w * widget.getHeight() >> 10);
                }
            }
            n4 = n - n2;
        } else if (this.o == 0) {
            switch (this.s) {
                case 0: {
                    n4 = this.w;
                    break;
                }
                case 1: {
                    n4 = this.w * widget.getHeight() >> 10;
                }
            }
        }
        return new int[]{n3, n4};
    }

    public int[] measurePosition(Widget widget, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = widget.getWidth();
        if (this.n == 1) {
            switch (this.p) {
                case 0: {
                    n4 = this.t;
                    break;
                }
                case 1: {
                    n4 = this.t * n6 >> 10;
                }
            }
        } else if (this.n == 0) {
            n3 = 0;
            n4 = this.align.alignX(n6, n);
            switch (this.p) {
                case 0: {
                    n3 = this.t;
                    break;
                }
                case 1: {
                    n3 = this.t * n6 >> 10;
                }
            }
            if (this.align.isLeft() || this.align.isHorizontalCenter()) {
                n4 += n3;
            } else if (this.align.isRight()) {
                n4 -= n3;
            }
        }
        if (this.o == 1) {
            switch (this.r) {
                case 0: {
                    n5 = this.v;
                    break;
                }
                case 1: {
                    n5 = this.v * widget.getHeight() >> 10;
                }
            }
        } else if (this.o == 0) {
            n3 = 0;
            n5 = this.align.alignY(widget.getHeight(), n2);
            switch (this.r) {
                case 0: {
                    n3 = this.v;
                    break;
                }
                case 1: {
                    n3 = this.v * widget.getHeight() >> 10;
                }
            }
            if (this.align.isTop() || this.align.isVerticalCenter()) {
                n5 += n3;
            } else if (this.align.isBottom()) {
                n5 -= n3;
            }
        }
        return new int[]{n4, n5};
    }

    public void measureCorrection(Widget widget, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (this.n == 1) {
            switch (this.p) {
                case 0: {
                    n5 = this.t;
                    break;
                }
                case 1: {
                    n5 = this.t * widget.getWidth() >> 10;
                }
            }
            switch (this.q) {
                case 0: {
                    n6 = this.u;
                    break;
                }
                case 1: {
                    n6 = this.u * widget.getWidth() >> 10;
                }
            }
            n3 = n5;
            n6 = n5 + n6;
            if (n6 != 0 && (n3 += n5 * (widget.getWidth() - n - n6) / n6) < 0) {
                n3 = 0;
            }
        } else if (this.n == 0) {
            n6 = 0;
            n3 = this.align.alignX(widget.getWidth(), n);
            switch (this.p) {
                case 0: {
                    n6 = this.t;
                    break;
                }
                case 1: {
                    n6 = this.t * widget.getWidth() >> 10;
                }
            }
            if (this.align.isLeft() || this.align.isHorizontalCenter()) {
                n3 += n6;
            } else if (this.align.isRight()) {
                n3 -= n6;
            }
        }
        if (this.o == 1) {
            switch (this.r) {
                case 0: {
                    n7 = this.v;
                    break;
                }
                case 1: {
                    n7 = this.v * widget.getHeight() >> 10;
                }
            }
            switch (this.s) {
                case 0: {
                    n8 = this.w;
                    break;
                }
                case 1: {
                    n8 = this.w * widget.getHeight() >> 10;
                }
            }
            n4 = n7;
            n6 = n7 + n8;
            if (n6 != 0 && (n4 += n7 * (widget.height - n2 - n6) / n6) < 0) {
                n4 = 0;
            }
        } else if (this.o == 0) {
            n6 = 0;
            n4 = this.align.alignY(widget.getHeight(), n2);
            switch (this.r) {
                case 0: {
                    n6 = this.v;
                    break;
                }
                case 1: {
                    n6 = this.v * widget.getHeight() >> 10;
                }
            }
            if (this.align.isTop() || this.align.isVerticalCenter()) {
                n4 += n6;
            } else if (this.align.isBottom()) {
                n4 -= n6;
            }
        }
        this.setBounds(n3, n4, n, n2);
    }

    public void measureInflate(Widget widget) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (widget.n == 1) {
            n = widget.getWidth();
            switch (widget.p) {
                case 0: {
                    n3 = widget.t;
                    break;
                }
                case 1: {
                    n3 = widget.t * this.getWidth() >> 10;
                }
            }
            switch (widget.q) {
                case 0: {
                    n4 = widget.u;
                    break;
                }
                case 1: {
                    n4 = widget.u * this.getWidth() >> 10;
                }
            }
        } else if (widget.n == 0 && widget.q == 1) {
            n = (n << 10) / widget.u;
        }
        if (widget.o == 1) {
            n2 = widget.getHeight();
            switch (widget.r) {
                case 0: {
                    n5 = widget.v;
                    break;
                }
                case 1: {
                    n5 = widget.v * this.getHeight() >> 10;
                }
            }
            switch (this.s) {
                case 0: {
                    n6 = widget.w;
                    break;
                }
                case 1: {
                    n6 = widget.w * this.getHeight() >> 10;
                }
            }
        } else if (widget.o == 0 && widget.s == 1) {
            n2 = (n2 << 10) / widget.w;
        }
        this.setSize(n + n3 + n4, n2 + n5 + n6);
    }

    public Widget clone(Widget widget) {
        if (widget == null) {
            widget = this.tag == -1 ? new Widget(this.tagName) : new Widget(this.tag);
        }
        widget.name = this.name;
        widget.visible = this.visible;
        widget.align = this.align;
        widget.n = this.n;
        widget.o = this.o;
        widget.p = this.p;
        widget.t = this.t;
        widget.r = this.r;
        widget.v = this.v;
        widget.q = this.q;
        widget.u = this.u;
        widget.s = this.s;
        widget.w = this.w;
        widget.j = this.j;
        widget.e = this.e;
        Widget widget2 = this.getChild();
        while (widget2 != null) {
            widget.add(widget2.clone(null));
            widget2 = widget2.next;
        }
        return widget;
    }

    public String toString() {
        return super.toString() + "^tag=" + this.tagName + "^id=" + this.id + "^name=" + this.name;
    }
}

