/*
 * Decompiled with CFR 0.152.
 */
package com.ea.product.module;

import com.ea.engine.model.CuteXmlModel;
import com.ea.product.module.Module;
import com.ea.util.Log;
import com.ea.util.structure.Attribute;
import com.ea.util.structure.LinkedList;
import com.ea.util.text.StringUtil;
import java.io.DataInputStream;
import java.io.InputStream;

public class Group
extends Module {
    public String moduleName;
    public String[] moduleParmType;
    private LinkedList modules;

    public void init(InputStream stream, CuteXmlModel cuteXml, String parm) {
        try {
            if (parm != null) {
                if (parm.indexOf(44) == -1) {
                    this.moduleName = parm;
                } else {
                    this.moduleParmType = StringUtil.split(parm, ',');
                }
            }
            this.xmlId = cuteXml.id.substring(0, cuteXml.id.indexOf("."));
            this.cuteXml = cuteXml;
            DataInputStream dis = stream instanceof DataInputStream ? (DataInputStream)stream : new DataInputStream(stream);
            this.inflate(dis);
        }
        catch (Exception e2) {
            Log.error("Group.init " + this.xmlId, e2);
        }
    }

    protected void inflate(DataInputStream dis) throws Exception {
        this.attribute = new Attribute(this.cuteXml.getTags());
        int count = dis.readShort();
        this.modules = new LinkedList();
        for (int i2 = 0; i2 < count; ++i2) {
            Module module;
            if (this.moduleParmType != null) {
                module = new Module();
                for (int j2 = 0; j2 < this.moduleParmType.length; ++j2) {
                    if ("byte".equals(this.moduleParmType[j2])) {
                        module.set("byte" + j2, dis.readByte());
                        continue;
                    }
                    if ("short".equals(this.moduleParmType[j2])) {
                        module.set("short" + j2, dis.readShort());
                        continue;
                    }
                    if ("int".equals(this.moduleParmType[j2])) {
                        module.set("int" + j2, dis.readInt());
                        continue;
                    }
                    if ("long".equals(this.moduleParmType[j2])) {
                        module.set("long" + j2, dis.readLong());
                        continue;
                    }
                    if (!"string".equals(this.moduleParmType[j2])) continue;
                    module.set("string" + j2, dis.readUTF());
                }
                this.modules.add(module);
                continue;
            }
            if (this.moduleName == null) continue;
            module = Module.createModule(dis, this.moduleName, null);
            module.set("gid", i2);
            this.modules.add(module);
        }
    }

    public LinkedList getModules() {
        return this.modules;
    }

    public Module getModuleByIdx(int idx) {
        return (Module)this.modules.getItem(idx);
    }

    public void addModule(Module module) {
        this.modules.add(module);
    }

    public int getModuleCount() {
        return this.modules.getLength();
    }
}

