/*
 * Decompiled with CFR 0.152.
 */
package com.ea.product.module;

import com.ea.engine.model.AModel;
import com.ea.engine.model.CuteXmlModel;
import com.ea.engine.model.M;
import com.ea.engine.model.PackageModel;
import com.ea.engine.ui.DataProvider;
import com.ea.product.Constants;
import com.ea.product.module.Config;
import com.ea.product.module.Creature;
import com.ea.product.module.Effect;
import com.ea.product.module.Group;
import com.ea.product.module.Item;
import com.ea.product.module.Itemz;
import com.ea.product.module.Mail;
import com.ea.product.module.Package;
import com.ea.product.module.Task;
import com.ea.util.Log;
import com.ea.util.structure.Attribute;
import java.io.DataInputStream;
import java.io.InputStream;

public class Module
extends DataProvider
implements Constants {
    private static PackageModel modelPackage;
    protected CuteXmlModel cuteXml;
    protected String xmlId;
    protected boolean isNull = true;
    protected Attribute attribute = new Attribute();

    public void init(InputStream stream, String tag) {
        int length = -2;
        try {
            length = stream.available();
            CuteXmlModel cuteXml = Module.getCuteXmlModel(tag);
            this.xmlId = cuteXml.id.substring(0, cuteXml.id.indexOf("."));
            this.cuteXml = cuteXml;
            DataInputStream dis = stream instanceof DataInputStream ? (DataInputStream)stream : new DataInputStream(stream);
            this.inflate(dis);
            this.isNull = false;
        }
        catch (Exception e2) {
            Log.error(this.xmlId + " Module.init " + length, e2);
        }
    }

    protected void inflate(DataInputStream dis) throws Exception {
        this.attribute = new Attribute(this.cuteXml.getTags());
        for (int i2 = 0; i2 < this.cuteXml.getTagnum(); ++i2) {
            String tagName = this.cuteXml.getTag(i2);
            String type = this.cuteXml.getAtt(i2, "type");
            if ("byte".equals(type)) {
                byte value = dis.readByte();
                this.debugModuleData(tagName, "" + value);
                this.attribute.setIntValue(tagName, value);
                continue;
            }
            if ("ubyte".equals(type)) {
                int value = dis.readUnsignedByte();
                this.debugModuleData(tagName, "" + value);
                this.attribute.setIntValue(tagName, value);
                continue;
            }
            if ("short".equals(type)) {
                short value = dis.readShort();
                this.debugModuleData(tagName, "" + value);
                this.attribute.setIntValue(tagName, value);
                continue;
            }
            if ("int".equals(type)) {
                int value = dis.readInt();
                this.debugModuleData(tagName, "" + value);
                this.attribute.setIntValue(tagName, value);
                continue;
            }
            if ("long".equals(type)) {
                long value = dis.readLong();
                this.debugModuleData(tagName, "" + value);
                this.attribute.setLongValue(tagName, value);
                continue;
            }
            if ("string".equals(type)) {
                String value = dis.readUTF();
                this.debugModuleData(tagName, value);
                this.attribute.setStringValue(tagName, value);
                continue;
            }
            if (type.startsWith(".")) {
                AModel resource = M.instance.getResource(dis);
                this.debugModuleData(tagName, resource.toString());
                if (resource == null) continue;
                this.attribute.setObjectValue(tagName, resource);
                continue;
            }
            String statetag = this.cuteXml.getAtt(i2, "state");
            int state = -1;
            if (statetag == null || (state = this.getInt(statetag)) == 1) {
                Module module;
                String parm = this.cuteXml.getAtt(i2, "parm");
                if (parm == null) {
                    type = this.getString(type);
                    module = Module.createModule(dis, type, parm);
                } else {
                    module = Module.createModule(dis, type, parm);
                    this.debugModuleData(tagName, " " + module);
                }
                if (module == null) continue;
                this.attribute.setObjectValue(tagName, module);
                continue;
            }
            if (state != -1) continue;
        }
    }

    public void debugModuleData(String tagName, String value) {
        Log.debug(this.xmlId + "." + tagName + "=" + value);
    }

    public boolean isModule(String xmlId) {
        if (this.xmlId == null) {
            return false;
        }
        return this.xmlId.equals(xmlId);
    }

    public boolean isNull() {
        return this.isNull;
    }

    public void setNull() {
        this.setNull(true);
    }

    public void setNull(boolean isNull) {
        this.isNull = isNull;
        if (isNull) {
            this.attribute.clean();
            this.dispatchUpdateEvent(null);
        }
    }

    public Module clone(Module target) {
        Module module = target;
        if (module == null) {
            module = new Module();
        }
        module.xmlId = this.xmlId;
        module.cuteXml = this.cuteXml;
        module.attribute = this.attribute.clone(null);
        module.isNull = this.isNull;
        return module;
    }

    public int getId() {
        return this.attribute.getIntValue("id");
    }

    public String getName() {
        return this.attribute.getStringValue("name");
    }

    public String getGrade() {
        return this.attribute.getStringValue("grade");
    }

    public String getType() {
        return this.attribute.getStringValue("type");
    }

    public int getGid() {
        return this.attribute.getIntValue("gid");
    }

    public AModel getIcon() {
        String icon = this.getString("icon");
        if (icon == null || "".equals(icon)) {
            return null;
        }
        return M.instance.getResourceBackground(this.getString("icon") + ".cpng");
    }

    public int getInt(String tagName) {
        return this.attribute.getIntValue(tagName);
    }

    public long getLong(String tagName) {
        return this.attribute.getLongValue(tagName);
    }

    public short getShort(String tagName) {
        return (short)this.attribute.getIntValue(tagName);
    }

    public byte getByte(String tagName) {
        return (byte)this.attribute.getIntValue(tagName);
    }

    public void set(String tagName, int value) {
        this.attribute.setIntValue(tagName, value);
        this.dispatchUpdateEvent(tagName);
    }

    public void set(String tagName, long value) {
        this.attribute.setLongValue(tagName, value);
        this.dispatchUpdateEvent(tagName);
    }

    public String getString(String tagName) {
        return this.attribute.getStringValue(tagName);
    }

    public void set(String tagName, String value) {
        this.attribute.setStringValue(tagName, value);
        this.dispatchUpdateEvent(tagName);
    }

    public Module getModule(String tagName) {
        System.out.println("tagName======" + tagName);
        return (Module)this.attribute.getObjectValue(tagName);
    }

    public void set(String tagName, Module value) {
        this.attribute.setObjectValue(tagName, value);
        this.dispatchUpdateEvent(tagName);
    }

    public void set(String tagName, DataInputStream dis) {
        String tagtype = this.getTagStyle(tagName, "type");
        if (tagtype == null) {
            return;
        }
        try {
            if ("byte".equals(tagtype)) {
                this.set(tagName, dis.readByte());
            } else if ("short".equals(tagtype)) {
                this.set(tagName, dis.readShort());
            } else if ("int".equals(tagtype)) {
                this.set(tagName, dis.readInt());
            } else if ("long".equals(tagtype)) {
                this.set(tagName, dis.readLong());
            } else if ("string".equals(tagtype)) {
                this.set(tagName, dis.readUTF());
            } else if ("grup".equals(tagtype)) {
                String parm = this.getTagStyle(tagName, "parm");
                Group group = new Group();
                group.init(dis, Module.getCuteXmlModel("grup"), parm);
                this.set(tagName, group);
            }
        }
        catch (Exception e2) {
            Log.error("Module.setLoading ph\u00e1t sinh b\u1ea5t th\u01b0\u1eddng " + tagName + "," + tagtype, e2);
        }
    }

    public Object getObject(String tagName) {
        return this.attribute.getObjectValue(tagName);
    }

    public void remove(String tagName) {
        this.attribute.removeValue(tagName);
    }

    public String name(String tagName) {
        return this.getString(tagName, "name");
    }

    public String getString(String tagName, String atttibuteName) {
        Object object = this.cuteXml.getAtt(tagName, atttibuteName);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public int getInt(String tagName, String atttibuteName) {
        return Integer.parseInt(this.getString(tagName, atttibuteName));
    }

    public Object getUserDefinedValue(String property) {
        if ("icon".equals(property)) {
            return this.getIcon();
        }
        if ("post".equals(property) || "pash".equals(property)) {
            return Config.gangConfig(this.getString(property));
        }
        Object object = this.getObject(property);
        if (object != null && object instanceof String && "".equals(object) && !"name".equals(property)) {
            return "Kh\u00f4ng";
        }
        return object;
    }

    public String getTagStyle(String tag, String xmlatt) {
        return this.cuteXml.getAtt(tag, xmlatt).toString();
    }

    public void update() {
        this.dispatchUpdateEvent(null);
    }

    public void update(String tag) {
        this.dispatchUpdateEvent(tag);
    }

    public static final Module createModule(InputStream stream, String tag, String parm) {
        Module module = null;
        if ("grup".equals(tag)) {
            module = new Group();
            ((Group)module).init(stream, Module.getCuteXmlModel(tag), parm);
            return module;
        }
        module = "role".equals(tag) || "srle".equals(tag) || "spet".equals(tag) || "pet".equals(tag) || "npc".equals(tag) || "lkrl".equals(tag) || "mmnt".equals(tag) || "mnst".equals(tag) || "bpet".equals(tag) || "brle".equals(tag) ? new Creature() : ("spck".equals(tag) ? new Package() : ("equp".equals(tag) || "pequp".equals(tag) || "prop".equals(tag) || "skil".equals(tag) || "sequ".equals(tag) || "fmla".equals(tag) || "fb".equals(tag) || "bfb".equals(tag) ? new Item() : ("itmz".equals(tag) ? new Itemz() : ("efct".equals(tag) ? new Effect() : ("task".equals(tag) ? new Task() : ("mail".equals(tag) ? new Mail() : new Module()))))));
        if ("pequp".equals(tag)) {
            module.init(stream, "equp");
            module.xmlId = "pequp";
        } else if ("bfb".equals(tag)) {
            module.init(stream, "fb");
            module.xmlId = "fb";
        } else {
            module.init(stream, tag);
        }
        return module;
    }

    public static final Module createModule(InputStream stream, String tag) {
        return Module.createModule(stream, tag, null);
    }

    public static void setPackageModel(PackageModel model) {
        modelPackage = model;
    }

    public static CuteXmlModel getCuteXmlModel(String id) {
        return (CuteXmlModel)modelPackage.getModelByName(id + ".cxml");
    }
}

