/*
 * Decompiled with CFR 0.152.
 */
package com.ea.product.module;

import com.ea.engine.script.Script;
import com.ea.io.net.Protocol;
import com.ea.io.net.ProtocolHandle;
import com.ea.io.net.ProtocolListener;
import com.ea.product.Constants;
import com.ea.product.MainMIDlet;
import com.ea.product.frame.FrameConstants;
import com.ea.product.frame.ProtocolConstants;
import com.ea.product.frame.RiskFrame;
import com.ea.product.module.Config;
import com.ea.product.module.Group;
import com.ea.product.module.Module;
import com.ea.util.structure.LinkedList;
import com.ea.util.structure.LinkedListItem;
import com.ea.util.text.StringUtil;

public class Task
extends Module
implements ProtocolConstants,
FrameConstants,
Constants,
ProtocolListener {
    public static ProtocolHandle logicHandle = MainMIDlet.logicHandle;
    public Script script;

    public String getState() {
        return this.getString("state");
    }

    public Script getScript() {
        if (this.script == null) {
            logicHandle.createProtocol((byte)8, (byte)8).writeInt(this.getId()).writeUTF(this.getState()).setListener(this).send();
        }
        return this.script;
    }

    public void setScript(String scriptContent) {
        if (this.script != null && scriptContent == null) {
            this.script.setActionHandler(null);
            this.script = null;
        } else {
            this.script = new Script(this.getName(), scriptContent, this);
            this.script.setActionHandler(RiskFrame.currentEntity);
        }
    }

    public void executeScript() {
        Script script = this.getScript();
        if (script != null) {
            script.execute(false);
        }
    }

    public LinkedList getTaskJieTaskLuj() {
        return ((Group)this.getModule("jpos")).getModules();
    }

    public LinkedList getTaskFinTaskLuj() {
        return ((Group)this.getModule("fpos")).getModules();
    }

    public LinkedList getTaskLuj() {
        return ((Group)this.getModule("tkpt")).getModules();
    }

    public LinkedList getTaskTarget() {
        return ((Group)this.getModule("dsts")).getModules();
    }

    public LinkedList getTaskFixedReward() {
        return ((Group)this.getModule("awds")).getModules();
    }

    public LinkedList getTaskOptionalReward() {
        return ((Group)this.getModule("awdc")).getModules();
    }

    public String getTaskKeJieInfo() {
        StringBuffer msgBuf = new StringBuffer();
        msgBuf.append(this.getName()).append("<br/>");
        boolean flag = false;
        LinkedList listTemp = this.getTaskJieTaskLuj();
        for (LinkedListItem currentItem = listTemp.getFirst(); currentItem != null; currentItem = currentItem.getNext()) {
            Module module = (Module)currentItem;
            int mapid = module.getInt("mapid");
            String mapName = module.getString("mname");
            int npcid = module.getInt("npcid");
            String npcName = module.getString("nname");
            int x = module.getInt("npcx");
            int y = module.getInt("npcy");
            String action = "findw(" + mapid + "," + x + "," + y;
            String mapN = StringUtil.combineXml(mapName, "a", new String[]{"href", action, "ct", "cblue"});
            String npcP = StringUtil.combineXml(npcName, "a", new String[]{"href", action, "ct", "cgreen"});
            msgBuf.append(mapN).append("c\u1ee7a").append(npcP).append("\u0111ang \u0111\u1ee3i ng\u01b0\u01a1i, mau l\u00ean.").append("<br/>");
            flag = true;
        }
        if (!flag) {
            msgBuf.append("[Mi\u00eau t\u1ea3]:").append(this.getString("desc")).append("<br/>");
        }
        return msgBuf.toString();
    }

    public String getTaskDetailedInfo() {
        StringBuffer msgBuf = new StringBuffer();
        msgBuf.append(this.getName()).append("<br/>");
        msgBuf.append("[M\u1ee5c ti\u00eau nhi\u1ec7m v\u1ee5]:");
        LinkedList targetList = this.getTaskTarget();
        LinkedList targetLujList = this.getTaskLuj();
        for (LinkedListItem currentItem = targetList.getFirst(); currentItem != null; currentItem = currentItem.getNext()) {
            LinkedListItem ljitem;
            Module module = (Module)currentItem;
            for (ljitem = targetLujList.getFirst(); ljitem != null; ljitem = ljitem.getNext()) {
                Module moduleTemp = (Module)ljitem;
                if (module.getName().equals(moduleTemp.getName())) break;
            }
            String titleStr = module.getName() + module.getString("fnum") + "/" + module.getString("num");
            if (ljitem != null) {
                Module ljItemTemp = (Module)ljitem;
                String action = "findw(" + ljItemTemp.getInt("cmpid") + "," + ljItemTemp.getInt("cmpx") + "," + ljItemTemp.getInt("cmpy");
                String ljObj = StringUtil.combineXml(titleStr, "a", new String[]{"href", action, "ct", "cgreen"});
                msgBuf.append(ljObj);
            } else {
                msgBuf.append(module.getName() + module.getString("fnum") + "/" + module.getString("num"));
            }
            msgBuf.append("  ");
        }
        msgBuf.append("<br/>");
        msgBuf.append("[Mi\u00eau t\u1ea3]:").append(this.getString("desc")).append("<br/>");
        msgBuf.append("<br/>");
        msgBuf.append("[Tr\u1ea3 nhi\u1ec7m v\u1ee5]:");
        LinkedList listTemp = this.getTaskFinTaskLuj();
        for (LinkedListItem currentItem = listTemp.getFirst(); currentItem != null; currentItem = currentItem.getNext()) {
            Module module = (Module)currentItem;
            int mapid = module.getInt("mapid");
            String mapName = module.getString("mname");
            int npcid = module.getInt("npcid");
            String npcName = module.getString("nname");
            int x = module.getInt("npcx");
            int y = module.getInt("npcy");
            String action = "findw(" + mapid + "," + x + "," + y;
            String mapN = StringUtil.combineXml(mapName, "a", new String[]{"href", action, "ct", "cblue"});
            String npcP = StringUtil.combineXml(npcName, "a", new String[]{"href", action, "ct", "cgreen"});
            msgBuf.append(mapN).append("c\u1ee7a").append(npcP);
        }
        msgBuf.append("<br/>");
        msgBuf.append("[Ph\u1ea7n th\u01b0\u1edfng]:");
        LinkedList fixedRedardList = this.getTaskFixedReward();
        boolean fFlag = false;
        for (LinkedListItem currentItem = fixedRedardList.getFirst(); currentItem != null; currentItem = currentItem.getNext()) {
            Module module = (Module)currentItem;
            if (!fFlag) {
                fFlag = true;
            } else if (fFlag) {
                msgBuf.append("\u3001 ");
            }
            msgBuf.append(module.getName()).append("x").append(module.getInt("num"));
        }
        msgBuf.append("<br/>");
        LinkedList optionalRedardList = this.getTaskOptionalReward();
        if (optionalRedardList.getLength() > 0) {
            msgBuf.append("[Ch\u1ecdn ph\u1ea7n th\u01b0\u1edfng]\uff1a ");
        }
        fFlag = false;
        for (LinkedListItem currentItem = optionalRedardList.getFirst(); currentItem != null; currentItem = currentItem.getNext()) {
            Module module = (Module)currentItem;
            if (!fFlag) {
                fFlag = true;
            } else if (fFlag) {
                msgBuf.append("\u3001 ");
            }
            msgBuf.append(module.getName()).append("x").append(module.getInt("num"));
        }
        byte beac = this.getByte("beac");
        if (beac != 0) {
            String action = "fbfly(" + this.getId() + ")";
            msgBuf.append(StringUtil.combineXml("C\u1edd d\u1eabn \u0111\u01b0\u1eddng d\u1ecbch chuy\u1ec3n", "a", new String[]{"href", action, "ct", "rwdb"})).append("<br/>");
        }
        return msgBuf.toString();
    }

    public Task getQuicklyTask() {
        LinkedList taskTargetList;
        Task taskObj = null;
        LinkedList linkedList = null;
        Module moduleTemp = null;
        if ("fin".equals(this.getState()) && (linkedList = this.getTaskFinTaskLuj()) != null) {
            moduleTemp = (Module)linkedList.getFirst();
        }
        if (moduleTemp == null && (taskTargetList = this.getTaskTarget()) != null) {
            for (LinkedListItem currentItem = taskTargetList.getFirst(); currentItem != null; currentItem = currentItem.getNext()) {
                Module module = (Module)currentItem;
                if (module.getInt("fnum") >= module.getInt("num") || (taskObj = this.getSpecialTaskObjLuj(module.getName())) == null) continue;
                return taskObj;
            }
        }
        if (moduleTemp == null && (linkedList = this.getTaskJieTaskLuj()) != null) {
            moduleTemp = (Module)linkedList.getFirst();
        }
        if (moduleTemp != null) {
            taskObj = new Task();
            taskObj.set("id", this.getId());
            taskObj.set("mapid", moduleTemp.getInt("mapid"));
            taskObj.set("x", moduleTemp.getInt("npcx"));
            taskObj.set("y", moduleTemp.getInt("npcy"));
            taskObj.set("text", this.getQuicklyTaskName());
        }
        return taskObj;
    }

    private Task getSpecialTaskObjLuj(String targetName) {
        if (targetName == null) {
            return null;
        }
        Task taskObjLuj = null;
        Module taskTempLuj = null;
        LinkedList listTemp = this.getTaskLuj();
        if (listTemp != null) {
            for (LinkedListItem currentItem = listTemp.getFirst(); currentItem != null; currentItem = currentItem.getNext()) {
                Module currentModule = (Module)currentItem;
                if (!targetName.equals(currentModule.getName())) continue;
                taskTempLuj = currentModule;
                break;
            }
        }
        if (taskTempLuj != null) {
            taskObjLuj = new Task();
            taskObjLuj.set("id", this.getId());
            taskObjLuj.set("mapid", taskTempLuj.getInt("cmpid"));
            taskObjLuj.set("x", taskTempLuj.getInt("cmpx"));
            taskObjLuj.set("y", taskTempLuj.getInt("cmpy"));
            taskObjLuj.set("text", this.getQuicklyTaskName());
        }
        return taskObjLuj;
    }

    public String getQuicklyTaskName() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName()).append("[").append(Config.taskState(this.getState())).append("]");
        return sb.toString();
    }

    public String getTaskZhuzhiType() {
        return this.getString("zzty");
    }

    public void setTaskTargetNum(String targetType, int targetId, int targetNum) {
        if (targetType == null) {
            return;
        }
        LinkedList targetList = this.getTaskTarget();
        for (LinkedListItem currentItem = targetList.getFirst(); currentItem != null; currentItem = currentItem.getNext()) {
            Module module = (Module)currentItem;
            if (!targetType.equals(module.getType()) || targetId != module.getInt("id")) continue;
            module.set("fnum", targetNum);
            return;
        }
    }

    public boolean procError(Protocol pt) {
        return false;
    }

    public boolean procSucc(Protocol pt) {
        switch (pt.combineCommand()) {
            case 2056: {
                this.setScript(pt.readUTF());
                this.executeScript();
                return true;
            }
        }
        return false;
    }

    public Object getUserDefinedValue(String property) {
        if ("desc".equals(property)) {
            return this.getTaskDetailedInfo();
        }
        return super.getUserDefinedValue(property);
    }

    public Module clone(Module target) {
        Module module = target;
        if (module == null) {
            module = new Task();
        }
        return super.clone(module);
    }
}

