/*
 * Decompiled with CFR 0.152.
 */
package com.ea.util;

public class Alignment {
    public static final int TOP_VALUE = 16;
    public static final int LEFT_VALUE = 4;
    public static final int RIGHT_VALUE = 8;
    public static final int BOTTOM_VALUE = 32;
    public static final int VCENTER_VALUE = 2;
    public static final int HCENTER_VALUE = 1;
    public static final int CENTER_VALUE = 3;
    public static final int FILL_VALUE = 64;
    public static final Alignment TOP_LEFT = new Alignment(20);
    public static final Alignment TOP = new Alignment(16);
    public static final Alignment TOP_RIGHT = new Alignment(24);
    public static final Alignment TOP_CENTER = new Alignment(17);
    public static final Alignment LEFT = new Alignment(4);
    public static final Alignment LEFT_CENTER = new Alignment(6);
    public static final Alignment CENTER = new Alignment(3);
    public static final Alignment RIGHT = new Alignment(8);
    public static final Alignment RIGHT_CENTER = new Alignment(10);
    public static final Alignment BOTTOM_LEFT = new Alignment(36);
    public static final Alignment BOTTOM = new Alignment(32);
    public static final Alignment BOTTOM_RIGHT = new Alignment(40);
    public static final Alignment BOTTOM_CENTER = new Alignment(33);
    public static final Alignment FILL = new Alignment(64);
    public static final Alignment FILL_TOP = new Alignment(80);
    public static final Alignment FILL_LEFT = new Alignment(68);
    public static final Alignment FILL_CENTER = new Alignment(67);
    public static final Alignment FILL_RIGHT = new Alignment(72);
    public static final Alignment FILL_BOTTOM = new Alignment(96);
    public int value;

    private Alignment(int n) {
        this.value = n;
    }

    public boolean isTop() {
        return (this.value & 0x10) == 16;
    }

    public boolean isBottom() {
        return (this.value & 0x20) == 32;
    }

    public boolean isLeft() {
        return (this.value & 4) == 4;
    }

    public boolean isRight() {
        return (this.value & 8) == 8;
    }

    public boolean isHorizontalCenter() {
        return (this.value & 3) == 3 || (this.isTop() || this.isBottom()) && !this.isLeft() && !this.isRight();
    }

    public boolean isVerticalCenter() {
        return (this.value & 3) == 3 || (this.isLeft() || this.isRight()) && !this.isTop() && !this.isBottom();
    }

    public boolean isFill() {
        return (this.value & 0x40) == 64;
    }

    public int alignX(int n, int n2) {
        if (this.isHorizontalCenter()) {
            return (n - n2) / 2;
        }
        if (this.isRight()) {
            return n - n2;
        }
        return 0;
    }

    public int alignY(int n, int n2) {
        if (this.isVerticalCenter()) {
            return (n - n2) / 2;
        }
        if (this.isBottom()) {
            return n - n2;
        }
        return 0;
    }

    public static Alignment combine(Alignment alignment, Alignment alignment2) {
        if (alignment != null && alignment2 != null) {
            byte by = (byte)((alignment.isTop() ? 16 : 0) | (alignment.isVerticalCenter() ? 3 : 0) | (alignment.isBottom() ? 32 : 0) | ((alignment2.isLeft() ? 4 : 0) | (alignment2.isHorizontalCenter() ? 3 : 0) | (alignment2.isRight() ? 8 : 0)));
            return new Alignment(by);
        }
        return null;
    }

    public static Alignment convertAlignment(int n) {
        Alignment alignment = null;
        switch (n) {
            case 20: {
                alignment = TOP_LEFT;
                break;
            }
            case 16: {
                alignment = TOP;
                break;
            }
            case 24: {
                alignment = TOP_RIGHT;
                break;
            }
            case 17: {
                alignment = TOP_CENTER;
                break;
            }
            case 4: {
                alignment = LEFT;
                break;
            }
            case 6: {
                alignment = LEFT_CENTER;
                break;
            }
            case 3: {
                alignment = CENTER;
                break;
            }
            case 8: {
                alignment = RIGHT;
                break;
            }
            case 10: {
                alignment = RIGHT_CENTER;
                break;
            }
            case 36: {
                alignment = BOTTOM_LEFT;
                break;
            }
            case 32: {
                alignment = BOTTOM;
                break;
            }
            case 40: {
                alignment = BOTTOM_RIGHT;
                break;
            }
            case 33: {
                alignment = BOTTOM_CENTER;
                break;
            }
            case 64: {
                alignment = FILL;
            }
        }
        return alignment;
    }

    public String toString() {
        return super.toString() + " " + this.value;
    }
}

