/*
 * Decompiled with CFR 0.152.
 */
package com.ea.util;

public abstract class MathFP {
    public static final int DEFAULT_PRECISION = 12;
    private static int a = 0;
    private static int b = 0;
    private static int c;
    private static int d;
    private static int e;
    private static int f;
    public static int ONE;
    public static int HALF;
    public static int TWO;
    public static int E;
    public static int PI;
    public static int PI_HALF;
    public static int PI_TWO;
    public static final int INFINITY = Integer.MAX_VALUE;
    private static final int[] g;
    private static int[] h;
    private static final int[] i;
    private static int[] j;
    private static int k;
    private static int l;
    private static final int[] m;
    private static int[] n;
    private static final int[] o;
    private static int[] p;
    private static int q;

    public static int getPrecision() {
        return a;
    }

    public static void setPrecision(int n) {
        int n2;
        if (n > 30 || n < 0) {
            return;
        }
        a = n;
        ONE = 1 << n;
        HALF = ONE >> 1;
        TWO = ONE << 1;
        PI = n <= 29 ? 1686629713 >> 29 - n : 1686629713 << n - 29;
        PI_HALF = PI >> 1;
        PI_TWO = PI << 1;
        E = n <= 29 ? 1459366444 >> 29 - n : 1459366444 >> n - 29;
        for (n2 = 0; n2 < g.length; ++n2) {
            MathFP.h[n2] = n <= 31 ? g[n2] >> 31 - n : g[n2] << n - 31;
        }
        for (n2 = 0; n2 < i.length; ++n2) {
            MathFP.j[n2] = n <= 30 ? i[n2] >> 30 - n : i[n2] << n - 30;
        }
        k = n <= 30 ? 744261117 >> 30 - n : 744261117 << n - 30;
        l = n <= 30 ? 1549082004 >> 30 - n : 1549082004 << n - 30;
        for (n2 = 0; n2 < m.length; ++n2) {
            MathFP.n[n2] = n <= 31 ? m[n2] >> 31 - n : m[n2] << n - 31;
        }
        for (n2 = 0; n2 < o.length; ++n2) {
            MathFP.p[n2] = n <= 31 ? o[n2] >> 31 - n : o[n2] << n - 31;
        }
        b = ONE - 1;
        d = MathFP.div(PI, MathFP.toFP(180));
        c = MathFP.div(MathFP.toFP(180), PI);
        f = 1;
        e = 0;
        n2 = ONE;
        while (n2 != 0) {
            n2 /= 10;
            f *= 10;
            ++e;
        }
    }

    public static int convert(int n, int n2) {
        int n3 = Math.abs(n);
        if (n2 > 30 || n2 < 0) {
            return n;
        }
        n2 = n2 > a ? n3 >> n2 - a : n3 << a - n2;
        if (n < 0) {
            n2 = -n2;
        }
        return n2;
    }

    public static int toFP(int n) {
        if (n < 0) {
            return -(-n << a);
        }
        return n << a;
    }

    public static int toFP(String string) {
        int n;
        int n2;
        int n3 = 0;
        String string2 = null;
        boolean bl = false;
        if (string.charAt(0) == '-') {
            bl = true;
            string = string.substring(1);
        }
        if ((n2 = string.indexOf(46)) < 0) {
            n = Integer.parseInt(string);
        } else if (n2 == 0) {
            n = 0;
            string2 = string.substring(1);
        } else if (n2 == string.length() - 1) {
            n = Integer.parseInt(string.substring(0, n2));
        } else {
            n = Integer.parseInt(string.substring(0, n2));
            string2 = string.substring(n2 + 1);
        }
        if (string2 != null) {
            if (string2.length() > e) {
                string2 = string2.substring(0, e);
            }
            if (string2.length() > 0) {
                n3 = Integer.parseInt(string2);
                for (int k = e - string2.length(); k > 0; --k) {
                    n3 *= 10;
                }
            }
        }
        int n4 = (n << a) + (n3 << a) / f;
        if (bl) {
            n4 = -n4;
        }
        return n4;
    }

    public static int toInt(int n) {
        if (n < 0) {
            return -(-n >> a);
        }
        return n >> a;
    }

    public static String toString(int n) {
        boolean bl = false;
        if (n < 0) {
            bl = true;
            n = -n;
        }
        int n2 = n >> a;
        String string = String.valueOf((n & b) * f >> a);
        int n3 = e - string.length();
        while (n3 > 0) {
            string = "0" + string;
            --n3;
        }
        if (bl && n2 != 0) {
            n2 = -n2;
        }
        return String.valueOf(n2) + "." + string.toString();
    }

    public static int ceil(int n) {
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        if ((n & b) == 0) {
            if (bl) {
                return -n;
            }
            return n;
        }
        if (bl) {
            return -(n & ~b);
        }
        return (n & ~b) + ONE;
    }

    public static int floor(int n) {
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        if ((n & b) == 0) {
            if (bl) {
                return -n;
            }
            return n;
        }
        if (bl) {
            return -(n & ~b) - ONE;
        }
        return n & ~b;
    }

    public static int trunc(int n) {
        if (n < 0) {
            return -(-n & ~b);
        }
        return n & ~b;
    }

    public static int frac(int n) {
        if (n < 0) {
            return -(-n & b);
        }
        return n & b;
    }

    public static int fracAsInt(int n) {
        if (n < 0) {
            n = -n;
        }
        return f * (n & b) >> a;
    }

    public static int round(int n) {
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        n += HALF;
        n &= ~b;
        if (bl) {
            return -n;
        }
        return n;
    }

    public static int mul(int n, int n2) {
        return (int)((long)n * (long)n2 >> a);
    }

    public static int div(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n2 == 0) {
            if (n < 0) {
                return -2147483647;
            }
            return Integer.MAX_VALUE;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (n < 0) {
            bl = true;
            n = -n;
        }
        if (n2 < 0) {
            bl2 = true;
            n2 = -n2;
        }
        int n3 = 0;
        int n4 = 0;
        while ((n & 1 << 30 - n3) == 0) {
            ++n3;
        }
        while ((n2 & 1 << n4) == 0) {
            ++n4;
        }
        int n5 = a - (n3 + n4);
        n = (n << n3) / (n2 >> n4);
        n = n5 > 0 ? (n <<= n5) : (n >>= -n5);
        if (bl ^ bl2) {
            n = -n;
        }
        return n;
    }

    public static int sqrt(int n) {
        int n2 = n + ONE >> 1;
        for (int k = 0; k < 8; ++k) {
            n2 = n2 + MathFP.div(n, n2) >> 1;
        }
        return n2;
    }

    public static int sin(int n) {
        int n2 = 1;
        if ((n %= PI << 1) < 0) {
            n = (PI << 1) + n;
        }
        if (n > PI_HALF && n <= PI) {
            n = PI - n;
        } else if (n > PI && n <= PI + PI_HALF) {
            n -= PI;
            n2 = -1;
        } else if (n > PI + PI_HALF) {
            n = (PI << 1) - n;
            n2 = -1;
        }
        int n3 = MathFP.mul(n, n);
        int n4 = h[0];
        n4 = MathFP.mul(n4, n3);
        n4 -= h[1];
        n4 = MathFP.mul(n4, n3);
        n4 += ONE;
        n4 = MathFP.mul(n4, n);
        return n2 * n4;
    }

    public static int cos(int n) {
        return MathFP.sin(PI_HALF - n);
    }

    public static int tan(int n) {
        return MathFP.div(MathFP.sin(n), MathFP.cos(n));
    }

    public static int asin(int n) {
        boolean bl = false;
        if (n < 0) {
            bl = true;
            n = -n;
        }
        int n2 = MathFP.sqrt(ONE - n);
        int n3 = j[0];
        n3 = MathFP.mul(n3, n);
        n3 += j[1];
        n3 = MathFP.mul(n3, n);
        n3 -= j[2];
        n3 = MathFP.mul(n3, n);
        n3 += j[3];
        n3 = PI_HALF - MathFP.mul(n2, n3);
        if (bl) {
            n3 = -n3;
        }
        return n3;
    }

    public static int acos(int n) {
        return PI_HALF - MathFP.asin(n);
    }

    public static int atan(int n) {
        return MathFP.asin(MathFP.div(n, MathFP.sqrt(ONE + MathFP.mul(n, n))));
    }

    public static int atan2(int n, int n2) {
        if (n == 0) {
            if (n2 >= 0) {
                return 0;
            }
            if (n2 < 0) {
                return PI;
            }
        } else if (n2 >= -q && n2 <= q) {
            if (n > 0) {
                return PI_HALF;
            }
            return -PI_HALF;
        }
        int n3 = MathFP.atan(Math.abs(MathFP.div(n, n2)));
        if (n2 > 0) {
            if (n > 0) {
                return n3;
            }
            return -n3;
        }
        if (n > 0) {
            return PI - n3;
        }
        return n3 - PI;
    }

    public static int exp(int n) {
        if (n == 0) {
            return ONE;
        }
        int n2 = Math.abs(n);
        n2 = MathFP.mul(n2, l);
        n2 += HALF;
        n2 &= ~b;
        if (n < 0) {
            n2 = -n2;
        }
        int n3 = MathFP.mul(n -= MathFP.mul(n2, k), n);
        n3 = TWO + MathFP.mul(n3, p[0] + MathFP.mul(n3, p[1] + MathFP.mul(n3, p[2] + MathFP.mul(n3, p[3] + MathFP.mul(n3, p[4])))));
        n = ONE + MathFP.div(MathFP.mul(TWO, n), n3 - n);
        n2 = n2 < 0 ? ONE >> (-n2 >> a) : ONE << (n2 >> a);
        return MathFP.mul(n2, n);
    }

    public static int log(int n) {
        if (n < 0) {
            return 0;
        }
        if (n == 0) {
            return -2147483647;
        }
        int n2 = 0;
        while (n >= TWO) {
            n >>= 1;
            ++n2;
        }
        int n3 = MathFP.div(n -= ONE, TWO + n);
        int n4 = MathFP.mul(n3, n3);
        int n5 = MathFP.mul(n4, n4);
        n4 = MathFP.mul(n5, MathFP.n[1] + MathFP.mul(n5, MathFP.n[3] + MathFP.mul(n5, MathFP.n[5]))) + MathFP.mul(n4, MathFP.n[0] + MathFP.mul(n5, MathFP.n[2] + MathFP.mul(n5, MathFP.n[4] + MathFP.mul(n5, MathFP.n[6]))));
        return MathFP.mul(k, n2 << a) + n - MathFP.mul(n3, n - n4);
    }

    public static int log(int n, int n2) {
        return MathFP.div(MathFP.log(n), MathFP.log(n2));
    }

    public static int pow(int n, int n2) {
        if (n2 == 0) {
            return ONE;
        }
        if (n < 0) {
            return 0;
        }
        return MathFP.exp(MathFP.mul(MathFP.log(n), n2));
    }

    public static int toRadians(int n) {
        return MathFP.mul(n, d);
    }

    public static int toDegrees(int n) {
        return MathFP.mul(n, c);
    }

    static {
        g = new int[]{16342350, 356589659};
        h = new int[g.length];
        i = new int[]{-20110432, 79737141, 227756102, 1686557206};
        j = new int[i.length];
        m = new int[]{0x55555555, 0x33333333, 613566760, 477218077, 390489238, 328862160, 317788895};
        n = new int[m.length];
        o = new int[]{0x15555555, -5965232, 142029, -3550, 88};
        p = new int[o.length];
        MathFP.setPrecision(12);
        q = 65;
    }
}

