/*
 * Decompiled with CFR 0.152.
 */
package com.ea.util;

import com.ea.util.MathFP;

public class NumberUtil {
    public static final int MEGA_BYTE = 0x100000;
    public static final int KILO_BYTE = 1024;
    public static final int MEGA_FORMAT = 1;
    public static final int KILO_FORMAT = 2;
    public static final int ALL_FORMAT = 3;

    public static String formatByte(int n, int n2) {
        if (n > 0x100000 && (n2 & 1) == 1) {
            return Integer.toString(n / 0x100000) + "M";
        }
        if (n > 1024 && (n2 & 2) == 2) {
            return Integer.toString(n / 1024) + "K";
        }
        return Integer.toString(n);
    }

    public static String formatInt(int n, int n2) {
        if (n2 == 0) {
            return "";
        }
        String string = Integer.toString(n);
        if (n2 < 0) {
            return string;
        }
        int n3 = string.length();
        if ((n = n < 0 ? 1 : 0) != 0) {
            string = string.substring(1);
            --n3;
        }
        if (n3 > n2) {
            string = string.substring(n3 - n2);
        } else {
            while (n3++ < n2) {
                string = "0" + string;
            }
        }
        return (n != 0 ? "-" : "") + string;
    }

    public static String formatFP(int n, int n2, int n3) {
        boolean bl = false;
        if (n < 0) {
            bl = true;
        }
        int n4 = MathFP.toInt(n);
        n = MathFP.fracAsInt(n);
        String string = NumberUtil.formatInt(n4, n2);
        String string2 = Integer.toString(n);
        if (n3 >= 0) {
            if (string2.length() > n3) {
                string2 = string2.substring(0, n3);
            }
            while (string2.length() < n3) {
                string2 = string2 + "0";
            }
        }
        String string3 = "";
        if (string.length() > 0) {
            string3 = string3 + string;
        }
        if (string2.length() > 0) {
            string3 = string3 + "." + string2;
        }
        return (bl && n2 == 0 && n3 != 0 ? "-" : "") + string3;
    }

    public static String formatByGroupingBy(long l, int n) {
        n = 0;
        if (l < 0L) {
            n = 1;
            l = -l;
        }
        StringBuffer stringBuffer = new StringBuffer(Long.toString(l));
        int n2 = stringBuffer.length();
        for (int k = 3; k < n2; k += 3) {
            stringBuffer.insert(n2 - k, ' ');
        }
        if (n != 0) {
            stringBuffer.insert(0, '-');
        }
        return stringBuffer.toString();
    }

    public static byte[] toBytes(short s) {
        byte[] byArray = new byte[2];
        NumberUtil.toBytes(s, byArray, 0);
        return byArray;
    }

    public static byte[] toBytes(int n) {
        byte[] byArray = new byte[4];
        NumberUtil.toBytes(n, byArray, 0);
        return byArray;
    }

    public static byte[] toBytes(long l) {
        byte[] byArray = new byte[8];
        NumberUtil.toBytes(l, byArray, 0);
        return byArray;
    }

    public static void toBytes(short s, byte[] byArray, int n) {
        if (byArray.length - n < 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byArray[n] = (byte)(s >> 8);
        byArray[n + 1] = (byte)s;
    }

    public static void toBytes(int n, byte[] byArray, int n2) {
        if (byArray.length - n2 < 4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int k = 0; k < 4; ++k) {
            byArray[n2 + k] = (byte)(n >> (3 - k << 3));
        }
    }

    public static void toBytes(long l, byte[] byArray, int n) {
        if (byArray.length - n < 8) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int k = 0; k < 8; ++k) {
            byArray[n + k] = (byte)(l >> (7 - k << 3));
        }
    }

    public static short toShort(byte[] byArray, int n) {
        short s = 0;
        if (byArray != null && byArray.length >= 2) {
            s = (short)(0 + ((0xFF & byArray[n]) << 8));
            s = (short)(s + (0xFF & byArray[n + 1]));
        }
        return s;
    }

    public static int toInt(byte[] byArray, int n) {
        int n2 = 0;
        if (byArray != null && byArray.length >= 4) {
            for (int k = 0; k < 4; ++k) {
                n2 += (0xFF & byArray[n + k]) << (3 - k << 3);
            }
        }
        return n2;
    }

    public static long toLong(byte[] byArray, int n) {
        int n2 = 0;
        if (byArray != null && byArray.length >= 8) {
            for (int k = 0; k < 8; ++k) {
                n2 += (0xFF & byArray[n + k]) << (7 - k << 3);
            }
        }
        return n2;
    }

    public static final boolean isNumber(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }
}

