/*
 * Decompiled with CFR 0.152.
 */
package com.ea.util.graphics;

import com.ea.util.Log;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import java.util.Hashtable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphicsUtil {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int HCENTER = 1;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int VCENTER = 2;
    public static final int LEFTTOP = 20;
    public static final int RIGHTTOP = 24;
    public static final int CENTERTOP = 17;
    public static final int LEFTCENTER = 6;
    public static final int RIGHTCENTER = 10;
    public static final int CENTER = 3;
    public static final int LEFTBOM = 36;
    public static final int RIGHTBOM = 40;
    public static final int CENTERBOM = 33;
    public static final int ALL_DIRE = 60;
    public static final int[][] TRANSFORM_TABLE = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {1, 0, 3, 2, 5, 4, 7, 6}, {2, 3, 0, 1, 6, 7, 4, 5}, {3, 2, 1, 0, 7, 6, 5, 4}, {4, 6, 5, 7, 0, 2, 1, 3}, {5, 7, 4, 6, 1, 3, 0, 2}, {6, 4, 7, 5, 2, 0, 3, 1}, {7, 5, 6, 4, 3, 1, 2, 0}};
    public static boolean transparenceEnable = true;
    public static int transRectTileSize = 16;
    public static boolean useNokiaRegion = false;
    private static Hashtable a = new Hashtable();

    public static final int getDemitintColor(int n, int n2, int n3, int n4) {
        int n5 = (n2 >> 16 & 0xFF) - (n >> 16 & 0xFF);
        int n6 = (n2 >> 8 & 0xFF) - (n >> 8 & 0xFF);
        n2 = (n2 & 0xFF) - (n & 0xFF);
        n5 = n3 * n5 / n4 + (n >> 16 & 0xFF);
        n6 = n3 * n6 / n4 + (n >> 8 & 0xFF);
        n2 = n3 * n2 / n4 + (n & 0xFF);
        return (n5 << 16) + (n6 << 8) + n2;
    }

    public static final int getAlphaMixColor(int n, int n2, int n3) {
        return n * n3 >> 8 + n2 * (256 - n3) >> 8;
    }

    public static final void drawRegion(Graphics graphics, Image image, int n, int n2, int n3, int n4) {
        if (image == null) {
            return;
        }
        try {
            GraphicsUtil.drawRegion(graphics, image, 0, 0, image.getWidth(), image.getHeight(), n, n2, n3, n4);
            return;
        }
        catch (Exception exception) {
            Log.warn("\u56fe\u7247\u7ed8\u5236\u5f02\u5e38", exception);
            return;
        }
    }

    public static final void drawRegion(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        block30: {
            if (image == null) {
                return;
            }
            try {
                boolean bl;
                int n9 = image.getWidth();
                int n10 = image.getHeight();
                int n11 = n3 == -1 ? n9 : (n3 = n3 > n9 - n ? n9 - n : n3);
                n4 = n4 == -1 ? n10 : (n4 > n10 - n2 ? n10 - n2 : n4);
                boolean bl2 = bl = n != 0 || n2 != 0 || n3 != n9 || n4 != n10;
                if (useNokiaRegion) {
                    DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)graphics);
                    int n12 = 0;
                    int n13 = 0;
                    switch (n8) {
                        case 20: {
                            n12 = 0;
                            n13 = 0;
                            break;
                        }
                        case 24: {
                            n12 = -n3;
                            n13 = 0;
                            break;
                        }
                        case 3: {
                            n12 = -(n3 >> 1);
                            n13 = -(n4 >> 1);
                            break;
                        }
                        case 17: {
                            n12 = -(n3 >> 1);
                            n13 = 0;
                            break;
                        }
                        case 33: {
                            n12 = -(n3 >> 1);
                            n13 = -n4;
                            break;
                        }
                        case 40: {
                            n12 = -n3;
                            n13 = -n4;
                            break;
                        }
                        case 36: {
                            n12 = 0;
                            n13 = -n4;
                        }
                    }
                    n8 = 0;
                    int n14 = 0;
                    int n15 = 0;
                    int n16 = 0;
                    if (bl) {
                        n8 = graphics.getClipX();
                        n14 = graphics.getClipY();
                        n15 = graphics.getClipWidth();
                        n16 = graphics.getClipHeight();
                        switch (n5) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                graphics.clipRect(n6 + n12, n7 + n13, n3, n4);
                                break;
                            }
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: {
                                graphics.clipRect(n6 + n13, n7 + n12, n4, n3);
                            }
                        }
                    }
                    switch (n5) {
                        case 0: {
                            graphics.drawImage(image, n6 - n + n12, n7 - n2 + n13, 20);
                            break;
                        }
                        case 1: {
                            directGraphics.drawImage(image, n6 - n + n12, n7 - (n10 - n2 - n4) + n13, 20, 16384);
                            break;
                        }
                        case 2: {
                            directGraphics.drawImage(image, n6 - (n9 - n - n3) + n12, n7 - n2 + n13, 20, 8192);
                            break;
                        }
                        case 3: {
                            directGraphics.drawImage(image, n6 - (n9 - n - n3) + n12, n7 - (n10 - n2 - n4) + n13, 20, 180);
                            break;
                        }
                        case 4: {
                            directGraphics.drawImage(image, n6 - n2 + n13, n7 - n + n12, 20, 8462);
                            break;
                        }
                        case 5: {
                            directGraphics.drawImage(image, n6 - (n10 - n2 - n4) + n13, n7 - n + n12, 20, 270);
                            break;
                        }
                        case 6: {
                            directGraphics.drawImage(image, n6 - n2 + n13, n7 - (n9 - n - n3) + n12, 20, 90);
                            break;
                        }
                        case 7: {
                            directGraphics.drawImage(image, n6 - (n10 - n2 - n4) + n13, n7 - (n9 - n - n3) + n12, 20, 8282);
                        }
                    }
                    if (bl) {
                        graphics.setClip(n8, n14, n15, n16);
                    }
                    break block30;
                }
                if (!bl && n5 == 0) {
                    graphics.drawImage(image, n6, n7, n8);
                    break block30;
                }
                graphics.drawRegion(image, n, n2, n3, n4, n5, n6, n7, n8);
                return;
            }
            catch (Exception exception) {
                Log.warn("\u56fe\u7247\u7ed8\u5236\u5f02\u5e38", exception);
            }
        }
    }

    public static void drawTransRectByLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = graphics.getClipX();
        int n7 = graphics.getClipY();
        int n8 = graphics.getClipWidth();
        int n9 = graphics.getClipHeight();
        graphics.clipRect(n2, n3, n4, n5);
        graphics.setColor(n);
        for (n = 0; n < n4; n += 2) {
            graphics.drawLine(n2 + n, n3, n2 + n4, n3 + n4 - n);
        }
        for (n = 0; n < n5; n += 2) {
            graphics.drawLine(n2, n3 + n, n2 + n5 - n, n3 + n5);
        }
        graphics.setClip(n6, n7, n8, n9);
    }

    public static void drawTransRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Image image = GraphicsUtil.getTransRect(n);
        int n6 = graphics.getClipWidth();
        int n7 = graphics.getClipHeight();
        int n8 = graphics.getClipX();
        int n9 = graphics.getClipY();
        int n10 = n5 / transRectTileSize + (n5 % transRectTileSize == 0 ? 0 : 1);
        int n11 = n4 / transRectTileSize + (n4 % transRectTileSize == 0 ? 0 : 1);
        graphics.clipRect(n2, n3, n4, n5);
        for (n4 = 0; n4 < n10; ++n4) {
            for (n5 = 0; n5 < n11; ++n5) {
                graphics.drawImage(image, n2 + n5 * transRectTileSize, n3 + n4 * transRectTileSize, 0);
            }
        }
        graphics.setClip(n8, n9, n6, n7);
    }

    public static Image getTransRect(int n) {
        Image image = (Image)a.get(new Integer(n));
        if (image == null) {
            image = GraphicsUtil.createTransRect(transRectTileSize, transRectTileSize, n);
            a.put(new Integer(n), image);
        }
        return image;
    }

    public static Image createTransRect(int n, int n2, int n3) {
        int[] nArray = new int[n * n2];
        for (int k = 0; k < nArray.length; ++k) {
            nArray[k] = n3;
        }
        Image image = Image.createRGBImage((int[])nArray, (int)n, (int)n2, (boolean)true);
        return image;
    }

    public static void cleanCache() {
        a.clear();
    }

    public static void drawRimString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n4 >= 0) {
            graphics.setColor(n4);
            if ((n6 & 0x3C) == 60) {
                graphics.drawString(string, n, n2 - 1, n3);
                graphics.drawString(string, n + 1, n2, n3);
                graphics.drawString(string, n, n2 + 1, n3);
                graphics.drawString(string, n - 1, n2, n3);
            } else if ((n6 & 0x28) == 40) {
                graphics.drawString(string, n + 1, n2 + 1, n3);
            } else {
                if ((n6 & 0x10) == 16) {
                    graphics.drawString(string, n, n2 - 1, n3);
                }
                if ((n6 & 8) == 8) {
                    graphics.drawString(string, n + 1, n2, n3);
                }
                if ((n6 & 0x20) == 32) {
                    graphics.drawString(string, n, n2 + 1, n3);
                }
                if ((n6 & 4) == 4) {
                    graphics.drawString(string, n - 1, n2, n3);
                }
            }
        }
        graphics.setColor(n5);
        graphics.drawString(string, n, n2, n3);
    }

    public static void drawRollString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5, int[] nArray) {
        Font font = graphics.getFont();
        int n6 = graphics.getClipX();
        int n7 = graphics.getClipY();
        int n8 = graphics.getClipWidth();
        int n9 = graphics.getClipHeight();
        graphics.clipRect(n, n2, n3, font.getHeight());
        int n10 = Math.max(n3, font.stringWidth(string));
        graphics.drawString(string, n - nArray[0], n2, 20);
        if (nArray[0] + n3 > n10 + n5) {
            graphics.drawString(string, n - nArray[0] + n10 + n5, n2, 20);
        }
        graphics.setClip(n6, n7, n8, n9);
        nArray[0] = nArray[0] + n4;
        nArray[0] = nArray[0] >= n10 + n5 ? 0 : nArray[0];
    }

    public static int[] scale(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        int[] nArray2 = new int[n * n2];
        for (int k = 0; k < n2; ++k) {
            int n6 = k * n;
            int n7 = k * n5 / n2 * n3;
            for (int i2 = 0; i2 < n; ++i2) {
                nArray2[n6 + i2] = nArray[n7 + i2 * n4 / n];
            }
        }
        return nArray2;
    }
}

