/*
 * Decompiled with CFR 0.152.
 */
package org.j2mefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.UnsupportedEncodingException;
import org.j2mefs.Directory;
import org.j2mefs.FileSystem;
import org.j2mefs.FileSystemException;
import org.j2mefs.a;
import org.j2mefs.util.Input;
import org.j2mefs.util.Output;
import org.j2mefs.util.StringTools;

public class File
extends a {
    protected File(FileSystem fileSystem, Directory directory, a a2, String string, int n) {
        super(fileSystem, directory, a2, string, n);
    }

    public String getBaseName() {
        String[] stringArray = StringTools.split(this.name, '.');
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        if (n == 1) {
            return stringArray[0];
        }
        String string = "";
        for (int k = 0; k < n - 1; ++k) {
            string = string + stringArray[k];
            if (k >= n - 2) continue;
            string = string + '.';
        }
        return string;
    }

    public String getExtension() {
        String[] stringArray = StringTools.split(this.name, '.');
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        if (n == 1) {
            return "";
        }
        return stringArray[n - 1];
    }

    public int getSize() throws FileSystemException {
        this.checkFileSystem();
        return this.fileSystem.getNodeSize(this.id);
    }

    public byte[] read() throws FileSystemException {
        this.checkFileSystem();
        return this.fileSystem.readNode(this.id);
    }

    public String readString() throws FileSystemException {
        try {
            return new String(this.read(), "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            UnsupportedEncodingException unsupportedEncodingException2 = unsupportedEncodingException;
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public int readInt() throws FileSystemException {
        return new Input(this.read()).readInt();
    }

    public ByteArrayInputStream readByteArrayInputStream() throws FileSystemException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.read());
        try {
            byteArrayInputStream.close();
        }
        catch (Exception exception) {}
        return byteArrayInputStream;
    }

    public DataInputStream readDataInputStream() throws FileSystemException {
        return new DataInputStream(this.readByteArrayInputStream());
    }

    public void write(byte[] byArray) throws FileSystemException {
        this.checkFileSystem();
        this.fileSystem.writeNode(this.id, byArray);
    }

    public void write(String object) throws FileSystemException {
        try {
            this.fileSystem.writeNode(this.id, ((String)object).getBytes("utf-8"));
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = unsupportedEncodingException;
            unsupportedEncodingException.printStackTrace();
            return;
        }
    }

    public void write(int n) throws FileSystemException {
        Output output = new Output();
        output.writeInt(n);
        this.write(output);
    }

    public void write(ByteArrayOutputStream byteArrayOutputStream) throws FileSystemException {
        this.write(byteArrayOutputStream.toByteArray());
    }

    public void append(byte[] byArray) throws FileSystemException {
        Output output = new Output();
        byte[] byArray2 = this.read();
        output.write(byArray2);
        output.write(byArray);
        this.write(output);
    }

    public void append(ByteArrayOutputStream byteArrayOutputStream) throws FileSystemException {
        this.append(byteArrayOutputStream.toByteArray());
    }

    public void append(String string) throws FileSystemException {
        this.append(string.getBytes());
    }
}

