/*
 * Decompiled with CFR 0.152.
 */
package org.j2mefs;

import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;
import org.j2mefs.Directory;
import org.j2mefs.File;
import org.j2mefs.FileSystemException;
import org.j2mefs.a;
import org.j2mefs.util.StringTools;

public class FileSystem {
    public static final char pathSeparator = '/';
    public static final char extensionSeparator = '.';
    public static final byte fileSystemNameMaxLength = 32;
    protected static final byte rootRecordIndex = 1;
    private RecordStore a = null;
    private Directory b = null;
    private boolean c = true;

    private FileSystem(String string, boolean bl) throws FileSystemException {
        if (!FileSystem.isValidfileSystemName(string)) {
            throw new FileSystemException(6);
        }
        this.a = FileSystem.a(string, bl);
        this.b = Directory.newRoot(this);
        if (bl) {
            this.makeNode(Directory.emptyDirectoryByteArray());
            return;
        }
        this.b.restore();
    }

    public Directory getRootDirectory() {
        return this.b;
    }

    public File getFile(String string) throws FileSystemException {
        return (File)this.b(string, false);
    }

    public Directory getDirectory(String string) throws FileSystemException {
        return (Directory)this.b(string, true);
    }

    public void deleteFile(String string) throws FileSystemException {
        this.getFile(string).delete();
    }

    public void deleteDirectory(String string) throws FileSystemException {
        this.getDirectory(string).delete();
    }

    public void deleteTree(String string) throws FileSystemException {
        this.getDirectory(string).forceDelete();
    }

    public void unmount() throws FileSystemException {
        this.checkFileSystemMounted();
        try {
            this.a.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            throw new FileSystemException(recordStoreException);
        }
        this.b.unmount();
        this.b = null;
        this.a = null;
    }

    public long getLastModified() throws FileSystemException {
        this.checkFileSystemMounted();
        try {
            return this.a.getLastModified();
        }
        catch (RecordStoreException recordStoreException) {
            throw new FileSystemException(recordStoreException);
        }
    }

    public int getVersion() throws FileSystemException {
        this.checkFileSystemMounted();
        try {
            return this.a.getVersion();
        }
        catch (RecordStoreException recordStoreException) {
            throw new FileSystemException(recordStoreException);
        }
    }

    public int getSize() throws FileSystemException {
        this.checkFileSystemMounted();
        try {
            return this.a.getSize();
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            throw new FileSystemException((RecordStoreException)((Object)recordStoreNotOpenException));
        }
    }

    public int getSizeAvailable() throws FileSystemException {
        this.checkFileSystemMounted();
        try {
            return this.a.getSizeAvailable();
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            throw new FileSystemException((RecordStoreException)((Object)recordStoreNotOpenException));
        }
    }

    public boolean fileExists(String string) {
        try {
            this.getFile(string);
            return true;
        }
        catch (FileSystemException fileSystemException) {
            return false;
        }
    }

    public boolean directoryExists(String string) {
        try {
            this.getDirectory(string);
            return true;
        }
        catch (FileSystemException fileSystemException) {
            return false;
        }
    }

    protected int makeNode(byte[] byArray) throws FileSystemException {
        try {
            return this.a.addRecord(byArray, 0, byArray.length);
        }
        catch (RecordStoreFullException recordStoreFullException) {
            throw new FileSystemException(4);
        }
        catch (RecordStoreException recordStoreException) {
            throw new FileSystemException(recordStoreException);
        }
    }

    protected void writeNode(int n, byte[] byArray) throws FileSystemException {
        try {
            this.a.setRecord(n, byArray, 0, byArray.length);
            return;
        }
        catch (RecordStoreFullException recordStoreFullException) {
            throw new FileSystemException(4);
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
            throw new FileSystemException(5);
        }
        catch (RecordStoreException recordStoreException) {
            throw new FileSystemException(recordStoreException);
        }
    }

    protected byte[] readNode(int n) throws FileSystemException {
        try {
            byte[] byArray = this.a.getRecord(n);
            if (byArray == null) {
                return new byte[0];
            }
            return byArray;
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
            throw new FileSystemException(5);
        }
        catch (RecordStoreException recordStoreException) {
            throw new FileSystemException(recordStoreException);
        }
    }

    protected void deleteNode(int n) throws FileSystemException {
        try {
            this.a.deleteRecord(n);
            return;
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
            throw new FileSystemException(5);
        }
        catch (RecordStoreException recordStoreException) {
            throw new FileSystemException(recordStoreException);
        }
    }

    protected int getNodeSize(int n) throws FileSystemException {
        try {
            return this.a.getRecordSize(n);
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
            throw new FileSystemException(5);
        }
        catch (RecordStoreException recordStoreException) {
            throw new FileSystemException(recordStoreException);
        }
    }

    protected void checkFileSystemMounted() throws FileSystemException {
        if (this.a == null) {
            throw new FileSystemException(2);
        }
    }

    protected boolean isMounted() {
        return this.a != null;
    }

    private static RecordStore a(String string, boolean bl) throws FileSystemException {
        if (bl && FileSystem.exists(string)) {
            throw new FileSystemException(3);
        }
        try {
            return RecordStore.openRecordStore((String)string, (boolean)bl, (int)1, (boolean)true);
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            throw new FileSystemException(1);
        }
        catch (RecordStoreFullException recordStoreFullException) {
            throw new FileSystemException(4);
        }
        catch (RecordStoreException recordStoreException) {
            throw new FileSystemException(recordStoreException);
        }
    }

    private a b(String stringArray, boolean bl) throws FileSystemException {
        this.checkFileSystemMounted();
        if (!FileSystem.isAbsolutePath((String)stringArray)) {
            throw new FileSystemException(7);
        }
        stringArray = StringTools.split((String)stringArray, '/');
        int n = stringArray.length;
        Directory directory = this.b;
        if (n == 1) {
            if (bl) {
                return this.b;
            }
            throw new FileSystemException(10);
        }
        for (int k = 1; k < n - 1; ++k) {
            directory = (Directory)directory.getChild(stringArray[k], true);
        }
        return directory.getChild(stringArray[n - 1], bl);
    }

    public static boolean exists(String string) {
        try {
            string = FileSystem.a(string, false);
            string.closeRecordStore();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String[] list() {
        String[] stringArray = RecordStore.listRecordStores();
        if (stringArray == null) {
            return new String[0];
        }
        return stringArray;
    }

    public static FileSystem mount(String string) throws FileSystemException {
        return new FileSystem(string, false);
    }

    public static FileSystem make(String string) throws FileSystemException {
        return new FileSystem(string, true);
    }

    public static void kill(String string) throws FileSystemException {
        try {
            RecordStore.deleteRecordStore((String)string);
            return;
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            throw new FileSystemException(1);
        }
        catch (RecordStoreException recordStoreException) {
            throw new FileSystemException(recordStoreException);
        }
    }

    public static boolean isValidName(String string) {
        return string != null && string.indexOf(47, 0) < 0;
    }

    public static boolean isValidfileSystemName(String string) {
        return string != null && string.length() <= 32;
    }

    public static boolean isAbsolutePath(String string) {
        return string != null && string.charAt(0) == '/';
    }

    public Directory makeDirectory(String string) throws FileSystemException {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        Directory directory = this.getRootDirectory();
        int n = 1;
        int n2 = string.indexOf("/", 1);
        while (n != -1 && n2 != -1) {
            String string2 = string.substring(n, n2);
            try {
                directory = directory.getDirectory(string2);
            }
            catch (FileSystemException fileSystemException) {
                directory = directory.makeDirectory(string2);
            }
            n = n2 + 1;
            n2 = string.indexOf("/", n);
        }
        return directory;
    }

    public File makeFile(String object) throws FileSystemException {
        if (!((String)object).startsWith("/")) {
            object = "/" + (String)object;
        }
        Directory directory = this.getRootDirectory();
        int n = 1;
        int n2 = ((String)object).indexOf("/", 1);
        while (n != -1 && n2 != -1) {
            String string = ((String)object).substring(n, n2);
            try {
                directory = directory.getDirectory(string);
            }
            catch (FileSystemException fileSystemException) {
                directory = directory.makeDirectory(string);
            }
            n = n2 + 1;
            n2 = ((String)object).indexOf("/", n);
        }
        String string = ((String)object).substring(((String)object).lastIndexOf(47) + 1);
        if (directory.fileExists(string)) {
            directory.deleteFile(string);
        }
        object = directory.makeFile(string);
        return object;
    }

    public boolean needSync() {
        return this.c;
    }

    public void setNeedSync(boolean bl) {
        this.c = bl;
    }

    public void syncDirectory(String object) throws FileSystemException {
        object = this.getDirectory((String)object);
        while (object != null) {
            ((Directory)object).sync();
            if (this.b == object) break;
            object = ((a)object).parent;
        }
    }
}

