/*
 * Decompiled with CFR 0.152.
 */
package com.ea.engine.game._2d2;

import com.ea.engine.game._2d2.DBoard;
import com.ea.engine.script.Script;
import com.ea.engine.script.ScriptActionHandler;
import java.io.DataInputStream;

public class DData
implements ScriptActionHandler {
    public static final int TYPE_DEFAULT = 0;
    public static final int TYPE_GOMAP = 1;
    protected String name;
    protected int type;
    private Script a;
    public int x = -1;
    public int y = -1;
    public int col = -1;
    public int row = -1;
    protected DBoard board;
    private boolean b = false;
    private boolean c;
    private String d;

    public DData(DBoard dBoard) {
        this.board = dBoard;
    }

    public void init(DataInputStream object) throws Exception {
        this.type = ((DataInputStream)object).readByte();
        if (!"".equals(object = ((DataInputStream)object).readUTF())) {
            this.a = new Script("DData", (String)object, this);
        }
    }

    public void initialize(DataInputStream dataInputStream) throws Exception {
        this.col = dataInputStream.readUnsignedByte();
        this.row = dataInputStream.readUnsignedByte();
        this.setTilePosition(this.col, this.row);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void executeScript() {
        if (this.a != null) {
            this.a.setActionHandler(this);
            this.a.execute(true);
        }
    }

    public void setCurTilePosition(int n, int n2) {
        this.col = n;
        this.row = n2;
        if (this.board != null) {
            this.x = this.board.tileWidth * n + this.board.tileHalfWidth;
            this.y = this.board.tileHeight * n2 + this.board.tileHalfHeight;
        }
    }

    public boolean setCurPosition(int n, int n2) {
        boolean bl = false;
        if (this.board != null) {
            int n3 = n / this.board.tileWidth;
            int n4 = n2 / this.board.tileHeight;
            if (this.col != n3 || this.row != n4) {
                bl = true;
            }
            this.col = n3;
            this.row = n4;
        }
        this.x = n;
        this.y = n2;
        return bl;
    }

    public void setTilePosition(int n, int n2) {
        this.setCurTilePosition(n, n2);
    }

    public void setPosition(int n, int n2) {
        this.setCurPosition(n, n2);
    }

    public void setThroughAble(boolean bl) {
        this.b = bl;
    }

    public boolean isThroughAble() {
        return this.b;
    }

    public String getGotoMapName() {
        if (this.type == 1 && this.d == null) {
            this.c = true;
            this.executeScript();
            this.c = false;
            if (this.d == null) {
                this.d = "";
            }
        }
        return this.d;
    }

    protected void onAdded(DBoard dBoard) {
        this.board = dBoard;
        if (this.x != -1 && this.y != -1) {
            this.setPosition(this.x, this.y);
            return;
        }
        if (this.col != -1 && this.row != -1) {
            this.setTilePosition(this.col, this.row);
        }
    }

    protected void onRemoved() {
        this.board = null;
        this.row = -1;
        this.col = -1;
        this.y = -1;
        this.x = -1;
    }

    public DData clone(DData dData) {
        if (dData == null) {
            dData = new DData(this.board);
        }
        dData.name = this.name;
        dData.type = this.type;
        dData.a = this.a;
        return dData;
    }

    public Object onScriptAction(Script object, Object object2, Object[] objectArray) {
        if (!this.c) {
            object = this.board.getPlayer().getCharacterListener();
            if (object != null) {
                object.onMessage(object2, objectArray);
            }
        } else {
            switch (this.type) {
                case 1: {
                    this.d = (String)objectArray[0];
                }
            }
        }
        return null;
    }
}

