/*
 * Decompiled with CFR 0.152.
 */
package com.ea.engine.model;

import com.ea.engine.model.AModel;
import com.ea.engine.model.ImageModel;
import com.ea.engine.model.M;
import com.ea.util.Log;
import com.ea.util.graphics.GraphicsUtil;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class AnimationModel
extends AModel {
    public static final int HEADER = 1095650644;
    public static final int END = 1095061060;
    public AnimationData data;
    public static final byte MODE_WITH_IMAGE = 1;
    public int x;
    public int y;
    private int a;
    private int b;
    public int actionIndex;
    public int actionPlayTime;
    private int c = 0;
    public boolean pause;
    private String d;
    private int e;
    private short[] f;
    private int g;
    private int h;

    private AnimationModel() {
    }

    public AnimationModel(String string) throws Exception {
        super(string);
    }

    public AnimationModel(byte[] byArray) throws Exception {
        super(byArray);
    }

    public AnimationModel(InputStream inputStream) throws Exception {
        super(inputStream);
    }

    public AnimationModel(DataInputStream dataInputStream, boolean bl) throws Exception {
        super(dataInputStream, bl);
    }

    public static AnimationModel createBlankModel(String string) {
        AnimationModel animationModel = new AnimationModel();
        new AnimationModel().id = string;
        animationModel.data = new AnimationData(animationModel);
        return animationModel;
    }

    protected void inflate(DataInputStream dataInputStream) throws Exception {
        if (this.data == null) {
            this.data = new AnimationData(this);
        }
        this.data.init(dataInputStream);
        this.b = 0;
        this.actionPlayTime = 0;
    }

    public void setTransform(int n) {
        this.a = n;
    }

    public int getTransform() {
        return this.a;
    }

    public void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void setImages(ImageModel[] imageModelArray) {
        this.data.images = imageModelArray;
    }

    public int getWidth() {
        return this.data.right - this.data.left;
    }

    public int getHeight() {
        return this.data.bottom - this.data.top;
    }

    public void run() {
        if (this.isNull()) {
            return;
        }
        if (!this.pause) {
            this.nextFrame();
        }
    }

    public void draw(Graphics graphics) {
        this.draw(graphics, this.x, this.y);
    }

    public void draw(Graphics graphics, int n, int n2) {
        this.data.draw(graphics, n, n2, this.a, this.actionIndex, this.b);
    }

    public void setAction(int n) {
        if (this.isNull()) {
            return;
        }
        if (n < 0 || n >= this.data.actions.length) {
            throw new IndexOutOfBoundsException();
        }
        this.actionIndex = n;
        this.b = 0;
        this.actionPlayTime = 0;
        this.c = 0;
    }

    public int getAction() {
        return this.actionIndex;
    }

    public boolean checkMirror(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public void setPause(boolean bl) {
        this.pause = bl;
    }

    public void nextFrame() {
        try {
            ++this.c;
            int n = this.b;
            int n2 = (this.actionIndex << 1) + 1;
            n2 = n2 >= this.data.actions.length ? this.data.actions.length - 1 : n2;
            n2 = this.data.actions[n2];
            int n3 = this.actionIndex = this.actionIndex >= this.data.action_frame.length ? this.data.action_frame.length - 1 : this.actionIndex;
            if (n2 == -1) {
                n = (n + 1) % this.data.action_frame[this.actionIndex].length;
                this.setFrame(n);
                return;
            }
            if (n2 == 0) {
                this.setFrame(0);
                return;
            }
            if (this.actionPlayTime < n2) {
                if ((n = (n + 1) % this.data.action_frame[this.actionIndex].length) == 0) {
                    ++this.actionPlayTime;
                }
                if (this.actionPlayTime < n2) {
                    this.setFrame(n);
                }
            }
            return;
        }
        catch (Exception exception) {
            Log.error(this.id + " nextFrame " + this.b + "," + this.actionIndex + "," + this.data + "," + (this.data != null ? this.data.actions + "," : ",") + (this.data != null ? this.data.action_frame + "," : ","), exception);
            return;
        }
    }

    public void setFrame(int n) {
        try {
            byte by = this.data.action_frame[this.actionIndex][0 + n];
            if (this.c >= this.data.actions[this.actionIndex << 1] * this.data.frames[(by << 1) + 1]) {
                this.b = n;
                this.c = 0;
            }
            return;
        }
        catch (Exception exception) {
            Log.error(this.id + " setFrame " + n + "," + this.actionIndex + "," + this.data + "," + (this.data != null ? this.data.actions + "," : ",") + (this.data != null ? this.data.action_frame + "," : ","), exception);
            return;
        }
    }

    public int getFrame() {
        return this.b;
    }

    public boolean actionIsOver() {
        if (this.data.actions[(this.actionIndex << 1) + 1] == -1) {
            return false;
        }
        return this.actionPlayTime >= this.data.actions[(this.actionIndex << 1) + 1];
    }

    public void recover() {
        if (!GraphicsUtil.transparenceEnable) {
            return;
        }
        int n = this.data.images.length;
        for (int k = 0; k < n; ++k) {
            if (this.data.images[k] == null) continue;
            this.data.images[k].recover();
        }
    }

    public void setTransparence(int n) {
        this.setTransparence(n, false);
    }

    public void setTransparence(int n, boolean n2) {
        if (!GraphicsUtil.transparenceEnable) {
            return;
        }
        if (this.data == null || this.data.images == null) {
            return;
        }
        if (n2 != 0) {
            ImageModel[] imageModelArray = this.data.images;
            ImageModel[] imageModelArray2 = new ImageModel[this.data.images.length];
            int n3 = imageModelArray.length;
            for (int k = 0; k < n3; ++k) {
                if (imageModelArray[k] == null) continue;
                imageModelArray2[k] = (ImageModel)imageModelArray[k].clone(null, true);
                imageModelArray2[k].setTransparence(n);
            }
            this.setImages(imageModelArray2);
            return;
        }
        int n4 = this.data.images.length;
        for (n2 = 0; n2 < n4; ++n2) {
            if (this.data.images[n2] == null) continue;
            this.data.images[n2].setTransparence(n);
        }
    }

    public int getEnd() {
        return 1095061060;
    }

    public int getHeader() {
        return 1095650644;
    }

    public AModel clone(AModel aModel, boolean bl) {
        if ((aModel = (AnimationModel)aModel) == null) {
            aModel = new AnimationModel();
        }
        super.clone(aModel, bl);
        ((AnimationModel)aModel).x = this.x;
        ((AnimationModel)aModel).y = this.y;
        ((AnimationModel)aModel).a = this.a;
        if (bl) {
            AnimationData animationData = new AnimationData((AnimationModel)aModel);
            ((AnimationModel)aModel).data = this.data.clone(animationData);
        } else {
            ((AnimationModel)aModel).data = this.data;
        }
        ((AnimationModel)aModel).d = this.d;
        ((AnimationModel)aModel).e = this.e;
        ((AnimationModel)aModel).actionIndex = this.actionIndex;
        return aModel;
    }

    public void setElementPattern(String string, int n) {
        if (string.length() != this.data.elements.length) {
            throw new IllegalArgumentException(string + ".lenght != " + this.data.elements.length);
        }
        this.d = string;
        this.e = n;
    }

    public void setElementValue(String string) {
        int n;
        this.f = new short[this.data.elements.length];
        int n2 = string.length();
        int n3 = this.f.length;
        for (n = 0; n < n3; ++n) {
            if (n < n2) {
                int n4 = this.d.indexOf(string.charAt(n));
                this.f[n] = (short)n4;
                continue;
            }
            this.f[n] = -1;
        }
        n = this.data.images[0].getWidth();
        n2 = n * this.e / this.d.length();
        n3 = n * string.length() / this.d.length();
        this.x = this.g + (n2 - n3 >> 1);
        this.y = this.h;
    }

    public void setElementPosition(int n, int n2) {
        this.g = n;
        this.h = n2;
    }

    static short[] a(AnimationModel animationModel) {
        return animationModel.f;
    }

    public class AnimationData {
        public String name;
        public byte type;
        public short top;
        public short bottom;
        public short left;
        public short right;
        public short length3d;
        public short width3d;
        public short height3d;
        public boolean chipIsImage;
        public ImageModel[] images;
        public short[] chips;
        public String[] chips_name;
        public short[] elements;
        public short[][] element_chip;
        public byte[] actions;
        public byte[][] action_frame;
        public byte[] frames;
        public short[][] frame_element;
        public static final int BOX_ATTRIBUTE_COUNT = 4;
        public static final int POINT_ATTRIBUTE_COUNT = 2;
        public static final int POINT_ATTRIBUTE_X = 0;
        public static final int POINT_ATTRIBUTE_Y = 1;
        public static final int BOX_ATTRIBUTE_W = 2;
        public static final int BOX_ATTRIBUTE_H = 3;
        public static final int ACTION_ATTRIBUTE_COUNT = 2;
        public static final int ACTION_ATTRIBUTE_RATE = 0;
        public static final int ACTION_ATTRIBUTE_PLAYTIME = 1;
        public static final int ACTION_ATTRIBUTE_vx = 2;
        public static final int ACTION_ATTRIBUTE_vy = 3;
        public static final int ACTION_ATTRIBUTE_ax = 4;
        public static final int ACTION_ATTRIBUTE_ay = 5;
        public static final int FRAME_ATTRIBUTE_COUNT = 2;
        public static final int FRAME_ATTRIBUTE_TYPE = 0;
        public static final int FRAME_ATTRIBUTE_DURATION = 1;
        public static final int FRAME_PARAMETER_COUNT = 1;
        public static final int FRAME_PARAMETER_INDEX = 0;
        public static final int ELEMENT_ATTRIBUTE_COUNT = 1;
        public static final int ELEMENT_ATTRIBUTE_TYPE = 0;
        public static final int ELEMENT_PARAMETER_COUNT = 4;
        public static final int ELEMENT_PARAMETER_INDEX = 0;
        public static final int ELEMENT_PARAMETER_X = 1;
        public static final int ELEMENT_PARAMETER_Y = 2;
        public static final int ELEMENT_PARAMETER_TRANSFORM = 3;
        public static final int CHIP_ATTRIBUTE_COUNT = 5;
        public static final int CHIPISIMAGE_ATTRIBUTE_COUNT = 1;
        public static final int CHIP_ATTRIBUTE_IMAGE_INDEX = 0;
        public static final int CHIP_ATTRIBUTE_X = 1;
        public static final int CHIP_ATTRIBUTE_Y = 2;
        public static final int CHIP_ATTRIBUTE_W = 3;
        public static final int CHIP_ATTRIBUTE_H = 4;
        public static final int CHIP_PARAMETER_COUNT = 4;
        public static final int CHIP_PARAMETER_INDEX = 0;
        public static final int CHIP_PARAMETER_X = 1;
        public static final int CHIP_PARAMETER_Y = 2;
        public static final int CHIP_PARAMETER_TRANSFORM = 3;
        private final AnimationModel a;

        public AnimationData(AnimationModel animationModel) {
            this.a = animationModel;
        }

        public void init(DataInputStream dataInputStream) {
            block12: {
                try {
                    int n;
                    int n2;
                    int n3;
                    this.name = dataInputStream.readUTF();
                    this.type = dataInputStream.readByte();
                    this.top = dataInputStream.readShort();
                    this.bottom = dataInputStream.readShort();
                    this.left = dataInputStream.readShort();
                    this.right = dataInputStream.readShort();
                    this.length3d = dataInputStream.readShort();
                    this.width3d = dataInputStream.readShort();
                    this.height3d = dataInputStream.readShort();
                    this.chipIsImage = dataInputStream.readBoolean();
                    int n4 = dataInputStream.readShort();
                    this.actions = new byte[n4 << 1];
                    this.action_frame = new byte[n4][];
                    for (n3 = 0; n3 < n4; ++n3) {
                        this.actions[n3 << 1] = dataInputStream.readByte();
                        this.actions[(n3 << 1) + 1] = dataInputStream.readByte();
                        dataInputStream.readShort();
                        dataInputStream.readShort();
                        dataInputStream.readShort();
                        dataInputStream.readShort();
                        n2 = dataInputStream.readShort();
                        this.action_frame[n3] = new byte[n2];
                        for (n = 0; n < n2; ++n) {
                            this.action_frame[n3][n] = (byte)dataInputStream.readShort();
                        }
                    }
                    n3 = dataInputStream.readShort();
                    this.frames = new byte[n3 << 1];
                    this.frame_element = new short[n3][];
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.frames[n2 << 1] = (byte)dataInputStream.readShort();
                        this.frames[(n2 << 1) + 1] = (byte)dataInputStream.readShort();
                        n = dataInputStream.readShort();
                        this.frame_element[n2] = new short[n << 2];
                        for (n4 = 0; n4 < n; ++n4) {
                            this.frame_element[n2][n4 << 2] = dataInputStream.readShort();
                            this.frame_element[n2][(n4 << 2) + 1] = dataInputStream.readShort();
                            this.frame_element[n2][(n4 << 2) + 2] = dataInputStream.readShort();
                            this.frame_element[n2][(n4 << 2) + 3] = dataInputStream.readShort();
                        }
                    }
                    n2 = dataInputStream.readShort();
                    this.elements = new short[n2];
                    this.element_chip = new short[n2][];
                    for (n = 0; n < n2; ++n) {
                        this.elements[n] = dataInputStream.readShort();
                        n4 = dataInputStream.readShort();
                        this.element_chip[n] = new short[n4 << 2];
                        for (n3 = 0; n3 < n4; ++n3) {
                            this.element_chip[n][n3 << 2] = dataInputStream.readShort();
                            this.element_chip[n][(n3 << 2) + 1] = dataInputStream.readShort();
                            this.element_chip[n][(n3 << 2) + 2] = dataInputStream.readShort();
                            this.element_chip[n][(n3 << 2) + 3] = dataInputStream.readShort();
                        }
                        dataInputStream.readShort();
                        dataInputStream.readShort();
                        dataInputStream.readShort();
                        dataInputStream.readShort();
                    }
                    n = dataInputStream.readShort();
                    n4 = this.chipIsImage ? 1 : 5;
                    this.chips = new short[n * n4];
                    for (n3 = 0; n3 < n; ++n3) {
                        this.chips[n3 * n4] = dataInputStream.readShort();
                        if (this.chipIsImage) continue;
                        this.chips[n3 * n4 + 1] = dataInputStream.readShort();
                        this.chips[n3 * n4 + 2] = dataInputStream.readShort();
                        this.chips[n3 * n4 + 3] = dataInputStream.readShort();
                        this.chips[n3 * n4 + 4] = dataInputStream.readShort();
                    }
                    n3 = dataInputStream.readShort();
                    if ((this.a.mode & 1) != 0) {
                        this.images = new ImageModel[n3];
                        for (n4 = 0; n4 < n3; ++n4) {
                            int n5 = dataInputStream.readInt();
                            byte[] byArray = new byte[n5];
                            dataInputStream.read(byArray);
                            this.images[n4] = (ImageModel)M.instance.getResource(byArray);
                        }
                        break block12;
                    }
                    this.chips_name = new String[n3];
                    for (n4 = 0; n4 < n3; ++n4) {
                        this.chips_name[n4] = dataInputStream.readUTF();
                    }
                    return;
                }
                catch (Exception exception) {
                    Log.error("\u521d\u59cb\u5316\u52a8\u753b\u6570\u636e\u51fa\u9519:", exception);
                }
            }
        }

        public void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            if (this.a.isNull()) {
                return;
            }
            try {
                int n6;
                int n7;
                if (this.images == null) {
                    this.images = new ImageModel[this.chips_name.length];
                    n7 = this.images.length;
                    for (n6 = 0; n6 < n7; ++n6) {
                        this.images[n6] = (ImageModel)M.instance.getResource(this.chips_name[n6] + ".cpng");
                    }
                }
                n4 = n4 >= this.action_frame.length ? this.action_frame.length - 1 : n4;
                n6 = 0 + n5;
                n6 = n6 >= this.action_frame[n4].length ? this.action_frame[n4].length - 1 : n6;
                n7 = this.action_frame[n4][n6];
                short[] sArray = this.frame_element[n7];
                n6 = sArray.length / 4;
                for (n5 = 0; n5 < n6; ++n5) {
                    n7 = sArray[0 + (n5 << 2)];
                    if (AnimationModel.a(this.a) != null && (n7 = AnimationModel.a(this.a)[n5]) == -1) break;
                    short[] sArray2 = this.element_chip[n7];
                    short s = sArray[1 + (n5 << 2)];
                    short s2 = sArray[2 + (n5 << 2)];
                    short s3 = (short)GraphicsUtil.TRANSFORM_TABLE[sArray[3 + (n5 << 2)]][n3];
                    if (this.a.checkMirror(s3)) {
                        s = -s;
                    }
                    int n8 = sArray2.length / 4;
                    for (int k = 0; k < n8; ++k) {
                        short s4;
                        short s5 = sArray2[0 + (k << 2)];
                        short[] sArray3 = this.chips;
                        int n9 = this.chipIsImage ? 1 : 5;
                        int n10 = sArray2[1 + (k << 2)];
                        int n11 = sArray2[2 + (k << 2)];
                        short s6 = (short)GraphicsUtil.TRANSFORM_TABLE[sArray2[3 + (k << 2)]][s3];
                        switch (s6) {
                            case 2: {
                                n10 = (short)(-n10 - (sArray3[s5 * n9 + 3] & 1));
                                break;
                            }
                            case 7: {
                                n10 = (short)(-n10 - (sArray3[s5 * n9 + 4] & 1));
                                break;
                            }
                            case 1: {
                                n10 = (short)(-n10 - (sArray3[s5 * n9 + 3] & 1));
                                n11 = (short)(n11 - (sArray3[s5 * n9 + 4] & 1));
                                break;
                            }
                            case 4: {
                                n10 = (short)(-n10);
                                break;
                            }
                            case 3: {
                                n11 = (short)(n11 - (sArray3[s5 * n9 + 4] & 1));
                                break;
                            }
                            case 6: {
                                break;
                            }
                            case 0: {
                                break;
                            }
                            case 5: {
                                n10 = (short)(n10 - (sArray3[s5 * n9 + 4] & 1));
                            }
                        }
                        n10 = n + s + n10;
                        n11 = n2 + s2 + n11;
                        if (!this.chipIsImage) {
                            s4 = sArray3[s5 * n9];
                            short s7 = sArray3[s5 * n9 + 1];
                            short s8 = sArray3[s5 * n9 + 2];
                            short s9 = sArray3[s5 * n9 + 3];
                            s5 = sArray3[s5 * n9 + 4];
                            if (this.images[s4] == null) continue;
                            GraphicsUtil.drawRegion(graphics, this.images[s4].getImage(), s7, s8, s9, s5, s6, n10, n11, 3);
                            continue;
                        }
                        s4 = sArray3[s5 * n9];
                        if (this.images[s4] == null) continue;
                        GraphicsUtil.drawRegion(graphics, this.images[s4].getImage(), 0, 0, -1, -1, s6, n10, n11, 3);
                    }
                }
                return;
            }
            catch (Exception exception) {
                Log.warn("AnimationModel draw ", exception);
                return;
            }
        }

        public AnimationData clone(AnimationData animationData) {
            if (animationData == null) {
                animationData = new AnimationData(this.a);
            }
            animationData.name = this.name;
            animationData.type = this.type;
            animationData.top = this.top;
            animationData.bottom = this.bottom;
            animationData.left = this.left;
            animationData.right = this.right;
            animationData.length3d = this.length3d;
            animationData.width3d = this.width3d;
            animationData.height3d = this.height3d;
            animationData.chipIsImage = this.chipIsImage;
            animationData.chips = this.chips;
            animationData.chips_name = this.chips_name;
            animationData.elements = this.elements;
            animationData.element_chip = this.element_chip;
            animationData.actions = this.actions;
            animationData.action_frame = this.action_frame;
            animationData.frames = this.frames;
            animationData.frame_element = this.frame_element;
            animationData.images = this.images;
            return animationData;
        }
    }
}

