/*
 * Decompiled with CFR 0.152.
 */
package com.ea.engine.ui;

import com.ea.engine.core.EaCanvas;
import com.ea.engine.model.M;
import com.ea.engine.model.PropertyModel;
import com.ea.engine.ui.DataProvider;
import com.ea.engine.ui.FrameHandler;
import com.ea.engine.ui.transition.Transition;
import com.ea.engine.ui.widget.Chip;
import com.ea.engine.ui.widget.Desktop;
import com.ea.engine.ui.widget.InlineWidget;
import com.ea.engine.ui.widget.Menu;
import com.ea.engine.ui.widget.PopupBox;
import com.ea.engine.ui.widget.Screen;
import com.ea.engine.ui.widget.ScrollPane;
import com.ea.engine.ui.widget.Shape;
import com.ea.engine.ui.widget.Widget;
import com.ea.engine.ui.widget.WidgetConstants;
import com.ea.engine.ui.widget.Window;
import com.ea.engine.worker.Worker;
import com.ea.util.Log;
import com.ea.util.Method;
import com.ea.util.text.StringTokenizer;
import com.ea.util.text.StringUtil;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;

public class UI {
    public static final FrameHandler frameHandler = new FrameHandler();
    private static EaCanvas a;
    public static boolean firstIsLeft;
    protected static Hashtable controlMap;
    private static Hashtable b;
    private static Hashtable c;
    public static final String DEFAULT_I18N_MESSAGES_BUNDLE = "/mesg.bprp";
    private static Hashtable d;
    private static String e;
    public static final int HEADER = 1396920910;
    public static final int END = 1397050948;

    public static FrameHandler getFrameHandler() {
        return frameHandler;
    }

    public static EaCanvas getCanvas() {
        if (a == null) {
            throw new IllegalArgumentException("EaCanvas not initialized");
        }
        return a;
    }

    public static Desktop getDesktop() {
        return UI.getCanvas().getDesktop();
    }

    public static Screen getCurrentScreen() {
        return UI.getCanvas().getDesktop().getCurrentScreen();
    }

    public static boolean isInitialized() {
        return a != null;
    }

    public static void initialize(Display display, EaCanvas eaCanvas) {
        if (a != null) {
            throw new IllegalArgumentException("EaCanvas could be defined only once");
        }
        if (!Worker.mainWorker.isRunning()) {
            Worker.mainWorker.start();
        }
        if (!Worker.instance.isRunning()) {
            Worker.instance.start();
        }
        a = eaCanvas;
        if (display != null) {
            display.setCurrent((Displayable)eaCanvas);
        }
        eaCanvas.initialize();
    }

    public static void cleanUp() {
        frameHandler.removeAllFrames();
    }

    public static ScrollPane findFirstScrollPaneParent(Widget widget) {
        widget = widget.parent;
        while (widget != null) {
            if (widget instanceof ScrollPane) {
                return (ScrollPane)widget;
            }
            widget = widget.parent;
        }
        return null;
    }

    public static boolean callActionMethod(Method object) {
        if (object != null) {
            if (!frameHandler.processMessage(((Method)object).getName(), ((Method)object).getArguments())) {
                if ("!exit".equals(((Method)object).getName())) {
                    if (a != null) {
                        a.getInitializer().destroyImpl();
                    }
                    return true;
                }
                if ("!back".equals(((Method)object).getName())) {
                    if (a != null) {
                        object = a.getDesktop();
                        ((Desktop)object).setCurrentScreen(((Desktop)object).getPreviousScreen());
                    }
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static Method parseMethod(String object, Widget widget) {
        if (((String)object).length() == 0) {
            return null;
        }
        Object object2 = ((StringTokenizer)(object = new StringTokenizer((String)object, "(,)"))).nextToken().trim();
        if (object2 != null) {
            object2 = new Method((String)object2);
            Object[] objectArray = new Object[((StringTokenizer)object).countTokens()];
            int n = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken().trim();
                Object object3 = null;
                boolean bl = true;
                Object object4 = null;
                String string2 = null;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                while (stringTokenizer.hasMoreTokens()) {
                    Object object5;
                    object3 = null;
                    string2 = stringTokenizer.nextToken();
                    if (object4 == null && "this".equals(string2)) {
                        bl = false;
                        object4 = widget;
                        continue;
                    }
                    if (string2 != null && string2.startsWith("#")) {
                        bl = false;
                        object5 = object4 == null ? (a != null ? a.getDesktop().getWidget(string2.substring(1)) : null) : ((Widget)object4).getWidget(string2.substring(1));
                        if (object5 != null) {
                            object4 = object5;
                            continue;
                        }
                    }
                    if (object4 == null) break;
                    object5 = ((Widget)object4).getAttribute(string2.toLowerCase());
                    if (object5 != null) {
                        if (object5 instanceof Widget) {
                            object4 = (Widget)object5;
                            continue;
                        }
                        if (object5 instanceof Method) {
                            return (Method)object5;
                        }
                    }
                    object4 = null;
                    object3 = object5;
                }
                if (object3 == null) {
                    if (bl) {
                        object3 = string;
                    } else if (object4 != null) {
                        object3 = object4;
                    }
                }
                objectArray[n++] = object3;
            }
            ((Method)object2).setArguments(objectArray);
            return object2;
        }
        return null;
    }

    public static boolean initI18nSupport() {
        return UI.initI18nSupport(DEFAULT_I18N_MESSAGES_BUNDLE, UI.getLocale());
    }

    public static boolean initI18nSupport(String string) {
        return UI.initI18nSupport(DEFAULT_I18N_MESSAGES_BUNDLE, string);
    }

    public static boolean initI18nSupport(String string, String string2) {
        e = string2;
        d = new Hashtable();
        UI.loadI18nBundle(DEFAULT_I18N_MESSAGES_BUNDLE);
        return d != null;
    }

    public static boolean loadI18nBundle(String object) {
        if (d == null) {
            UI.initI18nSupport();
        }
        if (object != null && !((String)object).startsWith("/")) {
            object = "/" + (String)object;
        }
        PropertyModel propertyModel = null;
        try {
            propertyModel = (PropertyModel)M.instance.getClientResource((String)object);
            if (propertyModel != null) {
                d = propertyModel.getProperties();
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return d != null;
    }

    public static final void clean18nBundle() {
        d = null;
    }

    public static final String getMessage(String string) {
        return UI.getMessage(string, null);
    }

    public static String getLocale() {
        if (e == null) {
            try {
                e = System.getProperty("microedition.locale");
            }
            catch (Exception exception) {}
        }
        return e;
    }

    public static final String getMessage(String string, Object[] objectArray) {
        if (d == null && !UI.initI18nSupport()) {
            return string;
        }
        String string2 = (String)d.get(string);
        if (string2 != null) {
            return StringUtil.format(string2, objectArray);
        }
        return string;
    }

    public static String processI18nPattern(String string) {
        if (string != null && string.startsWith("%") && string.endsWith("%")) {
            int n;
            int n2 = string.length() - 1;
            String[] stringArray = null;
            int n3 = string.indexOf(40, 1);
            if (n3 != -1 && (n = string.indexOf(41, n3)) > n3 + 1) {
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n3 + 1, n), ",");
                stringArray = new String[stringTokenizer.countTokens()];
                n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n++] = stringTokenizer.nextToken().trim();
                }
                n2 = n3;
            }
            return UI.getMessage(string.substring(1, n2), stringArray);
        }
        return string;
    }

    public static void showPopupBox(PopupBox popupBox) {
        UI.getDesktop().addPopup(popupBox);
    }

    public static void splash(PopupBox popupBox, int n) {
        popupBox.setDuration(n);
        UI.getDesktop().addPopup(popupBox);
    }

    /*
     * Loose catch block
     */
    public static PopupBox loadPopupBox(String string, DataProvider dataProvider) {
        PopupBox popupBox;
        block10: {
            DataInputStream dataInputStream = new DataInputStream(M.getInputStreamFromRmsOrJar(string));
            popupBox = null;
            popupBox = UI.loadPopupBox(dataInputStream, dataProvider);
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {}
            break block10;
            catch (Exception exception) {
                try {
                    Log.error("UI.loadPopupBox " + string, exception);
                }
                catch (Throwable throwable) {
                    try {
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return popupBox;
    }

    public static PopupBox loadPopupBox(DataInputStream dataInputStream, DataProvider object) {
        PopupBox popupBox = null;
        try {
            int n;
            int n2;
            dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.readByte();
            dataInputStream.readByte();
            int n3 = dataInputStream.readUnsignedByte();
            for (n2 = 0; n2 < n3; ++n2) {
                n = dataInputStream.readUnsignedByte();
                Widget widget = UI.convertWidgetTag(n);
                widget.initialize(dataInputStream);
                if (popupBox == null && widget instanceof PopupBox) {
                    popupBox = (PopupBox)widget;
                }
                if (popupBox == null) continue;
                if (widget instanceof InlineWidget) {
                    popupBox.addInlineWidget((InlineWidget)widget, (DataProvider)object);
                    continue;
                }
                popupBox.addScreenBuf(widget);
            }
            if (object != null) {
                ((DataProvider)object).bind(popupBox, true);
            }
            n2 = dataInputStream.readUnsignedByte();
            for (n = 0; n < n2; ++n) {
                short s = dataInputStream.readShort();
                short s2 = dataInputStream.readShort();
                n3 = dataInputStream.readUnsignedByte();
                Transition transition = UI.convertTransition(n3);
                if (transition != null) {
                    transition.initialize(dataInputStream);
                }
                if ((object = UI.a(popupBox, s, s2)) == null) continue;
                ((Widget)object).addTransition(transition);
            }
            dataInputStream.readInt();
        }
        catch (Exception exception) {
            Log.error("UI.loadPopupBox " + popupBox, exception);
        }
        return popupBox;
    }

    public static void showWindow(Window window) {
        UI.getDesktop().addPopup(window);
    }

    /*
     * Loose catch block
     */
    public static Window loadWindow(String string, DataProvider dataProvider) {
        Window window;
        block10: {
            DataInputStream dataInputStream = new DataInputStream(M.getInputStreamFromRmsOrJar(string));
            window = null;
            window = UI.loadWindow(dataInputStream, dataProvider);
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {}
            break block10;
            catch (Exception exception) {
                try {
                    Log.error("UI.loadWindow " + string, exception);
                }
                catch (Throwable throwable) {
                    try {
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return window;
    }

    public static Window loadWindow(DataInputStream dataInputStream, DataProvider object) {
        Window window = null;
        try {
            int n;
            int n2;
            dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.readByte();
            dataInputStream.readByte();
            int n3 = dataInputStream.readUnsignedByte();
            for (n2 = 0; n2 < n3; ++n2) {
                n = dataInputStream.readUnsignedByte();
                Widget widget = UI.convertWidgetTag(n);
                widget.initialize(dataInputStream);
                if (window == null && widget instanceof Window) {
                    window = (Window)widget;
                }
                if (window == null) continue;
                if (widget instanceof InlineWidget) {
                    window.addInlineWidget((InlineWidget)widget, (DataProvider)object);
                }
                window.addScreenBuf(widget);
            }
            if (object != null) {
                ((DataProvider)object).bind(window, true);
            }
            n2 = dataInputStream.readUnsignedByte();
            for (n = 0; n < n2; ++n) {
                short s = dataInputStream.readShort();
                short s2 = dataInputStream.readShort();
                n3 = dataInputStream.readUnsignedByte();
                Transition transition = UI.convertTransition(n3);
                if (transition != null) {
                    transition.initialize(dataInputStream);
                }
                if ((object = UI.a(window, s, s2)) == null) continue;
                ((Widget)object).addTransition(transition);
            }
            dataInputStream.readInt();
        }
        catch (Exception exception) {
            Log.error("UI.loadWindow " + window, exception);
        }
        return window;
    }

    public static void showScreen(Screen screen) {
        UI.hideAllMenuPopups();
        screen.setCurrent();
    }

    public static void hideAllMenuPopups() {
        Screen screen = UI.getCurrentScreen();
        if (screen != null) {
            screen.switchToDefaultMenus();
        }
        Menu.hideAllMenuPopups();
    }

    /*
     * Loose catch block
     */
    public static Screen loadScreen(String string, DataProvider dataProvider) {
        Screen screen;
        block10: {
            DataInputStream dataInputStream = new DataInputStream(M.getInputStreamFromRmsOrJar(string));
            screen = null;
            screen = UI.loadScreen(dataInputStream, dataProvider);
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {}
            break block10;
            catch (Exception exception) {
                try {
                    Log.error("UI.loadScreen " + string, exception);
                }
                catch (Throwable throwable) {
                    try {
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return screen;
    }

    public static Screen loadScreen(DataInputStream dataInputStream, DataProvider object) {
        Screen screen = null;
        try {
            int n;
            int n2;
            dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.readByte();
            dataInputStream.readByte();
            int n3 = dataInputStream.readUnsignedByte();
            for (n2 = 0; n2 < n3; ++n2) {
                n = dataInputStream.readUnsignedByte();
                Widget widget = UI.convertWidgetTag(n);
                widget.initialize(dataInputStream);
                if (screen == null && widget instanceof Screen) {
                    screen = (Screen)widget;
                }
                if (screen == null) continue;
                if (widget instanceof InlineWidget) {
                    screen.addInlineWidget((InlineWidget)widget, (DataProvider)object);
                }
                screen.addScreenBuf(widget);
            }
            if (object != null) {
                ((DataProvider)object).bind(screen, true);
            }
            n2 = dataInputStream.readUnsignedByte();
            for (n = 0; n < n2; ++n) {
                short s = dataInputStream.readShort();
                short s2 = dataInputStream.readShort();
                n3 = dataInputStream.readUnsignedByte();
                Transition transition = UI.convertTransition(n3);
                if (transition != null) {
                    transition.initialize(dataInputStream);
                }
                if ((object = UI.a(screen, s, s2)) == null) continue;
                ((Widget)object).addTransition(transition);
            }
            dataInputStream.readInt();
        }
        catch (Exception exception) {
            Log.error("UI.loadScreen " + screen, exception);
        }
        return screen;
    }

    private static Widget a(Widget widget, int n, int n2) {
        if (n != widget.id) {
            if (widget instanceof Screen) {
                widget = ((Screen)widget).getBufferWidget(new Integer(n));
            } else if (widget instanceof PopupBox) {
                widget = ((PopupBox)widget).getBufferWidget(new Integer(n));
            } else if (widget instanceof Window) {
                widget = ((Window)widget).getBufferWidget(new Integer(n));
            }
        }
        if (n2 == -1) {
            return widget;
        }
        return widget.getWidget(n2);
    }

    public static Widget loadWidget(String string, DataProvider object) {
        object = new DataInputStream(M.getInputStreamFromRmsOrJar(string));
        Widget widget = null;
        try {
            int n = ((DataInputStream)object).readUnsignedByte();
            widget = UI.convertWidgetTag(n);
            widget.init((DataInputStream)object);
        }
        catch (Exception exception) {
            Log.error("UI.loadWidget " + string, exception);
        }
        return widget;
    }

    public static Widget convertWidgetTag(int n) {
        try {
            switch (n) {
                case 13: 
                case 14: {
                    return new Shape(n);
                }
            }
            return (Widget)WidgetConstants.WIDGET_CLASSES[n].newInstance();
        }
        catch (Exception exception) {
            Log.error("\u65e0\u6cd5\u8bc6\u522b\u7684WidgetTag " + n, exception);
            return null;
        }
    }

    public static Transition convertTransition(int n) {
        try {
            return (Transition)Transition.TRANSITION_CLASSES[n].newInstance();
        }
        catch (Exception exception) {
            Log.error("\u65e0\u6cd5\u8bc6\u522b\u7684TransitionTag " + n, exception);
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public static void loadControls(String object) {
        object = new DataInputStream(M.getInputStreamFromRmsOrJar((String)object));
        ((DataInputStream)object).readInt();
        ((DataInputStream)object).readByte();
        ((DataInputStream)object).readByte();
        UI.loadChips((DataInputStream)object);
        UI.loadControls((DataInputStream)object);
        try {
            ((FilterInputStream)object).close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (Exception exception) {
            try {
                Log.error("\u52a0\u8f7d\u63a7\u4ef6\u5f02\u5e38", exception);
            }
            catch (Throwable throwable) {
                try {
                    ((FilterInputStream)object).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((FilterInputStream)object).close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    public static void loadChips(DataInputStream dataInputStream) throws Exception {
        int n;
        short s = dataInputStream.readShort();
        String[] stringArray = new String[s];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = dataInputStream.readUTF();
        }
        n = dataInputStream.readShort();
        for (int k = 0; k < n; ++k) {
            Chip chip = new Chip();
            chip.init(dataInputStream);
            short s2 = dataInputStream.readShort();
            chip.setSourceName(stringArray[s2] + ".cpng");
            UI.addChip(chip);
        }
    }

    public static void loadControls(DataInputStream dataInputStream) {
        try {
            int n = dataInputStream.readShort();
            for (int k = 0; k < n; ++k) {
                int n2 = dataInputStream.readUnsignedByte();
                Widget widget = UI.convertWidgetTag(n2);
                widget.init(dataInputStream);
                UI.addControl(widget);
            }
            return;
        }
        catch (Exception exception) {
            Log.error("\u52a0\u8f7d\u63a7\u4ef6\u5f02\u5e38", exception);
            return;
        }
    }

    public static void addChip(Widget widget) {
        b.put(new Integer(widget.id), widget);
    }

    public static Chip getChip(int n) {
        return (Chip)b.get(new Integer(n));
    }

    public static void addControl(Widget widget) {
        controlMap.put(new Integer(widget.id), widget);
        if (widget.name != null) {
            c.put(widget.name, widget);
        }
    }

    public static Widget getControl(int n) {
        return (Widget)controlMap.get(new Integer(n));
    }

    public static Widget getControl(String string) {
        return (Widget)c.get(string);
    }

    public static PopupBox getTopPopupBox() {
        return UI.getCurrentScreen().getTopPopupBox();
    }

    public static Widget getDesktopWidget(String string) {
        return UI.getDesktop().getWidget(string);
    }

    static {
        firstIsLeft = true;
        controlMap = new Hashtable();
        b = new Hashtable();
        c = new Hashtable();
    }
}

