/*
 * Decompiled with CFR 0.152.
 */
package com.ea.engine.ui.widget;

import com.ea.engine.core.EaConstants;
import com.ea.engine.model.M;
import com.ea.engine.model.PatternModel;
import com.ea.engine.ui.widget.Widget;
import com.ea.engine.ui.widget.WidgetConstants;
import com.ea.engine.ui.widget.b;
import com.ea.engine.worker.Worker;
import com.ea.engine.worker.WorkerTask;
import com.ea.util.Alignment;
import java.io.DataInputStream;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Label
extends Widget {
    public static final int FACE_SIZE_CUSTOM = 128;
    public static final byte FONT_STYLE_NORMAL = 0;
    public static final byte FONT_STYLE_SHADOW = 1;
    public static final byte FONT_STYLE_CROSS = 2;
    public static final byte FONT_STYLE_AROUND = 3;
    public static final byte FONT_STYLE_RIM = 4;
    protected byte fontShadowStyle = 0;
    public static final byte FONT_STYLE_BOLD = 1;
    public static final byte FONT_STYLE_TILT = 2;
    public static final byte FONT_STYLE_BOLD_TILT = 3;
    protected String defaultText = "";
    protected String text = null;
    public static final byte FONT_SIZE_SMALL = 0;
    public static final byte FONT_SIZE_MID = 1;
    public static final byte FONT_SIZE_BIG = 2;
    public static final byte FONT_SIZE_CUSTOM = 3;
    protected int foreColor;
    protected int bgColor;
    protected Alignment fontAlig = Alignment.TOP_LEFT;
    protected Font font = EaConstants.DEFAULT_FONT;
    private String a;
    private PatternModel b;
    private String c = null;
    protected int textX;
    protected int textY;
    private boolean d = true;
    private int e;
    private int f = 1;
    private WorkerTask g;

    public Label() {
        this(16);
    }

    public Label(int n) {
        super(n);
    }

    public void initialize(DataInputStream dataInputStream) throws Exception {
        String string;
        this.fontShadowStyle = dataInputStream.readByte();
        int n = dataInputStream.readByte();
        byte by = dataInputStream.readByte();
        byte by2 = dataInputStream.readByte();
        int n2 = 0;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
            }
        }
        n = 8;
        switch (by) {
            case 0: {
                n = 8;
                break;
            }
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 16;
                break;
            }
            case 3: {
                n = by2;
            }
        }
        this.font = Font.getFont((int)(by == 3 ? 128 : 0), (int)n2, (int)n);
        this.fontAlig = Alignment.convertAlignment(dataInputStream.readByte());
        this.defaultText = string = dataInputStream.readUTF();
        if (!"".equals(string)) {
            this.setText(string);
        }
        this.foreColor = dataInputStream.readInt();
        this.bgColor = dataInputStream.readInt();
        this.setSourceName(dataInputStream.readUTF());
        super.initialize(dataInputStream);
    }

    public void initializeControl(DataInputStream dataInputStream) throws Exception {
        this.fontShadowStyle = dataInputStream.readByte();
        int n = dataInputStream.readByte();
        byte by = dataInputStream.readByte();
        dataInputStream.readByte();
        int n2 = 0;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
            }
        }
        n = 8;
        switch (by) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 16;
            }
        }
        this.font = Font.getFont((int)0, (int)n2, (int)n);
        this.fontAlig = Alignment.convertAlignment(dataInputStream.readByte());
        this.defaultText = this.text = dataInputStream.readUTF();
        this.foreColor = dataInputStream.readInt();
        this.bgColor = dataInputStream.readInt();
        this.setSourceName(dataInputStream.readUTF());
        super.initializeControl(dataInputStream);
    }

    public Object getAttribute(String string) {
        if (WidgetConstants.WIDGET_ATTRIBUTES[6].equals(string)) {
            return this.getText();
        }
        return super.getAttribute(string);
    }

    public PatternModel getPattern() {
        if (this.b == null && !"".equals(this.a)) {
            this.setPattern((PatternModel)M.instance.getResource(this.a));
        }
        return this.b;
    }

    public boolean setAttribute(String string, Object object) {
        if (object == null) {
            this.setText(null);
            return true;
        }
        if (object instanceof String) {
            this.setText((String)object);
            return true;
        }
        if (object instanceof Integer) {
            this.setText(((Integer)object).toString());
            return true;
        }
        return super.setAttribute(string, object);
    }

    public Label setSource(String string) {
        if (string == null || string.length() == 0) {
            this.setPattern(null);
            return this;
        }
        this.setPattern((PatternModel)M.instance.getClientResource(string));
        return this;
    }

    public void setSourceName(String string) {
        this.a = string;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.setDisplayedText(null);
        this.invalidate();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFontFace(int n) {
        this.font = Font.getFont((int)n, (int)this.font.getStyle(), (int)this.font.getSize());
    }

    public void setFontStyle(int n) {
        this.font = Font.getFont((int)this.font.getFace(), (int)n, (int)this.font.getSize());
    }

    public void setFontSize(int n) {
        this.font = Font.getFont((int)this.font.getFace(), (int)this.font.getStyle(), (int)n);
    }

    public void setPattern(PatternModel patternModel) {
        this.b = patternModel;
        if (patternModel != null) {
            patternModel.setFont(this.font);
        }
    }

    public void setForeColor(int n) {
        this.foreColor = n;
    }

    public void setBgColor(int n) {
        this.bgColor = n;
    }

    public void setFontShadowStyle(byte by) {
        this.fontShadowStyle = by;
    }

    protected String getDisplayedText() {
        if (this.c != null) {
            return this.c;
        }
        return this.getText();
    }

    protected void setDisplayedText(String string) {
        this.c = string;
    }

    public void doLayout() {
        int n = this.getHeight();
        this.textX = 0;
        this.textY = 0;
        String string = this.getDisplayedText();
        if (string != null) {
            Font font = this.getFont();
            Alignment alignment = this.fontAlig;
            PatternModel patternModel = this.getPattern();
            int n2 = patternModel != null ? patternModel.stringWidth(string) : font.stringWidth(string);
            int n3 = patternModel != null ? patternModel.stringHeight(string) : font.getHeight();
            int n4 = this.getWidth();
            if (alignment != null) {
                this.textX += alignment.alignX(n4, n2);
                this.textY += alignment.alignY(n, n3);
            }
            this.e = this.textX;
            if (this.g != null) {
                Worker.mainWorker.removeTask(this.g);
                this.g = null;
            }
            if (n2 > n4) {
                n = n2 - n4;
                n3 = Math.min(this.textX, -n);
                n = n3 + n;
                this.f = 1;
                this.g = new b(this, n3, n);
                if (!this.d || this.isFocusWidgetChild()) {
                    Worker.mainWorker.pushTask(this.g, 0);
                }
            }
        }
        this.markAsValidate();
    }

    protected void onFocus(Widget widget) {
        if (this.g != null) {
            Worker.mainWorker.removeTask(this.g, 0);
            Worker.mainWorker.pushTask(this.g, 0);
        }
    }

    protected void onLostFocus(Widget widget) {
        if (this.g != null) {
            Worker.mainWorker.removeTask(this.g, 0);
            this.textX = this.e;
            this.f = 1;
        }
    }

    public int[] pack() {
        this.markAsPack();
        int[] nArray = new int[]{this.x, this.y, this.width, this.height};
        if (this.text != null) {
            nArray[2] = this.font.stringWidth(this.text);
            nArray[3] = this.font.getHeight() + 2;
        }
        this.setSize(nArray[2], nArray[3]);
        return nArray;
    }

    public void paintChildrenImpl(Graphics object) {
        String string = this.getDisplayedText();
        if (string == null) {
            return;
        }
        object.setFont(this.font);
        Object object2 = this.getPattern();
        if (object2 != null) {
            object.setColor(this.foreColor);
            ((PatternModel)object2).draw((Graphics)object, string, this.textX, this.textY, 0);
            return;
        }
        int n = this.textY;
        int n2 = this.textX;
        int n3 = this.fontShadowStyle;
        object2 = string;
        string = object;
        object = this;
        switch (n3) {
            case 0: {
                string.setColor(object.foreColor);
                string.drawString((String)object2, n2, n, 0);
                return;
            }
            case 1: {
                string.setColor(object.bgColor);
                string.drawString((String)object2, n2 + 1, n + 1, 0);
                string.setColor(object.foreColor);
                string.drawString((String)object2, n2, n, 0);
                return;
            }
            case 3: {
                string.setColor(object.bgColor);
                string.drawString((String)object2, n2 - 1, n - 1, 0);
                string.drawString((String)object2, n2 - 1, n, 0);
                string.drawString((String)object2, n2 - 1, n + 1, 0);
                string.drawString((String)object2, n2, n - 1, 0);
                string.drawString((String)object2, n2, n + 1, 0);
                string.drawString((String)object2, n2 + 1, n - 1, 0);
                string.drawString((String)object2, n2 + 1, n, 0);
                string.drawString((String)object2, n2 + 1, n + 1, 0);
                string.setColor(object.foreColor);
                string.drawString((String)object2, n2, n, 0);
                return;
            }
            case 2: {
                string.setColor(object.bgColor);
                string.drawString((String)object2, n2 - 1, n, 0);
                string.drawString((String)object2, n2 + 1, n, 0);
                string.drawString((String)object2, n2, n - 1, 0);
                string.drawString((String)object2, n2, n + 1, 0);
                string.setColor(object.foreColor);
                string.drawString((String)object2, n2, n, 0);
                return;
            }
            case 4: {
                n3 = object.font.stringWidth((String)object2);
                int n4 = object.font.getHeight();
                string.setColor(object.bgColor);
                string.fillRect(n2 - 2, n - 2, n3 + 4, n4 + 2);
                string.setColor(object.foreColor);
                string.drawString((String)object2, n2, n, 0);
                string.drawRect(n2 - 2, n - 2, n3 + 4, n4 + 2);
            }
        }
    }

    public Vector getRawData(Vector vector) {
        vector = super.getRawData(vector);
        vector.addElement(this.text);
        return vector;
    }

    public void setRawData(Vector vector) {
        super.setRawData(vector);
        String string = (String)vector.elementAt(0);
        vector.removeElementAt(0);
        this.setText(string);
    }

    public Widget clone(Widget widget) {
        if ((widget = (Label)widget) == null) {
            widget = new Label(this.tag);
        }
        super.clone(widget);
        ((Label)widget).fontShadowStyle = this.fontShadowStyle;
        ((Label)widget).font = this.font;
        ((Label)widget).foreColor = this.foreColor;
        ((Label)widget).text = this.text;
        ((Label)widget).defaultText = this.defaultText;
        ((Label)widget).bgColor = this.bgColor;
        ((Label)widget).fontAlig = this.fontAlig;
        ((Label)widget).a = this.a;
        ((Label)widget).b = this.b;
        return widget;
    }

    public String toString() {
        return super.toString() + "^txt=" + this.text;
    }

    static int a(Label label, int n) {
        label.f = -label.f;
        return label.f;
    }

    static int a(Label label) {
        return label.f;
    }
}

