/*
 * Decompiled with CFR 0.152.
 */
package com.ea.engine.ui.widget;

import com.ea.engine.ui.widget.Widget;
import com.ea.util.graphics.GraphicsUtil;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;

public class Shape
extends Widget {
    public static final byte LINE_STYLE_LEFT_SLASH = 0;
    public static final byte LINE_STYLE_RIGHT_SLASH = 1;
    public static final byte LINE_STYLE_LEFT_VERTICAL = 2;
    public static final byte LINE_STYLE_MID_VERTICAL = 3;
    public static final byte LINE_STYLE_RIGHT_VERTICAL = 4;
    public static final byte LINE_STYLE_TOP_HORIZONTAL = 5;
    public static final byte LINE_STYLE_MID_HORIZONTAL = 6;
    public static final byte LINE_STYLE_BOTTOM_HORIZONTAL = 7;
    protected byte lineStyle = 0;
    protected short lineSize = 1;
    protected int lineColor = -1;
    protected int fillColor = -1;
    protected short alpha = (short)255;
    protected boolean needRim = false;
    protected boolean needFill = false;
    protected short horizontalRadius = 0;
    protected short verticalRadius = 0;

    public Shape(int n) {
        super(n);
    }

    public void initialize(DataInputStream dataInputStream) throws Exception {
        if (this.tag == 13) {
            this.lineStyle = dataInputStream.readByte();
            this.lineSize = dataInputStream.readShort();
            this.lineColor = dataInputStream.readInt();
        } else if (this.tag == 14) {
            this.needRim = dataInputStream.readBoolean();
            if (this.needRim) {
                this.lineSize = dataInputStream.readShort();
                this.lineColor = dataInputStream.readInt();
            }
            this.needFill = dataInputStream.readBoolean();
            if (this.needFill) {
                this.alpha = (short)dataInputStream.readUnsignedByte();
                this.fillColor = dataInputStream.readInt();
            }
            this.horizontalRadius = dataInputStream.readShort();
            this.verticalRadius = dataInputStream.readShort();
        }
        super.initialize(dataInputStream);
    }

    public void initializeControl(DataInputStream dataInputStream) throws Exception {
        if (this.tag == 13) {
            this.lineStyle = dataInputStream.readByte();
            this.lineSize = dataInputStream.readShort();
            this.lineColor = dataInputStream.readInt();
        } else if (this.tag == 14) {
            this.needRim = dataInputStream.readBoolean();
            if (this.needRim) {
                this.lineSize = dataInputStream.readShort();
                this.lineColor = dataInputStream.readInt();
            }
            this.needFill = dataInputStream.readBoolean();
            if (this.needFill) {
                this.alpha = (short)dataInputStream.readUnsignedByte();
                this.fillColor = dataInputStream.readInt();
            }
            this.horizontalRadius = dataInputStream.readShort();
            this.verticalRadius = dataInputStream.readShort();
        }
        super.initializeControl(dataInputStream);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
    }

    public Widget add(Widget widget) {
        return null;
    }

    public void paintChildrenImpl(Graphics graphics) {
        block0 : switch (this.tag) {
            case 13: {
                if (this.lineSize <= 0 || this.lineColor == -1) {
                    return;
                }
                graphics.setColor(this.lineColor);
                switch (this.lineStyle) {
                    case 0: {
                        for (int k = 0; k < this.lineSize; ++k) {
                            graphics.drawLine(k, 0, this.width - (this.lineSize - k), this.height);
                        }
                        break block0;
                    }
                    case 1: {
                        for (int k = 0; k < this.lineSize; ++k) {
                            graphics.drawLine(this.lineSize - k, this.height, this.width - k, 0);
                        }
                        break block0;
                    }
                    case 2: {
                        graphics.fillRect(0, 0, (int)this.lineSize, this.height);
                        break block0;
                    }
                    case 3: {
                        graphics.fillRect((this.width >> 1) - this.lineSize / 2, 0, (int)this.lineSize, this.height);
                        break block0;
                    }
                    case 4: {
                        graphics.fillRect(this.width - this.lineSize, 0, (int)this.lineSize, this.height);
                        break block0;
                    }
                    case 5: {
                        graphics.fillRect(0, 0, this.width, (int)this.lineSize);
                        break block0;
                    }
                    case 6: {
                        graphics.fillRect(0, (this.height >> 1) - this.lineSize / 2, this.width, (int)this.lineSize);
                        break block0;
                    }
                    case 7: {
                        graphics.fillRect(this.x, this.height - this.lineSize, this.width, (int)this.lineSize);
                    }
                    default: {
                        return;
                    }
                }
            }
            case 14: {
                if (this.needFill) {
                    if (this.alpha == 255) {
                        graphics.setColor(this.fillColor);
                        if (this.horizontalRadius == 0 && this.verticalRadius == 0) {
                            graphics.fillRect(0, 0, this.width, this.height);
                        } else {
                            graphics.fillRoundRect(0, 0, this.width, this.height, (int)this.horizontalRadius, (int)this.verticalRadius);
                        }
                    } else {
                        GraphicsUtil.drawTransRect(graphics, this.fillColor | this.alpha << 24, 0, 0, this.width, this.height);
                    }
                }
                if (!this.needRim || this.lineSize <= 0) break;
                graphics.setColor(this.lineColor);
                if (this.horizontalRadius == 0 && this.verticalRadius == 0) {
                    for (int k = 0; k < this.lineSize; ++k) {
                        graphics.drawRect(k, k, this.width - 2 * k - 1, this.height - 2 * k - 1);
                    }
                    return;
                }
                for (int k = 0; k < this.lineSize; ++k) {
                    graphics.drawRoundRect(k, k, this.width - 2 * k - 1, this.height - 2 * k - 1, (int)this.horizontalRadius, (int)this.verticalRadius);
                }
                break;
            }
        }
    }

    public Widget clone(Widget widget) {
        if ((widget = (Shape)widget) == null) {
            widget = new Shape(this.tag);
        }
        super.clone(widget);
        ((Shape)widget).lineStyle = this.lineStyle;
        ((Shape)widget).lineSize = this.lineSize;
        ((Shape)widget).lineColor = this.lineColor;
        ((Shape)widget).alpha = this.alpha;
        ((Shape)widget).fillColor = this.fillColor;
        ((Shape)widget).needRim = this.needRim;
        ((Shape)widget).needFill = this.needFill;
        ((Shape)widget).horizontalRadius = this.horizontalRadius;
        ((Shape)widget).verticalRadius = this.verticalRadius;
        return widget;
    }
}

