/*
 * Decompiled with CFR 0.152.
 */
package com.ea.io.net;

import com.ea.io.net.Content;
import com.ea.io.net.ProtocolHandle;
import com.ea.io.net.ProtocolListener;
import com.ea.util.Log;
import com.ea.util.structure.Attribute;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Protocol {
    public static final int LEN_HEADER = 16;
    public static final byte CMDTYPE_SUCC = 0;
    public static final byte CMDTYPE_GROUP = -1;
    public static final byte CMDTYPE_DONOTHING = -2;
    public static final byte CMDTYPE_RESEND = -3;
    public static final byte CMDTYPE_ERROR_TIP = -4;
    public static final byte CMDTYPE_ERROR = -5;
    public static final byte CMDTYPE_SUCC_SIMPLE = -10;
    public static final byte CMDGROUP_NULL = -1;
    public boolean singleInSendPeriod = false;
    public byte cmdType;
    public byte cmdMain;
    public byte cmdSub;
    public byte version;
    public int rid;
    public int sid;
    public short tid;
    public long sendTime;
    public Content content = new Content();
    public ProtocolHandle protocolHandle;
    public ProtocolListener ptListener;
    private boolean a = true;
    private Attribute b;
    public static final byte NORMAL = 2;
    public byte priority = (byte)2;

    Protocol() {
    }

    Protocol(Protocol protocol) {
        this.cmdType = protocol.cmdType;
        this.cmdMain = protocol.cmdMain;
        this.cmdSub = protocol.cmdSub;
        this.version = protocol.version;
        this.rid = protocol.rid;
        this.sid = protocol.sid;
        this.a = protocol.a;
        this.priority = protocol.priority;
        this.protocolHandle = protocol.protocolHandle;
    }

    Protocol(DataInputStream dataInputStream) throws IOException {
        this.doRead(dataInputStream);
    }

    Protocol(Protocol[] protocolArray) {
        this.cmdType = (byte)-1;
        this.cmdMain = (byte)-1;
        this.cmdSub = (byte)-1;
        this.version = (byte)-1;
        this.rid = -1;
        this.sid = -1;
        this.tid = (short)-1;
        this.content.setSubProtocols(protocolArray);
    }

    Protocol(byte by, byte by2, byte by3, byte by4, int n, int n2, short s) {
        this.cmdType = by;
        this.cmdMain = by2;
        this.cmdSub = by3;
        this.version = by4;
        this.rid = n;
        this.sid = n2;
        this.tid = s;
    }

    public void readHeader(DataInputStream dataInputStream) throws IOException {
        this.cmdType = dataInputStream.readByte();
        this.cmdMain = dataInputStream.readByte();
        this.cmdSub = dataInputStream.readByte();
        this.version = dataInputStream.readByte();
        this.rid = dataInputStream.readInt();
        this.sid = dataInputStream.readInt();
        this.tid = dataInputStream.readShort();
        dataInputStream.readShort();
    }

    public void doRead(DataInputStream dataInputStream) throws IOException {
        this.readHeader(dataInputStream);
        this.content.setIncludeProtocol(this.isGroupPt());
        this.content.doRead(dataInputStream);
    }

    public void doWrite(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.cmdType);
        dataOutputStream.writeByte(this.cmdMain);
        dataOutputStream.writeByte(this.cmdSub);
        dataOutputStream.writeByte(this.version);
        dataOutputStream.writeInt(this.rid);
        dataOutputStream.writeInt(this.sid);
        dataOutputStream.writeShort(this.tid);
        this.sendTime = System.currentTimeMillis();
        dataOutputStream.writeShort((short)this.sendTime);
        this.content.doWrite(dataOutputStream);
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.doWrite(dataOutputStream);
        }
        catch (Throwable throwable) {
            try {
                dataOutputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            dataOutputStream.close();
        }
        catch (IOException iOException) {}
        return byteArrayOutputStream.toByteArray();
    }

    public void deserialize(byte[] object) throws IOException {
        object = new DataInputStream(new ByteArrayInputStream((byte[])object));
        try {
            this.doRead((DataInputStream)object);
        }
        catch (Throwable throwable) {
            try {
                ((FilterInputStream)object).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((FilterInputStream)object).close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public int getSendSize() {
        return 16 + this.content.getSendSize();
    }

    public int getRecvSize() {
        return 16 + this.content.getRecvSize();
    }

    public void setPriority(byte by) {
        this.priority = by;
    }

    protected boolean theSameTo(Protocol protocol) {
        return this.toCmdString().equals(protocol.toCmdString());
    }

    public boolean isBlock() {
        Protocol[] protocolArray = this.content.getSubProtocols();
        if (this.isGroupPt() && protocolArray != null) {
            int n = protocolArray.length;
            for (int k = 0; k < n; ++k) {
                if (!protocolArray[k].a) continue;
                return true;
            }
            return false;
        }
        return this.a;
    }

    public Protocol setBlock(boolean bl) {
        this.a = bl;
        return this;
    }

    public Protocol setVersion(byte by) {
        this.version = by;
        return this;
    }

    public Protocol setListener(ProtocolListener protocolListener) {
        this.ptListener = protocolListener;
        return this;
    }

    public Protocol setAttribute(Object object, Object object2) {
        if (this.b == null) {
            this.b = new Attribute();
        }
        this.b.setObjectValue(object, object2);
        return this;
    }

    public Object getAttribute(Object object) {
        return this.b.getObjectValue(object);
    }

    public void transferFrom(Protocol protocol) {
        this.ptListener = protocol.ptListener;
        this.protocolHandle = protocol.protocolHandle;
        this.b = protocol.b;
    }

    public String toCmdCode() {
        return this.cmdMain + "x" + this.cmdSub + "x" + this.version;
    }

    public String toCmdString() {
        return "cmd " + this.cmdType + " " + this.cmdMain + " " + this.cmdSub + " " + this.version;
    }

    public String toHeaderString() {
        return this.toCmdString() + " " + this.rid + " " + this.sid + " " + this.tid;
    }

    public String toString() {
        return this.toHeaderString() + " " + this.content;
    }

    public boolean sameAs(Protocol protocol) {
        return this.cmdType == protocol.cmdType && this.cmdMain == protocol.cmdMain && this.cmdSub == protocol.cmdSub;
    }

    public String toFullString() {
        StringBuffer stringBuffer = new StringBuffer(this.toString());
        Protocol[] protocolArray = this.content.getSubProtocols();
        if (protocolArray != null) {
            int n = protocolArray.length;
            for (int k = 0; k < n; ++k) {
                stringBuffer.append("\n **").append(protocolArray[k]);
            }
        }
        return stringBuffer.toString();
    }

    public int combineCommand() {
        return (this.cmdMain << 8) + this.cmdSub;
    }

    public boolean containProtocol(byte by, byte by2) {
        Protocol[] protocolArray = this.content.getSubProtocols();
        if (this.isGroupPt() && protocolArray != null) {
            int n = protocolArray.length;
            for (int k = 0; k < n; ++k) {
                if ((by << 8) + by2 != protocolArray[k].combineCommand()) continue;
                return true;
            }
            return false;
        }
        return (by << 8) + by2 == this.combineCommand();
    }

    public boolean isGroupPt() {
        return this.cmdType == -1;
    }

    public Protocol send() {
        ProtocolHandle protocolHandle = this.protocolHandle;
        synchronized (protocolHandle) {
            this.protocolHandle.onSend(this);
            this.protocolHandle.getConnect().addProtocol(this);
        }
        return this;
    }

    public DataInputStream getInputStream() {
        return this.content.ois;
    }

    public void readBytes(byte[] byArray) {
        try {
            this.content.ois.read(byArray);
            return;
        }
        catch (IOException iOException) {
            Log.error(this.toCmdCode() + " readBytes", iOException);
            return;
        }
    }

    public byte readByte() {
        try {
            return this.content.ois.readByte();
        }
        catch (IOException iOException) {
            Log.error(this.toCmdCode() + " readByte", iOException);
            return -1;
        }
    }

    public int readUByte() {
        try {
            return this.content.ois.readUnsignedByte();
        }
        catch (IOException iOException) {
            Log.error(this.toCmdCode() + " readUByte", iOException);
            return -1;
        }
    }

    public short readShort() {
        try {
            return this.content.ois.readShort();
        }
        catch (IOException iOException) {
            Log.error(this.toCmdCode() + " readShort", iOException);
            return -1;
        }
    }

    public int readInt() {
        try {
            return this.content.ois.readInt();
        }
        catch (IOException iOException) {
            Log.error(this.toCmdCode() + " readInt", iOException);
            return -1;
        }
    }

    public long readLong() {
        try {
            return this.content.ois.readLong();
        }
        catch (IOException iOException) {
            Log.error(this.toCmdCode() + " readLong", iOException);
            return -1L;
        }
    }

    public String readUTF() {
        try {
            return this.content.ois.readUTF();
        }
        catch (IOException iOException) {
            Log.error(this.toCmdCode() + " readUTF", iOException);
            return null;
        }
    }

    public DataOutputStream getOutputStream() {
        return this.content.oos;
    }

    public Protocol writeBytes(byte[] byArray) {
        try {
            ((OutputStream)this.content.oos).write(byArray);
        }
        catch (IOException iOException) {
            Log.error(this.toCmdCode() + " writeBytes", iOException);
        }
        return this;
    }

    public Protocol writeByte(int n) {
        try {
            this.content.oos.writeByte(n);
        }
        catch (IOException iOException) {
            Log.error(this.toCmdCode() + " writeByte", iOException);
        }
        return this;
    }

    public Protocol writeShort(int n) {
        try {
            this.content.oos.writeShort(n);
        }
        catch (IOException iOException) {
            Log.error(this.toCmdCode() + " writeShort", iOException);
        }
        return this;
    }

    public Protocol writeInt(int n) {
        try {
            this.content.oos.writeInt(n);
        }
        catch (IOException iOException) {
            Log.error(this.toCmdCode() + " writeInt", iOException);
        }
        return this;
    }

    public Protocol writeLong(long l) {
        try {
            this.content.oos.writeLong(l);
        }
        catch (IOException iOException) {
            Log.error(this.toCmdCode() + " writeLong", iOException);
        }
        return this;
    }

    public Protocol writeUTF(String string) {
        try {
            this.content.oos.writeUTF(string);
        }
        catch (IOException iOException) {
            Log.error(this.toCmdCode() + " writeUTF", iOException);
        }
        return this;
    }
}

