/*
 * Decompiled with CFR 0.152.
 */
package com.ea.product.world;

import com.ea.engine.game._2d2.CharacterListener;
import com.ea.engine.game._2d2.DCharacter;
import com.ea.engine.model.AnimationModel;
import com.ea.engine.model.M;
import com.ea.engine.script.Script;
import com.ea.engine.script.ScriptActionHandler;
import com.ea.engine.ui.DataProvider;
import com.ea.engine.ui.UI;
import com.ea.engine.ui.widget.ActionWidget;
import com.ea.engine.ui.widget.Animation;
import com.ea.engine.ui.widget.List;
import com.ea.engine.ui.widget.ListItem;
import com.ea.engine.ui.widget.PopupBox;
import com.ea.engine.ui.widget.TextArea;
import com.ea.engine.ui.widget.Widget;
import com.ea.engine.ui.widget.Window;
import com.ea.engine.worker.Worker;
import com.ea.engine.worker.WorkerTask;
import com.ea.io.net.Protocol;
import com.ea.io.net.ProtocolHandle;
import com.ea.io.net.ProtocolListener;
import com.ea.product.Constants;
import com.ea.product.MainMIDlet;
import com.ea.product.frame.FrameConstants;
import com.ea.product.frame.GuideFrame;
import com.ea.product.frame.NPCFrame;
import com.ea.product.frame.ProtocolConstants;
import com.ea.product.frame.RiskFrame;
import com.ea.product.module.Creature;
import com.ea.product.module.Task;
import com.ea.product.world.BattleScene;
import com.ea.product.world.Player;
import com.ea.util.Log;
import com.ea.util.MessageCallback;
import com.ea.util.Method;
import com.ea.util.graphics.GraphicsUtil;
import com.ea.util.structure.LinkedHashtable;
import com.ea.util.text.StringUtil;
import java.io.DataInputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Entity
extends Creature
implements ScriptActionHandler,
MessageCallback,
ProtocolConstants,
FrameConstants,
Constants,
ProtocolListener,
CharacterListener,
WorkerTask {
    public static final int TASK_ANMT_PLAY = 8192;
    public static final int TASK_ANMT_PLAY1 = 8193;
    public static final Image shadow = M.instance.getClientResource("shdw.cpng").getImage();
    public static ProtocolHandle logicHandle = MainMIDlet.logicHandle;
    protected DCharacter character;
    protected Creature creature = this;
    private Script script;
    protected boolean isNull;
    private PopupBox npcMenu;
    public Object replyValue;
    public static final int RISK_STAND = 0;
    public static final int RISK_MOVE = 1;
    public static final int BATT_FATT = 2;
    public static final int BATT_DEFEND = 3;
    public static final int BATT_ATT = 4;
    public static final int BATT_MSG = 5;
    public static final int BATT_RELIVE = 9;
    private AnimationModel taskNpcAnimal;
    Vector[] npcMenuItem;
    public boolean calculateLeader;
    private String anmtMessage;
    public boolean battIsOK = false;
    public int battlePos;
    public int battFatt = -1;
    public int battDef = 0;
    public int[] battProt;
    public int fhasCatch = 0;
    public int battExit = 0;
    public int battCall = 0;
    public int battFJ = 0;
    public int battfjHP = 0;
    public int baohuOpt = 0;
    public int fangyuOpt = 0;
    public int buzuoOpt = 0;
    public int fuhOpt = 0;
    public int stopOpt = 0;
    public int hulOpt = 0;
    public int zdOpt = -1;
    public int qpOpt = 0;
    public int ysOpt = 0;
    public int zxOpt = 0;
    public int isfh = 0;
    boolean isdead = false;
    public boolean isshow = false;
    public AnimationModel catchamt;
    public int catchamtDx;
    public int catchamtDy;
    public Vector battle_effect;
    public String[] effs;
    public static final byte ATT_STATE_HIT = 0;
    public static final byte ATT_STATE_BLOW = 1;
    private LinkedHashtable effshow;
    private ActionWidget skillName;
    private int skillnamecont;
    private int talkMesCont;
    private ActionWidget talkWidget;
    private AnimationModel numBattleModel;
    private AnimationModel numBattleModel1;
    private AnimationModel numBattleModel2;
    private AnimationModel att_miss;
    public Vector wabAttEff = new Vector();
    public Vector hotEffect = new Vector();
    public Vector useHotEffect = new Vector();
    public Vector bdSkilEffect = new Vector();

    public Entity() {
        this.character = new DCharacter();
    }

    public Entity(DataInputStream dis, String tag) {
        this();
        try {
            this.init(dis, tag);
            this.initCharacter();
        }
        catch (Exception e2) {
            Log.error("Entity<init> " + this.getName(), e2);
        }
    }

    public void initCharacter() {
        if (this.character == null) {
            return;
        }
        try {
            this.character.setName(this.getName());
            this.character.setThroughAble(false);
            if (this.character.getAnimationModel() == null) {
                AnimationModel model = this.creature.getNpcAnimationModel();
                model.setCallbackListener(this.character);
                this.character.setAnimationModel((AnimationModel)model.clone(null));
            }
            this.character.setTilePosition(this.getInt("mapx"), this.getInt("mapy"));
            this.character.setCurDire("left".equals(this.getString("chan")) ? (byte)4 : 8);
            this.character.setCharacterListener(this);
        }
        catch (Exception e2) {
            Log.error("Entity.initCharacter " + this.getName(), e2);
        }
    }

    public synchronized void initMenu(DataInputStream dis) {
        try {
            byte itemCount = dis.readByte();
            this.npcMenuItem = this.addMenuItem(itemCount, dis);
            this.setTaskAnimal(this.getString("icon"));
        }
        catch (Exception e2) {
            Log.error(this.getName() + ",Entity.initMenu", e2);
        }
    }

    public synchronized void addNpcMenuItemAndr(DataInputStream dis) {
        try {
            Vector[] temp = this.addMenuItem((byte)1, dis);
            Vector[] tempEnd = new Vector[this.npcMenuItem.length + temp.length];
            System.arraycopy(this.npcMenuItem, 0, tempEnd, 0, this.npcMenuItem.length);
            System.arraycopy(temp, 0, tempEnd, this.npcMenuItem.length, temp.length);
            this.npcMenuItem = tempEnd;
        }
        catch (Exception e2) {
            Log.error("Entity.addmiand", e2);
        }
    }

    public synchronized void delNpcMenuItemAndr(int menuItemId) {
        int index = -1;
        for (int i2 = 0; i2 < this.npcMenuItem.length; ++i2) {
            int npcid = (Integer)this.npcMenuItem[i2].elementAt(1);
            if (npcid != menuItemId) continue;
            index = i2;
            break;
        }
        if (index == -1) {
            return;
        }
        Vector[] tempEnd = new Vector[this.npcMenuItem.length - 1];
        System.arraycopy(this.npcMenuItem, 0, tempEnd, 0, index);
        System.arraycopy(this.npcMenuItem, index + 1, tempEnd, index, this.npcMenuItem.length - index - 1);
        this.npcMenuItem = tempEnd;
    }

    public void setTaskAnimal(String taskState) {
        try {
            if ("".equals(taskState)) {
                if (this.taskNpcAnimal != null) {
                    this.taskNpcAnimal = null;
                }
                return;
            }
            if ("ques".equals(taskState)) {
                AnimationModel question = (AnimationModel)M.instance.getClientResource("question.anmt");
                this.taskNpcAnimal = (AnimationModel)question.clone(null);
            } else if ("sigh".equals(taskState)) {
                AnimationModel sigh = (AnimationModel)M.instance.getClientResource("sigh.anmt");
                this.taskNpcAnimal = (AnimationModel)sigh.clone(null);
            }
        }
        catch (Exception e2) {
            Log.error("setTaskAnimal", e2);
        }
    }

    private synchronized void getNpeMenuPop() {
        if (this.npcMenu != null) {
            this.npcMenu = null;
        }
        this.npcMenu = MainMIDlet.loadPopupBox("pplt", new DataProvider());
        this.npcMenu.setCleanUpWhenRemoved(false);
        int j2 = 0;
        try {
            for (j2 = 0; j2 < this.npcMenuItem.length; ++j2) {
                this.addMenuItemJava(this.npcMenuItem[j2]);
            }
        }
        catch (Exception e2) {
            Log.error("getNpeMenuPop-->" + this.npcMenuItem + "," + j2 + "  ", e2);
        }
    }

    private synchronized void getNpeMenuPop(Vector[] vec) {
        int talkcont = 0;
        int taskcont = 0;
        int cont = 0;
        for (int i2 = 0; i2 < vec.length; ++i2) {
            Vector temp = vec[i2];
            String itemtag = (String)temp.elementAt(0);
            if ("talk".equals(itemtag)) {
                ++talkcont;
                continue;
            }
            if ("task".equals(itemtag)) {
                ++taskcont;
                continue;
            }
            ++cont;
        }
        if (this.npcMenu != null) {
            this.npcMenu = null;
        }
        String buffname = "";
        buffname = taskcont > 0 && cont == 0 ? "pplt2" : (taskcont == 0 && cont > 0 ? "pplt3" : (taskcont == 0 && cont == 0 ? "pplt1" : ""));
        PopupBox box = MainMIDlet.loadPopupBox("pplt", new DataProvider());
        if ("".equals(buffname)) {
            this.npcMenu = box;
        } else {
            DataProvider data = new DataProvider();
            this.npcMenu = MainMIDlet.getBufferPopupBox(box, buffname);
            data.bind(this.npcMenu, true);
        }
        this.npcMenu.setCleanUpWhenRemoved(false);
    }

    private Vector[] addMenuItem(byte cont, DataInputStream dis) throws Exception {
        Vector[] temp = new Vector[cont];
        for (int i2 = 0; i2 < cont; ++i2) {
            temp[i2] = new Vector();
            int id = dis.readInt();
            String txt = dis.readUTF();
            String itemTag = dis.readUTF();
            temp[i2].addElement(itemTag);
            temp[i2].addElement(new Integer(id));
            temp[i2].addElement(txt);
            if ("task".equals(itemTag)) {
                int taskid = dis.readInt();
                String taskname = dis.readUTF();
                String taskState = dis.readUTF();
                temp[i2].addElement(new Integer(taskid));
                temp[i2].addElement(taskname);
                temp[i2].addElement(taskState);
                continue;
            }
            if ("talk".equals(itemTag)) {
                String content = dis.readUTF();
                temp[i2].addElement(content);
                continue;
            }
            if (!"cscpt".equals(itemTag)) continue;
            String content = dis.readUTF();
            temp[i2].addElement(content);
        }
        return temp;
    }

    private synchronized Widget addMenuItemAnd(Vector ver) throws Exception {
        String taskState = null;
        List tasklist = (List)this.npcMenu.getWidget("nmenu");
        List optlist = (List)this.npcMenu.getWidget("omenu");
        DataProvider menuItem = new DataProvider();
        int id = (Integer)ver.elementAt(1);
        menuItem.setValue("id", id);
        menuItem.setValue("txt", (String)ver.elementAt(2));
        menuItem.setValue("npc", this);
        String itemTag = (String)ver.elementAt(0);
        if ("task".equals(itemTag)) {
            Task task = new Task();
            task.set("id", (Integer)ver.elementAt(3));
            taskState = (String)ver.elementAt(5);
            task.set("name", (String)ver.elementAt(4));
            task.set("state", taskState);
            task.setNull(false);
            menuItem.setValue("task", task);
            String name = (String)ver.elementAt(4);
            if (!"over".equals(taskState)) {
                name = StringUtil.combineXml((String)ver.elementAt(4), "sp", new String[]{"ct", "tgree"});
            }
            menuItem.setValue("txt", name);
            menuItem.setValue("icon", "over".equals(taskState) ? "ui_npcm_wh.cpng" : "ui_npcm_gt.cpng");
            ListItem listitem = (ListItem)tasklist.addItem(menuItem);
            listitem.id = id;
            listitem.setOnAction("slmenu(" + itemTag + ",this.datapd)");
            return listitem;
        }
        if ("talk".equals(itemTag)) {
            String content = (String)ver.elementAt(3);
            this.script = new Script(this.getName(), content, this);
            this.script.setActionHandler(this);
            return null;
        }
        if ("cscpt".equals(itemTag)) {
            String content = (String)ver.elementAt(3);
            Script script = new Script(this.getName(), content, this);
            script.setActionHandler(this);
            menuItem.setValue("cscpt", script);
        }
        ListItem listitem = (ListItem)optlist.addItem(menuItem);
        listitem.id = id;
        listitem.setOnAction("slmenu(" + itemTag + ",this.datapd)");
        return null;
    }

    private void addMenuItemJava(Vector ver) {
        String content;
        String taskState = null;
        List list = (List)this.npcMenu.getWidget("nmenu");
        DataProvider menuItem = new DataProvider();
        int id = (Integer)ver.elementAt(1);
        menuItem.setValue("id", id);
        menuItem.setValue("txt", (String)ver.elementAt(2));
        menuItem.setValue("npc", this);
        String itemTag = (String)ver.elementAt(0);
        if ("task".equals(itemTag)) {
            Task task = new Task();
            task.set("id", (Integer)ver.elementAt(3));
            task.set("name", (String)ver.elementAt(4));
            taskState = (String)ver.elementAt(5);
            task.set("state", taskState);
            task.setNull(false);
            menuItem.setValue("task", task);
            menuItem.setValue("icon", "over".equals(taskState) ? "ui_npcm_wh.cpng" : "ui_npcm_gt.cpng");
        } else if ("talk".equals(itemTag)) {
            content = (String)ver.elementAt(3);
            this.script = new Script(this.getName(), content, this);
            this.script.setActionHandler(this);
        } else if ("cscpt".equals(itemTag)) {
            content = (String)ver.elementAt(3);
            Script script = new Script(this.getName(), content, this);
            script.setActionHandler(this);
            menuItem.setValue("cscpt", script);
        }
        ListItem listitem = (ListItem)list.addItem(menuItem);
        listitem.id = id;
        listitem.setOnAction("slmenu(" + itemTag + ",this.datapd)");
    }

    public void delMenuItem(int menuItemId) {
        List list = (List)this.npcMenu.getWidget("nmenu");
        Widget widget = list.getWidget(menuItemId);
        if (widget != null) {
            widget.remove();
        }
    }

    public void setCharacter(DCharacter character) {
        this.character = character;
    }

    public DCharacter getCharacter() {
        return this.character;
    }

    public Creature getCreature() {
        return this.creature;
    }

    public Script getScript() {
        return this.script;
    }

    public void stop() {
        if (this.character != null) {
            this.character.stop();
        }
    }

    public boolean isLeader() {
        if (this.calculateLeader) {
            return false;
        }
        return this.character.isLeader();
    }

    public void ignoreDireMove(int x, int y) {
        this.character.ignoreDireMoveLinearTo(x, y);
    }

    public void removeFromBorad() {
        this.getCharacter().removeSelf();
    }

    public boolean paintSelf(Graphics g2) {
        GraphicsUtil.drawRegion(g2, shadow, 0, 0, 0, 3);
        GraphicsUtil.drawRimString(g2, this.getName(), 0, -this.character.getHeight(), 33, 0xFFFFFF, 0, MainMIDlet.isAndroid() ? 60 : 40);
        if (this.taskNpcAnimal != null) {
            this.taskNpcAnimal.run();
            this.taskNpcAnimal.draw(g2, 0, -this.character.getHeight());
        }
        return false;
    }

    public Object onScriptAction(Script script, Object identifier, Object[] arguments) {
        if ("say".equals(identifier)) {
            Object onSayScriptAction = null;
            try {
                onSayScriptAction = this.onSayScriptAction(script, identifier, arguments);
            }
            catch (Exception e2) {
                Log.error(this.getName() + " onSayScriptAction(" + script + "," + identifier + "," + StringUtil.convertString(arguments) + ")", e2);
            }
            return onSayScriptAction;
        }
        if ("guide".equals(identifier)) {
            return this.onGuideScriptAction(script, identifier, arguments);
        }
        if ("guidentask".equals(identifier)) {
            return null;
        }
        if ("gettask".equals(identifier)) {
            NPCFrame.instance.acceptTheTask((Task)script.getCarrier());
            return null;
        }
        if ("paytask".equals(identifier)) {
            NPCFrame.instance.deliveryOfTasks((Task)script.getCarrier());
            return null;
        }
        if ("replytask".equals(identifier)) {
            logicHandle.createProtocol((byte)8, (byte)9).writeInt(((Task)script.getCarrier()).getId()).writeUTF((String)arguments[0]).send();
            return null;
        }
        if ("go".equals(identifier)) {
            String data = "go(" + StringUtil.combin(arguments, ",") + ")";
            UI.callActionMethod(UI.parseMethod(data, null));
            return null;
        }
        if ("sendpt".equals(identifier)) {
            Protocol protocol = logicHandle.createProtocol(((Integer)arguments[0]).byteValue(), ((Integer)arguments[1]).byteValue());
            for (int i2 = 2; i2 < arguments.length; ++i2) {
                if (arguments[i2] instanceof Integer) {
                    protocol.writeInt((Integer)arguments[i2]);
                    continue;
                }
                protocol.writeUTF(arguments[i2].toString());
            }
            protocol.send();
            return null;
        }
        if ("selnmenu".equals(identifier)) {
            logicHandle.createProtocol((byte)14, (byte)5).writeInt((Integer)arguments[0]).writeInt((Integer)arguments[1]).send();
            return null;
        }
        if ("onmess".equals(identifier)) {
            UI.callActionMethod(UI.parseMethod((String)arguments[0], null));
            return null;
        }
        if ("anmtplay".equals(identifier)) {
            AnimationModel model = (AnimationModel)M.instance.getResource((String)arguments[0]);
            int duration = (Integer)arguments[1];
            this.anmtMessage = (String)arguments[2];
            if (model == null) {
                if (!"".equals(this.anmtMessage) && this.anmtMessage != null) {
                    MainMIDlet.alert(this.anmtMessage, new String[]{"Quay l\u1ea1i"}, new String[]{"close"});
                }
            } else {
                PopupBox box = MainMIDlet.loadPopupBox("anmtp", null);
                box.setDuration(duration);
                ((Animation)box.getWidget("anmt")).setAnimationModel(model);
                MainMIDlet.showPopupBox(box);
                Worker.instance.pushTask(this, 8192, duration);
            }
            return null;
        }
        if ("anmtplays".equals(identifier)) {
            Widget widgetBg;
            AnimationModel model = (AnimationModel)M.instance.getResource((String)arguments[0]);
            model.setAction(0);
            int duration = (Integer)arguments[1];
            int playerid = (Integer)arguments[2];
            boolean iswon = playerid == Player.player.getId();
            Widget widget = MainMIDlet.getDesktopWidget("risk");
            if (widget == null) {
                return null;
            }
            if (iswon && (widgetBg = MainMIDlet.getDesktopWidget("rlpg")) != null) {
                UI.callActionMethod(new Method("!back"));
            }
            if (model != null) {
                Window window = MainMIDlet.loadWindow("anmtps", null);
                ((Animation)window.getWidget("anmt")).setAnimationModel(model);
                MainMIDlet.showWindow(window);
                Worker.instance.pushTask(this, 8193, duration);
            }
            return null;
        }
        return null;
    }

    private Object onSayScriptAction(Script script, Object identifier, Object[] arguments) {
        Widget ntsay;
        TextArea mess;
        boolean isAndroidSay;
        String talker;
        if (arguments.length == 1) {
            String content = (String)arguments[0];
            arguments = new Object[]{"", content, "", ""};
        }
        if ("".equals(talker = (String)arguments[0])) {
            talker = this.getName();
        } else if (talker.indexOf("{rl.name}") != -1) {
            talker = StringUtil.replace(talker, "{rl.name}", Player.player.getName());
        }
        String content = (String)arguments[1];
        String amt = (String)arguments[2];
        AnimationModel amtModel = null;
        amtModel = "".equals(amt) ? (AnimationModel)this.getAnimationModel().clone(null) : (" ".equals(amt) ? AnimationModel.createBlankModel(null) : ("{rl.cht}".equals(amt) ? (AnimationModel)Player.player.getAnimationModel().clone(null) : (AnimationModel)M.instance.getResource(amt + ".anmt").clone(null)));
        String[] items = null;
        items = "".equals(arguments[3]) ? new String[]{} : StringUtil.split((String)arguments[3], '|');
        String[] labels = new String[items.length];
        String[] actions = new String[items.length];
        int m = items.length;
        for (int i2 = 0; i2 < m; ++i2) {
            String[] split = StringUtil.split(items[i2], '=');
            if (split.length == 2) {
                actions[i2] = split[0];
                labels[i2] = split[1];
                continue;
            }
            actions[i2] = null;
            labels[i2] = split[0];
        }
        DataProvider sayProvider = new DataProvider();
        sayProvider.setValue("taker", talker);
        sayProvider.setValue("anmt", amtModel);
        sayProvider.setValue("mess", content);
        sayProvider.setValue("script", script);
        PopupBox sayDialog = MainMIDlet.loadPopupBox("nsay", null);
        if (actions.length != 0) {
            sayDialog = sayDialog.getBufferPopupBox("nsay" + actions.length);
        }
        boolean bl = isAndroidSay = MainMIDlet.isAndroid() && script == this.getScript();
        if (isAndroidSay) {
            DataProvider npcMenuDataProvider = this.npcMenu.getDataProvider();
            if (npcMenuDataProvider != null) {
                npcMenuDataProvider.setValue("taker", talker);
                npcMenuDataProvider.setValue("anmt", amtModel);
                npcMenuDataProvider.setValue("mess", content);
                npcMenuDataProvider.setValue("script", script);
            }
            sayDialog = this.npcMenu;
        } else {
            sayProvider.bind(sayDialog, true);
        }
        List list = (List)sayDialog.getWidget("meli");
        Widget guideWidget = null;
        if (list != null) {
            list.removeAllItems();
            for (int i3 = 0; i3 < actions.length; ++i3) {
                ListItem listitem = (ListItem)list.addItem((Task)script.getCarrier());
                listitem.setText(labels[i3]);
                listitem.setOnAction("slrply(" + actions[i3] + ",this.datapd)");
                if (guideWidget != null) continue;
                guideWidget = listitem;
            }
        }
        if (sayDialog.getWidget("nnext") != null && (mess = (TextArea)sayDialog.getWidget("mess")) != null) {
            mess.setHalfWordEnable(false);
        }
        sayDialog.getFocusManager().setLoop(false);
        if (!isAndroidSay) {
            RiskFrame.removeWindowNpc();
            RiskFrame.freeFind1Way();
            MainMIDlet.showPopupBox(sayDialog);
        }
        UI.getCanvas().forceRevalidate();
        NPCFrame.instance.updateNpcSayPreviousNextVisible(sayDialog);
        if (guideWidget == null && (ntsay = sayDialog.getWidget("ntsay")) != null) {
            guideWidget = ntsay;
        }
        if (guideWidget != null) {
            GuideFrame.instance.showOperateGuide(null, guideWidget, sayDialog);
        }
        if (!isAndroidSay) {
            script.pause();
        }
        Object replyValue = this.replyValue;
        this.replyValue = null;
        return replyValue == null ? "" : replyValue;
    }

    private Object onGuideScriptAction(Script script, Object identifier, Object[] arguments) {
        String screenTag = (String)arguments[0];
        String content = (String)arguments[1];
        String amt = (String)arguments[2];
        AnimationModel amtModel = null;
        if ("".equals(amt)) {
            amtModel = (AnimationModel)this.getAnimationModel().clone(null);
        } else if (" ".equals(amt)) {
            amtModel = AnimationModel.createBlankModel(null);
        } else {
            AnimationModel anim = (AnimationModel)M.instance.getClientResource(amt + ".anmt");
            if (anim != null) {
                amtModel = (AnimationModel)anim.clone(null);
            }
        }
        String[] items = null;
        items = "".equals(arguments[3]) ? new String[]{} : StringUtil.split((String)arguments[3], '|');
        String[] labels = new String[items.length];
        String[] actions = new String[items.length];
        int m = items.length;
        for (int i2 = 0; i2 < m; ++i2) {
            String[] split = StringUtil.split(items[i2], '=');
            if (split.length == 2) {
                actions[i2] = split[0];
                labels[i2] = split[1];
                continue;
            }
            actions[i2] = null;
            labels[i2] = split[0];
        }
        DataProvider guideProvider = new DataProvider();
        guideProvider.setValue("anmt", amtModel);
        guideProvider.setValue("mess", content);
        guideProvider.setValue("script", script);
        PopupBox guideDialog = MainMIDlet.loadPopupBox(screenTag, null);
        guideProvider.bind(guideDialog, true);
        List list = (List)guideDialog.getWidget("meli");
        ListItem guideWidget = null;
        if (list != null) {
            list.removeAllItems();
            for (int i3 = 0; i3 < actions.length; ++i3) {
                ListItem listitem = (ListItem)list.addItem(guideProvider);
                listitem.setText(labels[i3]);
                listitem.setOnAction("ntguide(" + actions[i3] + ",this.datapd)");
                if (guideWidget != null) continue;
                guideWidget = listitem;
            }
        }
        MainMIDlet.showPopupBox(guideDialog);
        if (guideWidget != null) {
            GuideFrame.instance.showOperateGuide(null, guideWidget, guideDialog);
        }
        script.pause();
        Object replyValue = this.replyValue;
        this.replyValue = null;
        return replyValue == null ? "" : replyValue;
    }

    public boolean onMessage(Object identifier, Object[] arguments) {
        if ("stepnpc".equals(identifier)) {
            this.showNpcMenu();
            return true;
        }
        return false;
    }

    public synchronized void showNpcMenu() {
        RiskFrame.removeWindowNpc();
        RiskFrame.freeFind1Way();
        try {
            if (BattleScene.battle != null) {
                return;
            }
            Widget guideWidget = null;
            if (MainMIDlet.isAndroid()) {
                try {
                    this.getNpeMenuPop(this.npcMenuItem);
                }
                catch (Exception e2) {
                    Log.error("sNmAnd1:" + this.npcMenuItem + ",", e2);
                }
                try {
                    if (this.npcMenuItem != null) {
                        for (int j2 = 0; j2 < this.npcMenuItem.length; ++j2) {
                            Widget menuItem = this.addMenuItemAnd(this.npcMenuItem[j2]);
                            if (menuItem == null || guideWidget != null) continue;
                            guideWidget = menuItem;
                        }
                    }
                }
                catch (Exception e3) {
                    Log.error("sNmAnd2:" + this.npcMenuItem + ",", e3);
                }
                if (this.getScript() != null) {
                    this.getScript().execute(false);
                }
            } else {
                this.getNpeMenuPop();
            }
            if (this.npcMenu != null) {
                RiskFrame.currentEntity = this;
                MainMIDlet.showPopupBox(this.npcMenu);
                if (guideWidget != null) {
                    GuideFrame.instance.showOperateGuide(null, guideWidget, this.npcMenu);
                }
            }
        }
        catch (Exception e4) {
            Log.error("Entity.showNpcMenu", e4);
        }
    }

    public boolean isAnimState(int state) {
        return false;
    }

    public void setBattState(int state) {
    }

    public AnimationModel getAnimationModel() {
        return this.character.getAnimationModel();
    }

    public void setAnimationModel(AnimationModel ani) {
        if (ani != null) {
            this.character.setAnimationModel(null);
        }
        this.character.setAnimationModel(ani);
    }

    public int getX() {
        return this.character.getX();
    }

    public int getY() {
        return this.character.getY();
    }

    public void initBattRoudVa() {
        this.battFatt = -1;
        this.battDef = 0;
        this.battExit = 0;
        this.battCall = 0;
        this.battFJ = 0;
        this.battfjHP = 0;
        this.battProt = null;
        this.baohuOpt = 0;
        this.fangyuOpt = 0;
        this.buzuoOpt = 0;
        this.isfh = 0;
    }

    public void initBattBegin() {
        this.initBattRoudVa();
        this.fhasCatch = 0;
        this.fuhOpt = 0;
        this.stopOpt = 0;
        this.hulOpt = 0;
        this.zdOpt = -1;
        this.qpOpt = 0;
        this.ysOpt = 0;
        this.zxOpt = 0;
        this.wabAttEff.removeAllElements();
        this.hotEffect.removeAllElements();
        this.useHotEffect.removeAllElements();
        this.bdSkilEffect.removeAllElements();
    }

    public void setProt(int baohPos) {
        int[] temp;
        if (this.battProt == null) {
            temp = new int[]{baohPos};
        } else {
            temp = new int[1 + this.battProt.length];
            System.arraycopy(this.battProt, 0, temp, 0, this.battProt.length);
            temp[temp.length - 1] = baohPos;
        }
        this.battProt = temp;
    }

    public void setIsDead(boolean isdead) {
        this.isdead = isdead;
    }

    public void setBattle_eff(String[] battle_eff) {
        if (this.battle_effect == null) {
            this.battle_effect = new Vector();
        }
        this.setShowBattle_eff(false);
        this.numBattleModel1 = null;
        this.numBattleModel = null;
        this.numBattleModel2 = null;
        this.effs = null;
        this.battle_effect.removeAllElements();
        this.battle_effect.addElement(battle_eff);
    }

    public boolean flushEff() {
        if (this.battle_effect != null) {
            this.battle_effect.removeAllElements();
        }
        this.numBattleModel1 = null;
        this.numBattleModel = null;
        this.numBattleModel2 = null;
        return true;
    }

    public void setCatchAmt(String amt) {
        if (amt != null && !"".equals(amt)) {
            AnimationModel temp = (AnimationModel)M.instance.getClientResource(amt);
            this.catchamt = (AnimationModel)temp.clone(null);
        }
    }

    public void runBattle_eff() {
        if (!this.isshow) {
            return;
        }
        if (this.catchamt != null && !this.catchamt.actionIsOver()) {
            this.catchamt.run();
        }
        if (this.battle_effect == null || this.battle_effect.size() <= 0) {
            return;
        }
        String[] effTemp = (String[])this.battle_effect.elementAt(0);
        if (this.effs == effTemp) {
            if (this.effs != null) {
                int vun = Integer.parseInt(this.effs[1]);
                boolean isRunover = false;
                if ("hp".equals(this.effs[0])) {
                    if (vun == 0) {
                        isRunover = this.battleWmzRun();
                    } else if (vun > 0) {
                        isRunover = this.runBattleAttNum(vun + "");
                    } else {
                        vun = Math.abs(vun);
                        isRunover = this.runBattleAttNum1(vun + "");
                    }
                } else {
                    isRunover = this.runBattleAttNum2(this.effs[1]);
                }
                if (isRunover) {
                    this.battle_effect.removeElementAt(0);
                    this.setShowBattle_eff(false);
                }
            }
        } else {
            this.effs = effTemp;
        }
    }

    public void setShowBattle_eff(boolean isshow) {
        if (!isshow) {
            // empty if block
        }
        this.isshow = isshow;
    }

    public void addEffshow(String name, AnimationModel ani) {
        if (this.effshow == null) {
            this.effshow = new LinkedHashtable();
        }
        this.effshow.put(name, ani);
    }

    public void removeEffshow(String name) {
        if (this.effshow == null) {
            this.effshow = new LinkedHashtable();
        }
        this.effshow.remove(name);
    }

    public void drawEffect(Graphics g2) {
        if (this.effshow == null) {
            return;
        }
        Enumeration en = this.effshow.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            AnimationModel ani = (AnimationModel)this.effshow.get(key);
            ani.draw(g2, this.getX(), this.getY());
        }
    }

    public void runEffect() {
        if (this.effshow == null) {
            return;
        }
        Enumeration en = this.effshow.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            AnimationModel ani = (AnimationModel)this.effshow.get(key);
            ani.run();
            if (!ani.actionIsOver()) continue;
            this.effshow.remove(key);
        }
    }

    public void setSkilName(String name) {
        if (name == null || name.equals("")) {
            this.skillName = null;
            return;
        }
        Widget aWidget = UI.getControl(this.battlePos < 9 ? "btalkr" : "btalkl");
        TextArea textAr = null;
        try {
            this.skillName = (ActionWidget)aWidget.clone(null);
            this.skillName.setSize(120, 80);
            if (MainMIDlet.isAndroid()) {
                this.skillName.setPosition(this.battlePos < 9 ? this.catchamtDx - 130 : this.catchamtDx, this.catchamtDy - this.getCharacter().getHeight());
            } else {
                this.skillName.setPosition(this.battlePos < 9 ? this.catchamtDx - 80 : this.catchamtDx, this.catchamtDy - this.getCharacter().getHeight() - 35);
            }
            textAr = (TextArea)this.skillName.getWidget("txt");
            textAr.setText(name);
            textAr.measure(this.skillName);
            this.skillnamecont = 0;
        }
        catch (Exception e2) {
            Log.error("sSkilN1:" + aWidget);
            Log.error("sSkilN2:" + this.skillName);
            Log.error("sSkilN3:" + textAr);
        }
    }

    public void drawSkilName(Graphics g2) {
        if (this.skillName == null) {
            return;
        }
        if (this.skillnamecont < 10) {
            this.skillName.paintImpl(g2);
            ++this.skillnamecont;
        } else if (this.skillnamecont == 10) {
            this.setSkilName("");
            ++this.skillnamecont;
        }
    }

    public void setTalkMes(String mes) {
        if (mes == null || "".equals(mes)) {
            this.talkWidget = null;
            return;
        }
        Widget aWidget = UI.getControl(this.battlePos < 9 ? "btalkr" : "btalkl");
        this.talkWidget = (ActionWidget)aWidget.clone(null);
        this.talkWidget.setSize(120, 80);
        if (MainMIDlet.isAndroid()) {
            this.talkWidget.setPosition(this.battlePos < 9 ? this.catchamtDx - 130 : this.catchamtDx, this.catchamtDy - this.getCharacter().getHeight());
        } else {
            this.talkWidget.setPosition(this.battlePos < 9 ? this.catchamtDx - 80 : this.catchamtDx, this.catchamtDy - this.getCharacter().getHeight() - 35);
        }
        TextArea texar = (TextArea)this.talkWidget.getWidget("txt");
        texar.setText(mes);
        texar.measure(this.talkWidget);
        this.talkMesCont = 0;
    }

    public void drawTalk(Graphics g2) {
        if (this.talkWidget == null) {
            return;
        }
        if (this.talkMesCont < 15) {
            this.talkWidget.paintImpl(g2);
            ++this.talkMesCont;
        } else if (this.talkMesCont == 15) {
            this.setTalkMes("");
            ++this.talkMesCont;
        }
    }

    public void drawBattle_eff(Graphics g2) {
        if (!this.isshow) {
            return;
        }
        if (this.catchamt != null) {
            this.catchamt.draw(g2, this.catchamtDx, this.catchamtDy);
        }
        if (this.battle_effect == null || this.battle_effect.size() <= 0) {
            return;
        }
        if (this.effs != null) {
            int state = Integer.parseInt(this.effs[2]);
            if (state == 1) {
                int y = this.getY() - this.getCharacter().getHeight() - 20;
                GraphicsUtil.drawRegion(g2, BattleScene.att_bao, 0, this.getX(), y, 3);
            }
            int vun = Integer.parseInt(this.effs[1]);
            if ("hp".equals(this.effs[0])) {
                if (vun == 0) {
                    this.paintBattleWmz(g2);
                } else if (vun > 0) {
                    this.paintBattleAttNum(g2);
                } else {
                    vun = Math.abs(vun);
                    this.paintBattleAttNum1(g2);
                }
            } else {
                this.paintBattleAttNum2(g2, this.effs[1]);
            }
        }
    }

    public void paintBattleNameHp(Graphics g2, int x, int y) {
        int finalY = Math.abs(this.getCharacter().getAnimationModel().data.top);
        if (this.isModule("mnst")) {
            int tempfinalY = y - finalY - 15;
            GraphicsUtil.drawRimString(g2, this.getName(), x, tempfinalY, 17, 0x130000, 1496831, MainMIDlet.isAndroid() ? 60 : 40);
            return;
        }
        int tempfinalY = y - finalY - 25;
        if (this.isModule("pet") || this.isModule("spet") || this.isModule("bpet")) {
            GraphicsUtil.drawRimString(g2, this.getName(), x, tempfinalY, 17, 3830020, 14089314, MainMIDlet.isAndroid() ? 60 : 40);
        } else {
            GraphicsUtil.drawRimString(g2, this.getName(), x, tempfinalY, 17, 70710, 16645882, MainMIDlet.isAndroid() ? 60 : 40);
        }
    }

    public void paintBattleHp(Graphics g2, int x, int y) {
        int finalY = Math.abs(this.getCharacter().getAnimationModel().data.top);
        int tempfinalY = y - finalY - 5;
        this.paintBattleHp(g2, x, tempfinalY, this.getCurrentHp(), this.getMaxHp());
    }

    private void paintBattleHp(Graphics g2, int x, int y, int curhp, int maxhp) {
        int dw;
        int oldcolor = g2.getColor();
        g2.setColor(12566193);
        int w = 30;
        int finalx = x - (w >> 1);
        int h2 = 7;
        g2.fillRect(finalx, y, w, h2);
        int width = w - 2;
        g2.setColor(15073297);
        g2.fillRect(finalx + 1, y + 1, width, h2 - 2);
        int n = dw = curhp >= maxhp ? width : curhp * width / maxhp;
        if (curhp <= 0) {
            dw = 1;
        } else if (dw <= 2) {
            dw = 2;
        }
        g2.setColor(16765737);
        g2.fillRect(finalx + 1, y + 1, dw, h2 - 2);
        g2.setColor(4063534);
        g2.drawRect(finalx + 1, y + 1, width - 1, h2 - 3);
        g2.setColor(oldcolor);
    }

    public void paintBattleWmz(Graphics g2) {
        if (this.att_miss != null) {
            this.att_miss.draw(g2);
        }
    }

    public boolean battleWmzRun() {
        if (this.att_miss == null) {
            AnimationModel temp = (AnimationModel)M.instance.getClientResource("ba_wmz.anmt");
            this.att_miss = (AnimationModel)temp.clone(null);
            this.att_miss.setPosition(this.catchamtDx, this.catchamtDy - this.getCharacter().getHeight() - 20);
        }
        this.att_miss.run();
        if (this.att_miss.actionIsOver()) {
            this.att_miss = null;
            return true;
        }
        return false;
    }

    public void paintBattleAttNum(Graphics g2) {
        if (this.numBattleModel != null) {
            this.numBattleModel.draw(g2);
        }
    }

    public boolean runBattleAttNum(String num) {
        if (this.numBattleModel == null) {
            AnimationModel temp = (AnimationModel)M.instance.getClientResource("ba_gj1.anmt");
            temp.setElementPattern("1234567890", 7);
            this.numBattleModel = (AnimationModel)temp.clone(null, true);
            this.numBattleModel.setElementPosition(this.catchamtDx, this.catchamtDy - this.getCharacter().getHeight());
            this.numBattleModel.setElementValue(num);
        }
        this.numBattleModel.run();
        if (this.numBattleModel.actionIsOver()) {
            this.numBattleModel = null;
            return true;
        }
        return false;
    }

    public void paintBattleAttNum1(Graphics g2) {
        if (this.numBattleModel1 != null) {
            this.numBattleModel1.draw(g2);
        }
    }

    public boolean runBattleAttNum1(String num) {
        if (this.numBattleModel1 == null) {
            AnimationModel temp = (AnimationModel)M.instance.getClientResource("ba_gj2.anmt");
            temp.setElementPattern("1234567890", 7);
            this.numBattleModel1 = (AnimationModel)temp.clone(null, true);
            this.numBattleModel1.setElementPosition(this.getX(), this.getY() - this.getCharacter().getHeight());
            this.numBattleModel1.setElementValue(num);
        }
        this.numBattleModel1.run();
        if (this.numBattleModel1.actionIsOver()) {
            this.numBattleModel1 = null;
            return true;
        }
        return false;
    }

    public void paintBattleAttNum2(Graphics g2, String num) {
        if (this.numBattleModel2 != null) {
            this.numBattleModel2.draw(g2);
        }
    }

    public boolean runBattleAttNum2(String num) {
        if (this.numBattleModel2 == null) {
            AnimationModel temp = (AnimationModel)M.instance.getClientResource("ba_eff.anmt");
            temp.setElementPattern("1234567890+-", 7);
            this.numBattleModel2 = (AnimationModel)temp.clone(null, true);
            this.numBattleModel2.setElementPosition(this.catchamtDx, this.catchamtDy - this.getCharacter().getHeight());
            this.numBattleModel2.setElementValue(num);
        }
        this.numBattleModel2.run();
        if (this.numBattleModel2.actionIsOver()) {
            this.numBattleModel2 = null;
            return true;
        }
        return false;
    }

    public void set(String tagName, int value) {
        super.set(tagName, value);
        if ("maxhp".equals(tagName) || "hp".equals(tagName)) {
            this.update("cbhp");
            return;
        }
        if ("maxmp".equals(tagName) || "mp".equals(tagName)) {
            this.update("cbmp");
            return;
        }
    }

    public void set(String tagName, long value) {
        super.set(tagName, value);
        if ("mxexp".equals(tagName) || "exp".equals(tagName)) {
            this.update("cbexp");
            return;
        }
    }

    public Object getUserDefinedValue(String property) {
        if ("cbhp".equals(property)) {
            return this.getCombinationValue("hp", "maxhp");
        }
        if ("cbmp".equals(property)) {
            return this.getCombinationValue("mp", "maxmp");
        }
        if ("cbexp".equals(property)) {
            return this.getCombinationValue("exp", "mxexp");
        }
        if ("cbhuol".equals(property)) {
            return this.getCombinationValue("huol", "huolm");
        }
        return super.getUserDefinedValue(property);
    }

    public Object getCombinationValue(String property1, String property2) {
        Object firstObj = super.getUserDefinedValue(property1);
        Object secondObj = super.getUserDefinedValue(property2);
        if (firstObj == null || secondObj == null) {
            return null;
        }
        return firstObj + "\uff0f" + secondObj;
    }

    public boolean procError(Protocol pt) {
        return false;
    }

    public boolean procSucc(Protocol pt) {
        return false;
    }

    public Entity clone(Entity target) {
        Entity entity = target;
        if (entity == null) {
            entity = new Entity();
        }
        super.clone(entity);
        entity.battlePos = this.battlePos;
        entity.battFatt = this.battFatt;
        entity.battDef = this.battDef;
        entity.battProt = this.battProt;
        entity.fhasCatch = this.fhasCatch;
        entity.battExit = this.battExit;
        entity.battFJ = this.battFJ;
        entity.wabAttEff = this.wabAttEff;
        entity.hotEffect = this.hotEffect;
        entity.useHotEffect = this.useHotEffect;
        entity.bdSkilEffect = this.bdSkilEffect;
        return entity;
    }

    public void freeEffect() {
        this.wabAttEff.removeAllElements();
        this.hotEffect.removeAllElements();
        this.useHotEffect.removeAllElements();
    }

    public void initSingleBSkill() {
    }

    public int getLevel() {
        return this.getInt("grade");
    }

    public int getXiuWei() {
        return this.getInt("xiuw") < 0 ? 0 : this.getInt("xiuw");
    }

    public boolean isShowInMenu() {
        byte idis = this.getByte("idis");
        return idis != 1;
    }

    public void onRemove(int taskindex) {
    }

    public boolean run(int taskindex) {
        if (taskindex == 8192) {
            if (!"".equals(this.anmtMessage) && this.anmtMessage != null) {
                MainMIDlet.alert(this.anmtMessage, new String[]{"Quay l\u1ea1i"}, new String[]{"close"});
            }
            return true;
        }
        if (taskindex == 8193) {
            Window windows = (Window)MainMIDlet.getDesktopWidget("anmtps");
            if (windows != null) {
                windows.remove();
            }
            return true;
        }
        return false;
    }

    public String getTaskName() {
        return "EntityTask " + this.getName();
    }
}

