/*
 * Decompiled with CFR 0.152.
 */
package com.ea.product.world;

import com.ea.engine.game._2d2.DCharacter;
import com.ea.engine.model.AnimationModel;
import com.ea.engine.model.M;
import com.ea.engine.worker.WorkerPool;
import com.ea.engine.worker.WorkerTask;
import com.ea.io.net.Protocol;
import com.ea.product.MainMIDlet;
import com.ea.product.module.Config;
import com.ea.product.module.Effect;
import com.ea.product.module.Group;
import com.ea.product.module.Item;
import com.ea.product.world.Entity;
import com.ea.product.world.Player;
import com.ea.product.world.RiskScene;
import com.ea.util.Log;
import com.ea.util.graphics.GraphicsUtil;
import com.ea.util.structure.LinkedHashtable;
import com.ea.util.structure.LinkedList;
import com.ea.util.structure.LinkedListItem;
import java.io.DataInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;

public class Ghost
extends Entity {
    public static final int PET_SKILL_NUM = 16;
    public static final int BATT_HEAD = 6;
    public static final int BATT_DEAD = 7;
    public static final byte BATT_FLAG = 1;
    public static final byte RISK_VIEW = 2;
    private AnimationModel headani;
    private AnimationModel alive;
    private static final String[] PET_UPDATE_ATTR = new String[]{"qiane", "hp", "maxhp", "mp", "maxmp", "strth", "sprit", "habit", "endur", "agil", "wlgj", "fsgj", "wlfy", "fsfy", "wlbj", "fsbj", "sd", "mz", "sb", "fk", "grade", "exp", "mxexp", "hpzz", "sdzz", "wgzz", "fgzz", "wfzz", "ffzz"};
    public LinkedHashtable petSkill;
    public Hashtable petEquipHash;

    public Ghost() {
        this.character = new DCharacter();
    }

    public Ghost(DataInputStream dis, String tag) {
        this();
        try {
            this.init(dis, tag);
            this.initCharacter();
        }
        catch (Exception e2) {
            Log.error("Ghost<init> " + this.getName(), e2);
        }
    }

    public boolean isBattle() {
        return (this.getByte("batt") & 1) == 1;
    }

    public boolean isView() {
        return (this.getByte("batt") & 2) == 2;
    }

    public void initCharacter() {
        if (this.character == null) {
            return;
        }
        try {
            this.character.setName(this.getName());
            if (this.character.getAnimationModel() == null) {
                AnimationModel model = super.getGhostAnimationModel();
                this.character.setAnimationModel((AnimationModel)model.clone(null));
            }
            this.character.setDefaultDire((byte)8);
            this.character.setCurDire((byte)8);
            this.character.setAction(0);
            this.character.setCharacterListener(this);
        }
        catch (Exception e2) {
            Log.error("Ghost.initCharacter " + this.getName(), e2);
        }
    }

    public AnimationModel getGhostHead() {
        if (this.headani == null) {
            AnimationModel model = this.getGhostAnimationModel();
            this.headani = (AnimationModel)model.clone(null);
            this.headani.setAction(6);
        }
        return this.headani;
    }

    public AnimationModel getGhostHeadNew() {
        AnimationModel model = this.getGhostAnimationModel();
        this.headani = (AnimationModel)model.clone(null);
        this.headani.setAction(6);
        return this.headani;
    }

    public AnimationModel getGhostAnimationModel() {
        if (this.character != null && this.character.getAnimationModel() != null) {
            return this.character.getAnimationModel();
        }
        return super.getGhostAnimationModel();
    }

    public AnimationModel getGhostNewAniModel() {
        return super.getGhostAnimationModel();
    }

    public void removeFromBorad() {
        super.removeFromBorad();
        AnimationModel model = this.getCharacter().getAnimationModel();
        if (model != null) {
            M.instance.removeMarkGroupResource("mt_", model.id);
        }
    }

    public boolean isAnimState(int state) {
        switch (state) {
            case 0: {
                return this.getAnimationModel().getAction() == 0;
            }
            case 1: {
                return this.getAnimationModel().getAction() == 1;
            }
            case 2: {
                return this.getAnimationModel().getAction() == 2;
            }
            case 3: {
                return this.getAnimationModel().getAction() == 3;
            }
            case 4: {
                return this.getAnimationModel().getAction() == 4;
            }
            case 5: {
                return this.getAnimationModel().getAction() == 5;
            }
            case 7: {
                return this.isdead;
            }
            case 9: {
                if (this.alive != null) {
                    this.setAnimationModel(this.alive);
                    this.alive = null;
                }
                this.isdead = false;
                return this.getAnimationModel().getAction() == 0;
            }
        }
        return false;
    }

    public void setBattState(int state) {
        if (this.isAnimState(state)) {
            return;
        }
        try {
            switch (state) {
                case 0: {
                    this.character.setAction(0);
                    break;
                }
                case 1: {
                    this.character.setAction(1);
                    break;
                }
                case 2: {
                    this.character.setAction(2);
                    break;
                }
                case 3: {
                    this.character.setAction(3);
                    break;
                }
                case 4: {
                    this.character.setAction(4);
                    break;
                }
                case 5: {
                    this.character.setAction(5);
                    break;
                }
                case 7: {
                    if (!this.isModule("mnst")) {
                        this.alive = this.getAnimationModel();
                        AnimationModel dead = (AnimationModel)M.instance.getClientResource("ef_wing.anmt");
                        this.character.setAnimationModel((AnimationModel)dead.clone(null));
                    }
                    this.isdead = true;
                    break;
                }
                case 9: {
                    this.isdead = false;
                    this.character.setAction(0);
                }
            }
        }
        catch (Exception e2) {
            Log.error("Ghost setB " + state, e2);
        }
    }

    public void updateGrade(Protocol pt) {
        for (int i2 = 0; i2 < PET_UPDATE_ATTR.length; ++i2) {
            this.set(PET_UPDATE_ATTR[i2], pt.getInputStream());
        }
    }

    public LinkedList getPetSkil() {
        return ((Group)this.creature.getModule("skils")).getModules();
    }

    public void addPetSkill(Item skill) {
        if (skill == null || skill.isNull()) {
            return;
        }
        this.getPetSkil().add(skill);
    }

    public void removePetSkill(int skillId) {
        Item skillItem = null;
        for (LinkedListItem curItem = this.getPetSkil().getFirst(); curItem != null; curItem = curItem.getNext()) {
            if (((Item)curItem).getId() != skillId) continue;
            skillItem = (Item)curItem;
            break;
        }
        if (skillItem != null) {
            this.getPetSkil().remove(skillItem);
            skillItem = null;
        }
    }

    public LinkedHashtable getPetSkilShow() {
        LinkedHashtable link = new LinkedHashtable();
        for (LinkedListItem curItem = this.getPetSkil().getFirst(); curItem != null; curItem = curItem.getNext()) {
            Item cskil = (Item)curItem;
            if (cskil.getString("zylx").equals("bdjn")) continue;
            Item skil = (Item)cskil.clone(null);
            link.put(new Integer(skil.getId()), skil);
        }
        return link;
    }

    public void initSingleBSkill() {
        if (this.isModule("mnst")) {
            return;
        }
        LinkedList list = this.getPetSkil();
        for (LinkedListItem litem = list.getFirst(); litem != null; litem = litem.getNext()) {
            Item skil = (Item)litem;
            String zylx = skil.getString("zylx");
            String kyx = skil.getString("kyx");
            byte canus = skil.getByte("caus");
            if (canus == 0 || !"bdjn".equals(zylx) || "nbat".equals(kyx) || "none".equals(kyx)) continue;
            LinkedList effectList = skil.getItemEffectrs();
            for (LinkedListItem item = effectList.getFirst(); item != null; item = item.getNext()) {
                Effect eTemp = (Effect)item;
                this.bdSkilEffect.addElement(eTemp.clone(null));
            }
        }
    }

    public void set(String tagName, int value) {
        super.set(tagName, value);
        if ("hpzz".equals(tagName) || "hpzzm".equals(tagName)) {
            this.update("cbhpzz");
            return;
        }
        if ("sdzz".equals(tagName) || "sdzzm".equals(tagName)) {
            this.update("cbsdzz");
            return;
        }
        if ("wgzz".equals(tagName) || "wgzzm".equals(tagName)) {
            this.update("cbwgzz");
            return;
        }
        if ("wfzz".equals(tagName) || "wfzzm".equals(tagName)) {
            this.update("cbwfzz");
            return;
        }
        if ("fgzz".equals(tagName) || "fgzzm".equals(tagName)) {
            this.update("cbfgzz");
            return;
        }
        if ("ffzz".equals(tagName) || "ffzzm".equals(tagName)) {
            this.update("cbffzz");
            return;
        }
        if ("grate".equals(tagName) || "gratm".equals(tagName)) {
            this.update("cbczl");
            return;
        }
        if ("zc".equals(tagName) || "zcm".equals(tagName)) {
            this.update("cbzcd");
            return;
        }
    }

    public Object getUserDefinedValue(String property) {
        if ("cbhpzz".equals(property)) {
            return this.getCombinationValue("hpzz", "hpzzm");
        }
        if ("cbsdzz".equals(property)) {
            return this.getCombinationValue("sdzz", "sdzzm");
        }
        if ("cbwgzz".equals(property)) {
            return this.getCombinationValue("wgzz", "wgzzm");
        }
        if ("cbwfzz".equals(property)) {
            return this.getCombinationValue("wfzz", "wfzzm");
        }
        if ("cbfgzz".equals(property)) {
            return this.getCombinationValue("fgzz", "fgzzm");
        }
        if ("cbffzz".equals(property)) {
            return this.getCombinationValue("ffzz", "ffzzm");
        }
        if ("cbczl".equals(property)) {
            return this.getCombinationValue("grate", "gratm");
        }
        if ("cbzcd".equals(property)) {
            return this.getCombinationValue("zc", "zcm");
        }
        if ("race".equals(property)) {
            return Config.jobName(this.getString("race"));
        }
        if ("bosom".equals(property) || "neckp".equals(property) || "hufu".equals(property)) {
            return this.getPetEquip(property);
        }
        if ("psrc".equals(property)) {
            String name = Config.getPetType(this.getString(property));
            if (name == null) {
                return null;
            }
            return M.instance.getResource(name + ".cpng");
        }
        if ("bianxin".equals(property)) {
            if (this.getByte("morp") == 0) {
                return null;
            }
            return M.instance.getClientResource("ui_bianxing.cpng");
        }
        if ("xiux".equals(property)) {
            return "Ngh\u1ec9 ";
        }
        if ("shui".equals(property)) {
            return "Thu h\u1ed3i";
        }
        if ("chuz".equals(property)) {
            return "Xu\u1ea5t chi\u1ebfn";
        }
        if ("zshi".equals(property)) {
            return "M\u1edf ra";
        }
        if ("anmt".equals(property)) {
            AnimationModel ghostAnimationModel = this.getGhostAnimationModel();
            if ("mt_jz_00.anmt".equals(ghostAnimationModel.id)) {
                return null;
            }
            return ghostAnimationModel;
        }
        if ("lock1".equals(property)) {
            if (this.isNull()) {
                return null;
            }
            byte lock = this.getByte("lock");
            if (!(MainMIDlet.isAndroid() || MainMIDlet.isAndroid480() || MainMIDlet.isNokiaN97())) {
                return null;
            }
            if (lock == 2) {
                return "ui_locked.cpng";
            }
            if (lock == 1) {
                return "ui_locked_02.cpng";
            }
            return null;
        }
        return super.getUserDefinedValue(property);
    }

    public void addPetEqu(String pos, Item equip) {
        if (this.petEquipHash == null) {
            this.petEquipHash = new Hashtable();
        }
        this.petEquipHash.put(pos, equip);
    }

    public Item getPetEquip(String pos) {
        if (this.petEquipHash == null) {
            this.petEquipHash = new Hashtable();
        }
        if (this.petEquipHash.containsKey(pos)) {
            return (Item)this.petEquipHash.get(pos);
        }
        Item item = new Item();
        item.set("icon", Config.equpPosImageName(pos));
        this.petEquipHash.put(pos, item);
        return item;
    }

    public void freePetEquipData() {
        if (this.petEquipHash != null) {
            this.petEquipHash.clear();
        } else {
            this.petEquipHash = new Hashtable();
        }
    }

    public Item getWearEquById(int id) {
        if (this.petEquipHash == null) {
            return null;
        }
        Enumeration enume = this.petEquipHash.elements();
        while (enume.hasMoreElements()) {
            Item item = (Item)enume.nextElement();
            if (item.getId() != id) continue;
            return item;
        }
        return null;
    }

    public void freePetSkillData() {
        this.petEquipHash.clear();
    }

    public Hashtable getPetEquipHash() {
        return this.petEquipHash;
    }

    public void setPetEquipHash(Hashtable petEquipHash) {
        this.petEquipHash = petEquipHash;
    }

    public boolean procSucc(final Protocol pt) {
        switch (pt.combineCommand()) {
            case 3343: {
                WorkerPool.instance.pushPoolTask(new WorkerTask(){

                    public boolean run(int taskInnerId) {
                        Ghost.this.init(pt.getInputStream(), "spet");
                        Ghost.this.initCharacter();
                        return true;
                    }

                    public void onRemove(int taskInnerId) {
                    }

                    public String getTaskName() {
                        return "GhostSuccTask " + Ghost.this.getName();
                    }
                }, 0, 300L);
                WorkerPool.instance.start();
                return true;
            }
        }
        return super.procSucc(pt);
    }

    public boolean paintSelf(Graphics g2) {
        DCharacter cht = Player.player.getCharacter();
        if (cht.contain(this.character)) {
            GraphicsUtil.drawRegion(g2, Entity.shadow, 0, 0, 0, 3);
            return false;
        }
        if (RiskScene.isOpenAnmt == 2) {
            return true;
        }
        int nearRadius = 3;
        if (RiskScene.isOpenAnmt == 1 && (Math.abs(this.character.getCol() - cht.getCol()) > nearRadius || Math.abs(this.character.getRow() - cht.getRow()) > nearRadius)) {
            return true;
        }
        GraphicsUtil.drawRegion(g2, Entity.shadow, 0, 0, 0, 3);
        return false;
    }

    public Entity clone(Entity target) {
        Ghost ghost = (Ghost)target;
        if (ghost == null) {
            ghost = new Ghost();
        }
        super.clone(ghost);
        return ghost;
    }
}

