/*
 * Decompiled with CFR 0.152.
 */
package com.ea.product.world;

import com.ea.engine.game._2d2.DCharacter;
import com.ea.engine.model.AnimationModel;
import com.ea.engine.model.ImageModel;
import com.ea.engine.model.M;
import com.ea.engine.script.ScriptActionHandler;
import com.ea.engine.ui.UI;
import com.ea.engine.ui.widget.ListItem;
import com.ea.engine.ui.widget.Screen;
import com.ea.engine.worker.WorkerPool;
import com.ea.engine.worker.WorkerTask;
import com.ea.io.net.Protocol;
import com.ea.product.MainMIDlet;
import com.ea.product.frame.BattleFrame;
import com.ea.product.frame.RiskFrame;
import com.ea.product.frame.RoleFrame;
import com.ea.product.module.Config;
import com.ea.product.module.Effect;
import com.ea.product.module.Group;
import com.ea.product.module.Item;
import com.ea.product.module.Itemz;
import com.ea.product.module.Module;
import com.ea.product.module.Package;
import com.ea.product.module.Task;
import com.ea.product.world.Entity;
import com.ea.product.world.Ghost;
import com.ea.product.world.RiskScene;
import com.ea.util.Log;
import com.ea.util.graphics.GraphicsUtil;
import com.ea.util.structure.LinkedHashtable;
import com.ea.util.structure.LinkedList;
import com.ea.util.structure.LinkedListItem;
import com.ea.util.text.StringUtil;
import java.io.DataInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Player
extends Entity
implements ScriptActionHandler {
    public static final String[] AVATAR_CACHE = new String[]{"rlt_m_", "rlt_f_", "rly_sn_m_", "rly_sn_f_", "rly_ty_m_", "rly_ty_f_", "rly_wj_m_", "rly_wj_f_", "rly_ym_m_", "rly_ym_f_", "rlw_sn_m_", "rlw_sn_f_", "rlw_ty_m_", "rlw_ty_f_", "rlw_wj_m_", "rlw_wj_f_", "rlw_ym_m_", "rlw_ym_f_", "fx_"};
    public static final int PACKAGE_NUM = 4;
    public static final int BATTLE_COUNT = 3;
    private int player_battle_rand = 4;
    public static final int BATT_FLY = 6;
    public static final int BATT_HEAD = 7;
    public static final int BATT_DEAD = 8;
    public static final int PET_MAX_NUM = 8;
    public static final int PET_DEPOT_MAXNUM = 8;
    private short state;
    public static final short STATE_OFFLINE = 1;
    public static final short STATE_AWAY = 2;
    public static final short STATE_BATTLE = 4;
    public static final short STATE_STALL = 8;
    public static final short STATE_FLAY = 16;
    public static final short STATE_VIP = 32;
    public static final short STATE_BLACKNAME = 64;
    public static final String FABAO_TAG = "fabao_";
    public String fab_morph = "";
    public static Player player;
    public Image headImage;
    public boolean drawCollBar = false;
    private byte isclose;
    private byte iszdxl;
    private byte iszdbz;
    private boolean isBattle = false;
    private AnimationModel playerSrcAni;
    public String oldFb = "";
    private AnimationModel fxani;
    public static final String[] grade_attribute;
    public Object[][] xf_stru;
    public int[][] xf_skilid;
    public LinkedHashtable studySkill;
    public LinkedHashtable fbskill;
    public LinkedHashtable receiveTaskHash = new LinkedHashtable();
    public LinkedHashtable canAcceptTaskHash = new LinkedHashtable();
    public Vector taskGuideVec = new Vector(2, 2);
    public LinkedHashtable productionSkillHash = new LinkedHashtable();
    public String[] equPosStr = new String[]{"head", "bosom", "feet", "hand", "wrist", "belt", "waist", "finger", "neck"};
    private Hashtable equHash;
    private Hashtable hashSuit;
    private Hashtable hashFumo;
    private LinkedHashtable hashZhenf;
    public LinkedHashtable petHash;
    private LinkedHashtable petHashClone;
    private Ghost attPet;
    private Ghost viewPet;
    private static boolean isSendBattle;
    private long times = 0L;
    private AnimationModel alive;
    private int flyOffHeight = 0;
    private int flyNameOffHeight = 0;
    public static final int PACKGS_NUM = 4;
    private Package[] packgs;
    private Package[] packgsClone;

    public boolean isClose() {
        return this.isclose == 1;
    }

    public boolean isZdxl() {
        return this.iszdxl == 1;
    }

    public boolean isZdbz() {
        return this.iszdbz == 1;
    }

    public void setClose(byte close) {
        this.isclose = close;
    }

    public void setZdxl(byte zdxl) {
        this.iszdxl = zdxl;
    }

    public void setZdbz(byte zdbz) {
        this.iszdbz = zdbz;
    }

    public static boolean isCloseAndXl() {
        return player != null && player.isClose() && player.isZdxl();
    }

    public Player() {
        this.character = new DCharacter();
        this.drawCollBar = false;
    }

    public Player(DataInputStream dis, String tag) {
        this();
        try {
            this.init(dis, tag);
            this.initCharacter();
        }
        catch (Exception e2) {
            Log.error("Player<init> " + this.getName(), e2);
        }
    }

    public Player(DataInputStream dis, String tag, boolean isBatt) {
        this();
        this.init(dis, tag);
        this.isBattle = isBatt;
        if (this.isBianshen()) {
            this.intBsChar(this.getString("fbxx"));
        } else {
            this.initCharacter();
        }
    }

    public void initCharacter() {
        if (this.character == null) {
            return;
        }
        try {
            this.character.setName(this.getName());
            AnimationModel model = (AnimationModel)M.instance.getClientResource("rl_" + this.creature.getJob() + "_" + this.creature.getSex() + ".anmt");
            this.character.setAnimationModel((AnimationModel)model.clone(null, true));
            this.character.setCharacterListener(this);
            this.updataCharacter();
        }
        catch (Exception e2) {
            Log.error("Player.initCharacter " + this.getName(), e2);
        }
    }

    public void getCharacterHead() {
        if (Player.player.headImage == null) {
            StringBuffer sb = new StringBuffer();
            if (MainMIDlet.isAndroid()) {
                sb.append("ui_").append(this.creature.getJob()).append(this.creature.getSex()).append(".cpng");
            } else {
                sb.append("rlt_").append(this.creature.getSex()).append("_").append(this.creature.getString("head")).append(".cpng");
            }
            this.headImage = M.instance.getClientResource(sb.toString()).getImage();
        }
    }

    public void updataCharacter() {
        if (this.character.getAnimationModel() != null) {
            this.character.getAnimationModel().setImages(this.getCharacterImages());
        }
    }

    public void updateFabo() {
        try {
            String chipName;
            this.oldFb = chipName = this.creature.getString("fbxx");
            if ("".equals(chipName)) {
                chipName = null;
            }
            this.updataCharacter();
        }
        catch (Exception e2) {
            Log.error("updateFabo", e2);
        }
    }

    private void intBsChar(String chipName) {
        AnimationModel tempFx = (AnimationModel)M.instance.getGroupResource("mt_", chipName + ".anmt", this != player);
        AnimationModel mt_ani = (AnimationModel)tempFx.clone(null);
        if (this.playerSrcAni == null) {
            this.playerSrcAni = this.getAnimationModel();
        }
        this.setAnimationModel(mt_ani);
        this.getCharacter().setDefaultDire((byte)8);
    }

    public void updateFboMt() {
        try {
            String chipName = "";
            if ("".equals(this.creature.getString("fbxx"))) {
                chipName = null;
            } else {
                this.fab_morph = chipName = this.creature.getString("fbxx");
            }
            boolean isFly = this.isAnimState(6);
            if (isFly) {
                this.setBattState(0);
            }
            if (chipName != null && !chipName.startsWith(FABAO_TAG)) {
                this.intBsChar(chipName);
            } else {
                this.setAnimationModel(this.playerSrcAni);
                this.updataCharacter();
                this.getCharacter().setDefaultDire((byte)4);
                this.playerSrcAni = null;
                this.fab_morph = "";
            }
            if (isFly) {
                this.setBattState(6);
            }
        }
        catch (Exception e2) {
            Log.error("updateFboMt", e2);
        }
    }

    public boolean isBianshen() {
        String fabo = this.getString("fbxx");
        return !"".equals(fabo) && !fabo.startsWith(FABAO_TAG);
    }

    public void updateFlyx() {
        String chipName = "";
        chipName = "".equals(this.creature.getString("flyf")) ? null : this.creature.getString("flyf");
        if (chipName != null) {
            AnimationModel tempFx = (AnimationModel)M.instance.getGroupResource("fx_", chipName + ".anmt", this != player);
            this.fxani = (AnimationModel)tempFx.clone(null);
            this.getCharacter().setMoveSpeed(8, 8);
            this.setBattState(6);
        } else if (this.isAnimState(6)) {
            int canmovx = 0;
            int canmovy = 0;
            boolean canmove = RiskScene.risk.getBoard().canTileMove(this.getCharacter().getCol(), this.getCharacter().getRow());
            if (!canmove) {
                int j2;
                int m;
                int i2;
                int n;
                int startx = this.getCharacter().getCol();
                int starty = this.getCharacter().getRow();
                int n2 = n = startx - 30 > 0 ? startx - 30 : 0;
                for (i2 = startx; i2 > n; --i2) {
                    m = starty + 30;
                    for (j2 = starty; j2 < m; ++j2) {
                        canmove = RiskScene.risk.getBoard().canTileMove(i2, j2);
                        if (!canmove) continue;
                        canmovx = i2;
                        canmovy = j2;
                        break;
                    }
                    if (canmove) break;
                    int n3 = m = starty - 30 > 0 ? starty - 30 : 0;
                    for (j2 = starty; j2 > m; --j2) {
                        canmove = RiskScene.risk.getBoard().canTileMove(i2, j2);
                        if (!canmove) continue;
                        canmovx = i2;
                        canmovy = j2;
                        break;
                    }
                    if (canmove) break;
                }
                if (!canmove) {
                    n = startx + 30;
                    for (i2 = startx; i2 > n; ++i2) {
                        m = starty + 30;
                        for (j2 = starty; j2 < m; ++j2) {
                            canmove = RiskScene.risk.getBoard().canTileMove(i2, j2);
                            if (!canmove) continue;
                            canmovx = i2;
                            canmovy = j2;
                            break;
                        }
                        if (canmove) break;
                        int n4 = m = starty - 30 > 0 ? starty - 30 : 0;
                        for (j2 = starty; j2 > m; --j2) {
                            canmove = RiskScene.risk.getBoard().canTileMove(i2, j2);
                            if (!canmove) continue;
                            canmovx = i2;
                            canmovy = j2;
                            break;
                        }
                        if (canmove) break;
                    }
                }
                if (canmove) {
                    this.getCharacter().setTilePosition(canmovx, canmovy);
                    RiskScene.risk.getBoard().resetPaintBuffer();
                }
            }
            this.fxani = null;
            this.getCharacter().setMoveSpeed(6, 6);
            this.setBattState(0);
        }
    }

    private ImageModel[] getCharacterImages() {
        String[] chips_name = this.character.getAnimationModel().data.chips_name;
        ImageModel[] images = new ImageModel[chips_name.length];
        int m = chips_name.length;
        for (int i2 = 0; i2 < m; ++i2) {
            String groupName = null;
            String chipName = chips_name[i2];
            String[] groupChipName = this.getGroupChipName(chipName);
            groupName = groupChipName[0];
            chipName = groupChipName[1];
            if (chipName != null) {
                if (groupName != null) {
                    images[i2] = (ImageModel)M.instance.getGroupResource(groupName, chipName + ".cpng", this != player);
                    continue;
                }
                images[i2] = (ImageModel)M.instance.getClientResource(chipName + ".cpng");
                continue;
            }
            images[i2] = null;
        }
        return images;
    }

    private String[] getGroupChipName(String tag) {
        String groupName = null;
        String chipName = tag;
        if (chipName.startsWith("rlt")) {
            groupName = "rlt_" + this.creature.getSex() + "_";
            chipName = groupName + this.creature.getHeadIndex();
        } else if (chipName.startsWith("rly")) {
            groupName = "rly_" + this.creature.getJob() + "_" + this.creature.getSex() + "_";
            chipName = groupName + this.creature.getClotIndex();
        } else if (chipName.startsWith("rlw")) {
            groupName = "rlw_" + this.creature.getJob() + "_" + this.creature.getSex() + "_";
            chipName = "".equals(this.creature.getWeaIndex()) ? groupName + "00" : this.creature.getWeaIndex();
        } else if (!chipName.startsWith("fx_")) {
            if (chipName.startsWith("sin_")) {
                chipName = "".equals(this.creature.getString("shin")) ? null : this.creature.getString("shin");
            } else if (chipName.startsWith(FABAO_TAG)) {
                String fabo = this.creature.getString("fbxx");
                chipName = !fabo.startsWith(FABAO_TAG) ? null : fabo;
            } else if (!chipName.equals("skil_youminghuo") && !this.isBattle) {
                chipName = null;
            }
        }
        return new String[]{groupName, chipName};
    }

    public void removeFromBorad() {
        super.removeFromBorad();
        String[] cleanGroupRescources = new String[]{"rlt", "rly", "rlw", "fx"};
        int m = cleanGroupRescources.length;
        for (int i2 = 0; i2 < m; ++i2) {
            String[] groupChipName = this.getGroupChipName(cleanGroupRescources[i2]);
            String groupName = groupChipName[0];
            String chipName = groupChipName[1];
            if (groupName == null || chipName == null) continue;
            M.instance.removeMarkGroupResource(groupName, chipName + ".cpng");
        }
    }

    public void initController() {
        this.setRand(3);
        player = this;
    }

    public void setRand(int rand) {
        this.player_battle_rand = rand;
        this.getCharacter().setEnemyRate(this.player_battle_rand);
    }

    public void setState(short state) {
        boolean oldStall = this.isStall();
        this.state = state;
        if (player.getId() == this.getId() && this.isVip()) {
            Screen screen = UI.getCurrentScreen();
            if ("rlpg".equals(screen.name)) {
                ((ListItem)screen.getWidget("pag3")).setEnabled(true);
            }
        }
        if (!oldStall && this.isStall()) {
            this.setBattState(0);
        }
    }

    public boolean isOffline() {
        return (this.state & 1) == 1;
    }

    public boolean isAway() {
        return (this.state & 2) == 2;
    }

    public boolean inBattle() {
        return (this.state & 4) == 4;
    }

    public void setBattleOver() {
        this.state = (short)(this.state & 0xFFFFFFFB);
    }

    public boolean isStall() {
        return (this.state & 8) == 8;
    }

    public boolean isFly() {
        return (this.state & 0x10) == 16;
    }

    public boolean isVip() {
        return (this.state & 0x20) == 32;
    }

    public boolean isBlackName() {
        return (this.state & 0x40) == 64;
    }

    public void upGrade(Protocol pt) {
        for (int i2 = 0; i2 < grade_attribute.length; ++i2) {
            this.set(grade_attribute[i2], pt.getInputStream());
        }
    }

    public void initSkillData() {
        this.studySkill = new LinkedHashtable();
    }

    public LinkedHashtable getSkillShow() {
        LinkedHashtable link = new LinkedHashtable();
        int n = this.studySkill.size();
        for (int i2 = 0; i2 < n; ++i2) {
            Item skil = (Item)this.studySkill.elementAt(i2);
            byte canus = skil.getByte("caus");
            String zylx = skil.getString("zylx");
            if (canus == 0 || "huic".equals(zylx) || "bdjn".equals(zylx)) continue;
            link.put(new Integer(skil.getId()), skil.clone(null));
        }
        Item itemfb = player.getFbItem();
        if (itemfb != null && !itemfb.isNull()) {
            int fblevel = itemfb.getInt("level");
            int n2 = this.fbskill.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                Item skil = (Item)this.fbskill.elementAt(i3);
                short skilGrade = skil.getShort("grade");
                String zylx = skil.getString("zylx");
                if ("bdjn".equals(zylx) || skilGrade > fblevel) continue;
                link.put(new Integer(skil.getId()), skil.clone(null));
            }
        }
        return link;
    }

    public void initSingleBSkill() {
        int n = this.studySkill.size();
        for (int i2 = 0; i2 < n; ++i2) {
            Item skil = (Item)this.studySkill.elementAt(i2);
            String zylx = skil.getString("zylx");
            String kyx = skil.getString("kyx");
            byte canus = skil.getByte("caus");
            if (canus == 0 || !"bdjn".equals(zylx) || "nbat".equals(kyx) || "none".equals(kyx)) continue;
            LinkedList effectList = skil.getItemEffectrs();
            for (LinkedListItem item = effectList.getFirst(); item != null; item = item.getNext()) {
                Effect eTemp = (Effect)item;
                String type = eTemp.getString("type");
                Effect clone = (Effect)eTemp.clone(null);
                if (skil.getName().equals("Qu\u1ef7 \u0111\u1ea1o v\u00f4 th\u01b0\u1eddng") && type.equals("zj")) {
                    clone.set("cd", skil.getInt("bound"));
                }
                this.bdSkilEffect.addElement(clone);
            }
        }
    }

    public String getXinfaName(String xfs) {
        String xinfId = xfs.substring(2);
        StringBuffer sb = new StringBuffer();
        if ("0".equals(xinfId)) {
            sb.append("T\u00e2m ph\u00e1p ch\u00ednh::");
        }
        int id = Integer.parseInt(xinfId);
        sb.append(Config.xinfName((String)this.xf_stru[id][0])).append("(").append((Integer)this.xf_stru[id][1]).append(")");
        return sb.toString();
    }

    public Item getSkillItem(String skl) {
        int xinfu_index = Integer.parseInt(skl.substring(2, 3));
        int ski_index = Integer.parseInt(skl.substring(3));
        if (ski_index >= this.xf_skilid[xinfu_index].length) {
            return new Item();
        }
        int id = this.xf_skilid[xinfu_index][ski_index];
        Item item = (Item)this.studySkill.get(new Integer(id));
        return item;
    }

    public Item getFbSkillByName(String name) {
        if (this.fbskill.containsKey(name)) {
            return (Item)this.fbskill.get(name);
        }
        return new Item();
    }

    public void initFbSkillData() {
        this.fbskill = new LinkedHashtable();
    }

    public Item getFbSkillById(int id) {
        int n = this.fbskill.size();
        for (int i2 = 0; i2 < n; ++i2) {
            Item skil = (Item)this.fbskill.elementAt(i2);
            if (skil.getId() != id) continue;
            return skil;
        }
        return null;
    }

    public Item getFbItem() {
        return player.getWearEquip(Config.equpPos("fb"));
    }

    public void addTask(Task task) {
        if (task == null || task.isNull()) {
            return;
        }
        int taskId = task.getInt("id");
        String taskState = task.getString("state");
        if ("none".equals(taskState)) {
            this.canAcceptTaskHash.put(new Integer(taskId), task);
        } else {
            this.receiveTaskHash.put(new Integer(taskId), task);
        }
    }

    public void removeTask(Task task) {
        if (task == null || task.isNull()) {
            return;
        }
        int taskId = task.getInt("id");
        String taskState = task.getString("state");
        if ("none".equals(taskState)) {
            this.canAcceptTaskHash.remove(new Integer(taskId));
        } else {
            this.receiveTaskHash.remove(new Integer(taskId));
        }
    }

    public void removeTask(int id) {
        Integer taskId = new Integer(id);
        if (this.canAcceptTaskHash.containsKey(taskId)) {
            this.canAcceptTaskHash.remove(taskId);
        } else if (this.receiveTaskHash.containsKey(taskId)) {
            this.receiveTaskHash.remove(taskId);
        }
    }

    public void removeAllTask() {
        this.receiveTaskHash.clear();
        this.canAcceptTaskHash.clear();
        this.taskGuideVec.removeAllElements();
    }

    public Task getTask(int taskId) {
        Integer taskkey = new Integer(taskId);
        if (this.receiveTaskHash.containsKey(taskkey)) {
            return (Task)this.receiveTaskHash.get(taskkey);
        }
        if (this.canAcceptTaskHash.containsKey(taskkey)) {
            return (Task)this.canAcceptTaskHash.get(taskkey);
        }
        return null;
    }

    public void addGuideTask(Task task) {
        if (task == null) {
            return;
        }
        this.taskGuideVec.addElement(task);
    }

    public void insertGuideTask(Task task, int idx) {
        if (task == null || idx < 0) {
            return;
        }
        if (idx >= this.taskGuideVec.size()) {
            this.addGuideTask(task);
        } else {
            this.taskGuideVec.insertElementAt(task, idx);
        }
    }

    public void setGuideTask(Task task, int idx) {
        if (task == null || idx < 0 || idx >= this.taskGuideVec.size()) {
            return;
        }
        this.taskGuideVec.setElementAt(task, idx);
    }

    public void removeGuideTask(Task task) {
        if (task == null) {
            return;
        }
        this.taskGuideVec.removeElement(task);
    }

    public void removeGuideTask(int id) {
        int size = this.taskGuideVec.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Task task = (Task)this.taskGuideVec.elementAt(i2);
            if (task.getId() != id) continue;
            this.taskGuideVec.removeElementAt(i2);
        }
    }

    public boolean addSpecialGuideTask(Task task) {
        if (task == null) {
            return false;
        }
        boolean changeObj = false;
        int taskId = task.getId();
        int size = this.taskGuideVec.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Task tempTask = (Task)this.taskGuideVec.elementAt(i2);
            if (tempTask.getId() != taskId) continue;
            this.setGuideTask(task, i2);
            changeObj = true;
            break;
        }
        if (!changeObj) {
            this.addGuideTask(task);
        }
        Vector<Task> mainTask = new Vector<Task>();
        Vector<Task> kjfTask = new Vector<Task>();
        Vector<Task> yjTask = new Vector<Task>();
        Vector<Task> kjTask = new Vector<Task>();
        size = this.taskGuideVec.size();
        for (int i3 = 0; i3 < size; ++i3) {
            Task tempTask = (Task)this.taskGuideVec.elementAt(i3);
            if ("zx".equals(tempTask.getTaskZhuzhiType())) {
                mainTask.addElement(tempTask);
                continue;
            }
            String taskState = tempTask.getState();
            if ("fin".equals(taskState)) {
                kjfTask.addElement(tempTask);
                continue;
            }
            if ("nfin".equals(taskState)) {
                yjTask.addElement(tempTask);
                continue;
            }
            kjTask.addElement(tempTask);
        }
        this.taskGuideVec.removeAllElements();
        Vector<Vector<Task>> vec = new Vector<Vector<Task>>();
        vec.addElement(mainTask);
        vec.addElement(kjfTask);
        vec.addElement(yjTask);
        vec.addElement(kjTask);
        for (int i4 = 0; i4 < vec.size(); ++i4) {
            Vector tempVec = (Vector)vec.elementAt(i4);
            for (int j2 = 0; j2 < tempVec.size(); ++j2) {
                this.taskGuideVec.addElement(tempVec.elementAt(j2));
            }
        }
        return true;
    }

    public Task searchGuideTask(int taskId) {
        int size = this.taskGuideVec.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Task tempTask = (Task)this.taskGuideVec.elementAt(i2);
            if (tempTask.getId() != taskId) continue;
            return tempTask;
        }
        return null;
    }

    public void addProSkill(Module proSkill) {
        if (proSkill == null) {
            return;
        }
        String tag = proSkill.getString("tag");
        Module oldSkill = (Module)this.productionSkillHash.get(tag);
        if (oldSkill != null) {
            proSkill.clone(oldSkill);
        } else {
            this.productionSkillHash.put(tag, proSkill);
        }
    }

    public void removeProSkill(Module proSkill) {
        if (proSkill == null) {
            return;
        }
        RoleFrame.instance.removeStudyFmla(proSkill.getString("tag"));
        this.productionSkillHash.remove(proSkill.getString("tag"));
    }

    public void removeAllProSkill() {
        this.productionSkillHash.clear();
    }

    public Module getProSkill(String tag) {
        if (tag == null || tag.equals("")) {
            return null;
        }
        return (Module)this.productionSkillHash.get(tag);
    }

    public boolean onMessage(Object identifier, Object[] arguments) {
        if ("sfenemy".equals(identifier)) {
            this.joinBattle();
            return true;
        }
        if ("gomap".equals(identifier)) {
            try {
                String mapName = arguments[0].toString();
                Entity.logicHandle.createProtocol((byte)3, (byte)1).writeInt(RiskScene.risk.getId()).writeUTF(mapName).writeByte(((Integer)arguments[1]).byteValue()).writeByte(((Integer)arguments[2]).byteValue()).writeByte(RiskFrame.instance.getMapVersion(mapName)).send();
            }
            catch (Exception e2) {
                Log.error(this.getName() + ".gomap" + StringUtil.convertString(arguments), e2);
            }
            return true;
        }
        return super.onMessage(identifier, arguments);
    }

    public void removeEquip(String pos) {
        this.equHash.remove(pos);
    }

    public void setWearEquip(String pos, Item equip) {
        if (this.equHash == null) {
            this.equHash = new Hashtable();
        }
        this.equHash.put(pos, equip);
    }

    public Item getWearEquip(String pos) {
        if (this.equHash == null) {
            this.equHash = new Hashtable();
        }
        if (this.equHash.containsKey(pos)) {
            return (Item)this.equHash.get(pos);
        }
        Item item = new Item();
        item.set("icon", Config.equpPosImageName(pos));
        this.equHash.put(pos, item);
        return item;
    }

    public Item getWearEquById(int id) {
        if (this.equHash == null) {
            return null;
        }
        Enumeration enume = this.equHash.elements();
        while (enume.hasMoreElements()) {
            Item item = (Item)enume.nextElement();
            if (item.getId() != id) continue;
            return item;
        }
        return null;
    }

    public Hashtable getSuit() {
        return this.hashSuit;
    }

    public void setEquSuit(Module suim) {
        if (this.hashSuit == null) {
            this.hashSuit = new Hashtable();
        }
        this.hashSuit.put(new Integer(suim.getId()), suim);
    }

    public int getWearEquSuit(int id) {
        if (this.equHash == null) {
            return 0;
        }
        Enumeration enume = this.equHash.elements();
        while (enume.hasMoreElements()) {
            Item item = (Item)enume.nextElement();
            if (item.getInt("srcid") != id) continue;
            return 1;
        }
        return 0;
    }

    public void setFumo(int equid, String[] vuals) {
        if (this.hashFumo == null) {
            this.hashFumo = new Hashtable();
        }
        this.hashFumo.put(new Integer(equid), vuals);
    }

    public void removeFumo(int equid) {
        if (this.hashFumo == null) {
            return;
        }
        this.hashFumo.remove(new Integer(equid));
    }

    public String[] getFumo(int equid) {
        if (this.hashFumo == null) {
            return null;
        }
        return (String[])this.hashFumo.get(new Integer(equid));
    }

    public void setZhenf(String zhftag) {
        if (this.hashZhenf == null) {
            this.hashZhenf = new LinkedHashtable();
        }
        this.hashZhenf.put(zhftag, zhftag);
    }

    public LinkedHashtable getZhenf() {
        if (this.hashZhenf == null) {
            this.hashZhenf = new LinkedHashtable();
        }
        return this.hashZhenf;
    }

    public void initPetData() {
        this.petHash = new LinkedHashtable();
    }

    public void addPet(Ghost ghost) {
        Player.player.petHash.put(new Integer(ghost.getId()), ghost);
    }

    public void removePet(Ghost ghost) {
        if (ghost != null && !ghost.isNull()) {
            Player.player.petHash.remove(new Integer(ghost.getId()));
            ghost.setNull();
            ghost.setCharacter(null);
            ghost = null;
        }
    }

    public LinkedHashtable getPetClone() {
        if (this.petHashClone == null) {
            this.petHashClone = new LinkedHashtable();
            if (Player.player.petHash.size() == 0) {
                return this.petHashClone;
            }
            Enumeration en = Player.player.petHash.elements();
            Ghost gho = (Ghost)en.nextElement();
            while (gho != null) {
                this.petHashClone.put(new Integer(gho.getId()), (Ghost)gho.clone(null));
                if (en.hasMoreElements()) {
                    gho = (Ghost)en.nextElement();
                    continue;
                }
                gho = null;
            }
        }
        return this.petHashClone;
    }

    public void addPetClone(Ghost ghost) {
        Player.player.petHashClone.put(new Integer(ghost.getId()), ghost);
    }

    public void removePetClone(Ghost ghost) {
        if (ghost != null && !ghost.isNull()) {
            Player.player.petHashClone.remove(new Integer(ghost.getId()));
            ghost.setNull();
            ghost = null;
        }
    }

    public void freePetClone() {
        if (this.petHashClone != null) {
            this.petHashClone.clear();
            this.petHashClone = null;
        }
    }

    public void setAttPet(Ghost pet) {
        this.attPet = pet;
        if (RiskFrame.instance.petHeadAniW != null) {
            RiskFrame.instance.petHeadAniW.setAnimationModel(this.attPet == null ? null : this.attPet.getGhostHead());
        }
    }

    public Ghost getAttPet() {
        return this.attPet;
    }

    public void setViewPet(Ghost pet) {
        if (pet == null && this.viewPet != null) {
            RiskScene.risk.getBoard().removeCharacter(this.viewPet.getCharacter());
        }
        this.viewPet = pet;
    }

    public Ghost getViewPet() {
        return this.viewPet;
    }

    public void setPetState(Ghost pet) {
        byte state = pet.getByte("batt");
        if ((state & 1) != 0) {
            BattleFrame.latPetskil = null;
            this.setAttPet(pet);
        } else if (this.attPet != null && this.attPet == pet) {
            BattleFrame.latPetskil = null;
            this.setAttPet(null);
        }
        if ((state & 2) != 0) {
            this.setViewPet(pet);
        } else if (this.viewPet != null && this.viewPet == pet) {
            this.setViewPet(null);
        }
    }

    public void upDataPet() {
        if (this.petHash.size() <= 0) {
            this.setAttPet(null);
            this.setViewPet(null);
            return;
        }
        Enumeration en = this.petHash.elements();
        Ghost attPet = null;
        Ghost viewPet = null;
        Ghost gho = (Ghost)en.nextElement();
        while (gho != null) {
            byte state = gho.getByte("batt");
            if ((state & 1) != 0) {
                attPet = gho;
            }
            if ((state & 2) != 0) {
                viewPet = gho;
            }
            if (en.hasMoreElements()) {
                gho = (Ghost)en.nextElement();
                continue;
            }
            gho = null;
        }
        this.setAttPet(attPet);
        this.setViewPet(viewPet);
    }

    public void refreshAttPet(int oldID, int newID) {
        Ghost cre;
        if (oldID != -1) {
            Ghost ghOld = (Ghost)this.petHash.get(new Integer(newID));
            ghOld.set("batt", 0);
            this.attPet = null;
        }
        if ((cre = (Ghost)this.petHash.get(new Integer(newID))) != null) {
            cre.setCharacter((DCharacter)cre.getCharacter().clone(null));
            cre.set("batt", 1);
        }
        this.attPet = cre;
    }

    public Item getPetEquById(int id) {
        if (this.petHash == null) {
            return null;
        }
        Enumeration en = this.petHash.elements();
        while (en.hasMoreElements()) {
            Ghost gho = (Ghost)en.nextElement();
            Item item = gho.getWearEquById(id);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public void resetGhostYs() {
        if (this.petHash == null) {
            return;
        }
        Enumeration en = this.petHash.elements();
        while (en.hasMoreElements()) {
            Ghost gho = (Ghost)en.nextElement();
            gho.getCharacter().recover();
        }
    }

    public void joinBattle() {
        long timeend;
        if (!isSendBattle) {
            Entity.logicHandle.createProtocol((byte)9, (byte)1).setBlock(false).send();
            isSendBattle = true;
            this.times = System.currentTimeMillis();
        } else if (this.times != 0L && (timeend = System.currentTimeMillis() - this.times) >= 20000L) {
            isSendBattle = false;
            this.times = 0L;
        }
    }

    public void setBattleContnue() {
        isSendBattle = false;
    }

    public void setNoBattle() {
        isSendBattle = true;
    }

    public boolean isAnimState(int state) {
        switch (state) {
            case 0: {
                return this.character.getAction() == 0 && !this.character.isFly();
            }
            case 1: {
                return this.character.getAction() == 1;
            }
            case 2: {
                return this.character.getAction() == 2;
            }
            case 3: {
                return this.character.getAction() == 3;
            }
            case 4: {
                return this.character.getAction() == 4;
            }
            case 5: {
                return this.character.getAction() == 5;
            }
            case 8: {
                return this.isdead;
            }
            case 6: {
                return this.character.isFly();
            }
            case 9: {
                if (this.alive != null) {
                    this.setAnimationModel(this.alive);
                    this.alive = null;
                }
                this.isdead = false;
                return this.character.getAction() == 0;
            }
        }
        return false;
    }

    public void setBattState(int state) {
        if (this.isAnimState(state)) {
            return;
        }
        try {
            switch (state) {
                case 0: {
                    if (this.isBianshen()) {
                        if (this.flyOffHeight > 0) {
                            this.getAnimationModel().y += this.flyOffHeight;
                            this.flyOffHeight = 0;
                        }
                    } else if (this.flyNameOffHeight > 0) {
                        this.character.getAnimationModel().data.top = (short)(this.character.getAnimationModel().data.top + this.flyNameOffHeight);
                        this.flyNameOffHeight = 0;
                    }
                    this.character.setAction(0);
                    this.character.setFly(false);
                    break;
                }
                case 1: {
                    this.character.setAction(1);
                    break;
                }
                case 2: {
                    this.character.setAction(2);
                    break;
                }
                case 3: {
                    this.character.setAction(3);
                    break;
                }
                case 4: {
                    this.character.setAction(4);
                    break;
                }
                case 5: {
                    this.character.setAction(5);
                    break;
                }
                case 8: {
                    this.alive = this.getAnimationModel();
                    AnimationModel dead = (AnimationModel)M.instance.getClientResource("ef_wing.anmt");
                    this.character.setAnimationModel((AnimationModel)dead.clone(null));
                    this.isdead = true;
                    break;
                }
                case 6: {
                    if (this.isBianshen()) {
                        if (this.flyOffHeight == 0) {
                            this.flyOffHeight = MainMIDlet.isAndroid() ? 54 : 36;
                            this.getAnimationModel().y -= this.flyOffHeight;
                        }
                        this.character.setAction(0);
                    } else {
                        if (this.flyNameOffHeight == 0) {
                            this.flyNameOffHeight = MainMIDlet.isAndroid() ? 54 : 36;
                            this.character.getAnimationModel().data.top = (short)(this.character.getAnimationModel().data.top - this.flyNameOffHeight);
                        }
                        this.character.setAction(6);
                    }
                    this.character.setFly(true);
                    break;
                }
                case 9: {
                    this.isdead = false;
                    this.character.setAction(0);
                }
            }
        }
        catch (Exception e2) {
            Log.error("Player setB " + state, e2);
        }
    }

    public void initPacks() {
        this.packgs = new Package[4];
    }

    public Package getPackage(int pagid) {
        return this.packgs[pagid];
    }

    public void setPackage(int pagid, Package bag) {
        this.packgs[pagid] = bag;
    }

    public void setPackageClone(int pagid, Package bag) {
        if (this.packgsClone == null) {
            this.packgsClone = new Package[4];
        }
        this.packgsClone[pagid] = bag;
    }

    public Package getPackageClone(int pagid) {
        if (this.packgsClone == null) {
            this.packgsClone = new Package[4];
        }
        if (this.packgsClone[pagid] == null) {
            Package bagEnd;
            this.packgsClone[pagid] = bagEnd = (Package)player.getPackage(pagid).clone(null);
        }
        return this.packgsClone[pagid];
    }

    public void freePackageClone() {
        if (this.packgsClone == null) {
            return;
        }
        for (int i2 = 0; i2 < this.packgsClone.length; ++i2) {
            this.packgsClone[i2] = null;
        }
        this.packgsClone = null;
    }

    public boolean ispagFull() {
        for (int i2 = 0; i2 < this.packgs.length; ++i2) {
            if (i2 == 2 || i2 == 3 && !player.isVip()) continue;
            LinkedList list = this.packgs[i2].getItemzs();
            for (LinkedListItem item = list.getFirst(); item != null; item = item.getNext()) {
                Itemz itemz = (Itemz)item;
                if (!itemz.isNull()) continue;
                return false;
            }
        }
        return true;
    }

    public Object getUserDefinedValue(String property) {
        if ("head".equals(property) || "bosom".equals(property) || "feet".equals(property) || "hand".equals(property) || "wrist".equals(property) || "belt".equals(property) || "waist".equals(property) || "finger".equals(property) || "neck".equals(property) || "fabao".equals(property)) {
            return this.getWearEquip(property);
        }
        if ("anmt".equals(property)) {
            if (this.character == null || this.character.getAnimationModel() == null) {
                return null;
            }
            AnimationModel aniClone = (AnimationModel)this.character.getAnimationModel().clone(null);
            return aniClone;
        }
        if ("job".equals(property)) {
            return Config.jobName(this.getString(property));
        }
        if ("faof".equals(property)) {
            return Config.gangConfig(this.getString(property));
        }
        if ("chlv".equals(property)) {
            return this.getCombinationValue("huol", "huolm");
        }
        if ("xf0".equals(property) || "xf1".equals(property) || "xf2".equals(property) || "xf3".equals(property) || "xf4".equals(property) || "xf5".equals(property)) {
            return this.getXinfaName(property);
        }
        if ("sk00".equals(property) || "sk01".equals(property) || "sk02".equals(property) || "sk03".equals(property) || "sk10".equals(property) || "sk11".equals(property) || "sk12".equals(property) || "sk13".equals(property) || "sk20".equals(property) || "sk21".equals(property) || "sk22".equals(property) || "sk23".equals(property) || "sk30".equals(property) || "sk31".equals(property) || "sk32".equals(property) || "sk33".equals(property) || "sk40".equals(property) || "sk41".equals(property) || "sk42".equals(property) || "sk43".equals(property) || "sk50".equals(property) || "sk51".equals(property) || "sk52".equals(property) || "sk53".equals(property)) {
            return this.getSkillItem(property);
        }
        if ("fbjx00".equals(property) || "fbjx01".equals(property) || "fbjx02".equals(property) || "fbjx03".equals(property)) {
            return this.getFaboJuxueName(property);
        }
        if ("fbjxt00".equals(property) || "fbjxt01".equals(property) || "fbjxt02".equals(property) || "fbjxt03".equals(property) || "fbjxt10".equals(property) || "fbjxt11".equals(property) || "fbjxt12".equals(property) || "fbjxt13".equals(property) || "fbjxt20".equals(property) || "fbjxt21".equals(property) || "fbjxt22".equals(property) || "fbjxt23".equals(property) || "fbjxt30".equals(property) || "fbjxt31".equals(property) || "fbjxt32".equals(property) || "fbjxt33".equals(property)) {
            return this.getFaboJuxItem(property);
        }
        return super.getUserDefinedValue(property);
    }

    public String getFaboJuxueName(String pro) {
        Item itemfb = player.getFbItem();
        if (itemfb == null || itemfb.isNull()) {
            return "Kh\u00f4ng k\u0129 n\u0103ng";
        }
        int index = Integer.parseInt(pro.substring(pro.length() - 1, pro.length()));
        String skin = "Kh\u00f4ng k\u0129 n\u0103ng";
        LinkedList juex = ((Group)itemfb.getModule("juex")).getModules();
        int cont = 0;
        for (LinkedListItem item = juex.getFirst(); item != null; item = item.getNext()) {
            if (cont == 3 && itemfb.getInt("level") < 10) {
                skin = "???";
                break;
            }
            if (cont == index) {
                skin = ((Module)item).getString("name");
                break;
            }
            ++cont;
        }
        return skin;
    }

    private Item getFaboJuxItem(String pro) {
        Item itemfb = player.getFbItem();
        if (itemfb == null || itemfb.isNull()) {
            return null;
        }
        int juxindex = Integer.parseInt(pro.substring(pro.length() - 2, pro.length() - 1));
        int skindex = Integer.parseInt(pro.substring(pro.length() - 1, pro.length()));
        LinkedList juex = ((Group)itemfb.getModule("juex")).getModules();
        int cont = 0;
        String skillName = "";
        block0: for (LinkedListItem item = juex.getFirst(); item != null && (cont != 3 || itemfb.getInt("level") >= 10); ++cont, item = item.getNext()) {
            if (cont != juxindex) continue;
            Module mo = (Module)item;
            LinkedList jej = ((Group)mo.getModule("jej")).getModules();
            int skcont = 0;
            for (LinkedListItem jxitem = jej.getFirst(); jxitem != null; jxitem = jxitem.getNext()) {
                if (skcont == skindex) {
                    skillName = ((Module)jxitem).getString("string0");
                    break block0;
                }
                ++skcont;
            }
            break;
        }
        if ("".equals(skillName)) {
            return null;
        }
        return (Item)this.fbskill.get(skillName);
    }

    public boolean procSucc(final Protocol pt) {
        switch (pt.combineCommand()) {
            case 527: {
                WorkerPool.instance.pushPoolTask(new WorkerTask(){

                    public boolean run(int taskInnerId) {
                        Player.this.init(pt.getInputStream(), "srle");
                        Player.this.initCharacter();
                        return true;
                    }

                    public void onRemove(int taskInnerId) {
                    }

                    public String getTaskName() {
                        return "PlayerSuccTask " + Player.this.getName();
                    }
                }, 0, 300L);
                WorkerPool.instance.start();
                return true;
            }
        }
        return super.procSucc(pt);
    }

    public boolean paintSelf(Graphics g2) {
        Module module;
        if (this.isStall()) {
            if (RiskScene.mmap_stall == null) {
                RiskScene.mmap_stall = M.instance.getResource("ri_dtan.cpng").getImage();
            }
            int offsetY = 10;
            if (MainMIDlet.isAndroid()) {
                offsetY = 30;
            }
            GraphicsUtil.drawRegion(g2, RiskScene.mmap_stall, 0, 0, offsetY, 33);
            this.showPlayerNameAndCH(g2, "".equals(this.getTanWei()) ? this.getName() : this.getTanWei(), -RiskScene.mmap_stall.getHeight() + offsetY, false);
            return true;
        }
        if (this.inBattle()) {
            if (RiskScene.mmap_battle == null) {
                RiskScene.mmap_battle = M.instance.getClientResource("ba_icon.cpng").getImage();
            }
            GraphicsUtil.drawRegion(g2, RiskScene.mmap_battle, 0, 0, this.character.getTop() - 20, 33);
        }
        if (this != player) {
            DCharacter cht = player.getCharacter();
            if (cht.contain(this.character)) {
                GraphicsUtil.drawRegion(g2, Entity.shadow, 0, 0, 0, 3);
                this.showPlayerNameAndCH(g2, this.getName(), this.character.getTop() + this.getAnimationModel().y, true);
                if (this.fxani != null) {
                    int trans = this.isBianshen() ? (this.getCharacter().getAnimationModel().getTransform() == 0 ? 2 : 0) : this.getCharacter().getAnimationModel().getTransform();
                    this.fxani.setTransform(trans);
                    this.fxani.draw(g2, 0, 0);
                    this.fxani.run();
                }
                return false;
            }
            int nearRadius = 3;
            if (RiskScene.isOpenName == 0) {
                this.showPlayerNameAndCH(g2, this.getName(), this.character.getTop() + this.getAnimationModel().y, true);
            } else if (RiskScene.isOpenName == 1 && Math.abs(this.character.getCol() - cht.getCol()) <= nearRadius && Math.abs(this.character.getRow() - cht.getRow()) <= nearRadius) {
                this.showPlayerNameAndCH(g2, this.getName(), this.character.getTop() + this.getAnimationModel().y, true);
            }
            if (RiskScene.isOpenAnmt == 2) {
                return true;
            }
            if (RiskScene.isOpenAnmt == 1 && (Math.abs(this.character.getCol() - cht.getCol()) > nearRadius || Math.abs(this.character.getRow() - cht.getRow()) > nearRadius)) {
                return true;
            }
            GraphicsUtil.drawRegion(g2, Entity.shadow, 0, 0, 0, 3);
            if (this.fxani != null) {
                int trans = this.isBianshen() ? (this.getCharacter().getAnimationModel().getTransform() == 0 ? 2 : 0) : this.getCharacter().getAnimationModel().getTransform();
                this.fxani.setTransform(trans);
                this.fxani.draw(g2, 0, 0);
                this.fxani.run();
            }
            return false;
        }
        GraphicsUtil.drawRegion(g2, Entity.shadow, 0, 0, 0, 3);
        if (this.fxani != null) {
            int trans = this.isBianshen() ? (this.getCharacter().getAnimationModel().getTransform() == 0 ? 2 : 0) : this.getCharacter().getAnimationModel().getTransform();
            this.fxani.setTransform(trans);
            this.fxani.draw(g2, 0, 0);
            this.fxani.run();
        }
        if (Player.player.drawCollBar && (module = (Module)player.getValue("gauge")) != null && !module.isNull()) {
            int w = module.getInt("w");
            int h2 = module.getInt("h");
            int x = -(w >> 1);
            int y = -this.character.getHeight() - h2;
            g2.setColor(module.getInt("ds"));
            g2.fillRect(x, y, w, h2);
            g2.setColor(module.getInt("jdt"));
            g2.fillRect(x, y, module.getInt("dqcd"), h2);
            g2.setColor(module.getInt("wk"));
            g2.drawRect(x, y, w, h2);
            return false;
        }
        this.showPlayerNameAndCH(g2, this.getName(), this.character.getTop() + this.getAnimationModel().y, true);
        return false;
    }

    private void showPlayerNameAndCH(Graphics g2, String name, int offsetY, boolean drawCH) {
        int color1;
        if (drawCH && this.getChenHao() != null) {
            GraphicsUtil.drawRimString(g2, this.getChenHao(), 0, this.character.getTop() + this.getAnimationModel().y - g2.getFont().getHeight(), 33, 0xFFFFFF, 0, MainMIDlet.isAndroid() ? 60 : 40);
        }
        int offsetX = -g2.getFont().stringWidth(name) / 2;
        if (this.isVip()) {
            offsetX = -g2.getFont().stringWidth("VIP " + name) / 2;
            GraphicsUtil.drawRimString(g2, "VIP ", offsetX, offsetY, 36, 0, 0xFFFF00, MainMIDlet.isAndroid() ? 60 : 40);
            offsetX += g2.getFont().stringWidth("VIP ");
        }
        int n = color1 = this.isBlackName() ? 0xFF0000 : 0;
        int color2 = this.isBlackName() ? 0 : (this.getInt("rednm") > 0 ? 0xFF0000 : 3920639);
        GraphicsUtil.drawRimString(g2, name, offsetX, offsetY, 36, color1, color2, MainMIDlet.isAndroid() ? 60 : 40);
    }

    public Entity clone(Entity target) {
        Player player = (Player)target;
        if (player == null) {
            player = new Player();
        }
        super.clone(player);
        return player;
    }

    public boolean isNewPlayer() {
        return this.getCurrentGrade() < 20;
    }

    static {
        grade_attribute = new String[]{"grade", "qiane", "exp", "mxexp", "hp", "maxhp", "mp", "maxmp", "strth", "sprit", "habit", "endur", "agil", "wlgj", "fsgj", "wlfy", "fsfy", "wlbj", "fsbj", "sd", "mz", "sb", "fk"};
        isSendBattle = false;
    }
}

