/*
 * Decompiled with CFR 0.152.
 */
package com.ea.product.world;

import com.ea.engine.core.EaConstants;
import com.ea.engine.core.InteractionListener;
import com.ea.engine.game._2d2.CharacterListener;
import com.ea.engine.game._2d2.DBoard;
import com.ea.engine.game._2d2.DCharacter;
import com.ea.engine.game._2d2.DElement;
import com.ea.engine.model.AModel;
import com.ea.engine.model.AnimationModel;
import com.ea.engine.model.M;
import com.ea.engine.model.PatternModel;
import com.ea.engine.ui.UI;
import com.ea.engine.ui.widget.ActionWidget;
import com.ea.engine.ui.widget.Animation;
import com.ea.engine.ui.widget.Label;
import com.ea.engine.ui.widget.List;
import com.ea.engine.ui.widget.Screen;
import com.ea.engine.ui.widget.Text;
import com.ea.engine.ui.widget.TextArea;
import com.ea.engine.ui.widget.Widget;
import com.ea.engine.ui.widget.Window;
import com.ea.engine.worker.Worker;
import com.ea.engine.worker.WorkerTask;
import com.ea.io.net.Protocol;
import com.ea.io.net.ProtocolHandle;
import com.ea.product.Constants;
import com.ea.product.MainMIDlet;
import com.ea.product.frame.CreatureFrame;
import com.ea.product.frame.FrameConstants;
import com.ea.product.frame.ProtocolConstants;
import com.ea.product.frame.RiskFrame;
import com.ea.product.module.Chat;
import com.ea.product.module.Module;
import com.ea.product.world.BattleScene;
import com.ea.product.world.Entity;
import com.ea.product.world.Ghost;
import com.ea.product.world.Player;
import com.ea.util.Log;
import com.ea.util.MathFP;
import com.ea.util.MathUtil;
import com.ea.util.Method;
import com.ea.util.graphics.GraphicsUtil;
import java.io.DataInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RiskScene
implements InteractionListener,
WorkerTask,
Constants,
ProtocolConstants,
FrameConstants {
    public static ProtocolHandle logicHandle = MainMIDlet.logicHandle;
    public static final int TIME_TASK_CHAT = 257;
    public static final int TASK_COORDINATE = 258;
    public static final int TASK_GETMINIMAP = 259;
    public static final int INTERACTION_RISK = 1;
    public static final int INTERACTION_WORLD = 2;
    public static final int INTERACTION_LOAD = 3;
    public static final int INTERACTION_MINIMAP = 4;
    public static final byte MAP_TYPE_MINING = 1;
    public static final byte MAP_TYPE_LOGGING = 2;
    public static final byte MAP_TYPE_HUNTING = 4;
    public static final byte MAP_TYPE_STALL = 8;
    public static final byte MAP_TYPE_BANGZ = 16;
    public static RiskScene risk;
    public static RiskScene loadRisk;
    private String miniMap;
    private AModel mmapModel;
    private int id;
    private DBoard board;
    public DBoard wMapBoard;
    private String name;
    private byte type;
    public static Hashtable selfCache;
    private Hashtable playerCache = new Hashtable();
    private Hashtable npcCache = new Hashtable();
    private Image mmap_wh = null;
    private Image mmap_th = null;
    public static Image mmap_stall;
    public static Image mmap_battle;
    public static int RISK_SEEN_WIDTH;
    public static int RISK_SEEN_HEIGHT;
    public static short timeCont;
    private DElement currtElement;
    private AnimationModel wMapchose = null;
    protected int[][] smallMapPath;
    private int lastPointerX;
    private int lastPointerY;
    private boolean operatePressed;
    private int pressedX;
    private int pressedY;
    private int draggedOffX;
    private int draggedOffY;
    private int[] ponintXy;
    private static final int TAN22_5FP;
    private static final int TAN67_5FP;
    private static final int TAN_22_5FP;
    private static final int TAN_67_5FP;
    public static int isOpenHpMp;
    public static int isOpenMap;
    public static int isOpenAnmt;
    public static int isOpenName;
    public static int isOpenTeam;
    public static int isOpenFact;
    public static int isOpenEqupck;
    public static int isOpenSameS;
    public static int isOpenRocker;
    public static boolean mailUread;
    public static boolean bagFull;
    private Image mmap_npc;
    private Image mmap_role1;
    private Image mmap_role2;
    private Image mmap_roleO1;
    private Image mmap_roleO2;
    private boolean isset = false;
    public static Image roleHpI;
    public static Image roleMpI;
    public static Image roleExpI;
    public static Image petHpI;
    public static Image petMpI;
    public static Image petExpI;
    private boolean needSynCcoordinate = true;

    public RiskScene() {
    }

    public RiskScene(DataInputStream dis) {
        Module map = Module.createModule(dis, "map");
        this.id = map.getId();
        this.name = map.getName();
        int mapVersion = map.getInt("mapv");
        try {
            if (RiskFrame.instance.getMapVersion(this.name) == mapVersion) {
                this.setBoard((DBoard)M.instance.getClientResource(this.name + ".bord", false));
            }
        }
        catch (Exception e2) {
            Log.error("RiskScene.setBoard", e2);
        }
        this.type = map.getByte("mpty");
        this.miniMap = map.getString("mnmp");
        Worker.instance.pushTask(this, 258, 6000L, 4000L);
        Worker.instance.pushTask(this, 257, 6000L, 100L);
        if (!MainMIDlet.isAndroid()) {
            Worker.instance.pushTask(this, 259, 5000L);
        }
    }

    public void setBoard(DBoard board) {
        if (board == null) {
            return;
        }
        board.setBackgroundColor(0);
        this.board = board;
    }

    public String getCurrtElName() {
        if (this.currtElement == null) {
            return "";
        }
        return this.currtElement.getName();
    }

    public void freeWorldMap() {
        if (this.wMapBoard != null) {
            this.wMapBoard.freeMapImages();
            this.wMapBoard.free();
            this.wMapBoard = null;
        }
        this.wMapchose = null;
        this.currtElement = null;
    }

    public void initLoadMap(String message) {
        Screen loadScreen = MainMIDlet.loadScreen("load", null);
        MainMIDlet.setCurrentScreen(loadScreen);
        ActionWidget riskWidget = (ActionWidget)loadScreen.getWidget("rik");
        riskWidget.setInteractionListener(3, loadRisk);
        UI.getCanvas().forceRevalidate();
        if (!MainMIDlet.isAndroid480()) {
            int anmtCont = MainMIDlet.isAndroid() ? 4 : 1;
            String[] getplay = new String[]{"rl_sn_", "rl_ty_", "rl_wj_", "rl_ym_"};
            String fame = MathUtil.nextInt(2) == 1 ? "m" : "f";
            for (int i2 = 0; i2 < anmtCont; ++i2) {
                Animation widgetrole = (Animation)loadScreen.getWidget("anmt" + i2);
                AnimationModel animonClone = null;
                AnimationModel animon = (AnimationModel)M.instance.getResourceRandomFromGroupCache("mt_", ".anmt");
                if (animon == null) {
                    animon = (AnimationModel)M.instance.getClientResource(getplay[i2] + fame + ".anmt");
                    animonClone = (AnimationModel)animon.clone(null);
                    animonClone.setAction(1);
                    widgetrole.setAnimationModel(animonClone);
                    widgetrole.setTransform(2);
                    continue;
                }
                animonClone = (AnimationModel)animon.clone(null);
                animonClone.setAction(1);
                widgetrole.setAnimationModel(animonClone);
                widgetrole.setTransform(0);
            }
        }
        TextArea ta = (TextArea)loadScreen.getWidget("_desc");
        if (!"".equals(message) && ta != null) {
            ta.setText(message);
        }
    }

    public void initWorldMap() {
        DElement delement;
        int i2;
        Screen worldScreen = MainMIDlet.setCurrentScreen("wmap", null);
        ActionWidget riskWidget = (ActionWidget)((Widget)worldScreen).getWidget("rik");
        riskWidget.setInteractionListener(2, risk);
        UI.getCanvas().forceRevalidate();
        M.instance.getPackageResource("wmap.pack");
        try {
            this.wMapBoard = new DBoard("worldm.bord");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.wMapBoard.setScreenSize(riskWidget.getWidth(), riskWidget.getHeight());
        this.wMapchose = (AnimationModel)M.instance.getClientResource("shou.anmt");
        Vector builds = this.wMapBoard.getBuildsStatic();
        for (i2 = 0; i2 < builds.size(); ++i2) {
            delement = (DElement)builds.elementAt(i2);
            if (delement.getType() != 0 || !this.name.equals(delement.getName())) continue;
            this.currtElement = delement;
            break;
        }
        if (this.currtElement == null) {
            for (i2 = 0; i2 < builds.size(); ++i2) {
                delement = (DElement)builds.elementAt(i2);
                if (delement.getType() != 0 || !"Ph\u1ed5 thi\u00ean th\u00f4n".equals(delement.getName())) continue;
                this.currtElement = delement;
                break;
            }
        }
        this.wMapBoard.setScreenCenterPosition(this.currtElement.getX(), this.currtElement.getY());
    }

    public void setNpcList(Widget windows) {
        List npcList = (List)windows.getWidget("npcst");
        npcList.removeAllItems();
        Vector chart = this.board.getCharacters();
        int n = chart.size();
        for (int i2 = 0; i2 < n; ++i2) {
            Entity ent;
            CharacterListener dc = ((DCharacter)chart.elementAt(i2)).getCharacterListener();
            if (dc == null || dc instanceof Player || dc instanceof Ghost || !(ent = (Entity)dc).isShowInMenu()) continue;
            int[] tilePosition = this.board.convertScreenPosition2Tile(ent.getX() - this.board.getScreenX(), ent.getY() - this.board.getScreenY());
            Module module = new Module();
            module.set("left", ent.getName());
            module.set("mapid", this.id);
            module.set("x", tilePosition[0]);
            module.set("y", tilePosition[1]);
            npcList.addItem(module);
        }
    }

    public void initrightTopMap() {
        Widget riskSc = MainMIDlet.getDesktopWidget("risk");
        Widget windows = ((Screen)riskSc).getBufferWidget("bmap");
        MainMIDlet.showWindow((Window)windows);
        ActionWidget riskWidget = (ActionWidget)windows.getWidget("mrisk");
        riskWidget.setInteractionListener(4, risk);
        UI.getCanvas().forceRevalidate();
        this.setNpcList(windows);
        if (!"".equals(this.miniMap)) {
            this.mmapModel = M.instance.getResource(this.miniMap + ".cpng");
        }
        this.isset = true;
    }

    public void resetTopMap() {
        Widget riskSc = MainMIDlet.getDesktopWidget("risk");
        Widget windows = ((Screen)riskSc).getBufferWidget("bmap");
        if (windows != null && windows.isVisible()) {
            ActionWidget riskWidget = (ActionWidget)windows.getWidget("mrisk");
            riskWidget.setInteractionListener(4, risk);
            UI.getCanvas().forceRevalidate();
            this.setNpcList(windows);
            if (!"".equals(this.miniMap)) {
                this.mmapModel = M.instance.getResource(this.miniMap + ".cpng");
            }
            this.isset = true;
        }
    }

    public void freerightTopMap() {
        if (this.mmapModel != null) {
            M.instance.removeResource(this.mmapModel.id);
            this.mmapModel = null;
        }
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public DBoard getBoard() {
        return this.board;
    }

    public boolean isMining() {
        return (1 & this.type) == 1;
    }

    public boolean isLogging() {
        return (2 & this.type) == 2;
    }

    public boolean isHunting() {
        return (4 & this.type) == 4;
    }

    public boolean isStall() {
        return (8 & this.type) == 8;
    }

    public boolean isFactionBattle() {
        return (0x10 & this.type) == 16;
    }

    public void addPlayer(Player player) {
        if (this.board == null) {
            return;
        }
        this.board.addCharacter(player.getCharacter());
    }

    public void addNpc(Entity npc) {
        this.npcCache.put(new Integer(npc.getId()), npc);
        if (this.board == null) {
            return;
        }
        this.board.addCharacter(npc.getCharacter());
    }

    public void removeNpx(int npcid) {
        Entity npc = (Entity)this.npcCache.get(new Integer(npcid));
        if (npc != null) {
            this.npcCache.remove(new Integer(npcid));
            this.board.removeCharacter(npc.getCharacter());
        }
    }

    public Entity getNpc(int id) {
        return (Entity)this.npcCache.get(new Integer(id));
    }

    public void addSelfPlayers() {
        Enumeration values = selfCache.elements();
        while (values.hasMoreElements()) {
            Player player = (Player)values.nextElement();
            this.playerCache.put(new Integer(player.getId()), player);
            this.board.addCharacter(player.getCharacter());
            Ghost pet = player.getViewPet();
            if (pet == null) continue;
            this.board.addCharacter(pet.getCharacter());
        }
    }

    public void addFollower(DCharacter last, DCharacter follower) {
        if (!last.contain(follower)) {
            last.addFollower(follower);
        }
        if (follower == Player.player.getCharacter()) {
            this.stopPlayer();
        }
        if (this.board.containCharacter(follower) && (Math.abs(last.getCol() - follower.getCol()) > 1 || Math.abs(last.getRow() - follower.getRow()) > 1)) {
            follower.moveTileLinearTo(last.getCol(), last.getRow());
        }
    }

    public Player getPlayerOnMap(int playerId, int petId, boolean self) {
        Player player = null;
        Ghost pet = null;
        Hashtable playerCache = this.playerCache;
        if (Player.player.getId() == playerId) {
            player = Player.player;
            pet = player.getViewPet();
        }
        if (player == null && (player = (Player)playerCache.get(new Integer(playerId))) != null) {
            pet = player.getViewPet();
        }
        if (player == null) {
            player = new Player();
            player.set("id", playerId);
            logicHandle.createProtocol((byte)2, (byte)15).writeInt(playerId).setListener(player).setBlock(false).send();
        }
        playerCache.put(new Integer(player.getId()), player);
        if (self) {
            selfCache.put(new Integer(player.getId()), player);
        }
        if (petId == -1) {
            if (player.getViewPet() != null) {
                this.board.removeCharacter(player.getViewPet().getCharacter());
            }
            player.setViewPet(null);
            pet = null;
        } else if (pet == null && (pet = new Ghost()).getId() != petId) {
            pet.set("id", petId);
            player.setViewPet(pet);
            logicHandle.createProtocol((byte)13, (byte)15).writeInt(petId).setListener(pet).setBlock(false).send();
        }
        return player;
    }

    public void clearPlayerCache(Hashtable curPlayers, boolean self) {
        Hashtable playerCache = self ? selfCache : this.playerCache;
        Enumeration keys = playerCache.keys();
        Enumeration values = playerCache.elements();
        while (keys.hasMoreElements()) {
            Integer id = (Integer)keys.nextElement();
            Player player = (Player)values.nextElement();
            Player curPlayer = (Player)curPlayers.get(new Integer(player.getId()));
            if (curPlayer != null) continue;
            if (!self) {
                if (player != Player.player) {
                    player.removeFromBorad();
                }
                if (player.getViewPet() != null) {
                    player.getViewPet().removeFromBorad();
                }
            }
            playerCache.remove(id);
        }
    }

    public void clearPlayerCache(boolean self) {
        if (self) {
            selfCache.clear();
        } else {
            this.playerCache.clear();
        }
    }

    public Vector getNearPlayer() {
        int nearRadius = 6;
        Vector<Player> nears = new Vector<Player>();
        DCharacter cht = Player.player.getCharacter();
        Enumeration values = this.playerCache.elements();
        while (values.hasMoreElements()) {
            DCharacter near;
            Player player = (Player)values.nextElement();
            if (player == Player.player || Math.abs((near = player.getCharacter()).getCol() - cht.getCol()) > nearRadius || Math.abs(near.getRow() - cht.getRow()) > nearRadius) continue;
            nears.addElement(player);
        }
        return nears;
    }

    public void stopPlayer() {
        this.operatePressed = false;
        if (Player.player != null) {
            Player.player.stop();
        }
    }

    public boolean onKeyEvent(int innerId, byte type, int keyCode) {
        block19: {
            switch (innerId) {
                case 1: {
                    if (loadRisk != null) break;
                    switch (type) {
                        case 10: {
                            if (Player.player.isLeader()) {
                                this.onKeyEventMove(keyCode);
                                break;
                            }
                            break block19;
                        }
                        case 11: {
                            if (Player.player.isClose() && Player.player.isZdxl()) break;
                            if (Player.player.isLeader()) {
                                this.stopPlayer();
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    switch (type) {
                        case 10: {
                            Vector builds = this.wMapBoard.getBuildsStatic();
                            int tempx = this.currtElement.getX();
                            int tempy = this.currtElement.getY();
                            DElement deTemp = null;
                            for (int i2 = 0; i2 < builds.size(); ++i2) {
                                DElement delement = (DElement)builds.elementAt(i2);
                                if (delement.getType() != 0) continue;
                                int x = delement.getX();
                                int y = delement.getY();
                                if ((keyCode == 8 || keyCode == 32768) && x <= tempx || (keyCode == 4 || keyCode == 8192) && x >= tempx || (keyCode == 1 || keyCode == 2048) && y >= tempy || (keyCode == 2 || keyCode == 131072) && y <= tempy) continue;
                                if (deTemp == null) {
                                    deTemp = delement;
                                    continue;
                                }
                                DElement tempD = this.checkChangeSele(deTemp, this.currtElement, delement);
                                if (tempD == null) continue;
                                deTemp = tempD;
                            }
                            if (deTemp != null) {
                                this.currtElement = deTemp;
                            }
                            this.wMapBoard.setScreenCenterPosition(this.currtElement.getX(), this.currtElement.getY());
                            switch (keyCode) {
                                case 16: {
                                    UI.callActionMethod(new Method("menu"));
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private DElement checkChangeSele(DElement pre, DElement currt, DElement next) {
        int tempLength = Math.abs(pre.getX() - currt.getX()) + Math.abs(pre.getY() - currt.getY());
        int mmapLength = Math.abs(next.getX() - currt.getX()) + Math.abs(next.getY() - currt.getY());
        if (mmapLength < tempLength) {
            return next;
        }
        return null;
    }

    private void onKeyEventMove(int keyCode) {
        byte dire = 0;
        switch (keyCode) {
            case 1: 
            case 2048: {
                dire = 1;
                break;
            }
            case 2: 
            case 131072: {
                dire = 2;
                break;
            }
            case 4: 
            case 8192: {
                dire = 4;
                break;
            }
            case 8: 
            case 32768: {
                dire = 8;
                break;
            }
            default: {
                return;
            }
        }
        if (Player.player.isStall()) {
            return;
        }
        if (Player.player.isZdxl()) {
            Player.player.setZdxl((byte)0);
        }
        Player.player.getCharacter().cleanPatrolMove();
        if (Player.player.getCharacter().getAction() == 6) {
            Player.player.getCharacter().flyForever(dire);
        } else {
            Player.player.getCharacter().moveForever(dire);
        }
    }

    public void onPointerMove(final int col, final int row) {
        if (Player.player.isStall()) {
            return;
        }
        if (Player.player.getCharacter().isFly()) {
            Player.player.getCharacter().flyTileLinearTo(col, row);
        } else {
            new Thread(new Runnable(){

                public void run() {
                    RiskScene.this.smallMapPath = Player.player.getCharacter().moveAstarTo(col, row);
                }
            }).start();
        }
    }

    private void onRockerMove(int x, int y) {
        byte dire = this.getRockerDire(x, y);
        if (Player.player.isStall()) {
            return;
        }
        if (Player.player.getCharacter().getAction() == 6) {
            Player.player.getCharacter().flyForever(dire);
        } else {
            Player.player.getCharacter().moveForever(dire);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onPointerEvent(int innerId, byte type, int x, int y) {
        switch (innerId) {
            case 1: {
                if (loadRisk != null) return false;
                if (MainMIDlet.isAndroid() && isOpenRocker == 0) {
                    Widget operateArea = RiskFrame.instance.operateArea;
                    this.pressedX = operateArea.getX() + operateArea.getWidth() / 2;
                    this.pressedY = operateArea.getY() + operateArea.getHeight() / 2;
                    switch (type) {
                        case 21: 
                        case 23: {
                            boolean operatePressed = this.operatePressed;
                            this.operatePressed = false;
                            if (!operatePressed && (x - this.pressedX) * (x - this.pressedX) + (y - this.pressedY) * (y - this.pressedY) > operateArea.getWidth() / 2 * (operateArea.getWidth() / 2)) break;
                            if (!Player.player.isLeader()) return true;
                            this.stopPlayer();
                            Player.player.getCharacter().cleanPatrolMove();
                            return true;
                        }
                        case 20: {
                            if ((x - this.pressedX) * (x - this.pressedX) + (y - this.pressedY) * (y - this.pressedY) <= operateArea.getWidth() / 2 * (operateArea.getWidth() / 2)) {
                                this.operatePressed = true;
                            }
                        }
                        case 22: {
                            if (!this.operatePressed) break;
                            this.draggedOffX = x - this.pressedX;
                            this.draggedOffY = y - this.pressedY;
                            int rr = this.draggedOffX * this.draggedOffX + this.draggedOffY * this.draggedOffY;
                            int r = RiskFrame.instance.operateBoard.getImage().getWidth() >> 1;
                            if (rr > r * r) {
                                this.draggedOffX = (int)MathUtil.sqrt(this.draggedOffX * this.draggedOffX * r * r / rr) * (this.draggedOffX > 0 ? 1 : -1);
                                this.draggedOffY = (int)MathUtil.sqrt(this.draggedOffY * this.draggedOffY * r * r / rr) * (this.draggedOffY > 0 ? 1 : -1);
                            }
                            if (!Player.player.isLeader()) break;
                            this.onRockerMove(this.draggedOffX, -this.draggedOffY);
                        }
                    }
                }
                switch (type) {
                    case 21: 
                    case 23: {
                        Entity selectEntity;
                        if (RiskFrame.instance.slmap != null && MathUtil.pointInRect(x, y, RiskFrame.instance.slmap.getX(), RiskFrame.instance.slmap.getY(), RiskFrame.instance.slmap.getWidth(), RiskFrame.instance.slmap.getHeight())) {
                            UI.callActionMethod(new Method("minico"));
                            return true;
                        }
                        if (RiskFrame.instance.goRoleFo != null && MathUtil.pointInRect(x, y, RiskFrame.instance.goRoleFo.getX(), RiskFrame.instance.goRoleFo.getY(), RiskFrame.instance.goRoleFo.getWidth(), RiskFrame.instance.goRoleFo.getHeight())) {
                            UI.callActionMethod(UI.parseMethod("go(rlif)", null));
                            return true;
                        }
                        if (RiskFrame.instance.goPetFo != null && MathUtil.pointInRect(x, y, RiskFrame.instance.goPetFo.getX(), RiskFrame.instance.goPetFo.getY(), RiskFrame.instance.goPetFo.getWidth(), RiskFrame.instance.goPetFo.getHeight()) && Player.player != null && Player.player.getAttPet() != null) {
                            CreatureFrame.instance.showPetListWidget("normal", Player.player.getAttPet());
                            return true;
                        }
                        if (RiskFrame.instance.chat_radio_widget != null && RiskFrame.instance.chat_radio_widget.isVisible() && MathUtil.pointInRect(x, y, RiskFrame.instance.chat_radio_widget.getX(), RiskFrame.instance.chat_radio_widget.getY(), RiskFrame.instance.chat_radio_widget.getWidth(), RiskFrame.instance.chat_radio_widget.getHeight())) {
                            return true;
                        }
                        if (MainMIDlet.isAndroid() && mailUread && RiskFrame.instance.mailureadWidget != null && MathUtil.pointInRect(x, y, RiskFrame.instance.mailureadWidget.getX(), RiskFrame.instance.mailureadWidget.getY(), RiskFrame.instance.mailureadWidget.getWidth(), RiskFrame.instance.mailureadWidget.getHeight())) {
                            UI.callActionMethod(new Method("mailhp"));
                            return true;
                        }
                        if (bagFull && RiskFrame.instance.bagFullWidget != null && MathUtil.pointInRect(x, y, RiskFrame.instance.bagFullWidget.getX(), RiskFrame.instance.bagFullWidget.getY(), RiskFrame.instance.bagFullWidget.getWidth(), RiskFrame.instance.bagFullWidget.getHeight())) {
                            UI.callActionMethod(UI.parseMethod("go(rlpg)", null));
                            return true;
                        }
                        if (!Player.player.isLeader()) return false;
                        int[] tilePosition = null;
                        DCharacter screenCht = this.board.getScreenCharacter(x, y);
                        if (screenCht != null && (selectEntity = (Entity)screenCht.getCharacterListener()) != null && selectEntity != Player.player && !(selectEntity instanceof Player) && !(selectEntity instanceof Ghost)) {
                            tilePosition = new int[]{screenCht.col, screenCht.row};
                        }
                        if (tilePosition == null) {
                            tilePosition = this.board.convertScreenPosition2Tile(x, y);
                        }
                        RiskFrame.freeFind1Way();
                        this.ponintXy = tilePosition;
                        Player.player.getCharacter().cleanPatrolMove();
                        this.onPointerMove(tilePosition[0], tilePosition[1]);
                    }
                }
                return false;
            }
            case 2: {
                switch (type) {
                    case 20: {
                        this.lastPointerX = x;
                        this.lastPointerY = y;
                        return false;
                    }
                    case 22: {
                        int offx = x - this.lastPointerX;
                        int offy = y - this.lastPointerY;
                        this.lastPointerX = x;
                        this.lastPointerY = y;
                        this.wMapBoard.setScreenPosition(this.wMapBoard.getScreenX() - offx, this.wMapBoard.getScreenY() - offy);
                        return false;
                    }
                    case 21: {
                        DElement build = this.wMapBoard.getScreenBuild(x, y);
                        if (build == null) break;
                        this.currtElement = build;
                        UI.callActionMethod(new Method("menu"));
                    }
                }
                return false;
            }
            case 4: {
                switch (type) {
                    case 21: {
                        Widget riskSc = MainMIDlet.getDesktopWidget("risk");
                        Widget windows = ((Screen)riskSc).getBufferWidget("bmap");
                        if (windows == null || this.mmapModel == null || this.mmapModel.isNull() || this.board == null || !Player.player.isLeader()) return false;
                        int imagew = this.mmapModel.getImage().getWidth();
                        int imageH = this.mmapModel.getImage().getHeight();
                        int startx = 300 - imagew >> 1;
                        int starty = 300 - imageH >> 1;
                        int world_width = this.board.getWidth();
                        int world_height = this.board.getHeight();
                        boolean out = MathUtil.pointInRect(x, y, startx, starty, imagew, imageH);
                        if (!out) return false;
                        int endx = (x - startx) * world_width / imagew - this.board.getScreenX();
                        int endy = (y - starty) * world_height / imageH - this.board.getScreenY();
                        int[] tilePosition = this.board.convertScreenPosition2Tile(endx, endy);
                        Player.player.getCharacter().cleanPatrolMove();
                        this.onPointerMove(tilePosition[0], tilePosition[1]);
                    }
                }
            }
        }
        return false;
    }

    private byte getRockerDire(int x, int y) {
        if (x == 0 && y == 0) {
            return 0;
        }
        if (x == 0) {
            return y > 0 ? (byte)1 : 2;
        }
        if (y == 0) {
            return x > 0 ? (byte)8 : 4;
        }
        int dire = 0;
        x = MathFP.toFP(x);
        int tan = MathFP.div(y = MathFP.toFP(y), x);
        if (tan >= TAN_22_5FP && tan < TAN22_5FP) {
            dire = x > 0 ? 8 : 4;
        } else if (tan >= TAN22_5FP && tan < TAN67_5FP) {
            dire = x > 0 ? 9 : 6;
        } else if (tan >= TAN67_5FP || tan < TAN_67_5FP) {
            dire = y > 0 ? 1 : 2;
        } else if (tan >= TAN_67_5FP && tan < TAN_22_5FP) {
            dire = x > 0 ? 10 : 5;
        }
        return (byte)dire;
    }

    public void paint(int innerId, Graphics g2, int x, int y) {
        g2.setFont(EaConstants.DEFAULT_FONT);
        switch (innerId) {
            case 1: {
                if (loadRisk != null) break;
                if (this.board != null) {
                    this.board.paint(g2);
                }
                if (isOpenHpMp == 0) {
                    this.paintRolePetHead(g2);
                }
                this.paintRoleInfo(g2);
                if (isOpenMap == 0) {
                    this.paintRightTopMap(g2);
                }
                this.paintRolePos(g2);
                RiskFrame.instance.runFindWay();
                this.paintChatMessage(g2);
                if (MainMIDlet.isAndroid() && isOpenRocker == 0) {
                    if (this.operatePressed) {
                        GraphicsUtil.drawRegion(g2, RiskFrame.instance.operateBoard.getImage(), 0, this.pressedX, this.pressedY, 3);
                        GraphicsUtil.drawRegion(g2, RiskFrame.instance.operateRocker.getImage(), 0, this.pressedX + this.draggedOffX, this.pressedY + this.draggedOffY, 3);
                    } else {
                        Widget operateArea = RiskFrame.instance.operateArea;
                        int areaCenterX = operateArea.getX() + operateArea.getWidth() / 2;
                        int areaCenterY = operateArea.getY() + operateArea.getHeight() / 2;
                        GraphicsUtil.drawRegion(g2, RiskFrame.instance.operateBoardAlpha.getImage(), 0, areaCenterX, areaCenterY, 3);
                        GraphicsUtil.drawRegion(g2, RiskFrame.instance.operateRockerAlpha.getImage(), 0, areaCenterX, areaCenterY, 3);
                    }
                }
                if (RiskFrame.instance.point != null && this.ponintXy != null) {
                    int[] temp = this.board.convertTile2ScreenPosition(this.ponintXy[0], this.ponintXy[1]);
                    RiskFrame.instance.point.draw(g2, temp[0], temp[1]);
                    RiskFrame.instance.point.run();
                    if (Player.player.getCharacter().isStoped()) {
                        this.ponintXy = null;
                    }
                }
                if (RiskFrame.instance.onlineMess != null && timeCont > 0) {
                    RiskFrame.timeContW.paintImpl(g2);
                }
                if (!MainMIDlet.isAndroid() && !MainMIDlet.isAndroid480() && !MainMIDlet.isNokiaN97() || RiskFrame.instance.roleUpgrade == null) break;
                boolean isview = RiskFrame.instance.roleUpgrade.isIndividuallyVisible();
                if (Player.player.isNewPlayer()) {
                    if (Player.player.getCurrentExp() >= Player.player.getMaxExp() && !isview) {
                        RiskFrame.instance.roleUpgrade.setIndividuallyVisible(true);
                        break;
                    }
                    if (Player.player.getCurrentExp() >= Player.player.getMaxExp() || !isview) break;
                    RiskFrame.instance.roleUpgrade.setIndividuallyVisible(false);
                    break;
                }
                if (!isview) break;
                RiskFrame.instance.roleUpgrade.setIndividuallyVisible(false);
                break;
            }
            case 2: {
                if (this.wMapBoard == null) break;
                this.wMapBoard.paint(g2);
                if (this.wMapchose == null) break;
                g2.translate(-this.wMapBoard.getScreenX(), -this.wMapBoard.getScreenY());
                this.wMapchose.draw(g2, this.currtElement.getX(), this.currtElement.getY());
                g2.translate(this.wMapBoard.getScreenX(), this.wMapBoard.getScreenY());
                this.wMapchose.run();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.paintRightTopMapAndroid(g2);
            }
        }
    }

    private void paintRoleInfo(Graphics g2) {
        if (!mailUread || (Worker.instance.frameCount >> 3 & 1) == 1) {
            // empty if block
        }
        if (bagFull && (Worker.instance.frameCount >> 3 & 1) == 1) {
            GraphicsUtil.drawRegion(g2, RiskFrame.instance.bagFullImage, 0, RiskFrame.instance.bagFullWidget.getDisplayX(), RiskFrame.instance.bagFullWidget.getDisplayY(), 20);
        }
    }

    private void paintRolePos(Graphics g2) {
        if (RiskFrame.instance.slmap != null) {
            RiskFrame.instance.slmap.paint(g2);
        }
        if (MainMIDlet.isAndroid()) {
            if (RiskFrame.instance.rolePos != null && Player.player != null) {
                GraphicsUtil.drawRimString(g2, this.name + "(" + Player.player.getCharacter().col + "," + Player.player.getCharacter().row + ")", RiskFrame.instance.rolePos.getDisplayX() + (RiskFrame.instance.rolePos.getWidth() >> 1), RiskFrame.instance.rolePos.getDisplayY(), 17, 0, 0xFFFFFF, MainMIDlet.isAndroid() ? 60 : 40);
            }
        } else {
            PatternModel pattern = ((Label)RiskFrame.instance.roleLevel).getPattern();
            if (Player.player != null && pattern != null && RiskFrame.instance.rolePos != null) {
                int x = RiskFrame.instance.rolePos.getX() + RiskFrame.instance.rolePos.getWidth();
                int y = RiskFrame.instance.rolePos.getY();
                pattern.draw(g2, Player.player.getCharacter().col + "\uff0e " + Player.player.getCharacter().row, x, y, 24);
            }
            if (RiskFrame.instance.mapName != null) {
                GraphicsUtil.drawRimString(g2, this.name, RiskFrame.instance.mapName.getDisplayX() + RiskFrame.instance.mapName.getWidth(), RiskFrame.instance.mapName.getDisplayY(), 24, 0, 0xFFFFFF, MainMIDlet.isAndroid() ? 60 : 40);
            }
        }
    }

    public void paintChatMessage(Graphics g2) {
        if (Chat.chat != null) {
            g2.setFont(Font.getFont((int)0, (int)0, (int)16));
            Chat.chat.chatDraw(g2);
            if (BattleScene.battle == null) {
                Chat.chat.taskDraw(g2);
                Chat.chat.chatHornDraw(g2);
            }
            Chat.chat.chatSysdraw(g2);
            g2.setFont(EaConstants.DEFAULT_FONT);
        }
    }

    private void paintRightTopMapAndroid(Graphics g2) {
        if (this.mmapModel != null && !this.mmapModel.isNull() && this.board != null) {
            Window window;
            int imagew = this.mmapModel.getImage().getWidth();
            int imageH = this.mmapModel.getImage().getHeight();
            int startx = 300 - imagew >> 1;
            int starty = 300 - imageH >> 1;
            int world_width = this.board.getWidth();
            int world_height = this.board.getHeight();
            if (this.isset && (window = (Window)((Screen)MainMIDlet.getDesktopWidget("risk")).getBufferWidget("bmap")) != null) {
                ((Text)window.getWidget("mname")).setText(this.name);
                this.isset = false;
            }
            GraphicsUtil.drawRegion(g2, this.mmapModel.getImage(), 0, startx, starty, 20);
            g2.setColor(83278);
            g2.drawRect(startx, starty, imagew - 1, imageH);
            if (this.mmap_wh == null) {
                this.mmap_wh = M.instance.getClientResource("ui_s_00.cpng").getImage();
            }
            if (this.mmap_th == null) {
                this.mmap_th = M.instance.getClientResource("ui_s_01.cpng").getImage();
            }
            if (this.mmap_npc == null) {
                this.mmap_npc = M.instance.getClientResource("ui_s_npc.cpng").getImage();
            }
            if (this.mmap_role1 == null) {
                this.mmap_role1 = M.instance.getClientResource("ui_s_p0.cpng").getImage();
            }
            if (this.mmap_role2 == null) {
                this.mmap_role2 = M.instance.getClientResource("ui_s_p1.cpng").getImage();
            }
            if (this.mmap_roleO1 == null) {
                this.mmap_roleO1 = M.instance.getClientResource("ui_s_p00.cpng").getImage();
            }
            if (this.mmap_roleO2 == null) {
                this.mmap_roleO2 = M.instance.getClientResource("ui_s_p10.cpng").getImage();
            }
            Vector chart = this.board.getCharacters();
            int n = chart.size();
            for (int i2 = 0; i2 < n; ++i2) {
                Entity ent;
                CharacterListener dc = ((DCharacter)chart.elementAt(i2)).getCharacterListener();
                if (dc == null || dc instanceof Player || dc instanceof Ghost || !(ent = (Entity)dc).isShowInMenu()) continue;
                int npcx = ent.getX() * imagew / world_width + startx;
                int npcy = ent.getY() * imageH / world_height + starty;
                String icon = ent.getString("icon");
                if ("ques".equals(icon)) {
                    GraphicsUtil.drawRegion(g2, this.mmap_wh, 0, npcx, npcy, 3);
                    continue;
                }
                if ("sigh".equals(icon)) {
                    GraphicsUtil.drawRegion(g2, this.mmap_th, 0, npcx, npcy, 3);
                    continue;
                }
                GraphicsUtil.drawRegion(g2, this.mmap_npc, 0, npcx, npcy, 3);
            }
            Enumeration elements = selfCache.elements();
            while (elements.hasMoreElements()) {
                Player player = (Player)elements.nextElement();
                int playerx = player.getX() * imagew / world_width + startx;
                int playery = player.getY() * imageH / world_height + starty;
                if ((Worker.instance.frameCount >> 3 & 1) == 1) {
                    GraphicsUtil.drawRegion(g2, player == Player.player ? this.mmap_role1 : this.mmap_roleO1, 0, playerx, playery, 3);
                    continue;
                }
                GraphicsUtil.drawRegion(g2, player == Player.player ? this.mmap_role2 : this.mmap_roleO2, 0, playerx, playery, 3);
            }
            if (this.smallMapPath != null) {
                for (int i3 = 0; i3 < this.smallMapPath.length; ++i3) {
                    int[] temp = this.board.convertTile2ScreenPosition(this.smallMapPath[i3][0], this.smallMapPath[i3][1]);
                    int srcx = (temp[0] + this.board.getScreenX()) * imagew / world_width + startx;
                    int srcy = (temp[1] + this.board.getScreenY()) * imageH / world_height + starty;
                    g2.setColor(0xFF0000);
                    g2.fillRect(srcx, srcy, 2, 2);
                }
            }
            if (Player.player.getCharacter().isStoped()) {
                this.smallMapPath = null;
            }
        }
    }

    private void paintRightTopMap(Graphics g2) {
        if (RiskFrame.instance.miniMap != null && this.mmapModel != null && !this.mmapModel.isNull() && this.board != null) {
            int imagew = this.mmapModel.getImage().getWidth();
            int imageH = this.mmapModel.getImage().getHeight();
            int world_width = this.board.getWidth();
            int world_height = this.board.getHeight();
            int startx = RiskFrame.instance.miniMap.x + RiskFrame.instance.miniMap.width - imagew;
            int starty = RiskFrame.instance.miniMap.y + RiskFrame.instance.miniMap.height - imageH;
            GraphicsUtil.drawRegion(g2, this.mmapModel.getImage(), 0, startx, starty, 20);
            g2.setColor(0);
            g2.drawRect(startx - 1, starty - 1, imagew + 1, imageH + 1);
            if (this.mmap_wh == null) {
                this.mmap_wh = M.instance.getResource("ui_s_00.cpng").getImage();
            }
            if (this.mmap_th == null) {
                this.mmap_th = M.instance.getResource("ui_s_01.cpng").getImage();
            }
            Vector chart = this.board.getCharacters();
            int n = chart.size();
            for (int i2 = 0; i2 < n; ++i2) {
                Entity ent;
                CharacterListener dc = ((DCharacter)chart.elementAt(i2)).getCharacterListener();
                if (dc == null || dc instanceof Player || dc instanceof Ghost || !(ent = (Entity)dc).isShowInMenu()) continue;
                int npcx = ent.getX() * imagew / world_width;
                int npcy = ent.getY() * imageH / world_height;
                String icon = ent.getString("icon");
                if ("ques".equals(icon)) {
                    GraphicsUtil.drawRegion(g2, this.mmap_wh, 0, startx + npcx, starty + npcy, 3);
                    continue;
                }
                if ("sigh".equals(icon)) {
                    GraphicsUtil.drawRegion(g2, this.mmap_th, 0, startx + npcx, starty + npcy, 3);
                    continue;
                }
                this.drawMiniMapRect(g2, startx + npcx, starty + npcy, 65535, 0);
            }
            int playerx = Player.player.getX() * imagew / world_width;
            int playery = Player.player.getY() * imageH / world_height;
            int rectw = (Worker.instance.frameCount >> 3 & 1) == 1 ? 4 : 3;
            this.drawplayerInmini(g2, startx + playerx, starty + playery, rectw, 0xFFFF00, 0);
        }
    }

    private void paintRolePetHead(Graphics g2) {
        if (Player.player == null) {
            return;
        }
        if (!Player.player.getCharacter().isStoped()) {
            return;
        }
        if (RiskFrame.instance.rheadWidget != null) {
            this.drawRoleHead(g2);
        }
        if (Player.player.getAttPet() == null || RiskFrame.instance.pheadWidget == null) {
            return;
        }
        this.drawAttPetHead(g2, Player.player.getAttPet());
    }

    private void drawAttPetHead(Graphics g2, Ghost pet) {
        RiskFrame.instance.pheadWidget.paint(g2);
        int hpMax = RiskFrame.instance.petHPW.getWidth();
        int curHp = pet.getCurrentHp();
        int curMaxHp = pet.getMaxHp();
        GraphicsUtil.drawRegion(g2, petHpI, 0, 0, RiskScene.getImageWidght(curHp, curMaxHp, hpMax), petHpI.getHeight(), 0, RiskFrame.instance.petHPW.getDisplayX(), RiskFrame.instance.petHPW.getDisplayY(), 20);
        int mpw = RiskFrame.instance.petMPW.getWidth();
        int curmp = pet.getCurrentMp();
        int curMaxMp = pet.getMaxMp();
        GraphicsUtil.drawRegion(g2, petMpI, 0, 0, RiskScene.getImageWidght(curmp, curMaxMp, mpw), petMpI.getHeight(), 0, RiskFrame.instance.petMPW.getDisplayX(), RiskFrame.instance.petMPW.getDisplayY(), 20);
        int expw = RiskFrame.instance.petEXPW.getWidth();
        long curexp = pet.getCurrentExp();
        long curMaxexp = pet.getMaxExp();
        GraphicsUtil.drawRegion(g2, petExpI, 0, 0, RiskScene.getImageWidght(curexp, curMaxexp, expw), petExpI.getHeight(), 0, RiskFrame.instance.petEXPW.getDisplayX(), RiskFrame.instance.petEXPW.getDisplayY(), 20);
        PatternModel pattern = ((Label)RiskFrame.instance.petLevel).getPattern();
        if (pattern != null) {
            pattern.draw(g2, pet.getCurrentGrade() + "", RiskFrame.instance.petLevel.getDisplayX() + (RiskFrame.instance.petLevel.width >> 1), RiskFrame.instance.petLevel.getDisplayY() + (RiskFrame.instance.petLevel.height >> 1), 3);
        }
        if (pet.getQiann() > 0) {
            int offX = RiskFrame.instance.pheadWidget.getDisplayX();
            int offY = RiskFrame.instance.pheadWidget.getDisplayY();
            g2.translate(offX, offY);
            if (RiskFrame.instance.petUpadd != null) {
                RiskFrame.instance.petUpadd.paint(g2);
            }
            if (RiskFrame.instance.petUpadd1 != null && Player.player.isNewPlayer() && (Worker.instance.frameCount >> 3 & 1) == 1) {
                RiskFrame.instance.petUpadd1.paint(g2);
            }
            g2.translate(-offX, -offY);
        }
    }

    private void drawRoleHead(Graphics g2) {
        RiskFrame.instance.rheadWidget.paint(g2);
        if (Player.player == null) {
            return;
        }
        if (Player.player.headImage != null) {
            GraphicsUtil.drawRegion(g2, Player.player.headImage, 0, RiskFrame.instance.roleHeadI.getDisplayX() + (RiskFrame.instance.roleHeadI.getWidth() >> 1), RiskFrame.instance.roleHeadI.getDisplayY() + (RiskFrame.instance.roleHeadI.getHeight() >> 1), 3);
        }
        int hpMax = RiskFrame.instance.roleHPW.getWidth();
        int curHp = Player.player.getCurrentHp();
        int curMaxHp = Player.player.getMaxHp();
        GraphicsUtil.drawRegion(g2, roleHpI, 0, 0, RiskScene.getImageWidght(curHp, curMaxHp, hpMax), roleHpI.getHeight(), 0, RiskFrame.instance.roleHPW.getDisplayX(), RiskFrame.instance.roleHPW.getDisplayY(), 20);
        int mpw = RiskFrame.instance.roleMPW.getWidth();
        int curmp = Player.player.getCurrentMp();
        int curMaxMp = Player.player.getMaxMp();
        GraphicsUtil.drawRegion(g2, roleMpI, 0, 0, RiskScene.getImageWidght(curmp, curMaxMp, mpw), roleMpI.getHeight(), 0, RiskFrame.instance.roleMPW.getDisplayX(), RiskFrame.instance.roleMPW.getDisplayY(), 20);
        int expw = RiskFrame.instance.roleEXPW.getWidth();
        long curexp = Player.player.getCurrentExp();
        long curMaxexp = Player.player.getMaxExp();
        GraphicsUtil.drawRegion(g2, roleExpI, 0, 0, RiskScene.getImageWidght(curexp, curMaxexp, expw), roleExpI.getHeight(), 0, RiskFrame.instance.roleEXPW.getDisplayX(), RiskFrame.instance.roleEXPW.getDisplayY(), 20);
        PatternModel pattern = ((Label)RiskFrame.instance.roleLevel).getPattern();
        if (pattern != null) {
            pattern.draw(g2, Player.player.getCurrentGrade() + "", RiskFrame.instance.roleLevel.getDisplayX() + (RiskFrame.instance.roleLevel.width >> 1), RiskFrame.instance.roleLevel.getDisplayY() + (RiskFrame.instance.roleLevel.height >> 1), 3);
        }
        if (Player.player.getQiann() > 0) {
            int offX = RiskFrame.instance.rheadWidget.getDisplayX();
            int offY = RiskFrame.instance.rheadWidget.getDisplayY();
            g2.translate(offX, offY);
            if (RiskFrame.instance.roleUpadd != null) {
                RiskFrame.instance.roleUpadd.paint(g2);
            }
            if (RiskFrame.instance.roleUpadd1 != null && Player.player.isNewPlayer() && (Worker.instance.frameCount >> 3 & 1) == 1) {
                RiskFrame.instance.roleUpadd1.paint(g2);
            }
            g2.translate(-offX, -offY);
        }
    }

    public static int getImageWidght(long hp, long maxhp, int mxw) {
        long vaule = hp * (long)mxw / (maxhp = maxhp == 0L ? 1L : maxhp);
        if (vaule >= (long)mxw) {
            return mxw;
        }
        return (int)(vaule <= 0L ? 2L : vaule);
    }

    private void drawplayerInmini(Graphics g2, int x, int y, int w, int color1, int color2) {
        int oldcolor = g2.getColor();
        g2.setColor(color1);
        g2.fillRect(x + 1, y + 1, w - 2, w - 2);
        g2.setColor(color2);
        g2.drawLine(x + 1, y, x + w - 2, y);
        g2.drawLine(x + 1, y + w - 1, x + w - 2, y + w - 1);
        g2.drawLine(x, y + 1, x, y + w - 2);
        g2.drawLine(x + w - 1, y + 1, x + w - 1, y + w - 2);
        g2.setColor(oldcolor);
    }

    private void drawMiniMapRect(Graphics g2, int x, int y, int color1, int color2) {
        int oldcolor = g2.getColor();
        g2.setColor(color1);
        g2.fillRect(x, y, 3, 3);
        g2.setColor(color2);
        g2.drawLine(x + 2, y, x + 2, y + 2);
        g2.drawLine(x, y + 2, x + 2, y + 2);
        g2.setColor(oldcolor);
    }

    public boolean run(int taskInnerId) {
        if (this.getBoard() == null) {
            return false;
        }
        switch (taskInnerId) {
            case 258: {
                Player player = Player.player;
                if (player == null) {
                    return false;
                }
                if (!this.needSynCcoordinate) {
                    this.needSynCcoordinate = true;
                    break;
                }
                if (player.getCharacter().isSingle() || player.getCharacter().getLength() == 2 && player.getViewPet() != null) {
                    this.needSynCcoordinate = false;
                }
                DCharacter character = player.getCharacter();
                Protocol pt = MainMIDlet.logicHandle.createProtocol((byte)3, (byte)0);
                pt.singleInSendPeriod = true;
                pt.setBlock(false);
                pt.writeInt(risk.getId());
                Vector historyPaths = character.getHistoryPaths();
                character.cleanHistoryPaths();
                if (player.isLeader()) {
                    int pathCount = 0;
                    if (historyPaths != null && historyPaths.size() > 0) {
                        pathCount = historyPaths.size();
                    }
                    pt.writeByte(pathCount + 1);
                    for (int i2 = 0; i2 < pathCount; ++i2) {
                        int[] path = (int[])historyPaths.elementAt(i2);
                        pt.writeByte(path[0]);
                        pt.writeByte(path[1]);
                    }
                    pt.writeByte(character.getCol());
                    pt.writeByte(character.getRow());
                } else {
                    pt.writeByte(0);
                }
                boolean canmove = this.getBoard().canTileMove(character.getCol(), character.getRow());
                if (canmove) {
                    pt.writeByte(character.getCol());
                    pt.writeByte(character.getRow());
                } else {
                    pt.writeByte(-1);
                    pt.writeByte(-1);
                }
                pt.send();
                int[] screenTileBounds = this.board.getScreenTileBounds();
                Protocol pt2 = MainMIDlet.logicHandle.createProtocol((byte)3, (byte)3);
                pt2.singleInSendPeriod = true;
                pt2.setBlock(false);
                pt2.writeByte(screenTileBounds[0]).writeByte(screenTileBounds[1]).writeByte(screenTileBounds[0] + screenTileBounds[2]).writeByte(screenTileBounds[1] + screenTileBounds[3]).writeByte(isOpenAnmt == 2 ? 0 : isOpenSameS).send();
                break;
            }
            case 257: {
                if (Chat.chat == null) break;
                Chat.chat.chatRun();
                Chat.chat.taskTalkRun();
                Chat.chat.chatHornRun();
                Chat.chat.chatSysRun();
                break;
            }
            case 259: {
                if (!"".equals(this.miniMap)) {
                    this.mmapModel = M.instance.getResource(this.miniMap + ".cpng");
                }
                return true;
            }
        }
        return false;
    }

    public void onRemove(int taskInnerId) {
    }

    public String getTaskName() {
        return "RiskSceneTask " + this.getName();
    }

    public void showRoleNpcNameSub() {
        isOpenName = isOpenName == 0 ? 2 : --isOpenName;
    }

    public void showRoleNpcName() {
        isOpenName = isOpenName == 2 ? 0 : ++isOpenName;
    }

    public void showRoleAnmtSub() {
        isOpenAnmt = isOpenAnmt == 0 ? 2 : --isOpenAnmt;
    }

    public void showRoleAnmt() {
        isOpenAnmt = isOpenAnmt == 2 ? 0 : ++isOpenAnmt;
    }

    public void free() {
        M.instance.removeResource("bfg.cpng");
        if (this.mmapModel != null) {
            M.instance.removeResource(this.mmapModel.id);
        }
        Worker.instance.removeTask(this);
        if (this.board != null) {
            this.board.free();
        }
        this.clearPlayerCache(false);
        this.npcCache.clear();
        this.board = null;
        this.mmapModel = null;
    }

    static {
        selfCache = new Hashtable();
        mmap_stall = null;
        mmap_battle = null;
        timeCont = 0;
        TAN22_5FP = MathFP.toFP("0.414");
        TAN67_5FP = MathFP.toFP("2.414");
        TAN_22_5FP = MathFP.toFP("-0.414");
        TAN_67_5FP = MathFP.toFP("-2.414");
        isOpenHpMp = 0;
        isOpenMap = 0;
        isOpenAnmt = 0;
        isOpenName = 0;
        isOpenTeam = 0;
        isOpenFact = 0;
        isOpenEqupck = 0;
        isOpenSameS = 10;
        isOpenRocker = 0;
        mailUread = false;
        bagFull = false;
        roleHpI = null;
        roleMpI = null;
        roleExpI = null;
        petHpI = null;
        petMpI = null;
        petExpI = null;
    }
}

