/*
 * Decompiled with CFR 0.152.
 */
package com.ea.util.graphics;

import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class GIFDecode {
    public static final int STATUS_OK = 0;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OPEN_ERROR = 2;
    protected InputStream in;
    protected int status;
    protected int width;
    protected int height;
    protected boolean gctFlag;
    protected int gctSize;
    protected int loopCount = 1;
    protected int[] gct;
    protected int[] lct;
    protected int[] act;
    protected int bgIndex;
    protected int bgColor;
    protected int lastBgColor;
    protected int pixelAspect;
    protected boolean lctFlag;
    protected boolean interlace;
    protected int lctSize;
    protected int ix;
    protected int iy;
    protected int iw;
    protected int ih;
    protected int lrx;
    protected int lry;
    protected int lrw;
    protected int lrh;
    protected Image image;
    protected Image lastImage;
    protected byte[] block = new byte[256];
    protected int blockSize = 0;
    protected int dispose = 0;
    protected int lastDispose = 0;
    protected boolean transparency = false;
    protected int delay = 0;
    protected int transIndex;
    protected static final int MaxStackSize = 4096;
    protected short[] prefix;
    protected byte[] suffix;
    protected byte[] pixelStack;
    protected byte[] pixels;
    protected Vector frames;
    protected int frameCount;

    public GIFDecode(String string) {
        this.a(this.getClass().getResourceAsStream(string));
    }

    public int getDelay(int n) {
        this.delay = -1;
        if (n >= 0 && n < this.frameCount) {
            this.delay = ((a)this.frames.elementAt((int)n)).b;
        }
        return this.delay;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public Image getImage() {
        return this.getFrame(0);
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    protected void setPixels() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[this.width * this.height];
        if (this.lastDispose > 0) {
            if (this.lastDispose == 3) {
                n5 = this.frameCount - 2;
                this.lastImage = n5 > 0 ? this.getFrame(n5 - 1) : null;
            }
            if (this.lastImage != null) {
                this.lastImage.getRGB(nArray, 0, this.width, 0, 0, this.width, this.height);
                if (this.lastDispose == 2) {
                    n5 = 0;
                    if (!this.transparency) {
                        n5 = this.lastBgColor;
                    }
                    for (n4 = 0; n4 < this.lrh; ++n4) {
                        n3 = (this.lry + n4) * this.width + this.lrx;
                        n2 = n3 + this.lrw;
                        for (n = n3; n < n2; ++n) {
                            nArray[n] = n5;
                        }
                    }
                }
            }
        }
        n5 = 1;
        n4 = 8;
        n3 = 0;
        for (n2 = 0; n2 < this.ih; ++n2) {
            int n6;
            int n7;
            n = n2;
            if (this.interlace) {
                if (n3 >= this.ih) {
                    switch (++n5) {
                        case 2: {
                            n3 = 4;
                            break;
                        }
                        case 3: {
                            n3 = 2;
                            n4 = 4;
                            break;
                        }
                        case 4: {
                            n3 = 1;
                            n4 = 2;
                        }
                    }
                }
                n = n3;
                n3 += n4;
            }
            if ((n += this.iy) >= this.height) continue;
            if ((n *= this.width) + this.width < (n7 = (n6 = n + this.ix) + this.iw)) {
                n7 = n + this.width;
            }
            n = n2 * this.iw;
            while (n6 < n7) {
                int n8 = this.pixels[n++] & 0xFF;
                if ((n8 = this.act[n8]) != 0) {
                    nArray[n6] = n8;
                }
                ++n6;
            }
        }
        this.image = Image.createRGBImage((int[])nArray, (int)this.width, (int)this.height, (boolean)true);
    }

    public Image getFrame(int n) {
        Image image = null;
        if (n >= 0 && n < this.frameCount) {
            image = ((a)this.frames.elementAt((int)n)).a;
        }
        return image;
    }

    private int a(InputStream object) {
        this.init();
        if (object != null) {
            this.in = object;
            this.readHeader();
            if (!this.err()) {
                this.readContents();
                if (this.frameCount < 0) {
                    this.status = 1;
                }
            }
        } else {
            this.status = 2;
        }
        try {
            ((InputStream)object).close();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return this.status;
    }

    protected void decodeImageData() {
        int n;
        int n2 = this.iw * this.ih;
        if (this.pixels == null || this.pixels.length < n2) {
            this.pixels = new byte[n2];
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int n3 = this.read();
        int n4 = 1 << n3;
        int n5 = n4 + 1;
        int n6 = n4 + 2;
        int n7 = -1;
        int n8 = n3 + 1;
        int n9 = (1 << n8) - 1;
        for (n = 0; n < n4; ++n) {
            this.prefix[n] = 0;
            this.suffix[n] = (byte)n;
        }
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        while (n17 < n2) {
            if (n12 == 0) {
                if (n15 < n8) {
                    if (n14 == 0) {
                        n14 = this.readBlock();
                        if (n14 <= 0) break;
                        n10 = 0;
                    }
                    n16 += (this.block[n10] & 0xFF) << n15;
                    n15 += 8;
                    ++n10;
                    --n14;
                    continue;
                }
                n = n16 & n9;
                n16 >>= n8;
                n15 -= n8;
                if (n > n6 || n == n5) break;
                if (n == n4) {
                    n8 = n3 + 1;
                    n9 = (1 << n8) - 1;
                    n6 = n4 + 2;
                    n7 = -1;
                    continue;
                }
                if (n7 == -1) {
                    this.pixelStack[n12++] = this.suffix[n];
                    n7 = n;
                    n13 = n;
                    continue;
                }
                int n18 = n;
                if (n == n6) {
                    this.pixelStack[n12++] = (byte)n13;
                    n = n7;
                }
                while (n > n4) {
                    this.pixelStack[n12++] = this.suffix[n];
                    n = this.prefix[n];
                }
                n13 = this.suffix[n] & 0xFF;
                if (n6 >= 4096) break;
                this.pixelStack[n12++] = (byte)n13;
                this.prefix[n6] = (short)n7;
                this.suffix[n6] = (byte)n13;
                if ((++n6 & n9) == 0 && n6 < 4096) {
                    ++n8;
                    n9 += n6;
                }
                n7 = n18;
            }
            this.pixels[n11++] = this.pixelStack[--n12];
            ++n17;
        }
        for (n17 = n11; n17 < n2; ++n17) {
            this.pixels[n17] = 0;
        }
    }

    protected boolean err() {
        return this.status != 0;
    }

    protected void init() {
        this.status = 0;
        this.frameCount = 0;
        this.frames = new Vector();
        this.gct = null;
        this.lct = null;
    }

    protected int read() {
        int n = 0;
        try {
            n = this.in.read();
        }
        catch (Exception exception) {
            this.status = 1;
        }
        return n;
    }

    protected int readBlock() {
        int n;
        this.blockSize = this.read();
        if (this.blockSize > 0) {
            try {
                int n2 = 0;
                for (n = 0; n < this.blockSize && (n2 = this.in.read(this.block, n, this.blockSize - n)) != -1; n += n2) {
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
            if (n < this.blockSize) {
                this.status = 1;
            }
        }
        return n;
    }

    protected int[] readColorTable(int n) {
        int n2 = 3 * n;
        int[] nArray = null;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        try {
            n3 = this.in.read(byArray);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        if (n3 < n2) {
            this.status = 1;
        } else {
            nArray = new int[256];
            int n4 = 0;
            n2 = 0;
            while (n4 < n) {
                n3 = byArray[n2++] & 0xFF;
                int n5 = byArray[n2++] & 0xFF;
                int n6 = byArray[n2++] & 0xFF;
                nArray[n4++] = 0xFF000000 | n3 << 16 | n5 << 8 | n6;
            }
        }
        return nArray;
    }

    protected void readContents() {
        boolean bl = false;
        block10: while (!bl && !this.err()) {
            int n = this.read();
            switch (n) {
                case 44: {
                    this.readImage();
                    continue block10;
                }
                case 33: {
                    n = this.read();
                    switch (n) {
                        case 249: {
                            this.readGraphicControlExt();
                            continue block10;
                        }
                        case 255: {
                            this.readBlock();
                            String string = "";
                            for (int k = 0; k < 11; ++k) {
                                string = string + (char)this.block[k];
                            }
                            if (string.equals("NETSCAPE2.0")) {
                                this.readNetscapeExt();
                                continue block10;
                            }
                            this.skip();
                            continue block10;
                        }
                    }
                    this.skip();
                    continue block10;
                }
                case 59: {
                    bl = true;
                    continue block10;
                }
                case 0: {
                    continue block10;
                }
            }
            this.status = 1;
        }
    }

    protected void readGraphicControlExt() {
        this.read();
        int n = this.read();
        this.dispose = (n & 0x1C) >> 2;
        if (this.dispose == 0) {
            this.dispose = 1;
        }
        this.transparency = (n & 1) != 0;
        this.delay = this.readShort() * 10;
        this.transIndex = this.read();
        this.read();
    }

    protected void readHeader() {
        String string = "";
        for (int k = 0; k < 6; ++k) {
            string = string + (char)this.read();
        }
        if (!string.startsWith("GIF")) {
            this.status = 1;
            return;
        }
        this.readLSD();
        if (this.gctFlag && !this.err()) {
            this.gct = this.readColorTable(this.gctSize);
            this.bgColor = this.gct[this.bgIndex];
        }
    }

    protected void readImage() {
        this.ix = this.readShort();
        this.iy = this.readShort();
        this.iw = this.readShort();
        this.ih = this.readShort();
        int n = this.read();
        this.lctFlag = (n & 0x80) != 0;
        this.interlace = (n & 0x40) != 0;
        this.lctSize = 2 << (n & 7);
        if (this.lctFlag) {
            this.lct = this.readColorTable(this.lctSize);
            this.act = this.lct;
        } else {
            this.act = this.gct;
            if (this.bgIndex == this.transIndex) {
                this.bgColor = 0;
            }
        }
        n = 0;
        if (this.transparency) {
            n = this.act[this.transIndex];
            this.act[this.transIndex] = 0;
        }
        if (this.act == null) {
            this.status = 1;
        }
        if (this.err()) {
            return;
        }
        this.decodeImageData();
        this.skip();
        if (this.err()) {
            return;
        }
        ++this.frameCount;
        this.setPixels();
        this.frames.addElement(new a(this.image, this.delay));
        if (this.transparency) {
            this.act[this.transIndex] = n;
        }
        this.resetFrame();
    }

    protected void readLSD() {
        this.width = this.readShort();
        this.height = this.readShort();
        int n = this.read();
        this.gctFlag = (n & 0x80) != 0;
        this.gctSize = 2 << (n & 7);
        this.bgIndex = this.read();
        this.pixelAspect = this.read();
    }

    protected void readNetscapeExt() {
        do {
            this.readBlock();
            if (this.block[0] != 1) continue;
            int n = this.block[1] & 0xFF;
            int n2 = this.block[2] & 0xFF;
            this.loopCount = n2 << 8 | n;
        } while (this.blockSize > 0 && !this.err());
    }

    protected int readShort() {
        return this.read() | this.read() << 8;
    }

    protected void resetFrame() {
        this.lastDispose = this.dispose;
        this.lrx = this.ix;
        this.lry = this.iy;
        this.lrw = this.iw;
        this.lrh = this.ih;
        this.lastImage = this.image;
        this.lastBgColor = this.bgColor;
        this.dispose = 0;
        this.transparency = false;
        this.delay = 0;
        this.lct = null;
    }

    protected void skip() {
        do {
            this.readBlock();
        } while (this.blockSize > 0 && !this.err());
    }

    static final class a {
        public Image a;
        public int b;

        public a(Image image, int n) {
            this.a = image;
            this.b = n;
        }
    }
}

