/*
 * Decompiled with CFR 0.152.
 */
package com.ea.util.graphics;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Imagex {
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int TOPLEFT = 20;
    public static final int CENTER = 3;
    public Image[] src = new Image[2];
    public boolean[] singleFrame = new boolean[2];
    public int numSrc;
    public int w;
    public int h;
    public int[] locx;
    public int[] locy;
    public int[] srcIndices;
    public int numFrames = 0;
    public int anchor = 20;
    public int offsetx = 0;
    public int offsety = 0;

    public Imagex() {
    }

    public Imagex(Image image, int n, int n2) {
        this.addImage(image, n, n2);
    }

    public Imagex(Image image, int n, int n2, int n3, int n4) {
        this.addImage(image, n, n2, n3, n4);
    }

    public Imagex(Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        this.addImage(image, n, n2, n3, n4, n5, n6);
    }

    public void addImage(Image image) {
        this.addImage(image, 1, 1);
    }

    public void addImage(Image image, int n, int n2) {
        int n3 = image.getWidth();
        int n4 = image.getHeight();
        this.addImage(image, 0, 0, n3, n4, n3 / n, n4 / n2);
    }

    public void addImage(Image image, int n, int n2, int n3, int n4) {
        int n5 = image.getWidth();
        int n6 = image.getHeight();
        this.addImage(image, n, n2, n5 - n, n6 - n2, n3, n4);
    }

    public void addImage(Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = image.getWidth();
        int n8 = image.getHeight();
        if (n < 0 || n2 < 0 || n3 <= 0 || n4 <= 0 || n + n3 > n7 || n2 + n4 > n8 || n5 <= 0 || n6 <= 0 || n3 % n5 != 0 || n4 % n6 != 0 || this.w > 0 && n5 != this.w || this.h > 0 && n6 != this.h) {
            throw new IllegalArgumentException();
        }
        if (this.numSrc >= this.src.length) {
            Image[] imageArray = new Image[this.src.length << 1];
            boolean[] blArray = new boolean[imageArray.length];
            System.arraycopy(this.src, 0, imageArray, 0, this.src.length);
            System.arraycopy(this.singleFrame, 0, blArray, 0, this.singleFrame.length);
            this.src = imageArray;
            this.singleFrame = blArray;
        }
        this.src[this.numSrc] = image;
        this.singleFrame[this.numSrc++] = n3 == n5 && n4 == n6;
        this.w = n5;
        this.h = n6;
        n7 = n3 / n5;
        n8 = n4 / n6;
        int n9 = this.numFrames + n7 * n8;
        int n10 = n3 = this.locx != null ? this.locx.length : n9;
        while (n10 < n9) {
            n10 = n3 << 1;
        }
        if (this.locx == null || n3 > this.locx.length) {
            int[] nArray = new int[n3];
            if (this.locx != null) {
                System.arraycopy(this.locx, 0, nArray, 0, this.numFrames);
            }
            this.locx = nArray;
            nArray = new int[n3];
            if (this.locy != null) {
                System.arraycopy(this.locy, 0, nArray, 0, this.numFrames);
            }
            this.locy = nArray;
            nArray = new int[n3];
            if (this.srcIndices != null) {
                System.arraycopy(this.srcIndices, 0, nArray, 0, this.numFrames);
            }
            this.srcIndices = nArray;
        }
        for (int k = 0; k < n8; ++k) {
            n3 = 0;
            while (n3 < n7) {
                this.locx[this.numFrames] = n + n5 * n3;
                this.locy[this.numFrames] = n2 + n6 * k;
                this.srcIndices[this.numFrames] = this.numSrc - 1;
                ++n3;
                ++this.numFrames;
            }
        }
        this.setAnchor(this.anchor);
    }

    public int getFrameCount() {
        return this.numFrames;
    }

    public void setAnchor(int n) {
        this.anchor = n;
        this.offsetx = 0;
        this.offsety = 0;
        if ((n & 1) != 0) {
            this.offsetx = -(this.w >> 1);
        } else if ((n & 8) != 0) {
            this.offsetx = -this.w;
        }
        if ((n & 2) != 0) {
            this.offsety = -(this.h >> 1);
            return;
        }
        if ((n & 0x20) != 0) {
            this.offsety = -this.h;
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = this.srcIndices[n];
        if (this.singleFrame[n4]) {
            graphics.drawImage(this.src[n4], n2, n3, this.anchor);
            return;
        }
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        graphics.clipRect(n2 + this.offsetx, n3 + this.offsety, this.w, this.h);
        graphics.drawImage(this.src[n4], n2 + this.offsetx - this.locx[n], n3 + this.offsety - this.locy[n], 20);
        graphics.setClip(n5, n6, n7, n8);
    }
}

